#include "StdAfx.h"
#include "MultiEditBox.h"
#include "EditBox.h"

#include "UIImage.h"
#include "UIContainer.h"
#include "FontAgent.h"
#include "UICursor.h"

cMultiEditBox::cMultiEditBox( eUINodeType type )
: cUIIMENode( type )
, mEditTabIndex(0)
, mCaretTimeFlag( false )
, mShowCaretFlag( false )
, mLastTick(0)
, mEditingPos(0, 0)
, mEditWidth(0)
, mEditX(0)
, mEditY(0)
{
	mTextAlign = eALIGN_LEFT; 

	::ZeroMemory( mShowText, sizeof(mShowText) );

	mProcessEnable = true;
}

cMultiEditBox::~cMultiEditBox()
{
}

bool cMultiEditBox::OnCreate( cUINodeProperty* )
{
	if( cUINode::OnCreate() == false )
		return false;

	///  Է Ʈ ƴϸ  
	if( mEditKind != eEDIT_NOINPUT )
	{
		/// θ Ʈ  Ѵ
		mEditTabIndex = mpParent->AddEditBox( this );
	}

	return true;
}
/// ǻ : 
bool cMultiEditBox::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_MULTIEDITBOX ) == false )
	{
		assert( 0 && "not eidtbox skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
	{
		return false;
	}

	cEditBoxSkin* p = (cEditBoxSkin*)pskin;
	
	/// ڿ  ġ 
	mEditingPos = p->mEditPos;

	/// Ƽ Ʈ ڿ ִ width
	mEditWidth = p->mEditWidth;
	if( mEditWidth <= 0 )
	{
		///   ⺻  
		mEditWidth = pskin->mSkinInfo->mWidth;
	}

	/// Ʈ Ÿ 
	mEditKind = (eEditKind)p->mEditKind;
	
	/// Ʈ Ҽ ִ ִ 
	SetMaxEditLength( p->mMaxEditLength );
			
	/// ٿ  ִ  
	SetOneLineWidth( mEditWidth );

	/// ũƮ ̸  ؽƮ ִ° .
	if( mTextLength <= 0 )
	{
		Sstrncpy( mText, MAX_TEXT_LENGTH, p->mText.Cstr(), p->mText.GetLength() );

		///  
		mTextLength = p->mText.GetLength();

		/// ĳ ڿ  ű 
		CaretMoveEnd();
	}
	return true;
}

// ǻ : 
void cMultiEditBox::OnProcess( unsigned long /*deltaTime*/, unsigned long accumTime )
{
	mEditX = mEditingPos.mX + GetAbsoluteRect().mLeft;
	mEditY = mEditingPos.mY + GetAbsoluteRect().mTop;
	
	/// ĳ Ÿ 
	if( mEditKind != eEDIT_NOINPUT )
	{
		UpdateCaretTime( accumTime );
	}
	
	/// ؽƮ   
	if( mChangeText )
	{
		SetTextData();

		mChangeText = false;
	}
}

/// ǻ : 
void cMultiEditBox::OnRender( cUIFontItemKeeper* pKeeper )
{
	/// ̹ 
	if( mpImage )
		mpImage->Draw();
	
	/// Ʈ ؾ ĳ  
	if( mEditKind != eEDIT_NOINPUT )
	{
		/// ĳ    
		RenderCaret( pKeeper );
	}

	/// ؽƮ    
	RenderText( pKeeper );
}

/// ǻ : 
void cMultiEditBox::OnKeyDown( eKeyCode code )
{
	/// Ʈ  Ʈ ڽ  
	if( mEditKind == eEDIT_NOINPUT )
		return;

	/// Ű  Ŀ ű
	if( code == eKEY_TAB )
	{
		mpParent->ChangeFocus( mEditTabIndex );
	}
	else if( code == eKEY_ESCAPE )
	{
		ReleaseFocus();
	}

	cUIIMENode::OnKeyDown( code );
}

/// ǻ :
void cMultiEditBox::OnMouseMove( const cUIPos& )
{
}

/// ǻ : 
void cMultiEditBox::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{
	/// Ʈ  Ʈ ڽ  
	if( mEditKind == eEDIT_NOINPUT )
		return;

	cUINode::OnLButtonDown( pos, ctrl, alt, shift );

	/// Ŀ  
	if( GetFocus() != this )
	{
		SetFocus();
//		SetCapture();
	}

	/// 콺  ǥ شϴ ε ˾Ƴ.
	FindTextCaret( pos );
}

/// ǻ : ȣ  ̺Ʈ  
void cMultiEditBox::OnMouseLeft( const cUIPos& )
{
	CURSOR->SetCursor( eCURSOR_DEFAULT );
}

/*
	mTextLineArray =   ε ° ο ϴ Ǿ. ׷ ڰŭ  
	mTextIndexArray =  δ ھ ϱ ִ Ǿ.   ŭ  (  )
*/

/// ؽƮ   ( ؽƮ õ ؽƮ .. )
void cMultiEditBox::SetTextData()
{
	///
	mTextLineArray.Clear();
	mTextIndexArray.Clear();

	/// ũ  ȭ ڿ 
	///  ƴϸ 
	if( mCompFlag == false )
	{
		Sstrncpy( mShowText, MAX_TEXT_LENGTH, mText, mMaxEditLength );
	}
	else
	{
		/// ̸ 
		Sstrncpy( mShowText, MAX_TEXT_LENGTH, mText, mTextCaretX );
		Sstrncat( mShowText, MAX_TEXT_LENGTH, mCompText, 1 );
		Sstrncat( mShowText, MAX_TEXT_LENGTH, mText + mTextCaretX, mMaxEditLength - mTextCaretX - 1);
	}

	/// ˻ ڿ 
	int cutWidth = 0;

	/// ߸ڿ  
	int cutlen = 0;

	/// ⺻ ڿ  
	int showlen = ::_tcslen( mShowText ); 

	///  ȣ 
	int line = 0;

	/// ڿ
	LPTSTR str = (LPTSTR)mShowText;

	///
	unsigned int textlen = (int)::_tcslen(str);

	/// ؽƮ width ϱ 
	int textWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, str, textlen );

	/// ù  ۵Ǹ  
	if( mFixFlag == true )
	{
		textWidth += FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mCompText, 1 );
	}

	/// ؽƮ ξ ʺ , ȳѴ° ߶󳻾Ѵ.
	while( textWidth > mOneLineWidth )
	{
		///  ˻    
		if( cutWidth < mOneLineWidth )
		{
			/// UNICODE ϱ  ̸ 1 Ѵ
			cutlen += 1;

			///  ˻ ڵ  Ѵ 
			cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, str, cutlen );
		}
		else
		{
			///    (  Ƣ ڴ  ﵵ ̷ )
			if( cutWidth > mOneLineWidth )
			{
				/// UNICODE ϱ  ̸ 1 
				int minusWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, str + cutlen - 1, 1 );
				cutWidth -= minusWidth;
				cutlen -= 1;
			}

			/// 	
			///  ؽƮ ش ε  ´ ( ιȣ -  : Ī Ű )
			for( int i = cutlen*line; i < cutlen*(line+1); ++i )
			{
				mTextLineArray.PushBack( line );
			}

			///  δ  ε ϴ 
			if( mTextIndexArray.GetSize() > 0 )
			{
				int index = mTextIndexArray[line-1];
				mTextIndexArray.PushBack( cutlen + index );
			}
			else
			{
				mTextIndexArray.PushBack( cutlen );
			}
		
			/// 
			textWidth -= cutWidth;
			str += cutlen;

			/// ߶󳽱̸ŭ ѱ̸ ٿش 
			showlen -= cutlen;
			cutWidth = 0;
			cutlen = 0;
			line++;
		}
	}

	/// ؽƮ  ٿ  ̸, ׳  
	if( showlen > 0 && textWidth <= mOneLineWidth )
	{
		///  ؽƮ ش ε  ´ ( ιȣ -  : Ī Ű )
		/// textlen + (cutlen*line) ->     
		for( unsigned int i = cutlen*line; i < textlen + (cutlen*line); ++i )
		{
			mTextLineArray.PushBack( line );
		}

		///  δ  ε ϴ 
		mTextIndexArray.PushBack( textlen );
	}
}

/// ǻ :
void cMultiEditBox::RenderText( cUIFontItemKeeper* pKeeper )
{	
	TCHAR pText[MAX_TEXT_LENGTH] = {0,};
	unsigned int height = 0;
	unsigned int beforelen = 0;
	unsigned int curlen = 0;

	/// κ ߶ Ѹ ( ִ ΰ  )
	for( unsigned int i = 0; i < mTextIndexArray.GetSize(); ++i )
	{
		::ZeroMemory( pText, sizeof(pText) );

		//// i ° ο ִ  ̸ ´
		if( i > 0 )
		{
			beforelen = mTextIndexArray[i-1];
		}

		curlen = mTextIndexArray[i] - beforelen;

		///  ϴ± 
		Sstrncpy( pText, MAX_TEXT_LENGTH, mShowText + beforelen, curlen );
        
		///  ġ 
		height = ( i * FONTAGENT->GetTextHeight(cFontAgent::eFont_Chat) );
		int editY = mEditingPos.mY + GetAbsoluteRect().mTop + height;

		/// ߾ ̸,
		if( mTextAlign == eALIGN_CENTER )
		{
			mEditX = GetAbsoluteRect().mLeft + ( GetAbsoluteRect().GetWidth() - FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, pText, curlen ) ) / 2;
			mEditY = mEditingPos.mY + height + GetAbsoluteRect().mTop + ( GetAbsoluteRect().GetHeight() - FONTAGENT->GetTextHeight(cFontAgent::eFont_Chat) ) / 2;
		}

		pKeeper->AddFontItem( cFontAgent::eFont_Chat, pText, mEditX, editY, mDefaultColor );	
	}
}

/// ǻ : ĳġ ؼ 
void cMultiEditBox::RenderCaret( cUIFontItemKeeper* pKeeper )
{
	/// ĳ  Ÿ ƴϰų Ƽ Ʈ ڽ Ŀ   
	if( mShowCaretFlag == false || GetFocus() != this )
	{
		return;
	}

	LPTSTR caret = _T("|");
	int startX = mEditX;
	int startY = mEditY;
    unsigned int lineNum = 0;
	unsigned int startIndex = 0;		///     ε 
	unsigned int height = 0;			/// ο  y ġ ȭ 

	if( mTextCaretX > 0 )
	{
		///  ĳ ִ ڰ ° ο ִ ޾ƿ´ 
		if( mCompFlag )
		{
			/// ̸ ó (ѱΰ)
			lineNum = mTextLineArray[ mTextCaretX ];
		}
		else
		{
			lineNum = mTextLineArray[ mTextCaretX-1 ];
		}
	}

	if( lineNum > 0 )
	{
		///     ε  ޾ƿ´
		startIndex = mTextIndexArray[ lineNum-1 ];
	}

	height = lineNum * FONTAGENT->GetTextHeight(cFontAgent::eFont_Chat);
	
	/// ĳ  
	int textwidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, mShowText + startIndex, mTextCaretX - startIndex );
	int nextwidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, mShowText + startIndex, mTextCaretX - startIndex + 1);
	int newcaretpos = FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, caret, 1 ) / 2;

	///  ĳ  ġ ϱ
	int caretX = startX + textwidth - newcaretpos;

	/// ѱ ̸ 簢 ĳ  
	if( mCompFlag )
	{
		/// ѱ̸ 簢 ĳ ׸ 
		for( int i = 0; i < ( nextwidth - textwidth ); ++i )
		{
			caretX = startX + textwidth - newcaretpos;
			pKeeper->AddFontItem( cFontAgent::eFont_UI, caret, caretX, startY + height, (unsigned long)eCOLOR_PINK );
			startX++;
		}
	}
	else
	{
		/// ѱ ƴ  ׳  
		pKeeper->AddFontItem( cFontAgent::eFont_UI, caret, caretX, startY + height, (unsigned long)mDefaultColor );
	}
}

/// ǻ : ĳ ̴ ð   
void cMultiEditBox::UpdateCaretTime( unsigned long accumTime )
{
	/// ĳ  Ⱥ 
	if( mCaretTimeFlag )
	{
		mLastTick = accumTime;
		mCaretTimeFlag = false;
	}

	/// ĳ ̴ ð  
	if( accumTime - mLastTick >= 600 )
	{
		mShowCaretFlag = !mShowCaretFlag;
		mLastTick = accumTime;
	}
}

/// ǻ : 콺  ÿ  ǥ ִ ؽƮ ĳ ű.
void cMultiEditBox::FindTextCaret( const cUIPos& pos )
{
	unsigned int len = (int)::_tcslen(mShowText);
	if( len <= 0 ) return;

	/// edit  콺 Ŭ ǥ 
	unsigned int mouseX = pos.mX - mEditX;
	unsigned int mouseY = pos.mY - mEditY;
	
	if( (int)mouseX < mEditingPos.mX )
		mouseX = mEditingPos.mX;

	if( (int)mouseY < mEditingPos.mY )
		mouseY = mEditingPos.mY;

	///  ϱ
	unsigned int lineNum = mouseY / FONTAGENT->GetTextHeight(cFontAgent::eFont_Chat);

	/// y    
	if( lineNum >= mTextIndexArray.GetSize() )
		return;

	/// x    ε ϱ
	int startIndex = 0;
	if( lineNum > 0 )
	{
		///  len ϱ 
		startIndex = mTextIndexArray[ lineNum - 1];
	}

	/// ˻ ڿ 
	unsigned int cutWidth = 0;

	/// ߸ڿ  
	unsigned int cutlen = 0;

	/// ڰ  ˻
	while( cutWidth < mouseX )
	{
		///  ˻ʿ .
		if( (int)cutlen >= mTextLength )
			break;

		cutlen++;

		cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mShowText + startIndex, cutlen );
	}

	///    
	if( cutWidth > mouseX )
	{
		cutlen--;
		cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mShowText + startIndex, cutlen );
	}

	///   ϱ
	unsigned int nextWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mShowText + startIndex + cutlen, cutlen + 1);
		
	/// յڱ ߰   ⿡  ĳ ġ ޶ Ѵ
	unsigned int width = (nextWidth - cutWidth) / 2;

	if( mouseX - cutWidth > width )
	{
		cutlen++;
	}

	/// ڿ   ( ش ڼ   õǾ  )
	unsigned int limitlen = mTextIndexArray[ lineNum ];
	if( cutlen >= limitlen - startIndex )
	{
		cutlen = limitlen - startIndex;
	}

	/// 
	if( lineNum > 0 )
	{
		mTextCaretX = cutlen + startIndex;
	}
	else
	{
		mTextCaretX = cutlen;
	}
}

///
void cMultiEditBox::SetText( LPCTSTR text, eText_Align align )
{
	::ZeroMemory( mText, sizeof( mText ) );

	Sstrncpy( mText, MAX_TEXT_LENGTH, text, _tcslen(text) );
	mTextLength = ::_tcslen(text);
	mTextAlign = align;
	mChangeText = true;
}
