#include "StdAfx.h"
#include "namecardgauge.h"

#include "PlaneObject.h"

cNameCardGauge::cNameCardGauge()
: mpGaugeTexture(0), mpFrameTexture(0)
{
}

cNameCardGauge::~cNameCardGauge()
{
	SAFE_NIDELETE(mpFrameTexture);
	SAFE_NIDELETE(mpGaugeTexture);
}

bool cNameCardGauge::Init( NiTexture* pGaugeFile, RECT* GaugeUV, NiTexture* pFrameFile, RECT* FrameUV )
{
	if( pGaugeFile == 0 )
		return false;

	mpGaugeTexture = new cPlaneObject;
	if( mpGaugeTexture->Create( pGaugeFile, 0, 0, (unsigned short)GaugeUV->right, (unsigned short)GaugeUV->bottom,
			(unsigned short)GaugeUV->left, (unsigned short)GaugeUV->top,
			(unsigned short)(GaugeUV->left+GaugeUV->right), (unsigned short)(GaugeUV->top+GaugeUV->bottom) ) == false )
	{
		assert(0);
		return false;
	}

	if( pFrameFile )
	{
		mpFrameTexture = new cPlaneObject;
		mpFrameTexture->Create( pFrameFile, 0, 0, (unsigned short)FrameUV->right, (unsigned short)FrameUV->bottom,
			(unsigned short)FrameUV->left, (unsigned short)FrameUV->top,
			(unsigned short)(FrameUV->left+FrameUV->right), (unsigned short)(FrameUV->top+FrameUV->bottom) );

	}
/*
	if( pGaugeFile == 0 )
		return false;

	mpGaugeTexture = NiNew NiScreenTexture( pGaugeFile );
	mpGaugeTexture->SetApplyMode( NiTexturingProperty::APPLY_REPLACE );
	mpGaugeTexture->AddNewScreenRect( 0, 0, 
						(unsigned short)GaugeUV->right, (unsigned short)GaugeUV->bottom, 
						(unsigned short)GaugeUV->top, (unsigned short)GaugeUV->left, NiColorA(1.0f, 1.0f, 1.0f, 1.0f) );
	mpGaugeTexture->MarkAsChanged(NiScreenTexture::EVERYTHING_MASK);

	if( pFrameFile )
	{
		mpFrameTexture = NiNew NiScreenTexture( pFrameFile );
		mpFrameTexture->SetApplyMode( NiTexturingProperty::APPLY_MODULATE );
		mpFrameTexture->AddNewScreenRect( 0, 0, 
			(unsigned short)FrameUV->right, (unsigned short)FrameUV->bottom, 
			(unsigned short)FrameUV->top, (unsigned short)FrameUV->left, NiColorA(1.0f, 1.0f, 1.0f, 1.0f) );
		mpFrameTexture->MarkAsChanged(NiScreenTexture::EVERYTHING_MASK);
	}
*/
	return true;
}

void cNameCardGauge::SetGaugePos( short posx, short posy )
{
	short x = posx;
	short y = posy;
	if( mpFrameTexture )
	{
		mpFrameTexture->SetTranslate( x, y );
		x+=1;
		y+=1;
	}

	if( mpGaugeTexture )
		mpGaugeTexture->SetTranslate( x, y );

/*
	NiScreenTexture::ScreenRect& rc = mpGaugeTexture->GetScreenRect( 0 );
	rc.m_sPixLeft = posx+1;
	rc.m_sPixTop = posy+1;
	mpGaugeTexture->MarkAsChanged( NiScreenTexture::VERTEX_MASK );

	if( mpFrameTexture )
	{
		NiScreenTexture::ScreenRect& rcFrame = mpFrameTexture->GetScreenRect( 0 );
		rcFrame.m_sPixLeft = posx;
		rcFrame.m_sPixTop = posy;
		mpFrameTexture->MarkAsChanged( NiScreenTexture::VERTEX_MASK );
	}
*/
}

void cNameCardGauge::SetGaugeWidth( unsigned short width )
{
	if( mpGaugeTexture )
		mpGaugeTexture->SetScreenWidth( width );
/*
	NiScreenTexture::ScreenRect& rc = mpGaugeTexture->GetScreenRect( 0 );
	rc.m_usPixWidth = width;

	mpGaugeTexture->MarkAsChanged( NiScreenTexture::VERTEX_MASK | NiScreenTexture::TEXTURE_MASK );
*/
}

void cNameCardGauge::Draw()
{
	if( mpFrameTexture )
		mpFrameTexture->Draw();
	if( mpGaugeTexture )
		mpGaugeTexture->Draw();
/*
	NiRenderer* pRenderer = NiRenderer::GetRenderer();

	assert(mpGaugeTexture);

	mpGaugeTexture->Draw( pRenderer );

	if( mpFrameTexture )
		mpFrameTexture->Draw( pRenderer );
*/
}
