/* ==========================================================================
*    : ̼
*    : 2007.01.03
*      : ׺ʵ
* ǻ : 
*===========================================================================*/
#pragma once

/// ׺ʵ 
const unsigned int NAVIFIELD_DEFAULT_RESOLUTION = 512;
const unsigned int NAVIFIELD_BUFF_CELL_COUNT = 128;
const unsigned int NAVIFIELD_BUFF_LINE_COUNT = NAVIFIELD_BUFF_CELL_COUNT + 1;
const unsigned int NAVIFIELD_BUFF_VERT_COUNT = NAVIFIELD_BUFF_LINE_COUNT * NAVIFIELD_BUFF_LINE_COUNT;
const unsigned int NAVIFIELD_LEAF_CELL_COUNT = 8;
const unsigned int NAVIFIELD_LEAF_LINE_COUNT = NAVIFIELD_LEAF_CELL_COUNT + 1;
const unsigned int NAVIFIELD_LEAF_LINE_COUNT_X2 = NAVIFIELD_LEAF_LINE_COUNT * 2;
const unsigned int NAVIFIELD_LEAF_VERT_COUNT = NAVIFIELD_LEAF_LINE_COUNT * NAVIFIELD_LEAF_LINE_COUNT;

/// ׺ʵ  
#pragma pack( push, 1 )
class cNaviFieldFileHeader
{
public:
	/// ĺ ڵ
	char mCode[14];

	/// 
	unsigned int mVersion;

	/// ׸ ũ ( )
	unsigned int mCellCount;

	///   
	float mMetersPerVertex;

	/// ʹ   ( 100 )
	unsigned int mUnitsPerMeter;
};
#pragma pack( pop )

/// ׺ʵ
class cNaviField
{
public:
	cNaviField();
	~cNaviField();

	/// 
	void Clear();

	/// ε
	bool Load( const cString& pathName );

	/// ʵ尪
	void SetValue( unsigned int xi, unsigned int yi, unsigned char value );
	unsigned char GetValue( unsigned int xi, unsigned int yi ) const;

	/// ̰
	bool GetHeight( float* height, unsigned int xi, unsigned int yi ) const;
	bool GetHeight( float* height, const NiPoint3& pos ) const;

	/// ׸ ũ
	unsigned int GetCellCount() const;

	///  
	float GetMetersPerVertex() const;

	/// ʹ 
	unsigned int GetUnitsPerMeter() const;

	///  
	float GetUnitsPerVertex() const;

private:
	/// ׸ ũ⸦ ˻
	bool CheckCellCount( unsigned int cellCount );

private:
	/// ׸ ũ
	unsigned int mCellCount;
	unsigned int mLineCount;

	///  
	float mMetersPerVertex;

	/// ʹ  ( 100 )
	unsigned int mUnitsPerMeter;

	///  
	float mUnitsPerVertex;

	/// ʵ尪 迭
	unsigned char** mpValues;
	unsigned char* mValues;

	/// ̰ 迭
	float** mpHeights;
	float* mHeights;
};

inline
void cNaviField::SetValue( unsigned int xi, unsigned int yi, unsigned char value )
{
	assert( mValues );

	unsigned int i = yi * mLineCount + xi;
	mValues[i] = value;
}

inline
unsigned int cNaviField::GetCellCount() const
{
	return mCellCount;
}

inline
float cNaviField::GetMetersPerVertex() const
{
	return mMetersPerVertex;
}

inline
unsigned int cNaviField::GetUnitsPerMeter() const
{
	return mUnitsPerMeter;
}

inline
float cNaviField::GetUnitsPerVertex() const
{
	return mUnitsPerVertex;
}
