/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      : ׺޽
* ǻ : 
*===========================================================================*/
#pragma once

#include "Shader.h"

class cRay;
class cBox;
class cNaviMeshNode;
class cNaviMeshBranchNode;
class cNaviMeshLeafNode;

/// ׺޽ 
const unsigned int NAVIMESH_DEFAULT_RESOLUTION = 512;
const unsigned int NAVIMESH_BUFF_CELL_COUNT = 128;
const unsigned int NAVIMESH_BUFF_LINE_COUNT = NAVIMESH_BUFF_CELL_COUNT + 1;
const unsigned int NAVIMESH_BUFF_VERT_COUNT = NAVIMESH_BUFF_LINE_COUNT * NAVIMESH_BUFF_LINE_COUNT;
const unsigned int NAVIMESH_LEAF_CELL_COUNT = 8;
const unsigned int NAVIMESH_LEAF_LINE_COUNT = NAVIMESH_LEAF_CELL_COUNT + 1;
const unsigned int NAVIMESH_LEAF_LINE_COUNT_X2 = NAVIMESH_LEAF_LINE_COUNT * 2;
const unsigned int NAVIMESH_LEAF_VERT_COUNT = NAVIMESH_LEAF_LINE_COUNT * NAVIMESH_LEAF_LINE_COUNT;

/// ׺޽  
#pragma pack( push, 1 )
class cNaviMeshFileHeader
{
public:
	/// ĺ ڵ
	char mCode[13];

	/// 
	unsigned int mVersion;

	/// ׸ ũ ( )
	unsigned int mCellCount;

	///   
	float mMetersPerVertex;

	/// ʹ   ( 100 )
	unsigned int mUnitsPerMeter;
};
#pragma pack( pop )

/// ׺޽
class cNaviMesh
{
	static cNaviMesh* mSingleton;
	friend class cNaviMeshLeafNode;

public:
	static const unsigned int MAX_NODES = 21845;

public:
	cNaviMesh();
	~cNaviMesh();

	/// 
	void Clear();

	/// ε
	bool LoadHeader( unsigned int mapIdx, const cString& pathName );
	int LoadNodes( unsigned int count );

	/// ŷ
	bool Pick( NiPoint3* pos, int mouseX, int mouseY );
	bool Pick( NiPoint3* pos, const cRay& ray );
	bool Pick( NiPoint3* pos, float* dist, const cRay& ray, float maxDistance );

	/// ̰
	bool CalcHeight( float* height, float x, float y ) const;
	const float* GetHeights() const;

	/// ׸  
	unsigned int GetCellCount() const;

	///  ͼ 
	float GetMetersPerVertex() const;

	/// ʹ  
	unsigned int GetUnitsPerMeter() const;

	///    
	float GetUnitsPerVertex() const;

	///     
	float GetUnitsPerLeafNode() const;

	/// ش ġ  带 
	cNaviMeshLeafNode* GetLeafNode( float x, float y ) const;

	/// ׺޽ ü δ  ڸ 
	const cBox& GetBoundBox() const;

	///   
	float GetSegmentLength() const;

protected:
	/// ׸ ũ⸦ ˻
	bool CheckCellCount( unsigned int cellCount );

	/// ش ġ  带 
	void SetLeafNode( unsigned int xi, unsigned int yi, cNaviMeshLeafNode* node );

	/// ̰
	void SetHeight( unsigned int xi, unsigned int yi, float height );
	float GetHeightFast( unsigned int xi, unsigned int yi ) const;

	/// ؽó ǥ 迭
	NiPoint2* GetTexCoords() const;

	///  Ʈ 迭
	unsigned short* GetStripLength();
	unsigned short* GetStripIndex();

public:
	/// ü 
	static cNaviMesh* GetSingleton();

private:
	/// ׸ ũ
	unsigned int mCellCount;
	unsigned int mLineCount;

	/// 
	float mMetersPerVertex;
	unsigned int mUnitsPerMeter;
	float mUnitsPerVertex;
	float mUnitsPerLeafNode;

	///   
	float mSegmentLength;

	/// Ʈ 
	cNaviMeshBranchNode* mRootNode;

	///   迭
	typedef tPointerArray<void*> cLeafNodeArray;
	cLeafNodeArray mNodeArray;

	///  迭
	float* mHeights;

	/// ε
	cFileLoader mLoader;
	cNaviMeshNode** mLoadArray;
	unsigned int mLoadCount;
	unsigned int mLoadIndex;
};

inline
void cNaviMesh::SetHeight( unsigned int xi, unsigned int yi, float height )
{
	mHeights[yi * mLineCount + xi] = height;
}

inline
float cNaviMesh::GetHeightFast( unsigned int xi, unsigned int yi ) const
{
	return mHeights[yi * mLineCount + xi];
}

inline
const float* cNaviMesh::GetHeights() const
{
	return mHeights;
}

inline
unsigned int cNaviMesh::GetCellCount() const
{
	return mCellCount;
}

inline
float cNaviMesh::GetMetersPerVertex() const
{
	return mMetersPerVertex;
}

inline
unsigned int cNaviMesh::GetUnitsPerMeter() const
{
	return mUnitsPerMeter;
}

inline
float cNaviMesh::GetSegmentLength() const
{
	return mSegmentLength;
}

inline
float cNaviMesh::GetUnitsPerVertex() const
{
	return mUnitsPerVertex;
}

inline
float cNaviMesh::GetUnitsPerLeafNode() const
{
	return mUnitsPerLeafNode;
}

inline
cNaviMesh* cNaviMesh::GetSingleton()
{
	return mSingleton;
}

#define NAVIMESH cNaviMesh::GetSingleton()
