/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      : ׺޽ 
* ǻ : 
*===========================================================================*/
#pragma once

#include "Box.h"

class cRay;
class cNaviMeshBranchNode;
class cNaviMeshLeafNode;

/// ׺޽ 
class cNaviMeshNode
{
public:
	cNaviMeshNode( unsigned int xi, unsigned int yi, unsigned int cellCount );
	virtual ~cNaviMeshNode();

	/// ε
	virtual bool Load( cFileLoader& loader ) = 0;
	virtual void AddToLoadArray( cNaviMeshNode** loadArray, unsigned int& count ) = 0;

	/// 浹 ˻
	virtual bool CollideRay() = 0;

	///  
	const cBox& GetBoundBox() const;

public:
	///  
	cBox mBoundBox;
	NiPoint3 mCenter;
	float mRadius;

protected:
	/// 浹 ˻
	static const cRay* mRay;
	static float mMaxDistance;
	static float* mDistance;
	static NiPoint3* mContact;
};

inline
const cBox& cNaviMeshNode::GetBoundBox() const
{
	return mBoundBox;
}

/// ׺޽  
class cNaviMeshBranchNode : public cNaviMeshNode
{
public:
	cNaviMeshBranchNode( unsigned int xi, unsigned int yi, unsigned int cellCount );
	~cNaviMeshBranchNode();

	/// ε
	bool Load( cFileLoader& loader );
	void AddToLoadArray( cNaviMeshNode** loadArray, unsigned int& count );

	/// 浹 ˻
	bool CollideRay();

public:
	/// ڽ 迭
	cNaviMeshNode* mChild[4];
};

/// ׺޽  
class cNaviMeshLeafNode : public cNaviMeshNode
{
	friend class cNaviMesh;
	friend class cNaviMeshBranchNode;

public:
	cNaviMeshLeafNode( unsigned int xi, unsigned int yi, unsigned int cellCount );
	~cNaviMeshLeafNode();

	/// ε
	bool Load( cFileLoader& loader );
	void AddToLoadArray( cNaviMeshNode** loadArray, unsigned int& count );

	/// 浹 ˻
	bool CollideRay();

private:
	/// ǥ (׺޽ ׸  ġ)
	unsigned int mXIndex;
	unsigned int mYIndex;

private:
	/// 
	static unsigned int mVersion;

	///   ׸ ũ
	static unsigned int mCellCount;
	static unsigned int mLineCount;
};
