/* ==========================================================================
*    : ̹
*    : 2007.01.18
*      : NifϿ  ִϸ̼ 
* ǻ : 
*===========================================================================*/
#pragma once

class cNifTimeManager 
{
public:
	enum 
	{
		TM_SCALE_FACTOR = 0,
		TM_START_TIME,
		TM_END_TIME,
		TM_TIME_MODE,
		TM_ENABLING
	};

	cNifTimeManager();

	float GetFrameTime( float fTime );
	float GetRewTime( float fTime );
	void SetFrameTime(float fTime);

	float GetScaleFactor() const;
	void SetScaleFactor(float fScale);

	float GetStartTime() const;
	void SetStartTime(float fStart);

	float GetEndTime() const;
	void SetEndTime(float fEnd);

	bool IsEnabled() const;
	void Enable();
	void Disable();

protected:
	float m_fAccumTime;
	float m_fScaleFactor;
	float m_fStartTime;
	float m_fEndTime;
	bool m_bTimingEnabled;

	float m_fLastTime;
};

//---------------------------------------------------------------------------
inline float cNifTimeManager::GetScaleFactor() const
{ 
	return m_fScaleFactor;
}
//---------------------------------------------------------------------------
inline void cNifTimeManager::SetScaleFactor(float fScale)
{ 
	m_fScaleFactor = fScale;
}
//---------------------------------------------------------------------------
inline float cNifTimeManager::GetStartTime() const
{ 
	return m_fStartTime;
}
//---------------------------------------------------------------------------
inline void cNifTimeManager::SetStartTime(float fStart)
{ 
	m_fStartTime = fStart;
}
//---------------------------------------------------------------------------
inline float cNifTimeManager::GetEndTime() const
{ 
	return m_fEndTime;
}
//---------------------------------------------------------------------------
inline void cNifTimeManager::SetEndTime(float fEnd)
{ 
	m_fEndTime = fEnd;
}
//---------------------------------------------------------------------------
inline bool cNifTimeManager::IsEnabled() const
{
	return m_bTimingEnabled;
}
//---------------------------------------------------------------------------
inline void cNifTimeManager::Enable()
{
	m_bTimingEnabled = true;
	m_fLastTime = -NI_INFINITY;
}
//---------------------------------------------------------------------------
inline void cNifTimeManager::Disable()
{
	m_bTimingEnabled = false;
}
//---------------------------------------------------------------------------

class cNifAnimationInfo
{
public:
	cNifAnimationInfo();
	~cNifAnimationInfo();

	enum
	{
		eEvent_None = 0,
		eEvent_Ing,
		eEvent_End,
	};

	/// ִ     ̽
	void CollectData( NiNode* pRoot );

	/// Ʈѷ  
	inline unsigned int GetNumberOfControllers() { return mControllerCount; }
	/// ü Ʈѷ Ű  
	inline unsigned int GetNumberOfKeyframes() { return mKeyframeCount; }
	/// ü Ʈѷ ۽ð ּҽð
	inline float GetMinTime() { return (mMinTime == FLT_MAX)? 0:mMinTime; }
	/// ü Ʈѷ ð ִð
	inline float GetMaxTime() { return mMaxTime; }

	/// Ʈѷ Ӽ 
	void SetAnimType( NiTimeController::AnimType type );
	void SetCycleType( NiTimeController::CycleType type );
	void SetTarget( NiObjectNET* obj );

	/// ִϸ̼ Ȱȭ
	void Start( float time, bool begin = false );

	/// ִϸ̼ Ȱȭ
	void Stop();

	///    ó
	inline void SetLooping( bool loop ) { mLooping = loop; }
	inline bool IsLooping() { return mLooping; }
	inline bool IsEnable() { return mEnable; }

	/// ó
	unsigned char Update( unsigned long deltaTime, unsigned long accumTime );

	unsigned long GetFrameTime();

	void SetStopFlag( bool flag ) { mStopFlag = flag; }

protected:
	void Add(NiTimeController* pController);

	void AddInfo(NiTimeController* pController);
	void AddInterpInfo(NiInterpController* pController);
	void AddUVInfo(NiUVController* pController);

	void FindAndAdd(NiObjectNET* pkRoot);

protected:
	/// ü Ʈѵ鿡  
	float mMinTime;
	float mMaxTime;

	float mStartTime;

	unsigned int mKeyframeCount;
	unsigned int mControllerCount;

	///  Ʈѵ Ʈ
	NiTPointerList<NiTimeController*> mControllerList;

	///  Ʈѵ鿡  ݺ 
	bool mLooping;

	/// ü Ʈѷ Ȱȭ 
	bool mEnable;
	bool mStopFlag;
};
