#include "StdAfx.h"
#include "NoteListBox.h"
#include "ListBox.h"
#include "UIImage.h"
#include "FontAgent.h"

cNoteListBox::cNoteListBox( eUINodeType type )
: cListBox( type )
{
	mCheckSkin = 0;
	mNoCheckSkin = 0;
}

cNoteListBox::~cNoteListBox()
{

}

void  cNoteListBox::SetCheckSkin( cUINodeSkin* nodeSkin )
{
	if( nodeSkin )
		mCheckSkin = nodeSkin;
}

void cNoteListBox::SetNoCheckSkin( cUINodeSkin* nodeSkin )
{
	if( nodeSkin )
		mNoCheckSkin = nodeSkin;
}

/// ǻ : Ʈ  ׷ֱ
void cNoteListBox::RenderData( cUIFontItemKeeper* pKeeper )
{
	/// ü Ʈ  
	if( GetRowCount() <= 0 )
		return;

	/// Ų ޾ƿ 
	cListBoxSkin* pListSkin = (cListBoxSkin*)mpSkin;
	if( !pListSkin )
		return;

	/// Ʈ ڽ ǥ ޾ƿ
	int textposX = 0;
	int textPosY = GetAbsoluteRect().mTop + 1;

	unsigned int rowCount = ( mMaxRowInPage > GetRowCount() )? GetRowCount() : mMaxRowInPage;
	for( unsigned int row = mTopRowIdx; row < mTopRowIdx + rowCount; ++row )
	{
		sRowData* rData = GetRowData( row );
		if( !rData )
			continue;

		/// image  
		if( rData->mImage )
		{
			cUIImage* image = rData->mImage;

			sListCtrlParam* pParam = pListSkin->mpImgParam;
			unsigned int imageX = pParam->mColumnX;
			unsigned int imageY = textPosY + (int)((mRowHeight-image->GetHeight())*0.5f);

			if( mChange == true )
			{
				cUIRect rc = image->GetTextureRect();
				bool check = GetCheck( row );
				if( check == true )
				{
					image->SetTextureRect( mCheckSkin->mSkinInfo->mTexX, mCheckSkin->mSkinInfo->mTexY, 
										   mCheckSkin->mSkinInfo->mTexX + mCheckSkin->mSkinInfo->mTexWidth, 
										   mCheckSkin->mSkinInfo->mTexY + mCheckSkin->mSkinInfo->mTexHeight );
				}
				else
				{
					image->SetTextureRect( mNoCheckSkin->mSkinInfo->mTexX, mNoCheckSkin->mSkinInfo->mTexY, 
											mNoCheckSkin->mSkinInfo->mTexX + mNoCheckSkin->mSkinInfo->mTexWidth, 
											mNoCheckSkin->mSkinInfo->mTexY + mNoCheckSkin->mSkinInfo->mTexHeight );
				}
			}

			image->SetPos( GetAbsoluteRect().mLeft + imageX, imageY );
			image->Draw();
		}

		/// Ʈ  
		unsigned int colCount = rData->mColumes.GetSize();
		for( unsigned int col = 0; col< colCount; ++col )
		{
			///  ÷  
			sData* data = rData->mColumes[col];

			///  ÷ param data  ( ġ  )
			sListCtrlParam* pParam = pListSkin->GetCtrlParam( col );

			unsigned int tX = 0;
			unsigned int tW = 0;
			eText_Align align = eALIGN_LEFT;

			if( pParam )
			{
				tX = pParam->mColumnX;
				tW = pParam->mColumnW;
				align = pParam->mAlign;
			}

			///   ǥ  
			unsigned int strWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, (LPTSTR)data->mText.Cstr(), data->mText.GetLength() );
			textposX = UpdateTextPos( align, strWidth, tX, tW );

			/// Hover   ٸ  ǥ
			unsigned color = data->mTextColor;
			if( mHoveredRowIdx != -1 && row - mTopRowIdx == (unsigned int)mHoveredRowIdx )
				color = eCOLOR_RED;

			int addY = (int)((mRowHeight-FONTAGENT->GetTextHeight(cFontAgent::eFont_System))*0.5f);
			pKeeper->AddFontItem( cFontAgent::eFont_System, (LPTSTR)data->mText.Cstr(), textposX, textPosY + addY, color );
		}

		textPosY += mRowHeight;
	}

}