#include "StdAfx.h"
#include "NoteWindow.h"
#include "SendNoteWindow.h"
#include "ReceiveNoteWindow.h"
#include "NoteListBox.h"
#include "CheckBox.h"
#include "TabWindow.h"
#include "TabButton.h"
#include "ChatManager.h"
#include "UINodeData.h"
#include "GameUIManager.h"

#include "Protocol.h"
#include "Chat_Common.h"
#include "UIImage.h"
#include "Button.h"
#include "Radiobutton.h"
#include "GameResourceManager.h"

cNoteWindow::cNoteWindow()
: mpNoteList(0)
, mpImage(0)
, mpDelButton(0)
{
	for( int i = 0; i < MAXNUM; ++i )
		mpRadioNode[i] = 0;

	mCheckRect.Set( 0, 0, 0, 0 );
}

cNoteWindow::~cNoteWindow()
{
	SAFE_DELETE( mpImage );
}

///
void cNoteWindow::Clear()
{
	if( mpNoteList )
		mpNoteList->Clear();

	for( int i = 0 ; i < MAXNUM; ++i )
	{
		if( mpRadioNode[i] )
			mpRadioNode[i]->Hide();
	}
}

/// ǻ : 
bool cNoteWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	/// chat Ŵ  
	CHATMANAGER->SetNoteWindow( this );

	/// Ʈڽ 
	mpNoteList = (cNoteListBox*)GetChild( eUIID_GAME_NOTE_LISTBOX );
	mpDelButton = (cButton*)GetChild( eUIID_GAME_NOTE_DELETE_BUTTON );

	if( !mpNoteList )
	{
		assert(0);
		return false;
	}

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	/// Ʈڽ ̹
	cUINodeSkin* pCheckSkin = pSkin->GetNodeSkin( "Note_Check" );
	cUINodeSkin* pNoCheckSkin = pSkin->GetNodeSkin( "Note_NoCheck" );
	if( pCheckSkin && pNoCheckSkin )
	{
		mpNoteList->SetCheckSkin( pCheckSkin );
		mpNoteList->SetNoCheckSkin( pNoCheckSkin );

		///
		mpImage = new cUIImage( pNoCheckSkin->mpTexture );
		unsigned int tx = pNoCheckSkin->mSkinInfo->mTexX;
		unsigned int ty = pNoCheckSkin->mSkinInfo->mTexY;
		unsigned int x = pNoCheckSkin->mSkinInfo->mX;
		unsigned int y = pNoCheckSkin->mSkinInfo->mY;
		unsigned int w = pNoCheckSkin->mSkinInfo->mWidth;
		unsigned int h = pNoCheckSkin->mSkinInfo->mHeight;

		mpImage->SetTextureRect( cUIRect(tx, ty, tx+w, ty+h ) );
		mpImage->SetScreenRect( cUIRect(x, y, x+w, y+h ) );
	}

	/// Ŀ
	cUINodeSkin* pRectSkin = pSkin->GetNodeSkin( "Note_ButtonRect" );
	if( pRectSkin )
	{
		mCheckRect.mLeft = pRectSkin->mSkinInfo->mX;
		mCheckRect.mTop = pRectSkin->mSkinInfo->mY;
		mCheckRect.mRight = mCheckRect.mLeft + pRectSkin->mSkinInfo->mWidth;
		mCheckRect.mBottom = mCheckRect.mTop + pRectSkin->mSkinInfo->mHeight;
	}
	
	for( int i = 0; i < MAXNUM; ++i )
	{
		mpRadioNode[i] = (cRadioButton*)GetChild( eUIID_GAME_NOTE_RADIOBUTTON1 + i );
		if( mpRadioNode[i] )
			mpRadioNode[i]->Hide();
	}

	/// üũڽ ̹  
	if( mpNoteList )
		mpNoteList->SetChange( true );
	return true;
}

///
void cNoteWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_NOTE_CLOSE_BUTTON:
		{
			Hide();
		}
		break;
	case eUIID_GAME_NOTE_WRITE_BUTTON:
		{
			cSendNoteWindow* sendNote = GAMEUI->GetSendNoteWindow();
			if( sendNote && sendNote->IsVisible() == false )
				sendNote->ShowTop();
		}
		break;
	case eUIID_GAME_NOTE_DELETE_BUTTON:
		{
			///
			DeleteNote();	
		}
		break;
	}
}

///
void cNoteWindow::OnRadioPressed( cUINode*, unsigned int id )
{
	int row = 0;
	switch( id )
	{
	case eUIID_GAME_NOTE_RADIOBUTTON1:	row = 0; break;
	case eUIID_GAME_NOTE_RADIOBUTTON2:	row = 10; break;
	case eUIID_GAME_NOTE_RADIOBUTTON3:	row = 20; break;
	case eUIID_GAME_NOTE_RADIOBUTTON4:	row = 30; break;
	case eUIID_GAME_NOTE_RADIOBUTTON5:	row = 40; break;
	default: assert(0); return;
	}	

	if( mpNoteList )
		mpNoteList->ChangeTopIndex( row );
}

///
void cNoteWindow::OnListBoxSelected( cUINode*, unsigned int )
{
	if( !mpNoteList )
		return;

	cReceiveNoteWindow* recvNote = GAMEUI->GetReceiveNoteWindow();
	if( recvNote )
	{
		unsigned int selectIdx = mpNoteList->GetSelectIndex();

		///  ̸,  ޾ƿ 
		sNoteList* data = (sNoteList*)mpNoteList->GetExtraData( selectIdx );
		if( data )
		{
			recvNote->SetName( data->CharacterName );
			recvNote->SetText( data->Message );
			recvNote->ShowTop();
		}
		else
		{
			assert(0);
		}
	}
}

void cNoteWindow::AddNote( sNoteList* data )
{
	if( !mpNoteList || !data ) 
	{
		assert(0);
		return;
	}

	cStringT day;
	cStringT time;
	cStringT remain;

	if( mpNoteList->GetRowCount() < mpNoteList->GetMaxRowNum() )
	{
		day.Format( GAMERESOURCEMAN->GetGameText( 64 ), data->Month, data->Day );
		time.Format( GAMERESOURCEMAN->GetGameText( 65 ), data->Hour, data->Minute );

		///  ϼ 
		long remainDay = data->RemainTime / (86400*1000);
		remain.Format( GAMERESOURCEMAN->GetGameText( 66 ), remainDay );

		///   
		int row = mpNoteList->AddRow( data->CharacterName, mDefaultColor, data, mpImage );
		if( row != -1 )
		{
			mpNoteList->AddColume( row, (LPCTSTR)day.Cstr(), mDefaultColor );
			mpNoteList->AddColume( row, (LPCTSTR)time.Cstr(), mDefaultColor );
			mpNoteList->AddColume( row, (LPCTSTR)remain.Cstr(), mDefaultColor );
		}
		else
		{
			assert(0);
		}
	}
	else
	{
		assert(0);
	}
}

///
void cNoteWindow::DeleteNote()
{
	if( !mpNoteList )
		return;

	/// ִ ư ã 
	unsigned int page = 0;
	for( int i = 0; i < MAXNUM; ++i )
	{
		if( mpRadioNode[i]->IsPress() == true )
		{
			page = i;
			break;
		}
	}

	MSG_REQ_NOTE_DEL msg;
	::memset( &msg, 0, sizeof(msg) );

	msg.Category = NM_CHAT;
	msg.Protocol = NM_CHAT_NOTE_DEL_REQ;
	msg.RowCount = 0;

	unsigned int maxCount = (page + 1) * 10;
	unsigned int rowCount = mpNoteList->GetRowCount();

	///  ˻
	for( unsigned int i = page * 10; i < maxCount; ++i )
	{
		if( i >= rowCount )
			break;

		bool check = mpNoteList->GetCheck( i );
		if( check )
		{
			sNoteList* data = (sNoteList*)mpNoteList->GetExtraData( i );
			if( data )
			{
				msg.Idx[ msg.RowCount++ ] = data->Idx;
			}
			else
			{
				assert(0);
			}
		}
	}
	
	if ( msg.RowCount > 0 )
	{
		NETWORK->SendNetworkMsg( (char*)&msg, (unsigned short)msg.GetMsgLength( ) );

		/// 
		NetLock();
	}
}

void cNoteWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();
	UpdateButton();
}

void cNoteWindow::UpdateButton()
{
	/// ư ̰ Ⱥ̰ ϱ
	int total = mpNoteList->GetRowCount() - 1;
	int page = ( total / 10 );

	for( int i = 0; i < MAXNUM; ++i )
	{
		if( mpRadioNode[i] )
		{
			if( i <= page )
				mpRadioNode[i]->Show();
			else
				mpRadioNode[i]->Hide();
		}
	}

	int w = mpRadioNode[0]->GetAbsoluteRect().GetWidth();	
	int x = mCheckRect.mLeft + (int)((mCheckRect.GetWidth() - (w*(page+1))) * 0.5f);
	for( int i = 0; i <= page; ++i )
	{
		cUIPos pos;
		pos.mX = x + (w*i);
		pos.mY = mpRadioNode[i]->GetRelativeRect().mTop;
		mpRadioNode[i]->SetRelativePos( pos );
	}

	if( mpRadioNode[0] )
		mpRadioNode[0]->SetPress( true );
	
}

void cNoteWindow::OnNetLock( int lockTry )
{
	if( mpDelButton )
		mpDelButton->NetLock( lockTry );
}

void cNoteWindow::OnNetUnLock( int lockTry )
{
	if( mpDelButton )
		mpDelButton->NetUnLock( lockTry );
}
