#include "StdAfx.h"
#include "NoticeMsgPlane.h"
#include "RenderSystem.h"
#include "FontAgent.h"
#include "Application.h"

cNoticeMsgPlane::cNoticeMsgPlane()
{
}

cNoticeMsgPlane::~cNoticeMsgPlane()
{
	cMsgList::cIterator i = mMsgList.Begin();
	cMsgList::cIterator end = mMsgList.End();
	for( ; i != end; ++i )
	{
		sNoticeMsgItem* p = (sNoticeMsgItem*)(*i);
		if( p )
			SAFE_DELETE(p);
	}
	mMsgList.Clear();

	/// 
	cMsgList::cIterator di = mMsgDelList.Begin();
	cMsgList::cIterator dend = mMsgDelList.End();
	for( ; di != dend; ++di )
	{
		sNoticeMsgItem* p = (sNoticeMsgItem*)(*i);
		SAFE_DELETE( p );
	}
	mMsgDelList.Clear();
}

void cNoticeMsgPlane::ActiveMsg( LPCTSTR msg, unsigned long color )
{
	if( msg == 0 )
		return;

	sNoticeMsgItem* msgItem = new sNoticeMsgItem;
	Sstrncpy( msgItem->msg, NOTICEMSG_TEXT_LENGTH, msg, NOTICEMSG_TEXT_LENGTH-1 );
	msgItem->msgLength = ::_tcslen( msgItem->msg );
	msgItem->color = color;

	long width = FONTAGENT->GetTextExtent( cFontAgent::eFont_Notice, msgItem->msg, msgItem->msgLength );
	msgItem->posX = (int)( (RENDERSYS->GetScreenWidth() - width) * 0.5f);

	/// ð 
	msgItem->startTime = THEAPP->GetWorldAccumTime();

	///  ̸̻ 
	if( mMsgList.GetSize() >= MAX_NOTICCOUNT )
	{
		sNoticeMsgItem* p = (sNoticeMsgItem*)mMsgList.Front();
		if( p )
			SAFE_DELETE(p);

		mMsgList.PopFront();
	}

	/// 
	mMsgList.PushBack( msgItem );
}

void cNoticeMsgPlane::Update( unsigned long deltaTime, unsigned long accumTime )
{
	cMsgList::cIterator i = mMsgList.Begin();
	cMsgList::cIterator end = mMsgList.End();
	for( ; i != end; ++i )
	{
		sNoticeMsgItem* item = (sNoticeMsgItem*)(*i);
		if( !item )
			continue;

		/// ð  
		if( item->startTime + NOTICEMSG_ACTIVE_TIME <= accumTime )
		{
			mMsgDelList.PushBack( item );
		}
	}

	/// 
	cMsgList::cIterator di = mMsgDelList.Begin();
	cMsgList::cIterator dend = mMsgDelList.End();
	for( ; di != dend; ++di )
	{
		sNoticeMsgItem* p = (sNoticeMsgItem*)(*di);
		if( p )
		{
			mMsgList.Remove( p );
			SAFE_DELETE( p );
		}
	}
	mMsgDelList.Clear();
}

void cNoticeMsgPlane::Draw()
{
	if( mMsgList.IsEmpty() == true )
		return;

	unsigned int y = PRINT_POSY;
	cMsgList::cIterator i = mMsgList.Begin();
	cMsgList::cIterator end = mMsgList.End();
	for( ; i != end; ++i )
	{
		sNoticeMsgItem* item = (sNoticeMsgItem*)(*i);
		if( !item )
			continue;

		FONTAGENT->DrawText( cFontAgent::eFont_Notice, item->msg, item->msgLength, item->posX, y, item->color, true );
		y += FONTAGENT->GetTextHeight( cFontAgent::eFont_Notice );
	}
}