/* ====================================================================
 *      :	Npc.h
 *      :	Npc ü
 *    :	̹
 *    :	2006.12.20
 * ǻ :	
 * =================================================================== */
#pragma once
#include "BaseObject.h"
#include "Npc_Common.h"

enum eNpcAniType
{
	NPC_ANI_IDLE1 = 1,
	NPC_ANI_IDLE2,
	NPC_ANI_EVENT,
	NPC_ANI_ENDSPEECH,
	NPC_ANI_ETC,
};

class cNpc : public cBaseObject
{
public:
	cNpc( unsigned char type = eOBJECTTYPE_NPC );
	virtual ~cNpc();

	inline virtual unsigned long	GetObjectID() { return mObjectId; }

	virtual bool Create( unsigned long objId, unsigned long npcClassIdx, unsigned char questStatus, NiPoint3 sPos, NiMatrix3 sRot = NiMatrix3::IDENTITY, float fScale = 1.0f );

	virtual void Update( unsigned long deltaTime, unsigned long accumTime );

	virtual LPTSTR	GetName();

	LPTSTR	GetJobName();

	void SetQuestStatus( unsigned char status );

	void test();


	unsigned long GetClassId() { return mpNpcClassInfo->mNpcClassIdx; }

protected:
	/// ִϸ̼  
	virtual void Interpret( unsigned long time );

protected:
	/// npc ε
	unsigned long		mObjectId;

	/// npc  ..
	sNPCList*			mpNpcClassInfo;

	/// ̵   
	NiPoint3			mDesiredDir;

	unsigned char		mQuestStatus;

	unsigned long		mEffectIdx;
	cEffectSceneNode*	mQuestEffect;

};

inline LPTSTR cNpc::GetName()
{
	assert(mpNpcClassInfo);
	return mpNpcClassInfo->mName;
}

inline LPTSTR cNpc::GetJobName()
{
	assert( mpNpcClassInfo );
	return mpNpcClassInfo->mJobName;
}
