#include "stdafx.h"
#include "NpcDisjointWindow.h"
#include "TipWindow.h"
#include "GameUIManager.h"
#include "ItemManager.h"
#include "Icon.h"
#include "Gauge.h"
#include "Label.h"
#include "NumberEditBox.h"
#include "Button.h"
#include "ItemIcon.h"
#include "GameResourceManager.h"
#include "ChatManager.h"

cNpcDisjointWindow::cNpcDisjointWindow()
: mItemSlotIndex( UINT_MAX )
, mpGaugeBar(0)
, mpPrice(0)
, mpDisjointButton(0)
, mItemIcon(0)
{
	for( int i = 0; i < DISJOINT_COUNT; ++i )
		mResultIcon[i] = 0;
}

cNpcDisjointWindow::~cNpcDisjointWindow()
{
}

/// ʱȭ
void cNpcDisjointWindow::Clear()
{
	///  ʱȭ
	mItemIcon->ChangeImage( 0 );

	for( unsigned int i = 0; i < DISJOINT_COUNT; ++i )
	{
		mResultIcon[i]->ChangeImage( 0 );
		mResultIcon[i]->SetItemIndex( 0 );
		mResultIcon[i]->ShowNumber( false );
		mResultIcon[i]->SetNumber( 0 );
	}

	///   ʱȭ
	if( mItemSlotIndex <= MAX_INVENTORY )
	{
		cItem& oldItem = ITEMMAN->GetItem( mItemSlotIndex );
		oldItem.SetLock( false );
		mItemSlotIndex = UINT_MAX;
	}

	if( mpGaugeBar )
		mpGaugeBar->ClearFront();

	SetPrice( 0 );

	///
	NetUnLock();
}

void cNpcDisjointWindow::OnHide()
{
	cUIWindow::OnHide();

	///
	UIMAN->HideNpcBack();

	///
	Clear();
}

bool cNpcDisjointWindow::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;

	mpGaugeBar = (cGauge*)GetChild( eUIID_GAME_NPCDISJOINT_GAUGEBAR );
	mpPrice	   = (cLabel*)GetChild( eUIID_GAME_NPCDISJOINT_PRICE );
	mpDisjointButton = (cButton*)GetChild( eUIID_GAME_NPCDISJOINT_DISJOINT );

	if( mpGaugeBar )
		mpGaugeBar->SetMaxValue( 100 );

	///    
	cString str;
	for( unsigned int i = 0; i < DISJOINT_COUNT; ++i )
	{
		str.Format( "Disjoint_Result%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, i+1 ) == false )
			return false;

		icon->SetUsedFlag( false, false );
		mResultIcon[i] = icon;
	}

	///    
	mItemIcon = new cItemIcon;
	if( mItemIcon->CreateBySkinName( "Disjoint_Item", this, 100 ) == false )
		return false;

	/// hover ̺Ʈ ó ̵ Ұ 
	mItemIcon->SetUsedFlag( false, false );
	mItemIcon->SetSlotIndex( DISJOINT_SLOT );
	mItemIcon->SetLinked( true );	/// κ丮  

	//
	SetPrice(0);
	return true;
}

//bool cNpcDisjointWindow::HandleEvent( const cUIEvent& event )
//{
//	///  ̺Ʈ ޱ 
//	if( mVisible == false )
//		return false;
//
//	if( cUIContainer::HandleEvent( event ) == false )
//		return false;
//	return true;
//}

void cNpcDisjointWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_NPCDISJOINT_CLOSE:
	case eUIID_GAME_NPCDISJOINT_CANCEL:
		/// ݱư
		Hide();
		break;
	case eUIID_GAME_NPCDISJOINT_DISJOINT:
		if( mItemSlotIndex <= MAX_INVENTORY )
		{
			///  ǰ˻
			if( ITEMMAN->CheckDisjoint( mItemSlotIndex ) == false )
				return;

			if( mpGaugeBar )
				mpGaugeBar->SetGaugeAni( 100.0f );

			///  ɱ
			NetLock();
		}
		break;
	}
}

void cNpcDisjointWindow::OnGaugeEnd( cUINode* n , unsigned int )
{
	if( mpGaugeBar && n == mpGaugeBar )
	{
		/// ؽ۹ư
		if( ITEMMAN->TryToDisjoint( mItemSlotIndex ) == false )
		{
			NetUnLock();
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 261 ) );

			if( mpGaugeBar )
				mpGaugeBar->ClearFront();
		}

		UIMAN->HideTip();
	}
}

///   
bool cNpcDisjointWindow::AddItem( unsigned int slotIndex )
{
	/// ̹ ̸ 
	if( mpDisjointButton->IsNetLock() == true )
		return false;

	if( slotIndex > MAX_INVENTORY )
		return false;

	cItem& item = ITEMMAN->GetItem( slotIndex );
	cItemDefine* define = item.GetDefine();
	if( !define )
	{
		assert(0);
		return false;
	}

	sItemDisjoint* data = define->GetDisjoint();
	if( !data )
		return false;

	///   ʱȭ
	for( unsigned int i = 0; i < DISJOINT_COUNT; ++i )
	{
		mResultIcon[i]->ChangeImage( 0 );
		mResultIcon[i]->SetTipType( eTOOLTIP_NONE );
		mResultIcon[i]->SetNumber( 0 );
		mResultIcon[i]->SetItemIndex( 0 );
		mResultIcon[i]->ShowNumber( false );
	}

	///    
	if( mItemSlotIndex <= MAX_INVENTORY && mItemSlotIndex != slotIndex )
	{
		cItem& oldItem = ITEMMAN->GetItem( mItemSlotIndex );
		oldItem.SetLock( false );
	}

	///   ε
	mItemSlotIndex = slotIndex;
	item.SetLock( true );

	///  ̹ ü
	mItemIcon->SetItemIndex( item.GetIndex() );
	mItemIcon->ChangeImage( define->GetIconParam() );
	mItemIcon->SetTipType( define->GetTipType() );

	///     
	int result = 0;
	for( int i = 0 ; i < MAX_DISJOINT; ++i, ++result )
	{
		if( data->mDisjoint[i].itemIndex == 0 )
			break;

		cItemDefine* resultDefine = ITEMMAN->GetItemDefine( data->mDisjoint[i].itemIndex );
		if( !resultDefine )
		{
			assert(0);
			return false;
		}

		///  
		mResultIcon[result]->SetItemIndex( data->mDisjoint[i].itemIndex );
		mResultIcon[result]->ChangeImage( resultDefine->GetIconParam() );
		mResultIcon[result]->SetNumber( data->mDisjoint[i].count );
		mResultIcon[result]->SetTipType( resultDefine->GetTipType() );

		bool show = ( resultDefine->GetCapacity() > 1 ) ? true : false;
		mResultIcon[result]->ShowNumber( show );
	}

	SetPrice( data->mPrice );
	return true;
}

void cNpcDisjointWindow::SetPrice( unsigned int price )
{
	if( mpPrice )
	{
		LPCTSTR value = cNumberEditBox::FormatNumber( price );
		mpPrice->SetText( value );
	}
}

///
void cNpcDisjointWindow::OnNetLock( int lockTry )
{
	if( mpDisjointButton )
		mpDisjointButton->NetLock( lockTry );
}

void cNpcDisjointWindow::OnNetUnLock( int lockTry )
{
	if( mpDisjointButton )
		mpDisjointButton->NetUnLock( lockTry );
}

void cNpcDisjointWindow::OnIconHovered( cUINode* caller, unsigned int id, const cUIPos& pos )
{
	cIcon* hoverIcon = (cIcon*)caller;
	if( hoverIcon == mItemIcon && mItemSlotIndex <= MAX_INVENTORY )
	{
		cItem& item = ITEMMAN->GetItem( mItemSlotIndex );
		UIMAN->ShowItemTip( eTIP_ITEM, pos, item.GetIndex(), mItemSlotIndex, 0 );
	}
}