/* ==========================================================================
*      : NpcRewardWindow.h
*      : 
*    : 谡
*    : 2008-06-20
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "QuestWindow.h"

class cLabel;
class cUIImage;
struct sRewardIcon;

///   ̹ 
struct sRewardBack
{
	cUIImage*		mpImage;
	cUINodeSkin*	mpNodeSkin;
	bool			mShow;

	sRewardBack()
	{
		mpImage = 0;
		mpNodeSkin = 0;
		mShow = false;
	}
};

enum eRewardBack
{
	eBACK_DEFAULT = 0,
	eBACK_SELECT,
	eBACK_EXP,
	eBACK_SXP,
	eBACK_MONEY,
	eBACK_SKILLPOINT,

	eBACK_MAX,
};

class cNpcRewardWindow : public cUIWindow
{
public:
	cNpcRewardWindow();
	virtual ~cNpcRewardWindow();

	/// Ʈ  
	bool SetQuestReward( unsigned long questIdx );
	unsigned int GetSelectCount() { return mCount; }

	///    
	void UpdateUseReward( unsigned long questIdx );

	sRewardIcon* GetSelectData() { return mSelectIcon; }

protected:
	bool OnCreate( cUINodeProperty* property );
	void OnIconHovered(cUINode* caller, unsigned int id, const cUIPos& pos );
	void OnIconClicked( cUINode*, unsigned int );
	void OnRender( cUIFontItemKeeper* pKeeper );
	void UpdateRect();
	void OnHide();

	bool UpdateReward( cQuestReward* reward, sRewardIcon* icon );

	void SetExp( unsigned int exp );
	void SetSxp( unsigned int sxp );
	void SetMoney( unsigned long money );
	void SetSkillPoint( unsigned int sp );
	void SetSelectCount( unsigned int count );

	void ClearIcon();

protected:
	///    
	bool	mUseReward;

	cLabel* mpCount;
	cLabel* mpEXP;
	cLabel* mpSXP;
	cLabel* mpSkillPoint;
	cLabel* mpMoney;

	///  ̹
	sRewardBack*	mBackData[eBACK_MAX];
	
	/// 
	sRewardIcon mDefaultIcon[5];
	sRewardIcon mSelectIcon[5];

	/// ÿ ̹ 
	cUIImage* mpSelectImg[5];
	cUISize	mSelectSize;
	unsigned int mMaxCount;	///   
	unsigned int mCount;	
};
