#pragma once

#include "DynamicSceneNode.h"

class cNpc;

/// NPC   
class cNpcSceneNodeParam : public cDynamicSceneNodeParam
{
public:
	cNpcSceneNodeParam();
};

inline cNpcSceneNodeParam::cNpcSceneNodeParam()
{
}

class cNpcSceneNode : public cDynamicSceneNode
{
	friend class cSceneManager;

public:
	virtual ~cNpcSceneNode();

	/// ʱȭ
	virtual bool Init( const cNpcSceneNodeParam& param );

	virtual const NiPoint3& GetObjectCenter();
	virtual const NiPoint3& GetObjectFoot();
	virtual const NiPoint3& GetObjectHead();

	virtual void AddDepthPlaneObject();

protected:
	cNpcSceneNode( eType type = eNPC );

	/// ũ Ѵ.
	virtual bool	InitLinkInfo();

	/// ⺻ ִϸ̼ Ѵ.
	virtual void	InitializeRandomIdle();

	///
	virtual cObjectNameCard* CreateNameCard( cBaseObject* pObj );
};


//////////////////////////////////////////////////////////////////////////
class cRefereeSceneNode : public cDynamicSceneNode
{
	friend class cSceneManager;

public:
	virtual ~cRefereeSceneNode();

	/// ʱȭ
	virtual bool Init( const cSceneNodeParam& param );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );

	virtual const NiPoint3& GetObjectFoot() { return NiPoint3::ZERO; }
	virtual const NiPoint3& GetObjectCenter() { return NiPoint3::ZERO; }
	virtual const NiPoint3& GetObjectHead() { return NiPoint3::ZERO; }

protected:
	cRefereeSceneNode( eType type = eDYNAMIC );

	/// ũ Ѵ.
	virtual bool	InitLinkInfo();

	void Interpret( unsigned long accumTime );

	cObjectNameCard* CreateNameCard( cBaseObject* pObj ) { return 0; }

	void AddToVisibleArray();
	void AddDepthPlaneObject() {}
};