#include "stdafx.h"
#include "NpcStoreWindow.h"
#include "NpcStoreListBox.h"
#include "NumberEditBox.h"
#include "GameUIManager.h"
#include "TipWindow.h"
#include "DragWindow.h"
#include "UIMsgboxEvent.h"
#include "RadioButton.h"
#include "Button.h"

cNpcStoreWindow::cNpcStoreWindow()
: mNpcIndex(0)
, mpList(0)
, mpRadioSkin(0)
, mpBuy(0)
{
	::memset( mpRadio, 0, sizeof( mpRadio ) );
}

cNpcStoreWindow::~cNpcStoreWindow()
{

}

void cNpcStoreWindow::OnShow()
{
	cUIWindow::OnShow();

	/// Ʈ 
	if( mpList )
	{
		mpList->Clear();

		///  
		cItemNpcStore* store = ITEMMAN->GetItemNpcStore( mNpcIndex );
		if( store )
		{
			///  ư 
			unsigned int tabCount = store->GetTabCount();
			for( unsigned int i = 0; i < tabCount; ++i )
			{
				/// 
				if( mpRadio[i] )
				{
					unsigned long textIndex = store->GetTextIndex( i );
					mpRadio[i]->SetText( UIMAN->GetUIText( textIndex ) );
					mpRadio[i]->Show();
				}
			}

			UpdateItemList( 0 );
		}
	}

	if( mpRadio[0] )
		mpRadio[0]->SetPress( true );
}

void cNpcStoreWindow::OnHide()
{
	cUIWindow::OnHide();

	///
	UIMAN->HideDrag( this );
	UIMAN->HideNpcBack();

	for( unsigned int i = 0; i < MAX_RADIO; ++i )
	{
		if( mpRadio[i] )
			mpRadio[i]->Hide();
	}
}

void cNpcStoreWindow::Show( unsigned long npcIndex )
{
	mNpcIndex = npcIndex;
	cUIWindow::Show();
}

bool cNpcStoreWindow::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;

	mpList = (cNpcStoreListBox*)GetChild( eUIID_NPCSTORE_LIST );
	mpBuy = (cButton*)GetChild( eUIID_NPCSTORE_BUY );

	cUISkin* pSkin = UIMAN->GetSkin();
	if( pSkin )
	{
		mpRadioSkin = pSkin->GetNodeSkin( "NpcStore_Radio" );
		if( mpRadioSkin == 0 )
			return false;
	}
		
	/// ư 
	for( unsigned int i = 0; i < MAX_RADIO; ++i )
	{
		mpRadio[i] = new cRadioButton;
		if( mpRadio[i]->CreateBySkinName( "NpcStore_Radio", this, i ) == false )
			return false;
	
		/// ġ 
		cUIPos pos;
		pos.mX = mpRadioSkin->mSkinInfo->mX + (mpRadioSkin->mSkinInfo->mWidth * i );
		pos.mY = mpRadioSkin->mSkinInfo->mY;
		mpRadio[i]->SetRelativePos( pos );
		mpRadio[i]->Hide();
	}
	return true;
}

void cNpcStoreWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mpRadioSkin )
	{
		for( unsigned int i = 0; i < MAX_RADIO; ++i )
		{
			if( mpRadio[i] )
			{
				cUIPos pos;
				pos.mX = mpRadioSkin->mSkinInfo->mX + (mpRadioSkin->mSkinInfo->mWidth * i );
				pos.mY = mpRadioSkin->mSkinInfo->mY;
				mpRadio[i]->SetRelativePos( pos );
			}
		}
	}
}

void cNpcStoreWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();
	
	if( mpRadioSkin )
	{
		for( unsigned int i = 0; i < MAX_RADIO; ++i )
		{
			if( mpRadio[i] )
			{
				cUIPos pos;
				pos.mX = mpRadioSkin->mSkinInfo->mX + (mpRadioSkin->mSkinInfo->mWidth * i );
				pos.mY = mpRadioSkin->mSkinInfo->mY;
				mpRadio[i]->SetRelativePos( pos );
			}
		}
	}
}

void cNpcStoreWindow::OnCommand( cUINode* , unsigned int id )
{
	switch( id )
	{
	case eUIID_NPCSTORE_CLOSE:
		Hide();
		break;
	case eUIID_NPCSTORE_BUY:
		{
			/// 
			int row = mpList->GetSelectIndex();
			unsigned long itemIndex = (unsigned long)mpList->GetExtraData( row );

			if( itemIndex > 0 )
			{
				cItemDefine* define = ITEMMAN->GetItemDefine( itemIndex );
				if( !define )
					return;

				/// 1  ־ ԰
				if( ITEMMAN->CheckBuyItem( itemIndex, 1 ) == false )
					return;

				if( define->GetCapacity() == 1 )
					GAMEUI->ShowItemBuyAskWindow( itemIndex, 1 );
				else
					GAMEUI->ShowItemCountWindow( eMBEVENT_ITEMCOUNT_BUY, itemIndex );
			}
		}
		break;
	}
}

void cNpcStoreWindow::OnRadioPressed( cUINode* , unsigned int id )
{
	if( mpList )
	{
		///  
		if( id >= 0 && id < MAX_RADIO )
		{
			mpList->Clear();
			UpdateItemList( id );
		}
	}
}

void cNpcStoreWindow::OnListBoxSelected( cUINode* , unsigned int )
{
	OnCommand( 0, eUIID_NPCSTORE_BUY );
}

void cNpcStoreWindow::OnListBoxSelectedRButton( cUINode* caller, unsigned int , bool shift )
{
	int row = mpList->GetSelectIndex();
	unsigned long itemIndex = (unsigned long)mpList->GetExtraData( row );
	cItemDefine* define = ITEMMAN->GetItemDefine( itemIndex );
	if( !define )
	{
		assert(0);
		return;
	}

	if( shift )
		ITEMMAN->TryToBuyItem( itemIndex, define->GetCapacity() );
	else
		ITEMMAN->TryToBuyItem( itemIndex, 1 );
}

void cNpcStoreWindow::OnIconDragged( cUINode* caller, unsigned int, const cUIPos& pos, bool shift )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon )
		UIMAN->ShowDrag( this, DRAG_FROM_NPC_STORE, icon, pos, shift );
}

void cNpcStoreWindow::OnIconRightClicked( cUINode* caller, unsigned int , bool shift )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon )
	{
		unsigned long itemIndex = icon->GetItemIndex();
		cItemDefine* define = ITEMMAN->GetItemDefine( itemIndex );
		if( !define )
		{
			assert(0);
			return;
		}

		if( shift )
			ITEMMAN->TryToBuyItem( itemIndex, define->GetCapacity() );
		else
			ITEMMAN->TryToBuyItem( itemIndex, 1 );
	}
}

void cNpcStoreWindow::UpdateItemList( unsigned int tabIndex )
{
	///  
	cItemNpcStore* store = ITEMMAN->GetItemNpcStore( mNpcIndex );
	if( store )
	{
		///   
		cStringT priceStr;
		unsigned int count = store->GetItemCount( tabIndex );
		for( unsigned int i = 0; i < count; ++i )
		{
			unsigned long itemIndex = store->GetItemIndex( tabIndex, i );
			cItemDefine* define = ITEMMAN->GetItemDefine( itemIndex );
			if( define )
			{
				unsigned long color = eCOLOR_WHITE;
				ITEMMAN->GetTooltipColor( define->GetTipType(), color );

				TCHAR name[ITENNAME_LEN] = {0,};
				bool ret = ITEMMAN->ModifyItemName( define->GetName(), name );
				LPCTSTR itemName = ( ret == true ) ? name : define->GetName();
				unsigned int row = mpList->AddRow( itemName, color, (void*)itemIndex );

				///   
				TCHAR temp[128]={0,};
				LPCTSTR priceStr = cNumberEditBox::FormatNumber( define->GetBuyPrice() );
				LPCTSTR uiStr = UIMAN->GetUIText( 355 );

				/// 
				unsigned long tooltipIdx = ITEMMAN->GetPriceUinit( define->GetBuyType() );
				::_stprintf( temp, _T("%s %s %s"), uiStr, priceStr, GAMERESOURCEMAN->GetItemToolTipText( tooltipIdx ) );
				mpList->AddColume( row, temp, mDefaultColor );
			}
		}
	}
}

void cNpcStoreWindow::OnNetLock( int lockTry )
{
	if( mpBuy )
		mpBuy->NetLock( lockTry );
}

void cNpcStoreWindow::OnNetUnLock( int lockTry )
{
	if( mpBuy )
		mpBuy->NetUnLock( lockTry );
}
