#include "StdAfx.h"
#include "NpcTarotCheckWindow.h"
#include "NumberEditBox.h"
#include "Label.h"
#include "TarotWindow.h"
#include "TarotManager.h"
#include "Npc_Common.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "UIMsgboxEvent.h"

cNpcTarotCheckWindow::cNpcTarotCheckWindow()
: mpMain(0)
, mpPrice(0)
{

}

cNpcTarotCheckWindow::~cNpcTarotCheckWindow()
{

}

bool cNpcTarotCheckWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpMain = (cTarotWindow*)mpParent;
	mpPrice = (cLabel*)GetChild( eUIID_GAME_NPCTAROTCHECK_PAY );

	cLabel* payBack = (cLabel*)GetChild( eUIID_GAME_NPCTAROTCHECK_PAYIMAGE );
	if( payBack )
		payBack->SetEnabled( false );

	if( !mpMain )
	{
		assert(0);
		return false;
	}

	return true;
}

void cNpcTarotCheckWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_NPCTAROTCHECK_START:
		{
			unsigned int maxCount = mpMain->GetNpcHaveSpreadCount();

			unsigned long compare = 0;
			for( unsigned int i = 0; i < maxCount; ++i )
			{
				compare = compare << 4;
				compare = compare | 1;
			}

			/// Ʈ б
			for( unsigned int i = 0; i < MAX_SPREAD - maxCount; ++i )
			{
				compare = compare << 4;
			}

			if( mpMain->GetFortuneData() == compare )
			{
				UIMAN->CreateModal( eStage_Game, eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 335 ), //  ޽
					GAMERESOURCEMAN->GetGameText( 31 ), // 
					eSKIN_OK );
			}
			else
			{
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NPCTAROT_START, 
					GAMERESOURCEMAN->GetGameText( 314 ), // Ȯ ޼
					GAMERESOURCEMAN->GetGameText( 301 ), // ˸
					eSKIN_YESNO
					);
			}
		}
		break;
	case eUIID_GAME_NPCTAROTCHECK_CANCEL:
		{
			UIMAN->HideNpcBack();
			TAROTMAN->ChangePage( ePAGE_NONE );
		}
		break;
	}
}

void cNpcTarotCheckWindow::OnShow()
{
	cUIWindow::OnShow();

	LPCTSTR price = cNumberEditBox::FormatNumber( mpMain->GetPrice() );
	if( mpPrice )
		mpPrice->SetText( price );
}

void cNpcTarotCheckWindow::OnHide()
{
	cUIWindow::OnHide();

	if( mpPrice )
		mpPrice->SetValue( 0 );
}