#include "stdafx.h"
#include "NpcTarotManager.h"
#include "GameUIManager.h"

#include "Protocol.h"
#include "Npc_Common.h"

#define NPCTAROT_SPREAD_FILE		"./Script/Resource/NpcTarot_Spread.txt"
#define NPCTAROT_CARD_FILE			"./Script/Resource/NpcTarot_Card.txt"
#define NPCTAROT_COMMENT_FILE		"./Script/Resource/NpcTarot_Comment.txt"

cNpcTarotManager* cNpcTarotManager::mpSingleton = 0;

cNpcTarotManager::cNpcTarotManager()
//: mTarotIndex(0)
//, mTarotPrice(0)
//, mSpreadCount(0)
{
	mpSingleton = this;

	//
	//memset( mSpreadIndex, 0, sizeof(mSpreadIndex) );
}

cNpcTarotManager::~cNpcTarotManager()
{
	/// 
	{
		cNpcSpreadMap::cIterator i = mNpcSpreadMap.Begin();
		cNpcSpreadMap::cIterator end = mNpcSpreadMap.End();
		for( ; i != end; ++i )
		{
			sNpcSpread* p = (sNpcSpread*)(i->mSecond);
			SAFE_DELETE( p );
		}
		mNpcSpreadMap.Clear();
	}

	/// npc ī 
	{
		cNpcDeckMap::cIterator i = mNpcDeckMap.Begin();
		cNpcDeckMap::cIterator end = mNpcDeckMap.End();
		for( ; i != end; ++i )
		{
			sNpcTarotDeck* p = (sNpcTarotDeck*)(i->mSecond);
			SAFE_DELETE( p );
		}
		mNpcDeckMap.Clear();
	}

	/// npc ī
	{
		cNpcTarotMap::cIterator i = mNpcTarotMap.Begin();
		cNpcTarotMap::cIterator end = mNpcTarotMap.End();
		for( ; i != end; ++i )
		{
			sNpcTarotCard* p = (sNpcTarotCard*)(i->mSecond);
			SAFE_DELETE( p );
		}
		mNpcTarotMap.Clear();
	}

	/// ؼ 
	{
		cNpcCommentMap::cIterator i = mNpcCommentMap.Begin();
		cNpcCommentMap::cIterator end = mNpcCommentMap.End();
		for( ; i != end; ++i )
		{
			sNpcTarotComment* p = (sNpcTarotComment*)(i->mSecond);
			SAFE_DELETE( p );
		}
		mNpcCommentMap.Clear();
	}
}

bool cNpcTarotManager::Init()
{
	///   ε
	if( LoadNpcSpread( NPCTAROT_SPREAD_FILE ) == false )
	{
		assert( 0 && "failed to load npc spread" );
		return false;
	}

	/// ī   ε
	if( LoadTarotDeck( NPCTAROT_CARD_FILE ) == false )
	{
		assert( 0 && "failed to load tarot deck" );
		return false;
	}

	/// ؼ  ε
	if( LoadComment( NPCTAROT_COMMENT_FILE ) == false )
	{
		assert( 0 && "failed to load tarot comment" );
		return false;
	}
	return true;
}

void cNpcTarotManager::Clear()
{
	//mTarotIndex = 0;
	//mTarotPrice = 0;
	//mSpreadCount = 0;

	//memset( mSpreadIndex, 0, sizeof(mSpreadIndex) );
}

sNpcSpread* cNpcTarotManager::GetNpcSpread( unsigned long spreadIdx )
{
	return (sNpcSpread*)mNpcSpreadMap.GetAt( spreadIdx );
}

sNpcTarotDeck* cNpcTarotManager::GetNpcTarotDeck( unsigned long deckIdx )
{
	return (sNpcTarotDeck*)mNpcDeckMap.GetAt( deckIdx );
}

sNpcTarotCard* cNpcTarotManager::GetNpcTarot( unsigned long cardIdx )
{
	return (sNpcTarotCard*)mNpcTarotMap.GetAt( cardIdx );
}

sNpcTarotComment* cNpcTarotManager::GetNpcTarotComment( unsigned long commentIdx )
{
	return (sNpcTarotComment*)mNpcCommentMap.GetAt( commentIdx );
}

/// Ÿ  
void cNpcTarotManager::NpcTarotOpen( unsigned long deckIdx, unsigned long price, unsigned long* spreadArr, short size )
{
	if( deckIdx == 0 || size == 0 )
	{
		assert(0);
		return;
	}

	///  
	//mTarotIndex = deckIdx;
	//mTarotPrice = price;
	//mSpreadCount = size;

	//for( int i = 0; i < size; ++i, ++spreadArr )
	//	mSpreadIndex[i] = *spreadArr;

	/*cNpcTarotWindow* p = GAMEUI->GetNpcTarotWindow();
	if( p )
	{
		p->SetPrice( price );
		p->SetNpcTarotDeck( GetNpcTarotDeck( deckIdx ) );
		p->SetNpcSpread( spreadArr, size );
		p->ChangeTarotPage( eNPCPAGE_CHECK );
	}
	else
		assert(0);*/

	///// 
	//MSG_REQ_NPC_TAROT_OPEN msg;
	//msg.Category = NM_NPC;
	//msg.Protocol = NM_NPC_TAROT_OPEN_REQ;
	//NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

///  ݱ
void cNpcTarotManager::NpcTarotClose()
{
	/*MSG_REQ_NPC_TAROT_CLOSE msg;
	msg.Category = NM_NPC;
	msg.Protocol = NM_NPC_TAROT_CLOSE_REQ;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );*/

	//cNpcTarotWindow* p = GAMEUI->GetNpcTarotWindow();
	//if( p )
	//	p->Hide();
}

///  ̿ϱ
void cNpcTarotManager::NpcTarotJoin()
{

}

void cNpcTarotManager::NetworkMsgParser( char* msg )
{
	MSGROOT* tempMsg = (MSGROOT*)msg;

	cStringT str;
	switch( tempMsg->Protocol )
	{
	case NM_NPC_TAROT_OPEN_RES:
		{
			MSG_RES_NPC_TAROT_OPEN* pmsg = (MSG_RES_NPC_TAROT_OPEN*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_NPC_TAROT_OPEN_SUCESS:
				{
					/*cNpcTarotWindow* p = GAMEUI->GetNpcTarotWindow();
					if( p )
					{
						p->SetNpcTarotDeck( GetNpcTarotDeck( mTarotIndex ) );
						p->ChangeTarotPage( eNPCPAGE_CHECK );
					}
					else
						assert(0);*/
				}
				break;
			case ERROR_NPC_TAROT_OPEN_FAIL:
				{

				}
				break;
			}
		}
		break;
	case NM_NPC_TAROT_CLOSE_REQ:
		break;
	}
}