/* ==========================================================================
*      : NpcTarotManager.h
*      : 
*    : 谡
*    : 2009-01-05
* ǻ :
*===========================================================================*/
#pragma once

#define	MAX_SPREAD_COUNT	13			///    ִ 
#define MAX_TAROT_COUNT		22			///   ī 
#define MAX_HAVESPREAD		5			///  ִ 

///  
enum eNpcTarotPage
{
	eNPCPAGE_NONE = 0,
	eNPCPAGE_CHECK,
	eNPCPAGE_SELECT,
	eNPCPAGE_RESULT,
};

// Ӽ
enum eFortuneProp
{
	eFORTUNE_LOVE,	// 
	eFORTUNE_HEALTH,// ǰ
	eFORTUNE_WORK,	// 
	eFORTUNE_MONEY,	// 繰
	eFORTUNE_LUCK,	// 

	eFORTUNE_NONE,
};

// ġ Ӽ
enum ePositionProp
{
	ePOS_FIRST,		// ù°
	ePOS_SECOND,	// ι°
	ePOS_THIRD,		// °

	ePOS_NONE,
};

struct sNpcSpreadParam
{
	int mImageIndex;		/// ̹ ε
	short mX, mY;			/// ǥ
	short mFortuneProp;		///  Ӽ
	short mPositionProp;	/// ġ Ӽ
	long mQuestionIdx;		///  ε
};

// npc  Ӽ
struct sNpcSpread
{
	sNpcSpreadParam		mParam[MAX_SPREAD_COUNT];	
	unsigned int		mCount;					/// ִ   

	sNpcSpread()
	{
		memset( mParam, 0, sizeof(mParam) );
		mCount = 0;
	}
};

/// npc Ÿī
struct sNpcTarotCard
{
	//unsigned long	mCardIndex;
	unsigned int	mImageIndex;
	unsigned long	mStraightIdx;		///   ε 
	unsigned long	mInverseIdx;		///   ε	
	unsigned long	mCommnetIndex;		/// ؼ ε
};

// npc Ÿī 
struct sNpcTarotDeck
{
	unsigned long mCard[MAX_TAROT_COUNT];	/// ī ε

	sNpcTarotDeck()
	{
		memset( mCard, 0, sizeof(mCard) );
	}
};

// Ÿī ؼ
struct sNpcTarotComment
{
	unsigned long mComment[5][3][2][3]; /// [Ӽ][ġӼ][][ؼ] = ؼȣ

	sNpcTarotComment()
	{
		memset( mComment, 0, sizeof(mComment) );
	}
};

// NPC Ÿ Ŵ
class cNpcTarotManager
{
public:
	cNpcTarotManager();
	~cNpcTarotManager();

	bool Init();
	void Clear();

	///
	void NpcTarotOpen( unsigned long deckIdx, unsigned long price, unsigned long* spreadArr, short size );
	void NpcTarotClose();
	void NpcTarotJoin();

	void NetworkMsgParser( char* msg );

	sNpcSpread* GetNpcSpread( unsigned long spreadIdx );
	sNpcTarotDeck* GetNpcTarotDeck( unsigned long deckIdx );
	sNpcTarotCard* GetNpcTarot( unsigned long cardIdx );
	sNpcTarotComment* GetNpcTarotComment( unsigned long commentIdx );

public:
	static cNpcTarotManager* mpSingleton;
	static cNpcTarotManager* GetSingleton();

protected:
	bool LoadNpcSpread( const cString& path );
	bool LoadTarotDeck( const cString& path );
	bool LoadComment( const cString& path );

private:
	///   (sNpcSpread)
	typedef tPointerHashMap<unsigned long, void*> cNpcSpreadMap;
	cNpcSpreadMap	mNpcSpreadMap;
         
	/// ī   (sNpcTarotDeck)
	typedef tPointerHashMap<unsigned long, void*> cNpcDeckMap;
	cNpcDeckMap		mNpcDeckMap;

	/// Ÿ ī  (sNpcTarotCard)
	typedef tPointerHashMap<unsigned long, void*> cNpcTarotMap;
	cNpcTarotMap	mNpcTarotMap;

	/// ؼ  (sNpcTarotComment)
	typedef tPointerHashMap<unsigned long, void*> cNpcCommentMap;
	cNpcCommentMap		mNpcCommentMap;

	/////  ī 
	//unsigned long mTarotIndex;

	///// Ÿ 
	//unsigned long mTarotPrice;

	/////   
	//unsigned int mSpreadCount;
	//unsigned long mSpreadIndex[MAX_HAVESPREAD];
};

inline cNpcTarotManager* cNpcTarotManager::GetSingleton()
{
	return mpSingleton;
}

#define NPCTAROTMAN cNpcTarotManager::GetSingleton()