#include "stdafx.h"
#include "NpcTarotManager.h"

bool cNpcTarotManager::LoadNpcSpread( const cString& path )
{
	cFileLoader		loader;

	if( loader.Open( path, true ) == false )
	{
		assert( 0 && "failed to load LoadNpcSpread" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", path.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long idx = (unsigned long)str.ToInt();

		/// ̹ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long imgIdx = (unsigned long)str.ToInt();

		/// x ǥ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int xpos = (unsigned int)str.ToInt();

		/// y ǥ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int ypos = (unsigned int)str.ToInt();

		///  Ӽ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short fortuneProp = (short)str.ToInt();

		/// ġ Ӽ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		short posProp = (short)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long questionIdx = (unsigned long)str.ToInt();

		///
		sNpcSpread* spread = (sNpcSpread*)mNpcSpreadMap.GetAt( idx );
		if( spread )
		{
			/// ˻
			if( spread->mCount >= MAX_SPREAD_COUNT )
			{
				assert( 0 && "error npc spread axis" );
				return false;
			}

			int count = spread->mCount;
			spread->mParam[count].mImageIndex = imgIdx;
			spread->mParam[count].mX = xpos;
			spread->mParam[count].mY = ypos;
			spread->mParam[count].mFortuneProp = fortuneProp;
			spread->mParam[count].mPositionProp = posProp;
			spread->mParam[count].mQuestionIdx = questionIdx;
			spread->mCount++;
		}	
		else
		{
			///  
			spread = new sNpcSpread;
			spread->mParam[0].mImageIndex = imgIdx;
			spread->mParam[0].mX = xpos;
			spread->mParam[0].mY = ypos;
			spread->mParam[0].mFortuneProp = fortuneProp;
			spread->mParam[0].mPositionProp = posProp;
			spread->mParam[0].mQuestionIdx = questionIdx;
			spread->mCount = 1;

			if( mNpcSpreadMap.Insert( idx, spread ) == false )
			{
				assert( 0 && "faild to insert npc spread" );
				return false;
			}
		}
	}

	return true;
}

///
bool cNpcTarotManager::LoadTarotDeck( const cString& path )
{
	cFileLoader		loader;

	if( loader.Open( path, true ) == false )
	{
		assert( 0 && "failed to load LoadTarotDeck" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", path.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long idx = (unsigned long)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ī ε
		unsigned long cardIdx = (unsigned long)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ̹ ε
		unsigned long imgIdx = (unsigned long)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		///  ȣ
		short number = (short)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		///   ε
		unsigned long straightIdx = (unsigned long)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		///   ε
		unsigned long inverseIdx = (unsigned long)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long commentIdx = (unsigned long)str.ToInt();

		/// ˻
		if( !(number >= 0 && number < MAX_TAROT_COUNT) )
		{
			assert(0);
			return false;
		}

		/// ī  
		sNpcTarotCard* tarot = new sNpcTarotCard;
		tarot->mImageIndex = imgIdx;
		tarot->mStraightIdx = straightIdx;
		tarot->mInverseIdx = inverseIdx;
		tarot->mCommnetIndex = commentIdx;
		if( mNpcTarotMap.Insert( cardIdx, tarot ) == false )
		{
			assert(0);
			return false;
		}

		/// ī   
		sNpcTarotDeck* deck = (sNpcTarotDeck*)mNpcDeckMap.GetAt( idx );
		if( deck )
		{
			deck->mCard[number] = cardIdx;
		}
		else
		{
			deck = new sNpcTarotDeck;
			deck->mCard[number] = cardIdx;

			if( mNpcDeckMap.Insert( idx, deck ) == false )
			{
				assert(0);
				return false;
			}
		}
		/*sNpcTarotDeck* deck = (sNpcTarotDeck*)mNpcDeckMap.GetAt( idx );
		if( deck )
		{
			deck->mCard[number].mCardIndex = cardIdx;
			deck->mCard[number].mImageIndex = imgIdx;
			deck->mCard[number].mStraightIdx = straightIdx;
			deck->mCard[number].mInverseIdx = inverseIdx;
			deck->mCard[number].mCommnetIndex = commentIdx;
		}
		else
		{
			deck = new sNpcTarotDeck;
			deck->mCard[number].mCardIndex = cardIdx;
			deck->mCard[number].mImageIndex = imgIdx;
			deck->mCard[number].mStraightIdx = straightIdx;
			deck->mCard[number].mInverseIdx = inverseIdx;
			deck->mCard[number].mCommnetIndex = commentIdx;

			if( mNpcDeckMap.Insert( idx, deck ) == false )
			{
				assert(0);
				return false;
			}
		}*/
	}
	return true;
}

/// ؼ ε
bool cNpcTarotManager::LoadComment( const cString& path )
{
	cFileLoader		loader;

	if( loader.Open( path, true ) == false )
	{
		assert( 0 && "failed to load LoadComment" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", path.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long idx = (unsigned long)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		///  Ӽ
		short fortune = (short)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ġ Ӽ
		short pos = (short)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		///  Ӽ
		short dir = (short)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;
		
		/// ؼ 1
		unsigned long comment1 = (unsigned long)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ؼ 2
		unsigned long comment2 = (unsigned long)str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ؼ 3
		unsigned long comment3 = (unsigned long)str.ToInt();

		if( !(fortune >= 0 && fortune < 5) )
		{
			assert(0);
			return false;
		}

		if( !(pos >= 0 && pos < 3) )
		{
			assert(0);
			return false;
		}

		if( !(dir >= 0 && dir < 2) )
		{
			assert(0);
			return false;
		}

		sNpcTarotComment* p = (sNpcTarotComment*)mNpcCommentMap.GetAt( idx );
		if( p )
		{
			p->mComment[fortune][pos][dir][0] = comment1;
			p->mComment[fortune][pos][dir][1] = comment2;
			p->mComment[fortune][pos][dir][2] = comment3;
		}
		else
		{
			p = new sNpcTarotComment;
			p->mComment[fortune][pos][dir][0] = comment1;
			p->mComment[fortune][pos][dir][1] = comment2;
			p->mComment[fortune][pos][dir][2] = comment3;

			if( mNpcCommentMap.Insert( idx, p ) == false )
			{
				assert(0);
				return false;
			}
		}
	}
	return true;
}