#include "StdAfx.h"
#include "NpcTarotResultWindow.h"
#include "Label.h"
#include "TarotWindow.h"
#include "TarotManager.h"
#include "UIImageFont.h"
#include "GameUIManager.h"

cNpcTarotResultWindow::cNpcTarotResultWindow()
: mpMain(0)
, mpDesc(0)
, mpQuestion(0)
, mpOpenCardInfo(0)
, mpComment(0)
, mpSpread(0)
, mpResult(0)
, mpRightBtn(0)
, mpUpBtn(0)
{
}

cNpcTarotResultWindow::~cNpcTarotResultWindow()
{
}

bool cNpcTarotResultWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpDesc = (cLabel*)GetChild( eUIID_GAME_NPCTAROTRESULT_DESC );
	mpQuestion = (cLabel*)GetChild( eUIID_GAME_NPCTAROTRESULT_QUESTION );
	mpOpenCardInfo = (cLabel*)GetChild( eUIID_GAME_NPCTAROTRESULT_OPENCARDINFO );
	mpComment = (cLabel*)GetChild( eUIID_GAME_NPCTAROTRESULT_COMMENT );
	mpResult = GetChild( eUIID_GAME_NPCTAROTRESULT_RESULT );
	mpRightBtn = GetChild( eUIID_GAME_NPCTAROTRESULT_RIGHT );
	mpUpBtn = GetChild( eUIID_GAME_NPCTAROTRESULT_UP );

	cUINode* backImg = GetChild( eUIID_GAME_NPCTAROTRESULT_COMMENTBACK );
	if( backImg )
		backImg->SetEnabled( false );

	cUINode* descImg = GetChild( eUIID_GAME_NPCTAROTRESULT_DESCBACKIMG );
	if( descImg )
		descImg->SetEnabled( false );

	if( mpDesc )
		mpDesc->SetEnabled( false );
	if( mpQuestion )
		mpQuestion->SetEnabled( false );
	if( mpOpenCardInfo )
		mpOpenCardInfo->SetEnabled( false );
	if( mpComment )
		mpComment->SetEnabled( false );
	if( mpResult )
		mpResult->SetEnabled( false );

	mpMain = (cTarotWindow*)mpParent;
	if( !mpMain )
	{
		assert(0);
		return false;
	}

	return true;
}

void cNpcTarotResultWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();
	UpdateButton();
}

void cNpcTarotResultWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	if( mpSpread )
	{
		sNpcSpreadParam* spreadParam = mpSpread->mParam;
		for( unsigned int i = 0; i < mpSpread->mCount; ++i, ++spreadParam )
		{
			unsigned int x = spreadParam->mX + mpMain->GetAbsoluteRect().mLeft;
			unsigned int y = spreadParam->mY + mpMain->GetAbsoluteRect().mTop;
	
			cString IndexStr;
			IndexStr.Format( "%d", i + 1 );
			cUIImageFont* pImageFont = UIMAN->GetImageFont( 0 );
			if( pImageFont )
				pImageFont->DrawText( x + 8, y + 8, IndexStr.Cstr() );
			else
			{
				assert(0);
			}
		}
		
	}
}

void cNpcTarotResultWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_NPCTAROTRESULT_RESULT:
		{
			///  ޱ 
			UIMAN->HideNpcBack();
			TAROTMAN->ChangePage( ePAGE_NONE );

			///  ø ̱
			GAMEUI->ShowTodayWordWindow();
		}
		break;
	case eUIID_GAME_NPCTAROTRESULT_RIGHT:
	case eUIID_GAME_NPCTAROTRESULT_UP:
	case eUIID_GAME_NPCTAROTRESULT_STRAIGHT:
	case eUIID_GAME_NPCTAROTRESULT_INVERSE:
		{
			if( mpMain->OpenNpcResultCard() == true )
			{
				UpdateButton();

				if( mpMain->GetSelectedCount() >= mpMain->GetMaxCount() )
				{
					if( mpResult )
						mpResult->SetEnabled( true );

					ShowButton( false );
				}
			}
		}
		break;
	case eUIID_GAME_NPCTAROTRESULT_REVIEWLEFT:
		{
			/// ؼ Ȯ .
			unsigned int arrIndex = mpMain->GetShowReviewIndex();
			if( arrIndex > 0 )
			{
				mpMain->OpenNpcResultReview( arrIndex - 1 );
			}
		}
		break;
	case eUIID_GAME_NPCTAROTRESULT_REVIEWRIGHT:
		if( mpMain->GetSelectedCount() > 0 )
		{
			/// ؼ Ȯ .
			unsigned int arrIndex = mpMain->GetShowReviewIndex();
			unsigned int max = mpMain->GetSelectedCount() - 1;
			if( arrIndex < max )
			{
				mpMain->OpenNpcResultReview( arrIndex + 1 );
			}
		}
		break;
	}
}

void cNpcTarotResultWindow::OnShow()
{
	cUIWindow::OnShow();

	unsigned long spreadIdx = mpMain->GetSelectedSpreadIndex();
	mpSpread = TAROTMAN->GetNpcSpread( spreadIdx );
	assert(mpSpread);

	ShowButton( true );
	UpdateButton();
}

///
void cNpcTarotResultWindow::OnHide()
{
	cUIWindow::OnHide();

	mpSpread = 0;

	if( mpDesc )
		mpDesc->Clear();
	if( mpQuestion )
		mpQuestion->Clear();
	if( mpOpenCardInfo )
		mpOpenCardInfo->Clear();
	if( mpComment )
		mpComment->Clear();
	if( mpResult ) 
		mpResult->SetEnabled( false );
}

void cNpcTarotResultWindow::SetDesc( LPCTSTR desc )
{
	if( mpDesc )
		mpDesc->SetText( desc );
}

void cNpcTarotResultWindow::SetQuestion( LPCTSTR question )
{
	if( mpQuestion )
		mpQuestion->SetText( question );
}

void cNpcTarotResultWindow::SetCardInfo( LPCTSTR info )
{
	if( mpOpenCardInfo )
		mpOpenCardInfo->SetText( info );
}

void cNpcTarotResultWindow::SetComment( LPCTSTR comment )
{
	if( mpComment )
		mpComment->SetText( comment );
}

void cNpcTarotResultWindow::ShowButton( bool show )
{
	if( mpRightBtn && mpUpBtn )
	{
		if( show == true )
		{
			mpRightBtn->Show();
			mpUpBtn->Show();
		}
		else
		{
			mpRightBtn->Hide();
			mpUpBtn->Hide();
		}
	}
	else
	{
		assert(0);
	}
}

void cNpcTarotResultWindow::UpdateButton()
{
	if( mpSpread && mpRightBtn && mpUpBtn )
	{
		unsigned int i = mpMain->GetSelectedCount();
		unsigned int x = mpSpread->mParam[i].mX;
		unsigned int y = mpSpread->mParam[i].mY;

		unsigned int cardHW = mpMain->GetCardHalfWidth();
		unsigned int cardHH = mpMain->GetCardHalfHeight();

		x = mpSpread->mParam[i].mX + cardHW - mpUpBtn->GetRelativeRect().GetWidth()/2;
		y = mpSpread->mParam[i].mY - mRelativeRect.mTop - mpUpBtn->GetRelativeRect().GetHeight() - 5;
		cUIPos upPos(x, y);
		mpUpBtn->SetRelativePos( upPos );

		x = mpSpread->mParam[i].mX + cardHW*2 + 5;
		y = mpSpread->mParam[i].mY - mRelativeRect.mTop + cardHH - mpRightBtn->GetRelativeRect().GetHeight()/2;

		cUIPos rightPos(x, y);
		mpRightBtn->SetRelativePos( rightPos );

		/// ư ̵ߴµ ĸĳ ȣ Ƿ  
		UIMAN->ReleaseEventNode();	
	}
}