#include "StdAfx.h"
#include "NpcTarotSelectWindow.h"
#include "Label.h"
#include "TarotWindow.h"
#include "TarotManager.h"
#include "Npc_Common.h"
#include "UIMsgboxEvent.h"

cNpcTarotSelectWindow::cNpcTarotSelectWindow()
: mpMain(0)
, mpCount(0)
, mpComplete(0)
{

}

cNpcTarotSelectWindow::~cNpcTarotSelectWindow()
{
}

bool cNpcTarotSelectWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpMain = (cTarotWindow*)mpParent;
	mpCount = (cLabel*)GetChild( eUIID_GAME_NPCTAROTSELECT_COUNT );
	mpComplete = GetChild( eUIID_GAME_NPCTAROTSELECT_COMPLETE );

	if( !mpMain )
	{
		assert(0);
		return false;
	}

	return true;
}

void cNpcTarotSelectWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_NPCTAROTSELECT_COMPLETE:
		{
			sNpcSpread* spread = TAROTMAN->GetNpcSpread( mpMain->GetSelectedSpreadIndex() );
			if( spread )
			{
				unsigned long compare = 0x00010000;
				compare = compare >> (4 * spread->mFortuneProp);
				if( (mpMain->GetFortuneData() & compare) == compare ) 
				{
					UIMAN->CreateModal(	eStage_Game,
						eMBEVENT_NONE, 
						GAMERESOURCEMAN->GetGameText( 332 ),
						GAMERESOURCEMAN->GetGameText( 301 ),
						eSKIN_OK
						);
				}
				else
				{
					MSG_REQ_NPC_TAROT_FORTUNE msg;
					msg.Category = NM_NPC;
					msg.Protocol = NM_NPC_TAROT_FORTUNE_REQ;
					msg.fortuneProp = spread->mFortuneProp;
					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

					mpMain->NetLock( ePAGE_SELECT );
				}
			}
			else
			{
				assert(0);
			}
		}
		break;
	case eUIID_GAME_NPCTAROTSELECT_CANCEL:
		{
			/// 
			UIMAN->CreateModal( eStage_Game, eMBEVENT_NPCTAROT_EXIT, 
				GAMERESOURCEMAN->GetGameText( 312 ), //  ޽
				GAMERESOURCEMAN->GetGameText( 31 ), // 
				eSKIN_YESNO );
		}
		break;
	case eUIID_GAME_NPCTAROTSELECT_RANDOM:
		{
			///  ̱
			for(;;)
			{
				if( mpMain->GetSelectedCount() >= mpMain->GetMaxCount() )
					break;

				mpMain->OpenSelectNpcCard( 0 );
			}
		}
		break;
	}
}

///
void cNpcTarotSelectWindow::OnShow()
{
	cUIWindow::OnShow();

	if( mpComplete )
		mpComplete->SetEnabled( false );
}
 
///
void cNpcTarotSelectWindow::SelectCount( short count, short max )
{
	if( mpCount )
	{
		cStringT str;
		str.Format( _T("%d / %d"), count, max );
		mpCount->SetText( (LPCTSTR)str.Cstr() );
	}
	else
	{
		assert(0);
	}
}

void cNpcTarotSelectWindow::SetEnableComplete( bool enable )
{
	if( mpComplete )
		mpComplete->SetEnabled( enable );
}