#include "stdafx.h"
#include "NpcWindow.h"

#include "UIImage.h"
#include "UIManager.h"
#include "UINpcTelling.h"
#include "UIFuncText.h"

#include "GameUIManager.h"
#include "ObjectManager.h"
#include "QuestManager.h"
#include "GameResourceManager.h"
#include "Hero.h"
#include "Button.h"
#include "Label.h"
#include "TextBox.h"
#include "ListBox.h"
#include "NpcRewardWindow.h"
#include "SkillScript.h"
#include "Npc_Common.h"
#include "Page.h"
#include "UIMsgboxEvent.h"
#include "GuildManager.h"
#include "UIRootNode.h"

#include "ResourceManager.h"

cNpcWindow::cNpcWindow()
: mNpcClassIndex( 0 )
, mTelling( 0 )
, mNameLabel(0)
, mpTextBox(0)
, mpStoreButton(0)
, mpWareHouseButton(0)
, mpSkillStoreButton(0)
, mpDisjointButton(0)
, mpGuildButton(0)
, mpTarotButton(0)
, mpQuestList(0)
, mNpcIndex(0)
, mHideBack( true )
, mIsUseSkillStore( false )
, mIsUseQuest( false )
, mSceneImage(0)
, mSceneIndex(0)
, mSceneSkin(0)
, mpClose(0)
{
	SetExceptEvent( true );
	SetExceptSnap( true );
}

cNpcWindow::~cNpcWindow()
{
	Clear();

	SAFE_DELETE( mSceneImage );
}

void cNpcWindow::UIStageIn()
{
	///   ؽİ ٸǷ   
	if( mSceneSkin && mSceneImage == 0 )
	{
		mSceneImage = new cUITransformImage;
	}
}

void cNpcWindow::Close()
{
	SAFE_DELETE( mSceneImage );
}

/// Ʈ  
void cNpcWindow::Clear()
{
	if( mpQuestList )
		mpQuestList->Clear();

	if( mpTextBox )
		mpTextBox->Clear();

	for( unsigned int i = 0; i < mDelArr.GetSize(); ++i )
	{
		sQuestStatus* data = (sQuestStatus*)mDelArr[i];
		SAFE_DELETE( data );
	}
	mDelArr.Clear();

	mIsUseQuest = false;
	mQuestIndex = 0;
	mNextPageIdx = 0;
	mSceneIndex = 0;
	mStatus = eNPCQUEST_NONE;
}

void cNpcWindow::ShowDefaultPage()
{
	/// ġ
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	SetRelativePos( cUIPos( x, GetRelativeRect().mTop ) );

	/// ⺻ 縦 ǥ
	cUIFuncTextParam textParam;
	textParam.mName = HERO->GetName();

	if( mpTextBox )
		mpTextBox->Clear();

	mTelling = UIMAN->GetNpcTelling( mNpcClassIndex );
	if( mTelling )
	{
		sPageText* pageText = mTelling->GetDefaultTextRandomly();
		if( pageText )
		{
			for( unsigned int i = 0; i < pageText->numLine; ++i )
			{
				if( mpTextBox )
				{
					mpTextBox->AddFucnText( UIMAN->GetNpcTextNode( pageText->textIndex + i ), &textParam );
					mpTextBox->AddEmptyRow(1);
				}
			}
		}

		///  ̹ 
		mSceneIndex = mTelling->GetDefaultScene();
		UpdateScene();
	
		if( mpStoreButton )
			mpStoreButton->Hide();

		if( mpWareHouseButton )
			mpWareHouseButton->Hide();

		if( mpSkillStoreButton )
			mpSkillStoreButton->Hide();

		if( mpDisjointButton )
			mpDisjointButton->Hide();

		if( mpGuildButton )
			mpGuildButton->Hide();

		if( mpTarotButton )
			mpTarotButton->Hide();
        
		///  ư 
		for( int i = 0; i < mTelling->GetFuncCount(); ++i )
		{
			switch( mTelling->GetFunc(i) )
			{
			case NPC_FUNC_STORE:
				if( mpStoreButton )
					mpStoreButton->Show();
				break;
			case NPC_FUNC_WAREHOUSE:
				if( mpWareHouseButton )
					mpWareHouseButton->Show();
				break;
			case NPC_FUNC_SKILLSTORE:
				if( mpSkillStoreButton && mIsUseSkillStore == true )
					mpSkillStoreButton->Show();
				break;
			case NPC_FUNC_ITEMDISJOINT:
				if( mpDisjointButton )
					mpDisjointButton->Show();
				break;
			case NPC_FUNC_GUILD:
				if( mpGuildButton )
					mpGuildButton->Show();
				break;
			case NPC_FUNC_TAROT:
				if( mpTarotButton )
					mpTarotButton->Show();
				break;
			}
		}
	}

	cNpcRewardWindow* reward = GAMEUI->GetNpcRewardWindow();
	if( reward )
		reward->Hide();

	if( mpQuestList )
		mpQuestList->Hide();
}

void cNpcWindow::Show( unsigned int npcClassIdx, unsigned long npcIndex, LPCTSTR npcName )
{
	mNpcClassIndex = npcClassIdx;
	mNpcIndex = npcIndex;
	mHideBack = true;
	mIsUseSkillStore = false;
	mIsUseQuest = false;

	/// ̸ 
	if( mNameLabel )
		mNameLabel->SetText( npcName );

	ePLAYER_JOB job = HERO->GetJob();

	/// npc  ִ  ԵǴ ˻
	tArray<unsigned long>* parray = SKILLSCRIPT->GetStoreJobList( mNpcClassIndex );
	if( parray )
	{
		for( unsigned int i=0; i<parray->GetSize(); i++ )
		{
			unsigned long jobIdx = (*parray)[i];

			if( GAMERESOURCEMAN->IsCorrelateJob( job, jobIdx ) == true)
			{
				mIsUseSkillStore = true;
				break;
			}
		}
	}

	/// npc 츦  ٸ  ݱ
	GetRoot()->HideAllChild( true, this );

	/// ڱڽ ̱
	cUIWindow::ShowTop();

	/// ޼ ڽ鸸  
	UIMAN->GotoFrontMsgBox();
}

void cNpcWindow::OnShow()
{
	cUIWindow::OnShow();

	/// ⺻ 縦 ǥ
	cUIFuncTextParam textParam;
	textParam.mName = HERO->GetName();

	if( mpTextBox )
		mpTextBox->Clear();

	mTelling = UIMAN->GetNpcTelling( mNpcClassIndex );
	if( mTelling )
	{
		/// NPC   ̱
		UIMAN->ShowNpcBack();

		sPageText* pageText = mTelling->GetDefaultTextRandomly();
		if( pageText )
		{
			for( unsigned int i = 0; i < pageText->numLine; ++i )
			{
				if( mpTextBox )
				{
					mpTextBox->AddFucnText( UIMAN->GetNpcTextNode( pageText->textIndex + i ), &textParam );
					mpTextBox->AddEmptyRow(1);
				}
			}
		}

		///  ̹ 
		mSceneIndex = mTelling->GetDefaultScene();
		UpdateScene();

		if( mpStoreButton )
			mpStoreButton->Hide();

		if( mpWareHouseButton )
			mpWareHouseButton->Hide();

		if( mpSkillStoreButton )
			mpSkillStoreButton->Hide();

		if( mpDisjointButton )
			mpDisjointButton->Hide();

		if( mpGuildButton )
			mpGuildButton->Hide();

		if( mpTarotButton )
			mpTarotButton->Hide();

		///  ư 
		for( int i = 0; i < mTelling->GetFuncCount(); ++i )
		{
			switch( mTelling->GetFunc(i) )
			{
			case NPC_FUNC_STORE:
				if( mpStoreButton )
					mpStoreButton->Show();
				break;
			case NPC_FUNC_WAREHOUSE:
				if( mpWareHouseButton )
					mpWareHouseButton->Show();
				break;
			case NPC_FUNC_SKILLSTORE:
				if( mpSkillStoreButton && mIsUseSkillStore == true )
					mpSkillStoreButton->Show();
				break;
			case NPC_FUNC_ITEMDISJOINT:
				if( mpDisjointButton )
					mpDisjointButton->Show();
				break;
			case NPC_FUNC_GUILD:
				if( mpGuildButton )
					mpGuildButton->Show();
				break;
			case NPC_FUNC_TAROT:
				if( mpTarotButton )
					mpTarotButton->Show();
				break;
			}
		}
	}
	else
	{
		Hide();
	}
}

void cNpcWindow::HideESC( bool onsound )
{
	if( IsNetLock() == false )
		cUIWindow::HideESC( onsound );
}

void cNpcWindow::OnHide()
{
	cUIWindow::OnHide();

	/// ESC ư ݰų, ݱư   .
	///  찡 Ŷ  .
	if( mHideBack == true )
	{
		UIMAN->HideNpcBack();

		mNpcClassIndex = 0;
		mNpcIndex = 0;
	}

	/// Ʈ  Ŭ 
	Clear();

	if( mNameLabel )
		mNameLabel->Clear();

	cNpcRewardWindow* reward = GAMEUI->GetNpcRewardWindow();
	if( reward )
		reward->Hide();

	if( mpQuestList )
		mpQuestList->Hide();
}


bool cNpcWindow::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;

	///
	mNameLabel = (cLabel*)GetChild( eUIID_NPCTELL_NAME );
	mpTextBox = (cTextBox*)GetChild( eUIID_NPCTELL_TEXTBOX );
	mpStoreButton = (cButton*)GetChild( eUIID_NPCTELL_STORE );
	mpWareHouseButton = (cButton*)GetChild( eUIID_NPCTELL_WAREHOUSE );
	mpSkillStoreButton = (cButton*) GetChild( eUIID_NPCTELL_SKILLSTORE );
	mpDisjointButton = (cButton*)GetChild( eUIID_NPCTELL_DISJOINT );
	mpGuildButton = (cButton*)GetChild( eUIID_NPCTELL_GUILD );
	mpTarotButton = (cButton*)GetChild( eUIID_NPCTELL_TAROT );
	mpClose = (cButton*)GetChild( eUIID_NPCTELL_CLOSE );

	mpQuestList = (cListBox*) GetChild( eUIID_NPCTELL_QUESTLISTBOX );

	if( mpTextBox )
		mpTextBox->SetDrawTextBottom( false );

	if( mpQuestList )
	{
		mpQuestList->SetContinueEvent( true );
		mpQuestList->Hide();
	}

	/// ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
		return false;

	/// ̹ 
	mSceneSkin = pSkin->GetNodeSkin( "NpcTelling_Scene" );
	if( mSceneSkin )
	{
		mSceneImage = new cUITransformImage;
	}

	/// npc ̸
	if( mNameLabel )
		mNameLabel->SetTextColor( 0xFFE9E47C );
	return true;
}

void cNpcWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ġ
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	SetRelativePos( cUIPos( x, GetRelativeRect().mTop ) );

	if( mSceneIndex > 0 && mSceneImage )
	{
		sSceneData* scene = UIMAN->GetSceneData( mSceneIndex );
		if( scene )
		{
			unsigned int x = (GetScreenWidth()-mOldScreenWidth) + GetAbsoluteRect().mLeft + mSceneSkin->mSkinInfo->mX;
			unsigned int y = GetScreenHeight() - scene->mTexHeight;

			unsigned int w = scene->mTexWidth;
			unsigned int h = scene->mTexHeight;
			mSceneImage->SetScreenRect( cUIRect( x, y, x+w, y+h ) );
		}
	}
}

void cNpcWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mVisible == false )
		return;

	/// NPC ̹ ׸,  ׸
	if( mSceneIndex > 0 && mSceneImage )
		mSceneImage->Draw();

	/// ̹ 
	if( mpImage )
		mpImage->Draw();
	
	/// ڽ 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		if( ((cUINode*)(*i))->IsVisible() == true )
		{
			((cUINode*)(*i))->OnRender(pKeeper);
		}
	}

	pKeeper->DrawAll();
}

void cNpcWindow::OnCommand( cUINode*, unsigned int id )
{
	if( IsNetLock() == true )
		return;

	mHideBack = false;

	switch( id )
	{
	case eUIID_NPCTELL_CLOSE:
		UIMAN->SetNpcFunc( NPC_FUNC_NULL );
		mHideBack = true;
		break;
	case eUIID_NPCTELL_STORE:
		UIMAN->SetNpcFunc( NPC_FUNC_STORE );
		GAMEUI->ShowInventoryWindow();
		GAMEUI->ShowNpcStoreWindow( mNpcClassIndex );
		break;
	case eUIID_NPCTELL_WAREHOUSE:
		UIMAN->SetNpcFunc( NPC_FUNC_WAREHOUSE );
		GAMEUI->ShowWareHouse();
		GAMEUI->ShowInventoryWindow();
		break;
	case eUIID_NPCTELL_SKILLSTORE:
		UIMAN->SetNpcFunc( NPC_FUNC_SKILLSTORE );
		GAMEUI->ShowSkillStore( mNpcClassIndex );
		GAMEUI->ShowSkillWindow();
		break;
	case eUIID_NPCTELL_DISJOINT:
		UIMAN->SetNpcFunc( NPC_FUNC_ITEMDISJOINT );
		GAMEUI->ShowNpcDisjointWindow();
		GAMEUI->ShowInventoryWindow();
		break;
	case eUIID_NPCTELL_GUILD:
		UIMAN->SetNpcFunc( NPC_FUNC_GUILD );
		if( GUILDMAN->CheckCreate( mNpcIndex ) == true )
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_GUILD_CREATE, 
								GAMERESOURCEMAN->GetGameText( 1231 ),	// û ޽
								GAMERESOURCEMAN->GetGameText( 1233 ),	//  
								eSKIN_YESNO, (void*)mNpcIndex );
		}
		break;
	case eUIID_NPCTELL_TAROT:
		{
			UIMAN->SetNpcFunc( NPC_FUNC_TAROT );
			GAMEUI->ShowNpcTarotWindow( mTelling->GetTarotIndex(), mTelling->GetTarotPrice(), mTelling->GetSpreadArr(), mTelling->GetSpreadCount() );
		}
		break;
	default:
		assert(0);
		return;
	}

	Hide();
}

void cNpcWindow::OnListBoxChanged( cUINode* , unsigned int )
{
	if( IsNetLock() == true )
		return;

	/// Ʈ  
	if( mIsUseQuest == false )
	{
		SelectQuest();

		cNpcRewardWindow* reward = GAMEUI->GetNpcRewardWindow();
		if( reward )
			reward->ShowTop();
	}
	else
	{
		unsigned int selectIdx = mpQuestList->GetSelectIndex();
		unsigned int nextPageIdx = (unsigned int)mpQuestList->GetExtraData( selectIdx );

		/// ó ó
		if( nextPageIdx == 0 )
		{
			QUESTMAN->QuestNewListReSend( mNpcIndex );
		}
		/// ݱ ó
		else if( nextPageIdx == ULONG_MAX )
		{
			Hide();
		}
		///  
		else
		{
			cPage* nextPage = mTelling->GetPage( nextPageIdx );
			if( !nextPage )
			{
				assert(0);
				return;
			}

			eAnswerEvent event = nextPage->GetAnswerEvent();
			bool retvalue = false;

			if( mStatus == eNPCQUEST_NEW && event == eEVENT_YES )
			{
				retvalue = QUESTMAN->QuestAddByNpc( mQuestIndex, mNpcIndex );
			}
			else if( mStatus == eNPCQUEST_COMPLETE && event == eEVENT_COMPLETE )
			{
				retvalue = QUESTMAN->QuestComplete( mQuestIndex, mNpcIndex );
			}
			else if( mStatus == eNPCQUEST_COMPLETE && event == eEVENT_REWARD )
			{
				retvalue = QUESTMAN->QuestReward( mQuestIndex, mNpcIndex );
			}
			else if( mStatus == eNPCQUEST_REWARD && event == eEVENT_REWARD )
			{
				retvalue = QUESTMAN->QuestReward( mQuestIndex, mNpcIndex );
			}
			else
			{
				/// ̺Ʈ  ׳  ѱ
				mNextPageIdx = nextPageIdx;
				UpdateDialog();
			}

			///   
			if( retvalue == true )
				mNextPageIdx = nextPageIdx;
		}
	}
}

/// Ʈ  ߰
void cNpcWindow::AddQuest( unsigned long questIdx, unsigned int status )
{
	if( !mpQuestList )
		return;

	if( mpQuestList && mpQuestList->IsVisible() == false )
		mpQuestList->ShowTop();

	cQuestDefine* define = QUESTMAN->GetQuestDefine( questIdx );
	assert(define);
	if( define )
	{
		LPCTSTR title = GAMERESOURCEMAN->GetQuestTitle( define->mTitleIndex );

		int textIdx = 0;
		switch( status )
		{
		case eNPCQUEST_PLAYING:	textIdx = 462;		break;
		case eNPCQUEST_NEW:		textIdx = 461;		break;
		case eNPCQUEST_COMPLETE:textIdx = 463;		break;
		case eNPCQUEST_REWARD:	textIdx = 463;		break;
		default:				assert(0);			return;
		}

		cStringT str;
		str.Format( GAMERESOURCEMAN->GetGameText( textIdx ), define->mLevel, title );
		if( define->mRepeatType == eQUEST_REPEAT )
			str.Append( GAMERESOURCEMAN->GetGameText( 472 ) );

		/// Ȯ 
		sQuestStatus* exData = new sQuestStatus;
		exData->questIdx = questIdx;
		exData->status = status;
		mDelArr.PushBack( exData );

		mpQuestList->AddRow( (LPCTSTR)str.Cstr(), mDefaultColor, exData );
	}
}

void cNpcWindow::SelectQuest()
{
	if( !mpQuestList ) return;

	mIsUseQuest = true;
	
	/// ư 
	if( mpStoreButton )
		mpStoreButton->Hide();

	if( mpWareHouseButton )
		mpWareHouseButton->Hide();

	if( mpSkillStoreButton )
		mpSkillStoreButton->Hide();

	if( mpDisjointButton )
		mpDisjointButton->Hide();

	if( mpGuildButton )
		mpGuildButton->Hide();

	if( mpTarotButton )
		mpTarotButton->Hide();

	unsigned int selectIdx = mpQuestList->GetSelectIndex();
	sQuestStatus* exData = (sQuestStatus*)mpQuestList->GetExtraData( selectIdx );

	/// ̾α  
	if( mTelling )
	{
		if( SetDialog( exData->questIdx, exData->status ) == true )
		{
			cQuestDefine* define = QUESTMAN->GetQuestDefine( exData->questIdx );
			assert(define);
			if( define )
			{
				if( mNameLabel )
					mNameLabel->SetText( GAMERESOURCEMAN->GetQuestTitle( define->mTitleIndex ) );
			}

			mHideBack = true;
		}
	}
}


/// Ʈ   ͼ ȭ 
bool cNpcWindow::SetDialog( unsigned long quetIdx, unsigned int status )
{
	mQuestIndex = quetIdx;
	mStatus = status;
	mNextPageIdx = 0;

	/// Ʈ  
	cNpcRewardWindow* reward = GAMEUI->GetNpcRewardWindow();
	if( reward && reward->SetQuestReward( mQuestIndex ) == false )
	{
		assert(0);
	}

	///   ȹ
	sQuestLinkPage* linkPage = mTelling->GetQuestLinkPage( quetIdx );
	if( !linkPage )
		return false;

	unsigned long pageIdx = 0;
	switch( mStatus )
	{
	case eNPCQUEST_PLAYING:	pageIdx = linkPage->playIndex;		break;
	case eNPCQUEST_NEW:		pageIdx = linkPage->newIndex;		break;
	case eNPCQUEST_COMPLETE:pageIdx = linkPage->completeIndex;	break;
	/// complete κ EVENT_COMPLETE  κã
	case eNPCQUEST_REWARD:	pageIdx = linkPage->rewardIndex;	break;
	default:				assert(0);	return false;
	}

	/// ȭ鰻 
	mNextPageIdx = pageIdx;

	///  
	cPage* page = mTelling->GetPage( pageIdx );
	if( !page )
	{
		assert(0);
		return false;
	}
		
	eAnswerEvent event = page->GetAnswerEvent();
	bool retvalue = true;
	switch( mStatus )
	{
	case eNPCQUEST_NEW:			/// űԿû
		if( event == eEVENT_YES )
		{
			retvalue = QUESTMAN->QuestAddByNpc( mQuestIndex, mNpcIndex );
		}
		break;
	case eNPCQUEST_COMPLETE:	/// Ϸû
		if( event == eEVENT_COMPLETE )
		{
			retvalue = QUESTMAN->QuestComplete( mQuestIndex, mNpcIndex );
		}
		break;
	case eNPCQUEST_REWARD:		/// û
		if( event == eEVENT_REWARD )
		{
			retvalue = QUESTMAN->QuestReward( mQuestIndex, mNpcIndex );
		}
		break;
	case eNPCQUEST_PLAYING:
		break;
	default:
		assert(0);
		return false;
	}
	/// 鰻
	return UpdateDialog();
}

///   
bool cNpcWindow::UpdateDialog()
{
	if( !mpQuestList ) 
		return false;

	if( !mpTextBox )
		return false;

	/// ʱȭ
	mpTextBox->Clear();
	mpQuestList->Clear();

	/// ¿  
	cPage* page = mTelling->GetPage( mNextPageIdx );
	if( !page )
		return false;

	/// Ʈ  ð ˻
	cNpcRewardWindow* reward = GAMEUI->GetNpcRewardWindow();
	if( reward )
		reward->UpdateUseReward( mQuestIndex );

	///  
	mSceneIndex = page->GetSceneIdx();
	UpdateScene();

	/// ⺻ 縦 ǥ
	cUIFuncTextParam textParam;
	textParam.mName = HERO->GetName();

	/// ⺻ 
	sPageText* pageText = page->GetPageText();
	if( pageText && mpTextBox )
	{
		for( unsigned int i = 0; i < pageText->numLine; ++i )
		{
			mpTextBox->AddFucnText( UIMAN->GetNpcTextNode( pageText->textIndex + i ), &textParam );
			mpTextBox->AddEmptyRow(1);
		}
	}

	///   
	typedef tArray<void*> cAnswerArr;
	cAnswerArr& ansArr = page->GetAnswerArr();

	for( unsigned int b = 0; b < ansArr.GetSize(); ++b )
	{
		sPageAnswer* ansText = (sPageAnswer*)ansArr[b];
		if( !ansText )
		{
			assert(0);
			return false;
		}

		unsigned long textcolor = mDefaultColor;
		for( unsigned i = 0; i < ansText->numLine; ++i )
		{
			const cUIFuncTextNode* node = UIMAN->GetNpcTextNode( ansText->textIndex + i );
			if( !node )
			{
				assert(0);
				continue;
			}

			for( ; node; node = node->GetNext() )
			{
				if( node->mColor )
					textcolor = node->mColor;

				if( node->mpString )
					mpQuestList->AddRow( node->mpString, textcolor, (void*)ansText->nextPageIndex );
			}
		}
	}

	/// 簡  next ̸  ѱ
	if( ansArr.GetSize() == 0 )
	{
		if( page->GetNextPageIdx() > 0 )
		{
			mpQuestList->AddRow( UIMAN->GetUIText( 83 ), mDefaultColor, (void*)page->GetNextPageIdx() );
		}
		else
		{
			/// 簡 
			/// ű̸ "ݱ"
			if( page->GetAnswerEvent() == eEVENT_YES )
			{
				mpQuestList->AddRow( UIMAN->GetUIText( 112 ), mDefaultColor, (void*)(ULONG_MAX) );
			}
			///  "ó" 
			else
			{
				mpQuestList->AddRow( UIMAN->GetUIText( 84 ), mDefaultColor );
			}
			
		}
	}
	return true;
}

void cNpcWindow::UpdateScene()
{
	if( mSceneIndex == 0 || !mSceneImage )
		return;

	sSceneData* scene = UIMAN->GetSceneData( mSceneIndex );
	assert(scene);

	if( scene )
	{
		cString path;
		path.Format("./Data/2DData/%s", scene->mTexName.Cstr() );
		NiTexture* tex = RESOURCEMAN->LoadMapTexture( path, false );
		if( tex )
		{
			mSceneImage->SetTexture( tex );
			unsigned int tx = scene->mTexPosX;
			unsigned int ty = scene->mTexPosY;
			unsigned int tw = scene->mTexWidth;
			unsigned int th = scene->mTexHeight;
			unsigned int x = GetAbsoluteRect().mLeft + mSceneSkin->mSkinInfo->mX;
			unsigned int y = GetScreenHeight() - scene->mTexHeight;
			mSceneImage->SetTextureRect( tx, ty, tx + tw, ty + th );
			mSceneImage->SetScreenRect( cUIRect( x, y, x+tw, y+th ) );
		}
	}
}

void cNpcWindow::OnNetLock( int lockTry )
{
	if( mpClose )
		mpClose->NetLock( lockTry );
	if( mpStoreButton )
		mpStoreButton->NetLock( lockTry );
	if( mpWareHouseButton )
		mpWareHouseButton->NetLock( lockTry );
	if( mpSkillStoreButton )
		mpSkillStoreButton->NetLock( lockTry );
	if( mpDisjointButton )
		mpDisjointButton->NetLock( lockTry );
	if( mpGuildButton )
		mpGuildButton->NetLock( lockTry );
	if( mpTarotButton )
		mpTarotButton->NetLock( lockTry );
}

void cNpcWindow::OnNetUnLock( int lockTry )
{
	if( mpClose )
		mpClose->NetUnLock( lockTry );
	if( mpStoreButton )
		mpStoreButton->NetUnLock( lockTry );
	if( mpWareHouseButton )
		mpWareHouseButton->NetUnLock( lockTry );
	if( mpSkillStoreButton )
		mpSkillStoreButton->NetUnLock( lockTry );
	if( mpDisjointButton )
		mpDisjointButton->NetUnLock( lockTry );
	if( mpGuildButton )
		mpGuildButton->NetUnLock( lockTry );
	if( mpTarotButton )
		mpTarotButton->NetUnLock( lockTry );
}