/* ==========================================================================
*      : NpcWindow.h
*      : 
*    : 谡
*    : 2008-06-19
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"

struct sQuestStatus
{
	unsigned long questIdx;		/// Ʈ ε
	unsigned int status;		/// 
};

class cUINpcTelling;
class cButton;
class cLabel;
class cTextBox;
class cListBox;
class cUITransformImage;
//class cUIImage;

/// Npc 
class cNpcWindow : public cUIWindow
{
public:
	cNpcWindow();
	virtual ~cNpcWindow();

	void Show( unsigned int npcClassIdx, unsigned long npcIndex, LPCTSTR npcName );

	void UIStageIn();
	void Close();

	/// ο Ʈ Ʈ 
	void Clear();
	void AddQuest( unsigned long questIdx, unsigned int status );
	void ShowDefaultPage();

	///   
	bool UpdateDialog();

	///
	void HideESC( bool onsound );

protected:
	bool OnCreate( cUINodeProperty* property );
	void OnRender( cUIFontItemKeeper* pKeeper );
	void UpdateSkin();
	void OnShow();
	void OnHide();
	void OnCommand( cUINode* node, unsigned int id );
	void OnListBoxChanged( cUINode* , unsigned int );
	void OnNetLock( int lockTry );
	void OnNetUnLock( int lockTry );

	void SelectQuest();

	///    
	bool SetDialog( unsigned long quetIdx, unsigned int status );
	void UpdateScene();
	
protected:
	///  
	typedef tPointerArray<void*> cDelArr;
	cDelArr	mDelArr;

	/// ̸ 
	cLabel* mNameLabel;

	///  
	cTextBox* mpTextBox;

	/// Ʈ Ʈ
	cListBox* mpQuestList;

	///  ư
	cButton* mpClose;
	cButton* mpStoreButton;
	cButton* mpWareHouseButton;
	cButton* mpSkillStoreButton;
	cButton* mpDisjointButton;
	cButton* mpGuildButton;
	cButton* mpTarotButton;

	/// Npc ̵
	unsigned int mNpcClassIndex;	/// Ŭ ε
	unsigned long mNpcIndex;		/// Ʈ ε

	/// 
	cUINpcTelling* mTelling;

	///    ÷
	bool	mHideBack;

	/// ų ư Ȱȭ  ( ش npc  ųƮ ٸ ʴ´ )
	bool	mIsUseSkillStore;

	///	Ʈ ȭ 
	bool	mIsUseQuest;

	///   ִ Ʈ
	unsigned long mQuestIndex;
	unsigned int mStatus;
	unsigned int mNextPageIdx;

	/// NPC ̹
	cUITransformImage*	mSceneImage;
	cUINodeSkin*	mSceneSkin;
	unsigned long mSceneIndex;
};
