#include "Stdafx.h"
#include "NumberEditBox.h"

static TCHAR buffer[ 80 ];

cNumberEditBox::cNumberEditBox( eUINodeType type )
: cEditBox( type )
, mMaxValue( INT_MAX )
, mValue( 0 )
, mUseZero( true )
{
}

cNumberEditBox::~cNumberEditBox()
{
}

void cNumberEditBox::Clear()
{
	mValue = 0;
	mMaxValue = INT_MAX;

	if( mUseZero )
		SetText( _T( "0" ), mTextAlign  );
	else
		SetText( _T( "" ), mTextAlign  );
}

bool cNumberEditBox::OnCreate( cUINodeProperty* property )
{
	if( cEditBox::OnCreate( property ) == false )
		return false;

	if( mUseZero )
		SetText( _T( "0" ), mTextAlign  );
	else
		SetText( _T( "" ), mTextAlign  );
	return true;
}

void cNumberEditBox::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{
	cUINode::OnLButtonDown( pos, ctrl, alt, shift );
	
	/// Ʈ  Ʈ ڽ  
	if( mEditKind != eEDIT_NOINPUT )
	{
		/// Ŀ  
		if( GetFocus() != this )
		{
			SetFocus();
			SetCapture();
		}

		/// Ʈ  
		SetAllSelect();
	}
}

void cNumberEditBox::OnChar( unsigned int wparam )
{
	cEditBox::OnChar( wparam );

	const int previousLenght = ( int )_tcslen( mText );

	SetText( FormatNumber( mText ), mTextAlign );

	if( previousLenght < (int)mTextLength )
	{
		CaretMoveRight();
	}

	///  ĳ ġ ǥ̸ ĭ ̵
	if( _T(',') == mText[ mTextCaretX ] )
	{
		CaretMoveRight();
	}
}

void cNumberEditBox::OnFocusLost()
{
	mValue = GetValue();

	if( mValue == 0 )
	{
		if( mUseZero )
			SetText( _T( "0" ), mTextAlign  );
		else
			SetText( _T( "" ), mTextAlign  );
	}

	cEditBox::OnFocusLost();
}

LPCTSTR cNumberEditBox::UnformatNumber( LPCTSTR text ) const
{	
	LPTSTR b = buffer;
	for( LPCTSTR p = text; *p; ++p )
	{
		if( *p != ',' )
		{
			*b++ = *p;
		}
	}

	*b = _T('\0');

	return buffer;
}

LPCTSTR cNumberEditBox::FormatNumber( LPCTSTR source ) const
{
	LPTSTR dest = buffer;

	/// ǥ Ѵ.
	while( *source )
	{
		if( ',' != *source )
		{
			*dest++ = *source;
		}

		++source;
	}

	*dest = 0;

	return FormatNumber( ::_tstof( buffer ), mUseZero );
}


LPCTSTR cNumberEditBox::FormatNumber( double value, bool zero )
{
	if( !value )
		return ( zero == true ) ? _T( "0" ) : _T("");

	TCHAR buffer1[ 20 ] = {0,};
	static TCHAR buffer2[ 20 ] = {0,};

	::_stprintf( buffer1, _T( "/%0.0f" ), value );

	assert( ::_tcslen( buffer1 ) < 20 );
	LPCTSTR source = buffer1 + ::_tcslen( buffer1 ) - 1;
	LPTSTR dest	= buffer2 + sizeof( buffer2 )/sizeof(TCHAR) - 1;

	*dest-- = '\0';

	int gap = 3;	/// ڸ
	while( _T('/') != *source )
	{
		if( ! gap )
		{
			*( dest-- ) = _T(',');            
			gap = 3;
		}

		--gap;
		*( dest-- )= *( source-- );
	}

	return ++dest;
}

void cNumberEditBox::CaretMoveLeft()
{
	cEditBox::CaretMoveLeft();

	if( _T(',') == mText[ mTextCaretX ] )
	{
		cEditBox::CaretMoveLeft();
	}
}


void cNumberEditBox::CaretMoveRight()
{
	cEditBox::CaretMoveRight();

	if( _T(',') == mText[ mTextCaretX ] )
	{
		cEditBox::CaretMoveRight();
	}
}


void cNumberEditBox::KeyDownDelete()
{
	cEditBox::KeyDownDelete();

	::_tcscpy( mText, FormatNumber( mText ) );
	mTextLength	= ::_tcslen( mText );
	
	if( _T(',') == mText[ mTextCaretX ] )
	{
		cEditBox::CaretMoveRight();
	}

	UpdateText();
	UpdateShowText();
}


void cNumberEditBox::KeyDownBackSpace()
{
	if( 0 < mTextCaretX && _T(',') == mText[ mTextCaretX - 1 ] )
		cEditBox::KeyDownBackSpace();
	
	cEditBox::KeyDownBackSpace();
	SetText( FormatNumber( mText ), mTextAlign );
}

void cNumberEditBox::SetText( LPCTSTR text, int align )
{
	cEditBox::SetText( text, align );
}

void cNumberEditBox::SetValue( unsigned long value )
{
	mValue = value;

	if( mValue )
	{
		SetText( FormatNumber( ( double )( mMaxValue < value ? mMaxValue : value ), mUseZero ), mTextAlign );
	}
	else
	{
		if( mUseZero )
			SetText( _T( "0" ), mTextAlign  );
		else
			SetText( _T( "" ), mTextAlign  );
	}
}


void cNumberEditBox::SetMaxValue( unsigned long value )
{
	mMaxValue = value;
}


unsigned long cNumberEditBox::GetValue() const
{
	return _tstoi( UnformatNumber( mText ) );
}
unsigned long cNumberEditBox::GetMaxValue() const
{
	return mMaxValue;
}