/* ====================================================================
 *      :	ObjectManager.h
 *      :	 ü Ѵ.
 *    :	
 *    :	2006.08.29
 *
 * ߰ :
 *		߰¥	۾	߰
 *		2006.08.29		
 * 
 * ǻ :	
 * =================================================================== */
#pragma once
#include "CommonNetworkMsgStruct.h"
#include "BaseObject_Common.h"
#include "Monster_Common.h"

enum eOBJECTTYPE;

class cHero;
class cPlayer;
class cDynamicEntity;
class cBaseObject;
class cMonster;
class cTotem;
class cSceneNode;
class cManagedStaticSceneNode;
class cNpc;
class cLexer;
class cToken;

class cInputSystem;

struct sMonsterData;
struct sNpcData;

class cObjectManager
{
	friend class cInputSystem;

public:
	static cObjectManager*	mpObjectManager;

public:
	/// No Server Client 
	void AddHeroInfo( unsigned long objectIdx, LPTSTR heroname, char race, char gender );
	void AddHero();
	void AddPlayer( unsigned long objectIdx, char race, char gender, int x, int y );
	//

public:
	cObjectManager();
	virtual ~cObjectManager();

	/// ʱ(۽ ѹ)
	bool Init();

	/// ( ѹ)
	void Exit();

	/// ʱ(̵ Ž)
	void Open();

	/// (̵ Ž)
	void Close();

	/// selectâ Ѿ  
	void ClearHeroData();

	/// ó
	void Process( unsigned long deltaTime, unsigned long accumTime );

	/// Է¿  ó
	bool ProcessLButtonClick( int mouseX, int mouseY );
	bool ProcessLButtonDClick( int mouseX, int mouseY );
	bool ProcessMouseOver( int mouseX, int mouseY );

	bool ProcessRButtonUp( int mouseX, int mouseY );

	/// ĳ ̵
	void HeroGoto( int mouseX, int mouseY );

	/// Hero  ڵ.. 070420 wonju
	bool HeroAutoAttack(unsigned long id);

	/// hero 
	void AddHeroFromServerMsg( MSGROOT* pMsg );
	/// Player 
	void AddPlayerFromServerMsg( MSGROOT* pMsg, bool showEffect = false );

	/// player 
	void RemovePlayer( unsigned long objectIdx );

	///
	void MovePlayer( unsigned long objectIdx, float x, float y, long moveSpeed );

	void ActionMovePlayer( MSGROOT* pMsg );

	void AddTotem( unsigned long uIdx, unsigned long totemInfoIdx, NiPoint3 totemPos );
	void RemoveTotem( unsigned long uIdx );

	void AddNpc( sNpcData* pNpcInfo );
//	void AddNpc(  unsigned long objIdx, sNPCRegen* pNpcInfo );
	void RemoveNpc( unsigned long objectIdx );

	/// 061012 PKH  ߰
	void		AddMonster( sMonsterData* pMonstInfo, bool isRegen = false );
	/// 061012 PKH  ü 
	void		RemoveMonster( unsigned long objectIdx );

	///
	void AddGathering( unsigned long uIdx, unsigned long gatheringIdx, NiPoint3 genPos, float dir );
	///
	void RemoveGathering( unsigned long idx );

	/// 061012 PKH  ̵ 
	void		MonsterMoveStop( unsigned long monsterIdx, float posX, float posY );
	void		MonsterGoto( int idx, NiPoint2* moveArray, unsigned long count,
		unsigned int moveSpeed, eMOVE_SPEED_TYPE moveSpeedType = eMOVESPEED_RUN, float range = 0, 
		sObject* pTarget = NULL );

	cBaseObject* GetObject( sObject* pInfo );
	cBaseObject* GetObject( unsigned char type, unsigned long idx );

	/// npc   
	const tPointerHashMap<unsigned long, void*>* GetNpcMap();

	///
	inline cHero* GetHero()	{ return mpHero; }

	/// 061123 PKH ÷̾  
	cPlayer*	GetPlayer( unsigned long idx );
	cPlayer*	GetPlayerByName( LPCTSTR name );
	/// 061127 PKH   
	cMonster*	GetMonster( unsigned long idx );

	NiPoint3	GetGatherPos( unsigned long idx );

	/// NPC  ȹ
	cNpc*		GetNpc( unsigned long idx );

	/// 070108 PKH player ġƮ
	//bool		PlayerCheat( cLexer* pLexer );

	//float		GetMapSize() { return mMapSize; }
	//void		SetMapSize( float mapSize ) { mMapSize = mapSize; }

	/// 070503 PKH   
	void		AddMonsterDie( unsigned long monsterUniqueIdx ) { mMonsterDieArray.PushBack( monsterUniqueIdx ); }

	/// ü  Pickó
	unsigned int ObjectPicking( int mouseX, int mouseY, cBaseObject** out );
	void ClearPickObject();

	/// 
	cManagedStaticSceneNode* ManagedStaticPicking( int mouseX, int mouseY );

	inline cBaseObject* GetOverObject() { return GetObject( &mOverObject); }
	inline void ResetOverObject() { mOverObject.index = 0; mOverObject.type = eOBJECTTYPE_NONE; }

	/// 080307 PKH Ʈ Ÿ  Ÿ
	float		ObjectSizeRange( cBaseObject* object1, cBaseObject* object2, float range );

	///  ũ 
	void		UpdateGuildMark( unsigned long guildIndex, unsigned long markIndex );

	void		UpdateHelmetState();

private:
	cHero*		mpHero;

	/// Ŀ ü ..
	sObject			mPickObject;
	sObject			mOverObject;

	struct sOverNode
	{
		unsigned int	type;
		unsigned long	indexByManager;
	};
	sOverNode	mOverNode;

	//float		mMapSize;

	/// player map
//	typedef tPointerHashMap<unsigned long, cPlayer*> cPlayerHashMap;
	typedef tPointerHashMap<unsigned long, void*> cPlayerHashMap;
	cPlayerHashMap*	mpPlayerMap;

	/// monster map
//	typedef tPointerHashMap<unsigned long, cMonster*> cMonsterHashMap;
	typedef tPointerHashMap<unsigned long, void*> cMonsterHashMap;
	cMonsterHashMap*	mpMonsterMap;

	/// npc map
//	typedef tPointerHashMap<unsigned long, cNpc*> cNpcHashMap;
	typedef tPointerHashMap<unsigned long, void*> cNpcHashMap;
	cNpcHashMap*	mpNpcMap;

	typedef tPointerHashMap<unsigned long, void*> cTotemHashMap;
	cTotemHashMap* mpTotemMap;

	typedef tPointerHashMap<unsigned long, unsigned long> cGatheringMap;
	cGatheringMap* mpGatheringMap;

	/// pick ̺Ʈ ó ü
	/// 1.  ̵ Ż


	/// 
//	tArray<cSceneNode*> mCollidableArray;
	tArray<void*> mCollidableArray;

	/// 061212 PKH  ͸ صδ 迭
	typedef tArray<unsigned long> cMonsterDieArray;
	cMonsterDieArray mMonsterDieArray;

};

inline const tPointerHashMap<unsigned long, void*>* cObjectManager::GetNpcMap()
{
	return (tPointerHashMap<unsigned long, void*>*)mpNpcMap;
}

#define OBJECTMANAGER	cObjectManager::mpObjectManager
#define OBJECTMAN cObjectManager::mpObjectManager
#define HERO			cObjectManager::mpObjectManager->GetHero()
