#include "StdAfx.h"
#include "objectnamecard.h"

#include "FontAgent.h"
#include "NameCardGauge.h"

#include "ResourceManager.h"

#include "UIManager.h"
#include "PVPManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "Monster.h"
#include "Npc.h"
#include "TitleManager.h"
#include "PartyManager.h"

#include "OptionManager.h"

#include "DepthPlaneObject.h"
#include "CameraManager.h"
#include "RenderSystem.h"

#include "StageManager.h"
#include "PlaneObject.h"
#include "GuildManager.h"

cNameCard::cNameCard()
{
	mHeadScreenX = 0;
	mHeadScreenY = 0;
	mFootScreenX = 0;
	mFootScreenY = 0;
}

cNameCard::~cNameCard()
{
}

void cNameCard::Set2DPos( int hscreenX, int hscreenY, int fscreenX, int fscreenY )
{
	mHeadScreenX = hscreenX;
	mHeadScreenY = hscreenY;
	mFootScreenX = fscreenX;
	mFootScreenY = fscreenY;
}

void cNameCard::Set2DFootPos( int fscreenX, int fscreenY )
{
	mFootScreenX = fscreenX;
	mFootScreenY = fscreenY;
}

///
void cNameCard::SetName( LPTSTR name )
{
	::_stprintf( mName.mString, _T("%s"), name );
	mName.mStrLen = ::_tcslen(name);
	mName.mPixelWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_DepthFont, 
						mName.mString, mName.mStrLen );

	mName.mPixelHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_DepthFont);
}

///
void cNameCard::SetName( LPTSTR name, unsigned long color )
{
	SetName( name );
	SetNameColor( color );
}

void cNameCard::SetNameColor( unsigned long color )
{
	mName.mColor = color;

	float red	= (float)((color & 0xFF0000) >> 16) / 255.0f;
	float green	= (float)((color & 0xFF00) >> 8) / 255.0f;
	float blue	= (float)((color & 0xFF)) / 255.0f;

	mBackColor = NiColorA(red, green, blue, 0.0f);
}

void cNameCard::Draw()
{
	POINT pos;

	pos.x = (LONG)mHeadScreenX - (mName.mPixelWidth/2);
	pos.y = (LONG)mHeadScreenY - FONTAGENT->GetTextHeight(cFontAgent::eFont_System);
	FONTAGENT->DrawText( cFontAgent::eFont_System, mName.mString, mName.mStrLen, &pos, mName.mColor, true );
}


//////////////////////////////////////////////////////////////////////////
// Object NameCard
cObjectNameCard::cObjectNameCard( cBaseObject* pObj )
: mpOriginObject( pObj ), mpHPGauge(0), mpMPGauge(0)
{
	mUsedGauge = true;
	SetName( mpOriginObject->GetName() );
}

cObjectNameCard::~cObjectNameCard()
{
	mpOriginObject = 0;

	SAFE_DELETE(mpMPGauge);
	SAFE_DELETE(mpHPGauge);
}

//////////////////////////////////////////////////////////////////////////
// NpcNameCard
cNpcNameCard::cNpcNameCard( cBaseObject* pObj )
: cObjectNameCard( pObj )
{
}

cNpcNameCard::~cNpcNameCard()
{
}

///
void cNpcNameCard::SetJobName( LPTSTR name )
{
	::_stprintf( mJobName.mString, _T("<%s>"), name );
	mJobName.mStrLen = ::_tcslen(mJobName.mString);
	mJobName.mPixelWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_DepthFont, 
													mJobName.mString, mJobName.mStrLen );
	mJobName.mPixelHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_DepthFont);
}

///
void cNpcNameCard::SetJobName( LPTSTR name, unsigned long color )
{
	SetJobName( name );
	SetJobNameColor( color );
}

void cNpcNameCard::ChangeTextValue()
{
	if( mpOriginObject == 0 )
	{
		assert(0);
		return;
	}

	cNpc* p = (cNpc*)mpOriginObject;
	SetName( p->GetName() );

	/// hero  
	SetJobName( p->GetJobName() );
}


void cNpcNameCard::Draw()
{
	POINT pos;

	pos.x = (LONG)mHeadScreenX - (mJobName.mPixelWidth/2);
	pos.y = (LONG)mHeadScreenY - FONTAGENT->GetTextHeight(cFontAgent::eFont_System);
	FONTAGENT->DrawText( cFontAgent::eFont_System, mJobName.mString, mJobName.mStrLen, &pos, mJobName.mColor, true );

	pos.x = (LONG)mHeadScreenX - (mName.mPixelWidth/2);
	pos.y -= FONTAGENT->GetTextHeight(cFontAgent::eFont_System);
	FONTAGENT->DrawText( cFontAgent::eFont_System, mName.mString, mName.mStrLen, &pos, mName.mColor, true );
}


//////////////////////////////////////////////////////////////////////////
// MonsterNameCard
cMonsterNameCard::cMonsterNameCard( cBaseObject* pObj )
: cObjectNameCard( pObj )
{
	NiTexture* pTex = RESOURCEMAN->LoadTexture( "./Data/2DData/U_Basic_01.tga", false );
	if( pTex )
	{
		RECT rcFrame;
		rcFrame.left = 356;
		rcFrame.top = 368;
		rcFrame.right = GAUGE_WIDTH+2;
		rcFrame.bottom = GAUGE_HEIGHT+2;

		RECT rc;
		rc.left = 356;
		rc.top = 383;
		rc.right = GAUGE_WIDTH;
		rc.bottom = GAUGE_HEIGHT;

		mpHPGauge = new cNameCardGauge;
		if( mpHPGauge->Init( pTex,&rc, pTex, &rcFrame ) == false )
			SAFE_DELETE(mpHPGauge);
	}
}

cMonsterNameCard::~cMonsterNameCard()
{
}

void cMonsterNameCard::ChangeTextValue()
{
	if( mpOriginObject == 0 )
	{
		assert(0);
		return;
	}

	cMonster* p = (cMonster*)mpOriginObject;
	if( p )
	{
		SetName( p->GetName() );

		/// 
		if( p->IsPrecedeAttack() == true )
			SetNameColor(0xFFDC00FF);
		else
			SetNameColor(0xFFFFFF00);
	}
}

void cMonsterNameCard::ChangeGaugeValue()
{
	unsigned short width = 0;
	if( mpOriginObject->GetMaxHP() != 0 )
	{
		 width = (unsigned short)(GAUGE_WIDTH * mpOriginObject->GetHP() / mpOriginObject->GetMaxHP());
		 if( mpOriginObject->GetHP() > mpOriginObject->GetMaxHP() )
		 {
			 assert(0);
			 width = GAUGE_WIDTH;
		 }
	}

	if( mpHPGauge )
		mpHPGauge->SetGaugeWidth( width );
}

void cMonsterNameCard::Draw()
{
	POINT pos;
	pos.y = (LONG)mHeadScreenY;
	if( mUsedGauge && OPTIONMAN->IsShowGauge() )
	{
		pos.x = (LONG)mHeadScreenX - (GAUGE_WIDTH/2);
		pos.y -= GAUGE_HEIGHT;

		mpHPGauge->SetGaugePos( (short)pos.x, (short)pos.y );
		mpHPGauge->Draw();
	}

	if( OPTIONMAN->IsShowMonsterNameCard() )
	{
		pos.x = (LONG)mHeadScreenX - (mName.mPixelWidth/2);
		pos.y -= FONTAGENT->GetTextHeight(cFontAgent::eFont_System);
		FONTAGENT->DrawText( cFontAgent::eFont_System, mName.mString, mName.mStrLen, &pos, mName.mColor, true );
	}
}

//////////////////////////////////////////////////////////////////////////
// PlayerNameCard

cPlayerNameCard::cPlayerNameCard( cBaseObject* pObj )
: cObjectNameCard(pObj)
, mpGuildMark(0)
, mEnableGuildMark( true )
{
	mIsHeroNameCard = pObj->GetObjectType() == eOBJECTTYPE_HERO;

	NiTexture* pTex = RESOURCEMAN->LoadTexture( "./Data/2DData/U_Basic_01.tga", false );
	if( pTex )
	{
		RECT rcFrame;
		rcFrame.left = 356;
		rcFrame.top = 368;
		rcFrame.right = GAUGE_WIDTH+2;
		rcFrame.bottom = GAUGE_HEIGHT+2;

		RECT rc;
		rc.left = 356;
		rc.top = 383;
		rc.right = GAUGE_WIDTH;
		rc.bottom = GAUGE_HEIGHT;

		mpHPGauge = new cNameCardGauge;
		if( mpHPGauge->Init( pTex,&rc, pTex, &rcFrame ) == false )
			SAFE_DELETE(mpHPGauge);
	}

	if( pTex )
	{
		RECT rcFrame;
		rcFrame.left = 356;
		rcFrame.top = 375;
		rcFrame.right = GAUGE_WIDTH+2;
		rcFrame.bottom = GAUGE_HEIGHT+2;

		RECT rc;
		rc.left = 356;
		rc.top = 388;
		rc.right = GAUGE_WIDTH;
		rc.bottom = GAUGE_HEIGHT;

		mpMPGauge = new cNameCardGauge;
		if( mpMPGauge->Init( pTex,&rc, pTex, &rcFrame ) == false )
			SAFE_DELETE(mpMPGauge);
	}
}

cPlayerNameCard::~cPlayerNameCard()
{
	SAFE_DELETE( mpGuildMark );
}

void cPlayerNameCard::SetNickName( LPTSTR nickName, unsigned long color )
{
	::_stprintf( mNickName.mString, _T("%s"), nickName );
	mNickName.mStrLen = ::_tcslen(mNickName.mString);
	mNickName.mPixelWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_DepthFont, 
							mNickName.mString, mNickName.mStrLen );
	mNickName.mPixelHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_DepthFont);
	mNickName.mColor = color;
}

void cPlayerNameCard::SetTodayWord( LPTSTR word, unsigned long color )
{
	::_stprintf( mTodayWord.mString, _T("%s"), word );
	mTodayWord.mStrLen = ::_tcslen( mTodayWord.mString );
	mTodayWord.mPixelWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_DepthFont, 
							mTodayWord.mString, mTodayWord.mStrLen );
	mTodayWord.mPixelHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_DepthFont);
	mTodayWord.mColor = color;
}

void cPlayerNameCard::SetGuildName( LPTSTR guildName )
{
	if( ::_tcslen( guildName ) == 0 )
		::_stprintf( mGuildName.mString, _T("%s"), guildName );
	else
	{
		if( STAGEMAN->GetCurrentStage() == eStage_Game )
			::_stprintf( mGuildName.mString, _T("<%s>"), guildName );
		else
			::_stprintf( mGuildName.mString, _T("%s"), guildName );
	}

	mGuildName.mStrLen = ::_tcslen(mGuildName.mString);
	mGuildName.mPixelWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_DepthFont, 
							mGuildName.mString, mGuildName.mStrLen );
	mGuildName.mPixelHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_DepthFont);

/*
	::_stprintf( mGuildNameEx.mString, _T("<%s>"), guildName );
	mGuildNameEx.mStrLen = ::_tcslen(mGuildNameEx.mString);
	mGuildNameEx.mPixelWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_DepthFont, 
							mGuildNameEx.mString, mGuildNameEx.mStrLen );
	mGuildNameEx.mPixelHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_DepthFont);
*/
}

/*void cPlayerNameCard::SetGuildPlaceName( LPTSTR guildPlaceName )
{
	::_stprintf( mGuildPlaceName.mString, _T("%s"), guildPlaceName );
	mGuildPlaceName.mStrLen = ::_tcslen(mGuildPlaceName.mString);
	mGuildPlaceName.mPixelWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_DepthFont, 
								mGuildPlaceName.mString, mGuildPlaceName.mStrLen );
	mGuildPlaceName.mPixelHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_DepthFont);
}*/

void cPlayerNameCard::ChangeTextValue()
{
	if( mpOriginObject == 0 )
	{
		assert(0);
		return;
	}

	cPlayer* p = (cPlayer*)mpOriginObject;
	if( p )
	{
		if( PARTYMAN->IsHeroParty( p->GetObjectID() ) )
			SetName( p->GetName(), 0xFF0000FF ); //eCOLOR_BLUE
		else
			SetName( p->GetName(), 0xFFFFFFFF ); //eCOLOR_WHITE

		sPlayerExrInfo* exrInfo = p->GetPlayerExrInfo();
		if( exrInfo )
		{
			/// ŸƲ 
			if( exrInfo->mTitleIndex > 0 )
			{
				cTitleDefine* define = TITLEMAN->GetTitleDefine( exrInfo->mTitleIndex );
				if( define )
				{
					SetNickName( (LPTSTR)define->mName, define->mColor );
					SetNameColor( define->mColor );
				}
			}
			else
			{
				SetNickName( _T("") );
			}

			///  
			if( exrInfo->mGuildIndex > 0 )
				SetGuildName( exrInfo->mGuildName );
			else	
				SetGuildName( _T("") );

			///  Ѹ 
			if( ::_tcslen( exrInfo->mTodayWord ) > 0 )
				SetTodayWord( exrInfo->mTodayWord, exrInfo->mTodayColor );
			else
				SetTodayWord( _T("") );

			/// 帶ũ ˻ 
			ChangeGuildMark();
		}

		if( PVPMAN->IsEnableBattle() )
		{
			if( PVPMAN->IsMyTeam( p ) == false )
			{
				int textIdx = 0;
				switch( p->GetForceType() )
				{
				case eFORCETYPE_NONE:	textIdx = 119;	break;
				case eFORCETYPE_FIRE:	textIdx = 120;	break;
				case eFORCETYPE_WATER:  textIdx = 121;	break;
				case eFORCETYPE_WIND:	textIdx = 122;	break;
				case eFORCETYPE_EARTH:	textIdx = 123;	break;
				default: 
					{
						assert(0); 
						SetName( _T("Enumy"), 0xFFFF0000); //eCOLOR_RED
					}
					break;
				}

				if( textIdx != 0 )
					SetName( (LPTSTR)UIMAN->GetUIText( textIdx ), 0xFFFF0000 ); //eCOLOR_RED

				SetNickName( _T("") );
				SetGuildName( _T("") );
				
				mEnableGuildMark = false;
			}
		}
	}
}

void cPlayerNameCard::ChangeGaugeValue()
{
//	if( mpOriginObject->GetHP() > mpOriginObject->GetMaxHP() )
//		assert(0);
//	if( mpOriginObject->GetMP() > mpOriginObject->GetMaxMP() )
//		assert(0);

	/// hp  ǥ
	unsigned short width = 0;
	if( mpOriginObject->GetMaxHP() != 0 )
	{
		width = (unsigned short)(GAUGE_WIDTH * mpOriginObject->GetHP()/mpOriginObject->GetMaxHP());
		if( mpOriginObject->GetHP() > mpOriginObject->GetMaxHP() )
		{
			unsigned long check1 = mpOriginObject->GetHP();
			unsigned long check2 = mpOriginObject->GetMaxHP();

			assert(0);
			width = GAUGE_WIDTH;
		}
	}
	else
	{
		assert(0);
	}

	if( mpHPGauge )
		mpHPGauge->SetGaugeWidth( width );

	/// mp  ǥ
	width = 0;
	if( mpOriginObject->GetMaxMP() != 0 )
	{
		width = (unsigned short)(GAUGE_WIDTH * mpOriginObject->GetMP()/mpOriginObject->GetMaxMP());
		if( mpOriginObject->GetMP() > mpOriginObject->GetMaxMP() )
		{
			assert(0);
			width = GAUGE_WIDTH;
		}
	}
	else
	{
		assert(0);
	}

	if( mpMPGauge )
		mpMPGauge->SetGaugeWidth( width );
}

///  
void cPlayerNameCard::ChangeGuildName()
{
	if( mpOriginObject == 0 )
	{
		assert(0);
		return;
	}

	cPlayer* p = (cPlayer*)mpOriginObject;
	if( p )
	{
		sPlayerExrInfo* exrInfo = p->GetPlayerExrInfo();
		if( exrInfo )
		{
			if( exrInfo->mGuildIndex > 0 )
				SetGuildName( exrInfo->mGuildName );
			else	
				SetGuildName( _T("") );
		}
	}
}

void cPlayerNameCard::ChangeGuildMark()
{
	if( mpOriginObject == 0 )
	{
		assert(0);
		return;
	}

	cPlayer* p = (cPlayer*)mpOriginObject;
	if( p )
	{
		sPlayerExrInfo* exrInfo = p->GetPlayerExrInfo();
		if( exrInfo )
		{
			if( mEnableGuildMark == true )
				SAFE_DELETE( mpGuildMark );

			mEnableGuildMark = false;

			if( exrInfo->mGuildIndex > 0 && exrInfo->mGuildMarkIndex > 0 )
			{
				NiTexture* tex = GUILDMAN->CheckGuildMark( exrInfo->mGuildIndex, exrInfo->mGuildMarkIndex );
				if( tex )
				{
					mpGuildMark = new cPlaneObject;
					if( mpGuildMark->Create( tex, 0, 0, MARK_WIDTH, MARK_HEIGHT, 0, 0, MARK_WIDTH, MARK_HEIGHT ) == false )
					{
						assert(0);
						return;
					}

					mEnableGuildMark = true;
				}
			}
		}
	}
}

/// 帶ũ ̸
void cPlayerNameCard::PreviewGuildMark( NiTexture* tex )
{
	if( mpOriginObject == 0 )
	{
		assert(0);
		return;
	}

	if( tex == 0 )
	{
		assert(0);
		return;
	}

	cPlayer* p = (cPlayer*)mpOriginObject;
	if( p )
	{
		sPlayerExrInfo* exrInfo = p->GetPlayerExrInfo();
		if( exrInfo )
		{
			if( mEnableGuildMark == true )
				SAFE_DELETE( mpGuildMark );

			mEnableGuildMark = false;

			if( exrInfo->mGuildIndex > 0 )
			{
				mpGuildMark = new cPlaneObject;
				if( mpGuildMark->Create( tex, 0, 0, MARK_WIDTH, MARK_HEIGHT, 0, 0, MARK_WIDTH, MARK_HEIGHT ) == false )
				{
					assert(0);
					return;
				}

				mEnableGuildMark = true;
			}
		}
	}
}

void cPlayerNameCard::Draw()
{
	POINT pos;
	pos.y = (LONG)mFootScreenY;
	if( mUsedGauge && OPTIONMAN->IsShowGauge() )
	{
		pos.x = (LONG)mFootScreenX - (GAUGE_WIDTH/2);
		pos.y -= GAUGE_HEIGHT;

		mpMPGauge->SetGaugePos( (short)pos.x, (short)pos.y );
		mpMPGauge->Draw();

		pos.x = (LONG)mFootScreenX - (GAUGE_WIDTH/2);
		pos.y -= GAUGE_HEIGHT+3+1;

		mpHPGauge->SetGaugePos( (short)pos.x, (short)pos.y );
		mpHPGauge->Draw();
	}

	bool showTotal = false;

	if( STAGEMAN->GetCurrentStage() == eStage_Select )
	{
		showTotal = true;
	}
	else
	{
		if( mIsHeroNameCard )
		{
			if( OPTIONMAN->IsShowHeroNameCard() == false )
				return;

			if( OPTIONMAN->IsShowHeroTotal() )
				showTotal = true;
		}
		else
		{

			if( OPTIONMAN->IsShowPlayerNameCard() == false )
				return;

			if( OPTIONMAN->IsShowPlayerTotal() )
				showTotal = true;
		}
	}

	pos.y = (LONG)mHeadScreenY;

	if( showTotal )
	{
		/// ȣĪ & ̸
		pos.y -= FONTAGENT->GetTextHeight(cFontAgent::eFont_System);
		pos.x = (LONG)mHeadScreenX - ((mName.mPixelWidth + mNickName.mPixelWidth + NAME_GAP)/2);
		FONTAGENT->DrawText( cFontAgent::eFont_System, mNickName.mString, mNickName.mStrLen, &pos, mNickName.mColor, true );

		pos.x += mNickName.mPixelWidth + NAME_GAP;
		FONTAGENT->DrawText( cFontAgent::eFont_System, mName.mString, mName.mStrLen, &pos, mName.mColor, true );

		/// ȣĪ & 
		if( mGuildName.mStrLen > 0 )
		{
			pos.y -= FONTAGENT->GetTextHeight(cFontAgent::eFont_System);
			pos.x = (LONG)mHeadScreenX - ((mGuildName.mPixelWidth)/2);
			FONTAGENT->DrawText( cFontAgent::eFont_System, mGuildName.mString, mGuildName.mStrLen, &pos, mGuildName.mColor, true );
		}

		if( mEnableGuildMark && mpGuildMark )
		{
			long width = (mName.mPixelWidth + mNickName.mPixelWidth > mGuildName.mPixelWidth) ? mName.mPixelWidth + mNickName.mPixelWidth : mGuildName.mPixelWidth;
			pos.x = (LONG)mHeadScreenX - ((width + NAME_GAP)/2) - MARK_WIDTH;

			mpGuildMark->SetTranslate( (short)pos.x, (short)pos.y );
			mpGuildMark->Draw();
		}

		///  Ѹ
		if( mTodayWord.mStrLen > 0 )
		{
			pos.y -= FONTAGENT->GetTextHeight(cFontAgent::eFont_System);
			pos.x = (LONG)mHeadScreenX - ((mTodayWord.mPixelWidth)/2);
			FONTAGENT->DrawText( cFontAgent::eFont_System, mTodayWord.mString, mTodayWord.mStrLen, &pos, mTodayWord.mColor, true );
		}
	}
	else
	{
		/// ̸
		pos.x = (LONG)mHeadScreenX - (mName.mPixelWidth/2);
		pos.y  -= FONTAGENT->GetTextHeight(cFontAgent::eFont_System);
		FONTAGENT->DrawText( cFontAgent::eFont_System, mName.mString, mName.mStrLen, &pos, mName.mColor, true );
	}
}
