/* ====================================================================
 *      :	ObjectNameCard.h
 *      :	ü ̸ ǥϱ  Ŭ
 *    :	̹
 *    :	2006.12
 * ǻ :	
 * =================================================================== */
#pragma once

#include "DepthPlane.h"

class cPlaneObject;
class cBaseObject;

class cNameCardGauge;

/* ó 
1.  ġ => x,z(foot dummy ġ) y(foot dummy_y + head dummy_y + offset value)
2. font object  ۸ ߰ ü Ѵ.

 
5 4 ( 150 * 8 )
5 16( 150 * 8 )
*/

/// ǥ  ɼ
enum eNameCardOption
{
	eRenderType_3D = 0,
	eRenderType_2D,
};

const unsigned int	GAUGE_WIDTH = 109;
const unsigned int	GAUGE_HEIGHT = 4;

const unsigned int	NAMECARD_WIDTH = 300;//100;
const unsigned int	NAMECARD_HEIGHT = 68;//34;
const unsigned int	NAME_GAP = 4;

///  ´ 3Dü  ̸   Ѵ. ( : )
class cNameCard : public cPlane
{
public:
	cNameCard();
	virtual ~cNameCard();

	struct sName
	{
		TCHAR			mString[256];
		int				mStrLen;
		unsigned long	mColor;
		long			mPixelWidth;
		long			mPixelHeight;

		sName()
		{
			_stprintf( mString, _T("%s"), _T("") );
			mStrLen = ::_tcslen(mString);
			mColor = 0xFFFFFFFF;//0xFF19F0A0;//0xFF111111;
//			mPixelWidth = NAMECARD_WIDTH;
//			mPixelHeight = 12;
			mPixelWidth = 0;
			mPixelHeight = 0;
		}
	};

	inline LPCTSTR GetName() { return mName.mString; }
	inline virtual unsigned long GetNameColor() { return mName.mColor; }

	virtual void SetName( LPTSTR name );
	virtual void SetName( LPTSTR name, unsigned long color );
	virtual void SetNameColor( unsigned long color );

	///  ʿ 쿡 ܺο ȣѴ.
	virtual void ChangeTextValue() {}
	virtual void ChangeGaugeValue() {}
	virtual void ChangeGuildName() {}
	virtual void ChangeGuildMark() {}

	void Set2DPos( int hscreenX, int hscreenY, int fscreenX, int fscreenY );
	void Set2DFootPos( int fscreenX, int fscreenY );
	virtual void Draw();

protected:
	NiColorA					mBackColor;

	/// ü ̸
	sName mName;

	int mHeadScreenX;
	int mHeadScreenY;
	int mFootScreenX;
	int mFootScreenY;
};


///  ´ 3Dü HPMP  ǥ ʿ ü ( : , NPC, ĳ )
class cObjectNameCard : public cNameCard
{
public:
	virtual ~cObjectNameCard();

	inline virtual void SetEnableGauge( bool enable ) { mUsedGauge = enable; }

protected:
	cObjectNameCard( cBaseObject* pObj );

protected:
	/// ̸ǥ  ü
	cBaseObject*		mpOriginObject;

	///  
	bool mUsedGauge;
	cNameCardGauge*	mpHPGauge;
	cNameCardGauge*	mpMPGauge;
};


/// NPC  ǥѴ.
class cNpcNameCard : public cObjectNameCard
{
public:
	cNpcNameCard( cBaseObject* pObj );
	virtual ~cNpcNameCard();

	inline LPCTSTR GetJobName() { return mJobName.mString; }
	inline virtual unsigned long GetJobNameColor() { return mJobName.mColor; }

	virtual void ChangeTextValue();

	virtual void Draw();

protected:

	virtual void SetJobName( LPTSTR name );
	virtual void SetJobName( LPTSTR name, unsigned long color );

	inline virtual void SetJobNameColor( unsigned long color ) { mJobName.mColor = color; }

private:
	sName	mJobName;
};


///  ´ 3Dü Ϳ   ǥѴ.(  ǥ  ʴ´)
class cMonsterNameCard : public cObjectNameCard
{
public:
	cMonsterNameCard( cBaseObject* pObj );
	virtual ~cMonsterNameCard();

	virtual void ChangeTextValue();
	virtual void ChangeGaugeValue();

	virtual void Draw();
};


///  ´ 3Dü Player   Ư  ǥϴ 
class cPlayerNameCard : public cObjectNameCard
{
public:
	cPlayerNameCard( cBaseObject* pObj );
	virtual ~cPlayerNameCard();

	inline LPCTSTR GetNickName() { return mNickName.mString; }
	inline LPCTSTR GetGuildName() { return mGuildName.mString; }
	inline LPCTSTR GetGuildPlaceName() { return mGuildPlaceName.mString; }

	virtual void ChangeTextValue();
	virtual void ChangeGaugeValue();
	virtual void ChangeGuildName();

	inline virtual void SetEnableGuildMark( bool enable ) { mEnableGuildMark = enable; }
	virtual void ChangeGuildMark();
	virtual void PreviewGuildMark( NiTexture* tex );
	
	virtual void Draw();

	virtual void SetNickName( LPTSTR nickName, unsigned long color = 0xFFFFFFFF );
	virtual void SetTodayWord( LPTSTR word, unsigned long color = 0xFFFFFFFF );
	virtual void SetGuildName( LPTSTR guildName );
	//virtual void SetGuildPlaceName(LPTSTR guildPlaceName );

protected:

	bool mIsHeroNameCard;

	/// ȣĪ  
	sName	mNickName;

	/// ̸
	sName	mGuildName;

	///  Ѹ
	sName	mTodayWord;
	sName	mPreviewTodayWord;	/// ̸

//	sName	mGuildNameEx;

	///  ȣĪ
	sName	mGuildPlaceName;

	///  ũ
	cPlaneObject*	mpGuildMark;
	bool			mEnableGuildMark;
};