#include "stdafx.h"
#include "OptionSheet.h"

#include "OptionManager.h"
#include "ResourceManager.h"

#include "CheckBox.h"
#include "RadioButton.h"
#include "OptionGauge.h"
#include "ComboBox.h"

#include "Application.h"
#include "RenderSystem.h"

#include "StageManager.h"
#include "ObjectManager.h"

cOptionSheet1::cOptionSheet1( eUINodeType type )
: cUIWindow( type )
,mpShowHeroNameCard(0)
,mpShowPlayerNameCard(0)
,mpShowNPCNameCard(0)
,mpShowMonsterNameCard(0)
,mpShowGauge(0)
,mpShowBubble(0)
,mpShowHelmet(0)
,mpShowTip(0)
,mpRejectionTrade(0)
,mpRejectionDuel(0)
,mpRejectionWhisper(0)
,mpRejectionParty(0)
,mpRejectionFriend(0)
,mpRejectionNote(0)

{
	for( unsigned int i=0; i<2; i++ )
	{
		mShowHeroTotal[i] = 0;
		mShowPlayerTotal[i] = 0;
	}

	mOptionChange = false;
	mHelmetStateChange = false;
}

cOptionSheet1::~cOptionSheet1()
{
}

bool cOptionSheet1::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpShowHeroNameCard = (cCheckBox*)GetChild(eUIID_OPTION_NAMECHECK);
	mShowHeroTotal[0] = (cRadioButton*)GetChild(eUIID_OPTION_NAMEFULLCHECK);
	mShowHeroTotal[1] = (cRadioButton*)GetChild(eUIID_OPTION_NAMEONLYCHECK);

	mpShowPlayerNameCard = (cCheckBox*)GetChild(eUIID_OPTION_OTHERNAMECHECK);
	mShowPlayerTotal[0] = (cRadioButton*)GetChild(eUIID_OPTION_OTHERNAMEFULLCHECK);
	mShowPlayerTotal[1] = (cRadioButton*)GetChild(eUIID_OPTION_OTHERNAMEONLYCHECK);

	mpShowNPCNameCard = (cCheckBox*)GetChild(eUIID_OPTION_NPCNAMECHECK);
	mpShowMonsterNameCard = (cCheckBox*)GetChild(eUIID_OPTION_MONSTERNAMECHECK);
	mpShowGauge = (cCheckBox*)GetChild(eUIID_OPTION_GAUGECHECK);
	mpShowBubble = (cCheckBox*)GetChild(eUIID_OPTION_BALLOONCHECK);
	mpShowHelmet = (cCheckBox*)GetChild(eUIID_OPTION_HELMETCHECK);
	mpShowTip = (cCheckBox*)GetChild(eUIID_OPTION_TIPCHECK);

	mpRejectionTrade = (cCheckBox*)GetChild(eUIID_OPTION_TRADECHECK);
	mpRejectionDuel = (cCheckBox*)GetChild(eUIID_OPTION_DUALCHECK);
	mpRejectionWhisper = (cCheckBox*)GetChild(eUIID_OPTION_WHISPERCHECK);
	mpRejectionParty = (cCheckBox*)GetChild(eUIID_OPTION_PARTYCHECK);
	mpRejectionFriend = (cCheckBox*)GetChild(eUIID_OPTION_FRIENDCHECK);
	mpRejectionNote = (cCheckBox*)GetChild(eUIID_OPTION_NOTECHECK);

	return true;
}

void cOptionSheet1::OnShow()
{
	cUIWindow::OnShow();

	mOptionChange = false;
	mHelmetStateChange = false;
	UpdateOptionData();
}

void cOptionSheet1::UpdateOptionData()
{
	/// game option setting
	sGameOption* gameOpt = OPTIONMAN->GetGameOption();

	///
	if( mpShowHeroNameCard )
	{
		mpShowHeroNameCard->SetPress( gameOpt->option1.showHeroNameCard );

		if( mShowHeroTotal[0] && mShowHeroTotal[1] )
		{
			mShowHeroTotal[0]->SetEnabled( gameOpt->option1.showHeroNameCard );
			mShowHeroTotal[1]->SetEnabled( gameOpt->option1.showHeroNameCard );

			if( gameOpt->option1.showHeroNameCard == true )
			{
				mShowHeroTotal[0]->SetPress( gameOpt->option1.showHeroTotal, false );
				mShowHeroTotal[1]->SetPress( !gameOpt->option1.showHeroTotal, false );
			}
		}
	}

	///
	if( mpShowPlayerNameCard )
	{
		mpShowPlayerNameCard->SetPress( gameOpt->option1.showPlayerNameCard );

		if( mShowPlayerTotal[0] && mShowPlayerTotal[1] )
		{
			mShowPlayerTotal[0]->SetEnabled( gameOpt->option1.showPlayerNameCard );
			mShowPlayerTotal[1]->SetEnabled( gameOpt->option1.showPlayerNameCard );

			if( gameOpt->option1.showPlayerNameCard == true )
			{
				mShowPlayerTotal[0]->SetPress( gameOpt->option1.showPlayerTotal, false );
				mShowPlayerTotal[1]->SetPress( !gameOpt->option1.showPlayerTotal, false );
			}
		}
	}

	///
	if( mpShowNPCNameCard )
		mpShowNPCNameCard->SetPress( gameOpt->option1.showNPCNameCard );

	///
	if( mpShowMonsterNameCard )
		mpShowMonsterNameCard->SetPress( gameOpt->option1.showMonsterNameCard );

	///
	if( mpShowGauge )
		mpShowGauge->SetPress( gameOpt->option1.showGauge );

	///
	if( mpShowBubble )
		mpShowBubble->SetPress( gameOpt->option1.showBubble );

	if( mpShowHelmet )
		mpShowHelmet->SetPress( gameOpt->option1.showHelmet );

	if( mpShowTip )
		mpShowTip->SetPress( gameOpt->option1.showTip );

	///
	if( mpRejectionTrade )
		mpRejectionTrade->SetPress( gameOpt->option1.rejectionTrade );

	///
	if( mpRejectionDuel )
		mpRejectionDuel->SetPress( gameOpt->option1.rejectionDuel );

	///
	if( mpRejectionWhisper )
		mpRejectionWhisper->SetPress( gameOpt->option1.rejectionWhisper );

	///
	if( mpRejectionParty )
		mpRejectionParty->SetPress( gameOpt->option1.rejectionParty );

	///
	if( mpRejectionFriend )
		mpRejectionFriend->SetPress( gameOpt->option1.rejectionFriend );

	///
	if( mpRejectionNote )
		mpRejectionNote->SetPress( gameOpt->option1.rejectionNote );
}

void cOptionSheet1::InitOptionData()
{
	mOptionChange = false;
	mHelmetStateChange = false;

}

void cOptionSheet1::ApplyOptionData()
{
	if( mOptionChange == false )
		return;

	/// game option setting
	sGameOption* gameOpt = OPTIONMAN->GetGameOption();

	gameOpt->option1.showGauge = mpShowGauge->IsPress();
	gameOpt->option1.showBubble = mpShowBubble->IsPress();
	gameOpt->option1.showHeroNameCard = mpShowHeroNameCard->IsPress();
	gameOpt->option1.showHeroTotal = mShowHeroTotal[0]->IsPress();
	gameOpt->option1.showPlayerNameCard = mpShowPlayerNameCard->IsPress();
	gameOpt->option1.showPlayerTotal = mShowPlayerTotal[0]->IsPress();
	gameOpt->option1.showNPCNameCard = mpShowNPCNameCard->IsPress();
	gameOpt->option1.showMonsterNameCard = mpShowMonsterNameCard->IsPress();
	gameOpt->option1.showHelmet = mpShowHelmet->IsPress();
	gameOpt->option1.showTip = mpShowTip->IsPress();

	gameOpt->option1.rejectionTrade = mpRejectionTrade->IsPress();
	gameOpt->option1.rejectionDuel = mpRejectionDuel->IsPress();
	gameOpt->option1.rejectionWhisper = mpRejectionWhisper->IsPress();
	gameOpt->option1.rejectionParty = mpRejectionParty->IsPress();
	gameOpt->option1.rejectionFriend = mpRejectionFriend->IsPress();
	gameOpt->option1.rejectionNote = mpRejectionNote->IsPress();

	OPTIONMAN->ReqOptionValue();
	mOptionChange = false;

	if( mHelmetStateChange == true )
	{
		if( STAGEMAN->GetCurrentStage() == eStage_Game )
			OBJECTMAN->UpdateHelmetState();
	}
}

void cOptionSheet1::CancelOptionData()
{
	mOptionChange = false;
}


void cOptionSheet1::OnRadioPressed(cUINode* node, unsigned int id )
{
	switch( id )
	{
	case eUIID_OPTION_NAMEFULLCHECK:
	case eUIID_OPTION_NAMEONLYCHECK:
	case eUIID_OPTION_OTHERNAMEFULLCHECK:
	case eUIID_OPTION_OTHERNAMEONLYCHECK:
		mOptionChange = true;
		break;
	}
}

void cOptionSheet1::OnCheckBoxChanged(cUINode* node, unsigned int id)
{
	switch(id)
	{
	case eUIID_OPTION_NAMECHECK:
		{
			sGameOption* gameOpt = OPTIONMAN->GetGameOption();
			if( mShowHeroTotal[0] && mShowHeroTotal[1] )
			{
				if( node->IsPress() )
				{
					mShowHeroTotal[0]->SetPress( gameOpt->option1.showHeroTotal, false, true );
					mShowHeroTotal[1]->SetPress( !gameOpt->option1.showHeroTotal, false, true );
				}
				else
				{
					mShowHeroTotal[0]->SetPress( false, false, true );
					mShowHeroTotal[1]->SetPress( false, false, true );
				}

				mShowHeroTotal[0]->SetEnabled( node->IsPress() );
				mShowHeroTotal[1]->SetEnabled( node->IsPress() );
			}
			mOptionChange = true;
		}
		break;
	case eUIID_OPTION_OTHERNAMECHECK:
		{
			sGameOption* gameOpt = OPTIONMAN->GetGameOption();
			if( mShowPlayerTotal[0] && mShowPlayerTotal[1] )
			{
				if( node->IsPress() )
				{
					mShowPlayerTotal[0]->SetPress( gameOpt->option1.showPlayerTotal, false, true );
					mShowPlayerTotal[1]->SetPress( !gameOpt->option1.showPlayerTotal, false, true );
				}
				else
				{
					mShowPlayerTotal[0]->SetPress( false, false, true );
					mShowPlayerTotal[1]->SetPress( false, false, true );
				}

				mShowPlayerTotal[0]->SetEnabled( node->IsPress() );
				mShowPlayerTotal[1]->SetEnabled( node->IsPress() );
			}
			mOptionChange = true;
		}
		break;
	case eUIID_OPTION_HELMETCHECK:
		{
			mOptionChange = true;
			mHelmetStateChange = true;
		}
		break;
	case eUIID_OPTION_TIPCHECK:
	case eUIID_OPTION_NPCNAMECHECK:
	case eUIID_OPTION_MONSTERNAMECHECK:
	case eUIID_OPTION_GAUGECHECK:
	case eUIID_OPTION_BALLOONCHECK:
	case eUIID_OPTION_TRADECHECK:
	case eUIID_OPTION_DUALCHECK:
	case eUIID_OPTION_WHISPERCHECK:
	case eUIID_OPTION_PARTYCHECK:
	case eUIID_OPTION_FRIENDCHECK:
	case eUIID_OPTION_NOTECHECK:
		mOptionChange = true;
		break;
	}
}

//-----------------------------------------------------------------------
cOptionSheet2::cOptionSheet2( eUINodeType type )
: cUIWindow( type )
, mpWindowMode(0)
, mpWindowSize(0)
, mpLight(0)
, mpBackSound(0)
, mpEffSound(0)
{
	mOptionChange = false;
	mSpinMoved = false;
}

cOptionSheet2::~cOptionSheet2()
{
}

bool cOptionSheet2::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpWindowMode = (cCheckBox*)GetChild(eUIID_OPTION_WINDOWCHECK);
	mpWindowSize = (cComboBox*)GetChild(eUIID_OPTION_WINDOWSIZE);
	mpLight = (cOptionGauge*)GetChild(eUIID_OPTION_LIGHT);

	mpBackSound = (cOptionGauge*)GetChild(eUIID_OPTION_BACKSOUND);
	mpEffSound = (cOptionGauge*)GetChild(eUIID_OPTION_EFFECTSOUND);

	return true;
}

void cOptionSheet2::OnShow()
{
	cUIWindow::OnShow();
	UpdateOptionData();
}

///
void cOptionSheet2::UpdateOptionData()
{
	/// graphic & sound option setting
	mOptionChange = false;
	mSpinMoved = false;

	if( mpWindowMode )
		mpWindowMode->SetPress( OPTIONMAN->IsWindowed() );

	if( mpLight )
	{
		mDefaultRamp = OPTIONMAN->GetGammaPer();
		mpLight->SetPercent( OPTIONMAN->GetGammaPer() * 100.0f );
	}
	if( mpBackSound )
	{
		mDefaultEnvVol = OPTIONMAN->GetEnvVolume();
		mpBackSound->SetPercent( OPTIONMAN->GetEnvVolume() * 100.0f );
	}
	if( mpEffSound )
	{
		mDefaultEffVol = OPTIONMAN->GetEffVolume();
		mpEffSound->SetPercent( OPTIONMAN->GetEffVolume() *100.0f );
	}

	/// ޺ڽ 
	mpWindowSize->Clear();

	tArray<void*>* arr = RENDERSYS->GetResolutionArr();
	NiDX9AdapterDesc::ModeDesc* curMode = RENDERSYS->GetCurrentMode();
	if( arr )
	{
		TCHAR buff[256] = {0,};
		int select = -1;

		for( unsigned int i = 0; i<arr->GetSize(); i++ )
		{
			NiDX9AdapterDesc::ModeDesc* p = (NiDX9AdapterDesc::ModeDesc*)((*arr)[i]);
			if( p == 0 )
				continue;

			::_stprintf( buff, _T("%dx%dx%d"), p->m_uiWidth, p->m_uiHeight, p->m_uiBPP );
			mpWindowSize->AddItem( buff, p );

			if( curMode == (NiDX9AdapterDesc::ModeDesc*)((*arr)[i]) )
				select = (int)i;
		}

		if( select != -1 )
			mpWindowSize->SetSelect( select );
	}
}

void cOptionSheet2::InitOptionData()
{
	mOptionChange = false;
	mSpinMoved = false;

	if( mpWindowMode )
		mpWindowMode->SetPress( OPTIONMAN->IsWindowed() );

	OPTIONMAN->SetGammaPer( mDefaultRamp );
	OPTIONMAN->SetVolume( mDefaultEnvVol, mDefaultEffVol );

	if( mpLight )
		mpLight->SetPercent( mDefaultRamp * 100.0f );

	if( mpBackSound )
		mpBackSound->SetPercent( mDefaultEnvVol * 100.0f );

	if( mpEffSound )
		mpEffSound->SetPercent( mDefaultEffVol * 100.0f );

	/// ޺ڽ 
	mpWindowSize->Clear();

	tArray<void*>* arr = RENDERSYS->GetResolutionArr();
	NiDX9AdapterDesc::ModeDesc* curMode = RENDERSYS->GetCurrentMode();
	if( arr )
	{
		TCHAR buff[256] = {0,};
		int select = -1;

		for( unsigned int i = 0; i<arr->GetSize(); i++ )
		{
			NiDX9AdapterDesc::ModeDesc* p = (NiDX9AdapterDesc::ModeDesc*)((*arr)[i]);
			if( p == 0 )
				continue;

			::_stprintf( buff, _T("%dx%dx%d"), p->m_uiWidth, p->m_uiHeight, p->m_uiBPP );
			mpWindowSize->AddItem( (LPCTSTR)buff, p );

			if( curMode == (NiDX9AdapterDesc::ModeDesc*)((*arr)[i]) )
				select = (int)i;
		}

		if( select != -1 )
			mpWindowSize->SetSelect( select );
		else
			mpWindowSize->SetSelect( 0 );
	}
}

void cOptionSheet2::ApplyOptionData()
{
	if( mOptionChange == false )
		return;

	NiDX9AdapterDesc::ModeDesc* curMode = (NiDX9AdapterDesc::ModeDesc*)mpWindowSize->GetSelectData();
	if( curMode == 0 )
	{
		assert(0);
		return;
	}

	OPTIONMAN->SetWindowedOption( mpWindowMode->IsPress(), curMode->m_uiWidth, curMode->m_uiHeight, curMode->m_uiBPP );

	if( mSpinMoved == true )
	{
		OPTIONMAN->SetGammaPer( (float)mpLight->GetPercent()*0.01f );
		OPTIONMAN->SetVolume( (float)mpBackSound->GetPercent()*0.01f, (float)mpEffSound->GetPercent()*0.01f );

		mSpinMoved = false;
	}

	mOptionChange = false;
}

void cOptionSheet2::CancelOptionData()
{
	if( mSpinMoved )
	{
		OPTIONMAN->SetGammaPer( mDefaultRamp );
		OPTIONMAN->SetVolume( mDefaultEnvVol, mDefaultEffVol );
	}

	mOptionChange = false;
	mSpinMoved = false;
}


void cOptionSheet2::OnComboSelected( cUINode* caller, unsigned int id )
{
	mOptionChange = true;
}

void cOptionSheet2::OnCheckBoxChanged(cUINode*, unsigned int id)
{
	mOptionChange = true;

	switch( id )
	{
	case eUIID_OPTION_WINDOWCHECK:
		{
			UpdateResolutionComboData();
		}
		break;
	}
}

void cOptionSheet2::OnOptiongaugeUpdate( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_OPTION_LIGHT:
		{
			///  
			OPTIONMAN->SetGammaPer( (float)mpLight->GetPercent()*0.01f );
		}
		break;
	case eUIID_OPTION_BACKSOUND:
		{
			///  
			OPTIONMAN->SetVolume( (float)mpBackSound->GetPercent()*0.01f, (float)mpEffSound->GetPercent()*0.01f );
		}
		break;
	case eUIID_OPTION_EFFECTSOUND:
		{
			/// ȿ 
			OPTIONMAN->SetVolume( (float)mpBackSound->GetPercent()*0.01f, (float)mpEffSound->GetPercent()*0.01f );
		}
		break;
	}

	mSpinMoved = true;
	mOptionChange = true;
}

void cOptionSheet2::UpdateResolutionComboData()
{
	NiDX9AdapterDesc* adapter = RENDERSYS->GetCurrentAdapter();
	if( adapter == 0 )
		return;

	NiDX9AdapterDesc::ModeDesc* curMode = (NiDX9AdapterDesc::ModeDesc*)mpWindowSize->GetSelectData();

	mpWindowSize->Clear();

	tArray<void*> arr;
	arr.Clear();

	unsigned int modeCount = adapter->GetModeCount();

	for( unsigned int i=0; i<modeCount; i++ )
	{
		const NiDX9AdapterDesc::ModeDesc* pMode = adapter->GetMode( i );

		if( pMode == 0 )
			continue;

		/// ߰ ʿ  ܽŲ.
		if( pMode->m_uiWidth <= 800 )
			continue;
		if( pMode->m_uiHeight <= 600 )
			continue;

		/// 迭  
		arr.PushBack( (void*)pMode );
	}
	::Sort( arr.Begin(), arr.End(), cResolutionCompare() );


	/// ޺ ä
	TCHAR buff[256] = {0,};
	int select = -1;

	for( unsigned int i = 0; i<arr.GetSize(); i++ )
	{
		NiDX9AdapterDesc::ModeDesc* p = (NiDX9AdapterDesc::ModeDesc*)arr[i];
		if( p == 0 )
			continue;

		::_stprintf( buff, _T("%dx%dx%d"), p->m_uiWidth, p->m_uiHeight, p->m_uiBPP );
		mpWindowSize->AddItem( (LPCTSTR)buff, p );

		if( curMode == (NiDX9AdapterDesc::ModeDesc*)arr[i] )
			select = (int)i;
	}

	if( select != -1 )
		mpWindowSize->SetSelect( select );
	else
		mpWindowSize->SetSelect( 0 );
}
