/* ==========================================================================
*    : 谡
*    : 2008.09.05
*      : 
* ǻ : 
*===========================================================================*/
#pragma once
#include "PVP_Common.h"

class cPlayer;

enum eBattleState
{
	eBattleState_Enable,
	eBattleState_Ready,
	eBattleState_Fight,
	eBattleState_Result,

	eBattleState_None,
};

struct sMyTeamInfo
{
	unsigned long	mPlayerIdx;
	TCHAR			mName[MAX_NAME_BUFFER_SIZE];
	unsigned char	mForceType;
	unsigned long	mKillCnt;
	unsigned long	mDeathCnt;

	unsigned long	mScoreResult;
};

class cPVPManager
{
public:
	static cPVPManager* mpSingleton;

public:
	cPVPManager();
	~cPVPManager();

	bool Init();

	void Open();
	void Close();

	void Exit();

	void Process( unsigned long deltaTime, unsigned long accumTime );

	bool IsEnableAttack( cPlayer* player );
	bool IsMyTeam( cPlayer* player );

	inline bool IsEnableBattle() { return (mBattleState != eBattleState_None); }
	inline void SetEnableBattle( bool set ) { mBattleState = (set)? eBattleState_Enable:eBattleState_None; }

	/// Ʈũ ޽
	void NetworkMsgParser( char* pMsg );

	inline unsigned char GetMinLevel() { return mMinLevel; }
	inline unsigned char GetMaxLevel() { return mMaxLevel; }

	void LinkPvpForceEffect( cPlayer* player, unsigned char forceType );

	void SetDoor1( unsigned long nodeIdx ) { mStaticDoor1 = nodeIdx; }
	void SetDoor2( unsigned long nodeIdx ) { mStaticDoor2 = nodeIdx; }

public:
	static cPVPManager* GetSingleton();

	void AddTeamPlayerInfo( sMsgMemberInfo* memberInfo );
	void UpdateTeamPlayerInfo( unsigned long playerIdx, unsigned long value, bool kill );
	void DelTeamPlayerInfo( unsigned long playerIdx );

	void OpenRank( bool update );
	void OpenResult( MSG_SYN_PVP_DM_FIGHTEND* pmsg, bool win );

protected:
	eBattleState mBattleState;
	unsigned char mMinLevel;
	unsigned char mMaxLevel;
	unsigned long mFightLeftTime;

	unsigned long mReadyPrintTime;

	unsigned long	mStaticDoor1;
	unsigned long	mStaticDoor2;

	bool mUpdateRankInfo;
	typedef tPointerHashMap<unsigned long, void*> cMyTeamInfoMap;
	cMyTeamInfoMap  mTeamInfoMap;

	unsigned long mLeaderIdx;
};

inline cPVPManager* cPVPManager::GetSingleton()
{
	return mpSingleton;
}

#define PVPMAN cPVPManager::GetSingleton()