/* ==========================================================================
*      : Page.h
*      : 
*    : 谡
*    : 2008-01-24
* ǻ :
*===========================================================================*/
#pragma once

///    ̺Ʈ
enum eAnswerEvent
{
	eEVENT_NONE = 0,
	eEVENT_YES,
	eEVENT_REWARD,
	eEVENT_COMPLETE,
};

/// ⺻  ü
struct sPageText
{
	/// ؽƮ ε, ؽƮ ټ
	unsigned int textIndex;
	unsigned int numLine;

	sPageText::sPageText()
	{
		textIndex = 0;
		numLine = 0;
	}
};

///  ä
struct sPageAnswer : sPageText
{
	///  ε
	unsigned int nextPageIndex;

	sPageAnswer::sPageAnswer()
	{
		nextPageIndex = 0;
	}
};

///  ̹ ü
struct sSceneData
{
public:
	cString	 mTexName;

	/// ؽó
//	NiTexture* mpTexture;
	
	/// ؽó ġ ǥ
	unsigned int mTexPosX;
	unsigned int mTexPosY;
	
	/// ؽó 
	unsigned int mTexWidth;
	unsigned int mTexHeight;
};

///  
class cPage
{
	friend class cUINpcTelling;

public:
	cPage();
	~cPage();

	unsigned long GetNextPageIdx() { return mNextPageIndex; }
	unsigned long GetSceneIdx() { return mSceneIndex; }
	eAnswerEvent GetAnswerEvent() { return mAnswerType; }

	sPageText* GetPageText() { return (sPageText*)mDefaultTextArray[0]; }
	tArray<void*>& GetAnswerArr() { return mAnswerArr; }

private:
	/// ⺻迭 sPageText
	typedef tArray<void*> cTextArray;
	cTextArray mDefaultTextArray;

	///  迭 sPageAnswer
	typedef tArray<void*> cAnswerArr;
	cAnswerArr mAnswerArr;

	///   ( б  ƴϸ 밡 )
	///    
	unsigned long mNextPageIndex;

	/// ȭ 
	eAnswerEvent mAnswerType;

	/// ε
	unsigned long mSceneIndex;

	///  ε
	/// unsigned long mSoundIndex;
};

inline
cPage::cPage()
: mNextPageIndex(0)
, mAnswerType( eEVENT_NONE )
, mSceneIndex(0)
{
//	mDefaultTextArray.Reserve( 10 );
//	mAnswerArr.Reserve( 10 );
}

inline
cPage::~cPage()
{
	/// ⺻迭 
	for( unsigned int i = 0; i < mDefaultTextArray.GetSize(); ++i )
	{
		sPageText* pageText = (sPageText*)mDefaultTextArray[i];
		SAFE_DELETE( pageText );
	}
	mDefaultTextArray.Clear();

	/// б迭 
	for( unsigned int i = 0; i < mAnswerArr.GetSize(); ++i )
	{
		sPageAnswer* pageAns = (sPageAnswer*)mAnswerArr[i];
		SAFE_DELETE( pageAns );
	}
	mAnswerArr.Clear();
}