#include "stdafx.h"
#include "PartyManager.h"
#include "Protocol.h"
#include "UIMsgboxEvent.h"
#include "ChatManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "GameUIManager.h"
#include "PartyWindow.h"
#include "PartyStateWindow.h"
#include "SmallMiniMapWindow.h"
#include "MiniMapWindow.h"
#include "SkillScript.h"
#include "Application.h"
#include "SkillObject.h"

#include "ItemManager.h"

cPartyManager* cPartyManager::mpSingleton = 0;

cPartyManager::cPartyManager()
: mCount(0)
, mPartyIndex(0)
, mPartyLevel(0)
, mLeaderIndex(0)
, mDivideType(PARTY_DIVIDE_NONE)
, mSelectDataIndex(-1)
, mLastAccumTime(0)
, mHPMPAccumTime(0)
, mBuffAccumTime(0)
{
	assert( mpSingleton == 0 && "bad singleton!" );
	mpSingleton = this;

	for( int i = 0; i < PARTY_NUM; ++i )
		mParty[i] = 0;
}

cPartyManager::~cPartyManager()
{

}

bool cPartyManager::Init()
{
	return true;
}

/// ü 
void cPartyManager::Close()
{
	for( int i = 0; i < PARTY_NUM; ++i )
		mParty[i] = 0;

	mCount = 0;
	mPartyIndex = 0;
	mPartyLevel = 0;
	mLeaderIndex = 0;
	mDivideType = PARTY_DIVIDE_NONE;
	mSelectDataIndex = -1;

	/// ̴ϸκ 
	cSmallMiniMapWindow* minimap = GAMEUI->GetSmallMinimapWindow();
	cMiniMapWindow* pWide = GAMEUI->GetMinimapWindow();
	if( minimap && pWide )
	{
		minimap->ClearParty();
		pWide->ClearParty();
	}
}

void cPartyManager::Process( unsigned long accumTime )
{
	if( mCount == 0 )
		return;

	typedef tPointerHashMap<unsigned long, void*> cHashMap;

	///  Žð
	if( accumTime - mHPMPAccumTime > PARTY_HPMPUPDATE )
	{
		/// HP, MP 
		for( int i = 0; i < mCount; ++i )
		{
			// ش ϸ 
			cPlayer* user = OBJECTMAN->GetPlayer( mParty[i].mIndex );
			if( user )
			{
				UpdatePartyHP( i, user->GetHP(), user->GetMaxHP() );
				UpdatePartyMP( i, user->GetMP(), user->GetMaxMP() );
			}
		}

		mHPMPAccumTime = accumTime;
	}

	if( accumTime - mBuffAccumTime > PARTY_BUFFUPDATE )
	{
		///  
		for( int i = 0; i < mCount; ++i )
		{
			// ش ϸ 
			cPlayer* user = OBJECTMAN->GetPlayer( mParty[i].mIndex );
			if( user )
			{
				UpdateBuffList( i );
			}
		}

		mBuffAccumTime = accumTime;
	}
	
	if( accumTime - mLastAccumTime > PARTY_UPDATETIME )
	{
		UpdateMinimap();
		mLastAccumTime = accumTime;
	}
}

/// Ƽ UI 
void cPartyManager::ShowPartyUI()
{
	/// ǥ 
	UpdateStateUI();

	/// ̱
	cUIWindow* partywin = GAMEUI->GetPartyWindow();
	if( partywin )
		partywin->ShowTop();

	cUIWindow* stateWindow = 0;
	for( int i = 0; i < PARTY_NUM; ++i )
	{
		if( mParty[i].mUIIndex == -1 )
			continue;

		stateWindow = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
		if( stateWindow )
		{
			if( i < mCount )
				stateWindow->ShowTop();
			else
				stateWindow->Hide( false );
		}
	}
}

/// Ƽ UI ݱ
void cPartyManager::HidePartyUI()
{
	cUIWindow* partywin = GAMEUI->GetPartyWindow();
	if( partywin )
		partywin->Hide( false );

	cUIWindow* stateWindow = 0;
	for( int i = 0; i < PARTY_NUM; ++i )
	{
		stateWindow = GAMEUI->GetPartyStateWindow( i );
		if( stateWindow )
			stateWindow->Hide( false );
	}
}

/// Ƽ 
bool cPartyManager::CreateParty( MSG_SYN_PARTY_LIST* msgData )
{
	mPartyIndex = msgData->mIndex;
	mPartyLevel = msgData->mLevel;
	mDivideType = msgData->mDivideType;
	mLeaderIndex = msgData->mLeaderIndex;

	if( mPartyIndex <= 0 )
	{
		assert( 0 && "not create party" );
		return false;
	}

	cSmallMiniMapWindow* minimap = GAMEUI->GetSmallMinimapWindow();
	cMiniMapWindow* pWide = GAMEUI->GetMinimapWindow();

	/// Ƽ  
	for( int i = 0; i < msgData->RowCount; ++i )
	{
		mParty[i].mIndex	= msgData->party[i].UserIndex;
		mParty[i].mName		= msgData->party[i].Name;
		mParty[i].mUIIndex  = i;

		mParty[i].mLevel	= msgData->party[i].Level;
		mParty[i].mJob		= msgData->party[i].Job;
		mParty[i].mMapNum	= msgData->party[i].MapNum;	
		mParty[i].mInitX	= msgData->party[i].InitX;
		mParty[i].mInitY	= msgData->party[i].InitY;
		mParty[i].mHP		= msgData->party[i].HP;
		mParty[i].mMaxHP	= msgData->party[i].MaxHP;
		mParty[i].mMP		= msgData->party[i].MP;
		mParty[i].mMaxMP	= msgData->party[i].MaxMP;
	
		if( minimap && pWide && HERO->GetObjectID() != mParty[i].mIndex )
		{
			minimap->AddPartyUser( &mParty[i] );
			pWide->AddPartyUser( &mParty[i] );
		}
	}

	mCount = msgData->RowCount;

	/// UI  
	CreatePartyUI();
	return true;
}

/// Ƽ  UI  
void cPartyManager::CreatePartyUI()
{
	/// Ƽ  
	cPartyStateWindow* stateWindow = 0;
	for( int i = 0; i < mCount; ++i )
	{
		if( mParty[i].mIndex > 0 && mParty[i].mUIIndex > -1 )
		{
			/// UI   
			stateWindow = GAMEUI->GetPartyStateWindow( i );
			if( stateWindow )
			{
				stateWindow->SetUserIndex( mParty[i].mIndex );
				stateWindow->SetLevel( mParty[i].mLevel );
				stateWindow->SetJob( mParty[i].mJob );
				stateWindow->SetMaxHP( mParty[i].mMaxHP );
				stateWindow->SetHPGauge( mParty[i].mHP );
				stateWindow->SetMaxMP( mParty[i].mMaxMP );
				stateWindow->SetMPGauge( mParty[i].mMP );
				stateWindow->SetMapNum( mParty[i].mMapNum );
				stateWindow->LinkPartyIndex( i );

				eText_Color color = eCOLOR_WHITE;
				int mapnum = HERO->GetMapNum();
				if( mapnum == mParty[i].mMapNum )
				{
					///  ΰ
					color = eCOLOR_WHITE;
					stateWindow->ShowData( true );

					///   
					UpdateBuffList( i );
				}
				else
				{
					/// ƴѰ
					color = eCOLOR_DARKGRAY;
					stateWindow->ShowData( false );
				}

				stateWindow->SetName( (LPCTSTR)mParty[i].mName.Cstr(), color );
		
				/// NPC ȭ̸ Ƽ츦  ʴ´
				if( UIMAN->IsShowNpcBack() == false && GAMEUI->IsDuelMode() == false )
					stateWindow->ShowTop();
			}
		}
		else
		{
			assert(0);
		}
	}

	/// Ƽ 
	cPartyWindow* pPartyWindow = GAMEUI->GetPartyWindow();
	if( pPartyWindow )
	{
		/// ڱڽ 
		if( mLeaderIndex == HERO->GetObjectID() )
		{
			pPartyWindow->SetLeader( true );
		}
		/// ٸ  
		else
		{
			pPartyWindow->SetLeader( false );

			int i = FindUser( mLeaderIndex );
			if( i > -1 && mParty[i].mUIIndex > -1 )
			{
				cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
				if( state )
					state->SetLeader( true );
			}
			else
			{
				assert(0);
			}
		}

		pPartyWindow->SetDivideType( mDivideType );

		if( UIMAN->IsShowNpcBack() == false && GAMEUI->IsDuelMode() == false )
			pPartyWindow->ShowTop();
	}

	/// Ƽ ü   
	unsigned long userIdx =	( mParty[0].mIndex != HERO->GetObjectID() ) ? mParty[0].mIndex : mParty[1].mIndex;
	ChangeTarget( userIdx );
}

/// Ƽ ߰
void cPartyManager::AddUser( MSG_SYN_PARTY_ADDONE* msgData )
{
	///   ߰Ǹ鼭, Ƽ ְ 缼
	mPartyLevel = msgData->mPartyLevel;

	///  ߰
	if( mCount < PARTY_NUM )
	{
		int i = FindEmptyUI();
		if( i == -1 )
		{
			assert(0);
			return;
		}

		mParty[mCount].mIndex	= msgData->UserIndex;
		mParty[mCount].mName	= msgData->Name;
		mParty[mCount].mLevel	= msgData->Level;
		mParty[mCount].mJob		= msgData->Job;
		mParty[mCount].mHP		= msgData->HP;
		mParty[mCount].mMaxHP	= msgData->MaxHP;
		mParty[mCount].mMP		= msgData->MP;
		mParty[mCount].mMaxMP	= msgData->MaxMP;
		mParty[mCount].mMapNum	= msgData->MapNum;
		mParty[mCount].mInitX	= msgData->InitX;
		mParty[mCount].mInitY	= msgData->InitY;
		mParty[mCount].mUIIndex = i;

		cSmallMiniMapWindow* minimap = GAMEUI->GetSmallMinimapWindow();
		cMiniMapWindow* pWide = GAMEUI->GetMinimapWindow();
		if( minimap && pWide )
		{
			if( HERO->GetObjectID() != mParty[mCount].mIndex )
			{
				minimap->AddPartyUser( &mParty[mCount] );
				pWide->AddPartyUser( &mParty[mCount] );

				cPlayer* p = OBJECTMAN->GetPlayer( mParty[mCount].mIndex );
				if( p )
					p->PartyIn_Init();
			}
		}

		/// ߰ UI 
		cPartyStateWindow* stateWindow = GAMEUI->GetPartyStateWindow( mParty[mCount].mUIIndex );
		if( stateWindow )
		{
			stateWindow->SetUserIndex( mParty[mCount].mIndex );
			stateWindow->SetLevel( mParty[mCount].mLevel );
			stateWindow->SetJob( mParty[mCount].mJob );
			stateWindow->SetMaxHP( mParty[mCount].mMaxHP );
			stateWindow->SetHPGauge( mParty[mCount].mHP );
			stateWindow->SetMaxMP( mParty[mCount].mMaxMP );
			stateWindow->SetMPGauge( mParty[mCount].mMP );
			stateWindow->SetMapNum( mParty[mCount].mMapNum );
			stateWindow->LinkPartyIndex( mCount );

			eText_Color color = eCOLOR_WHITE;
			if( HERO->GetMapNum() == mParty[mCount].mMapNum )
			{
				///  ΰ
				color = eCOLOR_WHITE;
				stateWindow->ShowData( true );

				///   
				UpdateBuffList( mCount );
			}
			else
			{
				/// ƴѰ
				color = eCOLOR_DARKGRAY;
				stateWindow->ShowData( false );
			}

			stateWindow->SetName( (LPCTSTR)mParty[mCount].mName.Cstr(), color );

			/// NPC â   SHOW  
			if( UIMAN->IsShowNpcBack() == false && GAMEUI->IsDuelMode() == false )
				stateWindow->ShowTop();
		}
		else
		{
			assert(0);
		}

		mCount++;
	}
}

///    Ʈ ޾Ƽ 
void cPartyManager::UpdateBuffList( unsigned long index )
{
	if( mParty[index].mUIIndex > -1 )
	{
		cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[index].mUIIndex );

		typedef tPointerHashMap<unsigned long, void*>	cInfluenceMap;
		cPlayer* player = OBJECTMAN->GetPlayer( mParty[index].mIndex );
		if( player && state )
		{
			state->ClearBuff();

			cInfluenceMap* buffMap = player->GetBufMap();
			cInfluenceMap* debuffMap = player->GetDeBufMap();
			if( buffMap )
			{
				///   
				cInfluenceMap::cIterator i = buffMap->Begin();
				cInfluenceMap::cIterator end = buffMap->End();
				for( ; i != end; ++i )
				{
					unsigned long uniqueIndex = (unsigned long)(i->mFirst);
					cInfluenceObject* p = (cInfluenceObject*)(i->mSecond);
					if( p )
						state->AddBuff( uniqueIndex, p->GetInfluenceIdx() );
				}
			}

			if( debuffMap )
			{
				///   
				cInfluenceMap::cIterator i = debuffMap->Begin();
				cInfluenceMap::cIterator end = debuffMap->End();
				for( ; i != end; ++i )
				{
					unsigned long uniqueIndex = (unsigned long)(i->mFirst);
					cInfluenceObject* p = (cInfluenceObject*)(i->mSecond);
					if( p )
						state->AddBuff( uniqueIndex, p->GetInfluenceIdx() );
				}
			}	
		}
	}
}

/// Ƽ 
void cPartyManager::DeleteParty()
{
	/// Ƽ޴ UI ʱȭ
	cPartyWindow* partyWin = GAMEUI->GetPartyWindow();
	if( partyWin )
	{
		partyWin->Hide();
		partyWin->Clear();
	}

	/// Ƽ  ʱȭ  Ƽ UI ʱȭ 
	cPartyStateWindow* stateWindow = 0;
	for( int i = 0; i < PARTY_NUM; ++i )
	{
		cPlayer* p = 0;

		///  ʱȭ
		if( mParty[i].mIndex > 0 )
			p = OBJECTMAN->GetPlayer( mParty[i].mIndex );
		
		/// UI ʱȭ
		stateWindow = GAMEUI->GetPartyStateWindow( i );
		if( stateWindow )
		{
			stateWindow->Hide();
			stateWindow->Clear();
		}

		mParty[i] = 0;

		if( p )
			p->PartyOut_Init();
	}

	mPartyIndex = 0;
	mCount = 0;
	mPartyLevel = 0;
	mLeaderIndex = 0;
	mDivideType = PARTY_DIVIDE_NONE;

	/// ̴ϸκ 
	cSmallMiniMapWindow* minimap = GAMEUI->GetSmallMinimapWindow();
	cMiniMapWindow* pWide = GAMEUI->GetMinimapWindow();
	if( minimap && pWide )
	{
		minimap->ClearParty();
		pWide->ClearParty();
	}
}

void cPartyManager::DeleteUser( int arrIdx )
{
	if( arrIdx < PARTY_NUM )
	{
		/// ̴ϸκ 
		cSmallMiniMapWindow* minimap = GAMEUI->GetSmallMinimapWindow();
		cMiniMapWindow* pWide = GAMEUI->GetMinimapWindow();
		if( minimap && pWide )
		{
			minimap->RemovePartyUser( mParty[arrIdx].mIndex );
			pWide->RemovePartyUser( mParty[arrIdx].mIndex );
		}

		cPlayer* p = OBJECTMAN->GetPlayer( mParty[arrIdx].mIndex );

		/// UI ʱȭ  ݱ
		cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[arrIdx].mUIIndex );
		if( state )
		{
			state->Hide();
			state->Clear();
		}

		///  
		mCount--;
		for( int i = arrIdx; i < mCount; ++i )
			mParty[i] = mParty[i+1];

		mParty[mCount] = 0;

		if( p )
			p->PartyOut_Init();
		
		/// UI ġ 
		UpdateStateUI();
	}
	else
	{
		assert(0);
	}
}

/// Ƽ  ġ 
void cPartyManager::UpdateStateUI()
{
	for( int i = 0; i < mCount; i++ )
	{
		if( mParty[i].mIndex == 0 )
			break;

		///  Ƽ   ġ 
		cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
		if( state )
			state->LinkPartyIndex( i );
	}
}

/// Ƽ 
void cPartyManager::ChangeLeader()
{
	/// 켱  ʱȭ
	cPartyStateWindow* state = 0;
	for( int i = 0; i < PARTY_NUM; i++ )
	{
		state = GAMEUI->GetPartyStateWindow( i );
		if( state )
			state->SetLeader( false );
	}

	cPartyWindow* pPartyWindow = GAMEUI->GetPartyWindow();
	if( pPartyWindow )
	{
		/// ڱڽ 
		if( mLeaderIndex == HERO->GetObjectID() )
		{
			pPartyWindow->SetLeader( true );
		}
		else
		{
			pPartyWindow->SetLeader( false );

			/// ٸ  
			int i = FindUser( mLeaderIndex );
			if( i > -1 && mParty[i].mUIIndex > -1 )
			{
				cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
				if( state )
					state->SetLeader( true );
			}
			else
			{
				assert(0);
			}
		}
	}
}

/// Ÿ  - Ƽ쵵  
void cPartyManager::ChangeTarget( unsigned long userIdx )
{
	/// Ƽ  
	if( mCount <= 0 )
		return;

	if( userIdx == 0 || userIdx == HERO->GetObjectID() )
		return;

	int i = FindUser( userIdx );
	if( i > -1 )
		UpdateTarget( i );
}

void cPartyManager::ChangeTabTarget( unsigned long userIdx )
{
	if( mCount <= 0 )
		return;

	int i = FindUser( userIdx );

	/// (Not party user)?
	if( i < 0 )
	{
		HERO->SetTargetObject( eOBJECTTYPE_PLAYER, mParty[0].mIndex);
	}
	else
	{
		/// (last party user)?
		if( i+1 >= mCount )
		{
			HERO->SetTargetObject( eOBJECTTYPE_PLAYER, mParty[0].mIndex);
		}

		/// next party user
		HERO->SetTargetObject( eOBJECTTYPE_PLAYER, mParty[i+1].mIndex);
	}
}

/// Ƽ   ( Ƽ ε )
void cPartyManager::UpdateTarget( int index )
{
	GAMEUI->ShowGameUI();

	///  ͸ 
	if( index >= mCount )
		return;

	if( mParty[index].mUIIndex == -1 )
	{
		assert(0);
		return;
	}

	///  Ÿ 
	cPartyStateWindow* pState = 0;
	unsigned long color = eCOLOR_WHITE;
	for( int i = 0; i < PARTY_NUM; ++i )
	{
		pState = GAMEUI->GetPartyStateWindow( i );
		if( pState )
		{
			color = ( mParty[index].mMapNum == HERO->GetObjectID() ) ? eCOLOR_WHITE : eCOLOR_DARKGRAY;
			pState->ReleaseTarget( color );
		}
	}

	/// Ÿٵ  
	cPartyWindow* pPartyWindow = GAMEUI->GetPartyWindow();
	cPartyStateWindow* pTargetState = GAMEUI->GetPartyStateWindow( mParty[index].mUIIndex );
	if( pPartyWindow && pTargetState )
	{
		pPartyWindow->ChangeTarget( pTargetState );
		pTargetState->SetTarget();
	}		

	/// ð
	mSelectDataIndex = index;
}

/// Ƽ   ui ã
int cPartyManager::FindEmptyUI()
{
	cPartyStateWindow* state = 0;
	for( int i = 0; i < PARTY_NUM; ++i )
	{
		state = GAMEUI->GetPartyStateWindow(i);
		if( state && state->GetLinkPartyIndex() == -1 )
			return i;
	}
	return -1;
}

LPCTSTR cPartyManager::GetUserName( unsigned long userIdx )
{
	int i = FindUser( userIdx );
	return ( i == -1 ) ? 0 : (LPCTSTR)mParty[i].mName.Cstr();
}

LPCTSTR cPartyManager::GetSelectName()
{
	if( mSelectDataIndex == -1 )
	{
		assert(0);
		return 0;
	}

	return (LPCTSTR)mParty[mSelectDataIndex].mName.Cstr();
}

///
void cPartyManager::RequestPartyAdd( LPCTSTR targetName )
{
	/// Ƽ ϶ ڽ Ƽ̾ 
	if( HERO->GetPartyIndex() > 0 )
	{
		if( mLeaderIndex != HERO->GetObjectID() )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 110 ) );
			return;
		}
	}

	/// ڱڽ ʴҰ
	if( ::_tcscmp( targetName, HERO->GetName() ) == 0 )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 142 ) );
		return;
	}

	mTempTargetName = targetName;

	///
	MSG_REQ_PARTY_ADD msg;
	::memset( &msg, 0, sizeof(msg) );
	msg.Category = NM_PARTY;
	msg.Protocol = NM_PARTY_ADD_REQ;
	Sstrncpy( msg.Name, MAX_NAME_BUFFER_SIZE, targetName, MAX_NAME_SIZE );
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// Ƽ  UI  
	GAMEUI->NetLockParty( eLOCK_PARTYADD );
}

void cPartyManager::RequestPartyOut()
{
	/// Ƽ ƴϸ r Ұ
	if( HERO->GetPartyIndex() == 0 )
		return;

	MSG_REQ_PARTY_OUT msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_PARTY;
	msg.Protocol = NM_PARTY_OUT_REQ;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// Ƽ  UI  
	GAMEUI->NetLockParty( eLOCK_PARTYOUT );
}

void cPartyManager::RequestChangeDivide( PARTY_DIVIDE_TYPE type )
{
	/// Ƽ˻
	if( HERO->GetPartyIndex() == 0 )
		return;

	/// Ƽ ˻
	if( mLeaderIndex != HERO->GetObjectID() )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 122 ) );
		return;
	}

	if( type == mDivideType )
		return;

	if( type == PARTY_DIVIDE_NONE )
	{
		assert(0);
		return;
	}

	MSG_REQ_PARTY_CHANGEDIVIDE msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_PARTY;
	msg.Protocol = NM_PARTY_CHANGEDIVIDE_REQ;
	msg.type = type;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// Ƽ  UI  
	GAMEUI->NetLockParty( eLOCK_PARTYCHANGEDIVIDE );
}

///
void cPartyManager::RequestChangeLeader()
{
	/// Ƽ˻
	if( HERO->GetPartyIndex() == 0 )
		return;

	/// Ƽ ˻
	if( mLeaderIndex != HERO->GetObjectID() )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 122 ) );
		return;
	}

	if( mSelectDataIndex == -1 )
	{
		assert(0);
		return;
	}

	if( mParty[mSelectDataIndex].mIndex == 0 )
	{
		assert(0);
		return;
	}

	///
	if( mParty[mSelectDataIndex].mIndex == HERO->GetObjectID() )
		return;

	if( mParty[mSelectDataIndex].mIndex != 0 )
	{
		MSG_REQ_PARTY_CHANGELEADER msg;
		::memset( &msg, 0, sizeof( msg ) );

		msg.Category = NM_PARTY;
		msg.Protocol = NM_PARTY_CHANGELEADER_REQ;
		msg.UserIndex = mParty[mSelectDataIndex].mIndex;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		/// Ƽ  UI  
		GAMEUI->NetLockParty( eLOCK_PARTYCHANGELEADER );
	}
	else
	{
		/// Ÿ  Ÿ  û
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 121 ) );
	}
}

void cPartyManager::RequestChangeLeader( unsigned long playerIdx )
{
	/// Ƽ˻
	if( HERO->GetPartyIndex() == 0 )
		return;

	/// Ƽ ˻
	if( mLeaderIndex != HERO->GetObjectID() )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 122 ) );
		return;
	}

	for( int i = 0; i < mCount; ++i )
	{
		if( mParty[i].mIndex == HERO->GetObjectID() )
			continue;

		if( mParty[i].mIndex == playerIdx )
		{
			MSG_REQ_PARTY_CHANGELEADER msg;
			::memset( &msg, 0, sizeof( msg ) );

			msg.Category = NM_PARTY;
			msg.Protocol = NM_PARTY_CHANGELEADER_REQ;
			msg.UserIndex = mParty[i].mIndex;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			/// Ƽ  UI  
			GAMEUI->NetLockParty( eLOCK_PARTYCHANGELEADER );
			break;
		}
	}
}


void cPartyManager::RequestThrow()
{
	/// Ƽ˻
	if( HERO->GetPartyIndex() == 0 )
		return;

	/// Ƽ ˻
	if( mLeaderIndex != HERO->GetObjectID() )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 122 ) );
		return;
	}

	if( mSelectDataIndex == -1 )
	{
		assert(0);
		return;
	}

	if( mParty[mSelectDataIndex].mIndex == 0 )
	{
		assert(0);
		return;
	}

	/// ڱڽ ߹Ҽ 
	if( mParty[mSelectDataIndex].mIndex == HERO->GetObjectID() )
		return;

	MSG_REQ_PARTY_THROW msg;
	::memset( &msg, 0, sizeof( msg ) );
	msg.Category = NM_PARTY;
	msg.Protocol = NM_PARTY_THROW_REQ;
	msg.UserIndex = mParty[mSelectDataIndex].mIndex;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// Ƽ  UI  
	GAMEUI->NetLockParty( eLOCK_PARTYTHROW );
}

void cPartyManager::RequestThrow( unsigned long playerIdx )
{
	/// Ƽ˻
	if( HERO->GetPartyIndex() == 0 )
		return;

	/// Ƽ ˻
	if( mLeaderIndex != HERO->GetObjectID() )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 122 ) );
		return;
	}

	for( int i = 0; i < mCount; ++i )
	{
		if( mParty[i].mIndex == HERO->GetObjectID() )
			continue;

		if( mParty[i].mIndex == playerIdx )
		{
			MSG_REQ_PARTY_THROW msg;
			::memset( &msg, 0, sizeof( msg ) );
			msg.Category = NM_PARTY;
			msg.Protocol = NM_PARTY_THROW_REQ;
			msg.UserIndex = mParty[i].mIndex;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			/// Ƽ  UI  
			GAMEUI->NetLockParty( eLOCK_PARTYTHROW );
			break;
		}
	}
}


///    
void cPartyManager::UpdateMinimap()
{
	cSmallMiniMapWindow* minimap = GAMEUI->GetSmallMinimapWindow();
	cMiniMapWindow* pWide = GAMEUI->GetMinimapWindow();
	if( minimap && pWide )
	{
		for( int i = 0; i < mCount; ++i )
		{
			///  ׸忡 ִ  
			cPlayer* player = OBJECTMANAGER->GetPlayer( mParty[i].mIndex );
			if( player )
			{
				minimap->SetPosParty( mParty[i].mIndex, player->GetXPos(), player->GetYPos() );
				pWide->SetPosParty( mParty[i].mIndex, player->GetXPos(), player->GetYPos() );
			}
		}
	}
}

///    
void cPartyManager::UpdatePartyHP( unsigned int i, unsigned long hp, unsigned long maxhp )
{
	/// ش   
	mParty[i].mMaxHP = maxhp;
	mParty[i].mHP	 = hp;

	cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
	if( state )
	{
		state->SetMaxHP( maxhp );
		state->SetHPGauge( hp );
	}
}

///    
void cPartyManager::UpdatePartyMP( unsigned int i, unsigned long mp, unsigned long maxmp )
{
	/// ش   
	mParty[i].mMaxMP = maxmp;
	mParty[i].mMP	 = mp;

	cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
	if( state )
	{
		state->SetMaxMP( maxmp );
		state->SetMPGauge( mp );
	}
}

///    
void cPartyManager::UpdateLevelUp( unsigned long userIndex, unsigned char level )
{
	int i = FindUser( userIndex );
	if( !(i > -1 && mParty[i].mUIIndex > -1) )
	{
		assert( 0 && "not exist user" );
		return;
	}

	/// ش   
	mParty[i].mLevel = level;

	cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
	if( state )
		state->SetLevel( level );
}

bool cPartyManager::IsHeroLeader()
{
	return (mLeaderIndex == HERO->GetObjectID());
}

///
void cPartyManager::NetworkMsgParser( char* msg )
{
	MSGROOT* tempMsg = (MSGROOT*)msg;
	cStringT Message;

	switch( tempMsg->Protocol )
	{
	case NM_PARTY_ADD_RES:
		{
			/// Ƽ û 
			MSG_RES_PARTY_ADD* pmsg = (MSG_RES_PARTY_ADD*)msg;
			switch( pmsg->ErrorCode )
			{
			case ERROR_PARTY_ADD_SUCCESS:
				{
					/// ʴ  ̸ ֱ
					cStringT str;
					str.Format( GAMERESOURCEMAN->GetGameText( 100 ), (LPCTSTR)mTempTargetName.Cstr() );
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
				}
				break;
			case ERROR_PARTY_ADD_CREATE_SUCCESS:	/// Ƽ
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 103 ) );
				break;
			case ERROR_PARTY_ADD_STATUS:			/// Ƽ û Ұ 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 135 ) );
				break;
			case ERROR_PARTY_ADD_USEROUT:			/// ʴ    
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 106 ) );
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 106 ),	// Ƽ ʴ Ұ
					GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
					eSKIN_OK
					);
				break;
			case ERROR_PARTY_ADD_COMPLETE:			/// ش Ƽ 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 107 ) );
				break;
			case ERROR_PARTY_ADD_CONTINUE:			///  ʴ Ұ
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 138 ),	//  ʴ Ұ
					GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
					eSKIN_OK
					);
				break;
			case ERROR_PARTY_ADD_USER:				/// ʴĳ .
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 101 ) );
				break;
			case ERROR_PARTY_ADD_COUNT:			/// Ƽο Ǯ
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 109 ) );
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 109 ),	// Ƽ ο Ǯ
					GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
					eSKIN_OK
					);
				break;
			case ERROR_PARTY_ADD_REFUSE:		/// Ƽ 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 104 ) );
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 104 ),	// Ƽ ȳ
					GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
					eSKIN_OK
					);
				break;
			case ERROR_PARTY_ADD_NOTLEADER:		/// Ѿ
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 110 ) );
				break;
			case ERROR_PARTY_ADD_MAP:			/// ̵̶ ʴҼ 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 106 ) );
				break;
			case ERROR_PARTY_ADD_CREATEFAIL:	/// Ƽ  
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 111 ) );
				break;
			case ERROR_PARTY_ADD_OPTIONREFUSE:	/// Ƽ ź 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 2701 ) );
				break;		
			case ERROR_PARTY_ADD_FAIL:			/// Ƽ û 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 2701 ) );
				break;
			}

			mTempTargetName.Clear();

			/// Ƽ UI  Ǯ
			GAMEUI->NetUnLockParty( eLOCK_PARTYADD );
		}
		break;
	case NM_PARTY_ADD_SYN:
		{
			/// Ƽκ  û 
			MSG_SYN_PARTY_ADD* pmsg = (MSG_SYN_PARTY_ADD*)msg;

			/// û
			Message.Format( GAMERESOURCEMAN->GetGameText( 131 ), pmsg->Name );
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );

			Message.Format( GAMERESOURCEMAN->GetGameText( 132 ), pmsg->Name );
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_PARTY_ADD_REQ, 
								(LPCTSTR)Message.Cstr(),			// Ƽû ޽
								GAMERESOURCEMAN->GetGameText( 99 ), // Ƽ û
								eSKIN_YESNO
								, 0, PARTY_WAIT_TIME, false, false );
		}
		break;
	case NM_PARTY_REP_RES:
		{
			/// Ƽ û   
			UIMAN->SendEventToMsgbox( false, eMBEVENT_PARTY_ADD_REQ );

			MSG_RES_PARTY_REP* pmsg = (MSG_RES_PARTY_REP*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_PARTY_REP_REFUSE:
				{
					/// Ƽ
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 133 ) );
				}
				break;
			case ERROR_PARTY_REP_FULL:
				{
					/// Ƽο ʰ
					UIMAN->CreateModal(	eStage_Game,
						eMBEVENT_NONE, 
						GAMERESOURCEMAN->GetGameText( 112 ),	// Ƽ ʰ
						GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
						eSKIN_OK
						);
				}
				break;
			case ERROR_PARTY_REP_FAIL:
				{
					/// ʴ Ƽ   
					UIMAN->CreateModal(	eStage_Game,
						eMBEVENT_NONE, 
						GAMERESOURCEMAN->GetGameText( 114 ),	// Ƽ 
						GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
						eSKIN_OK
						);
				}
				break;
			}
		}
		break;
	case NM_PARTY_LIST_SYN:	/// Ƽ Ǿ ޴´!!!!!!!
		{
			/// Ƽ ü Ʈ
			MSG_SYN_PARTY_LIST* pmsg = (MSG_SYN_PARTY_LIST*)msg;

			/// Ƽ 
			CreateParty( pmsg );

			/// Ƽ ε 
			HERO->SetPartyIndex( pmsg->mIndex );
		}
		break;
	case NM_PARTY_ADDONE_SYN:
		{
			/// Ƽ Ѹ ߰
			MSG_SYN_PARTY_ADDONE* pmsg = (MSG_SYN_PARTY_ADDONE*)msg;
			AddUser( pmsg );

			Message.Format( GAMERESOURCEMAN->GetGameText( 105 ), pmsg->Name );
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
		}
		break;
	case NM_PARTY_OUT_RES:
		{
			/// ƼŻû 
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 116 ) );

			/// Ƽ UI ݱ
			DeleteParty();

			/// Ƽ Ż
			HERO->SetPartyIndex( 0 );

			/// Ƽ  UI  Ǯ
			GAMEUI->NetUnLockParty( eLOCK_PARTYOUT );
		}
		break;
	case NM_PARTY_OUT_SYN:
		{
			/// Ƽ Ż ˸.
			MSG_SYN_PARTY_OUT* pmsg = (MSG_SYN_PARTY_OUT*)msg;

			int i = FindUser( pmsg->UserIndex );
			if( i > -1 )
			{
				Message.Format( GAMERESOURCEMAN->GetGameText( 115 ), (LPCTSTR)mParty[i].mName.Cstr() );
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );

				DeleteUser(i);
			}
			else
			{
				assert(0);
			}
		}
		break;
	case NM_PARTY_DELETE_SYN:
		{
			DeleteParty();

			/// Ƽ Ż
			HERO->SetPartyIndex( 0 );

			/// Ƽ ػ
			Message.Format( GAMERESOURCEMAN->GetGameText( 141 ) );
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );

			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 117 ),	// Ƽ ػ
								GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
								eSKIN_OK
								);
		}
		break;
	case NM_PARTY_CHANGELEADER_RES:
		{
			MSG_RES_PARTY_CHANGELEADER* pmsg = (MSG_RES_PARTY_CHANGELEADER*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_PARTY_CHANGELEADER_SUCESS:
				break;
			case ERROR_PARTY_CHANGELEADER_LEADER:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 119 ) );
				break;
			case ERROR_PARTY_CHANGELEADER_FAIL:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 120 ) );
				break;
			}

			/// Ƽ  UI  Ǯ
			GAMEUI->NetUnLockParty( eLOCK_PARTYCHANGELEADER );
		}
		break;
	case NM_PARTY_CHANGELEADER_SYN:
		{
			/// Ƽ 
			MSG_SYN_PARTY_CHANGELEADER* pmsg = (MSG_SYN_PARTY_CHANGELEADER*)msg;

			if( HERO->GetObjectID() == pmsg->UserIndex )
			{
				mLeaderIndex = pmsg->UserIndex;
				Message.Format( GAMERESOURCEMAN->GetGameText( 118 ), HERO->GetName() );
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
			}
			else
			{
				for( int i = 0; i < mCount; ++i )
				{
					if( mParty[i].mIndex == pmsg->UserIndex )
					{
						mLeaderIndex = pmsg->UserIndex;
						Message.Format( GAMERESOURCEMAN->GetGameText( 118 ), (LPCTSTR)mParty[i].mName.Cstr() );
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
						break;
					}
				}

			}

			ChangeLeader();
		}
		break;
	case NM_PARTY_CHANGEDIVIDE_RES:
		{
			/// Ƽй  û 
			MSG_RES_PARTY_CHAGNEDIVIDE* pmsg = (MSG_RES_PARTY_CHAGNEDIVIDE*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_PARTY_CHANGEDIVIDE_SUCESS:
				break;
			case ERROR_PARTY_CHANGEDIVIDE_LEADER:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 122 ) );
				break;
			case ERROR_PARTY_CHANGEDIVIDE_FAIL:
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 123 ) );
				break;
			}

			/// Ƽ  UI 
			GAMEUI->NetUnLockParty( eLOCK_PARTYCHANGEDIVIDE );
		}
		break;
	case NM_PARTY_CHANGEDIVIDE_SYN:
		{
			/// Ƽй  ˸
			MSG_SYN_PARTY_CHANGEDIVDE* pmsg = (MSG_SYN_PARTY_CHANGEDIVDE*)msg;
			mDivideType = pmsg->type;

			unsigned int textId = 0;
			switch( mDivideType )
			{
			case PARTY_DIVIDE_TURN:		textId = 265;	break;
			case PARTY_DIVIDE_RANDOM:	textId = 266; 	break;
			case PARTY_DIVIDE_DAMAGE:	textId = 267; 	break;
			case PARTY_DIVIDE_FREE:		textId = 268; 	break;
			default:					assert(0);		return;
			}

			if( textId > 0 )
			{
				Message.Format( GAMERESOURCEMAN->GetGameText( 124 ), UIMAN->GetUIText( textId ) );
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
			}

			/// UI 
			cPartyWindow* pPartyWindow = GAMEUI->GetPartyWindow();
			if( pPartyWindow )
			{
				pPartyWindow->SetDivideType( mDivideType );
			}
			else
			{
				assert(0);
			}
		}
		break;
	case NM_PARTY_THROW_RES:
		{
			/// Ƽ ߹ 
			MSG_RES_PARTY_THROW* pmsg = (MSG_RES_PARTY_THROW*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_PARTY_THROW_SUCESS:
				break;
			case ERROR_PARTY_THROW_LEADER:
				///  
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 122 ) );
				break;
			case ERROR_PARTY_THROW_FAIL:
				/// ߹ 
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 125 ) );
				break;
			}

			/// Ƽ  UI 
			GAMEUI->NetUnLockParty( eLOCK_PARTYTHROW );
		}
		break;
	case NM_PARTY_THROW_SYN:
		{
			/// Ƽ ߹ ˸
			MSG_SYN_PARTY_THROW* pmsg = (MSG_SYN_PARTY_THROW*)msg;
			int i = FindUser( pmsg->UserIndex );
			if( i > -1 )
			{
				Message.Format( GAMERESOURCEMAN->GetGameText( 126 ), (LPCTSTR)mParty[i].mName.Cstr() );
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );

				DeleteUser(i);
			}
			else
			{
				assert(0);
			}
		}
		break;
	case NM_PARTY_CUT_SYN:
		{
			/// Ƽκ ߹
			DeleteParty();

			/// Ƽ Ż
			HERO->SetPartyIndex( 0 );

			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 127 ) );
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 127 ),	// Ƽ ߹
								GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
								eSKIN_OK
								);
		}
		break;
	case NM_PARTY_MAPCHANGE_SYN:
		{
			MSG_SYN_PARTY_MAPCHANGE* pmsg = (MSG_SYN_PARTY_MAPCHANGE*)msg;
			int i = FindUser( pmsg->UserIndex );
			if( i > -1 && mParty[i].mUIIndex > -1 )
			{
				/// Ƽ  ü 
				mParty[i].mMapNum = pmsg->MapNum;

				cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
				if( state )
				{
					if( HERO->GetMapNum() == mParty[i].mMapNum )
					{
						///  ΰ
						state->SetNameColor( eCOLOR_WHITE );
						state->ShowData( true );
					}
					else
					{
						/// ƴѰ
						state->SetNameColor( eCOLOR_DARKGRAY );
						state->ShowData( false );
					}
					
					state->SetMapNum( mParty[i].mMapNum );
				}

				/// ̴ϸ 
				cSmallMiniMapWindow* minimap = GAMEUI->GetSmallMinimapWindow();
				cMiniMapWindow* pWide = GAMEUI->GetMinimapWindow();
				if( minimap && pWide )
				{
					minimap->SetMapNumParty( mParty[i].mMapNum, pmsg->UserIndex );
					pWide->SetMapNumParty( mParty[i].mMapNum, pmsg->UserIndex );
				}

				Message.Format( GAMERESOURCEMAN->GetGameText( 136 ),  (LPCTSTR)mParty[i].mName.Cstr(), GAMERESOURCEMAN->GetMapName( pmsg->MapNum ) );
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );	
			}
			else
			{
				assert(0);
			}
		}
		break;
	case NM_PARTY_ITEMGET_SYN:
		{
			/// Ƽ  ȹ
			MSG_SYN_PARTY_ITEMGET* pmsg = (MSG_SYN_PARTY_ITEMGET*)msg;
			int i = FindUser( pmsg->UserIndex );
			if( i > -1 )
			{
				for( long idx = 0; idx < pmsg->RowCount; ++idx )
				{
					Message.Format( GAMERESOURCEMAN->GetGameText( 139 ), (LPCTSTR)mParty[i].mName.Cstr() );
					CHATMANAGER->AddItemMsg( pmsg->ItemIndex[idx], UINT_MAX, (LPCTSTR)Message.Cstr(), GAMERESOURCEMAN->GetGameText( 140 ) );
				}
			}
			else
			{
				assert(0);
			}
		}
		break;
	case NM_PARTY_DATA_SYN:
		{
			/// ð ŵǴ 
			MSG_SYN_PARTY_DATA* pmsg = (MSG_SYN_PARTY_DATA*)msg;
		
			/// ش Ƽ  
			int i = FindUser( pmsg->userIndex );
			if( i > -1 && mParty[i].mUIIndex > -1 )
			{
				mParty[i].mMaxHP = pmsg->maxHP;
				mParty[i].mHP	 = pmsg->hp;
				mParty[i].mMaxMP = pmsg->maxMP;
				mParty[i].mMP	 = pmsg->mp;
				mParty[i].mLevel = pmsg->level;

				/// UI 
				cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
				if( state )
				{
					state->SetMaxHP( pmsg->maxHP );
					state->SetHPGauge( pmsg->hp );
					state->SetMaxMP( pmsg->maxMP );
					state->SetMPGauge( pmsg->mp );
					state->SetLevel( pmsg->level );

					///   
					state->ClearBuff();
					for( int count = 0; count < pmsg->RowCount; ++count )
						state->AddBuff( pmsg->mTable[count].mUniqueIdx, pmsg->mTable[count].mInfluenceClassIdx );

					bool show = ( HERO->GetMapNum() == mParty[i].mMapNum ) ? true : false;
                    state->ShowData( show );
				}

				/// ̵ ǥ - ̴ϸ 
				cSmallMiniMapWindow* minimap = GAMEUI->GetSmallMinimapWindow();
				cMiniMapWindow* pWide = GAMEUI->GetMinimapWindow();
				if( minimap && pWide )
				{
					minimap->SetPosParty( pmsg->userIndex, pmsg->posX, pmsg->posY );
					pWide->SetPosParty( pmsg->userIndex, pmsg->posX, pmsg->posY );
				}
			}
		}
		break;
	case NM_PARTY_JOBCHANGE_SYN:
		{
			///  
			MSG_SYN_PARTY_CHANGEJOB* pmsg = (MSG_SYN_PARTY_CHANGEJOB*)msg;
			int i = FindUser( pmsg->userIndex );
			if( i > -1 && mParty[i].mUIIndex > -1 )
			{
				mParty[i].mJob = pmsg->job;
				
				/// UI 
				cPartyStateWindow* state = GAMEUI->GetPartyStateWindow( mParty[i].mUIIndex );
				if( state )
					state->SetJob( pmsg->job );
			}
		}
		break;
	case NM_PARTY_BREAK_SYN:
		{
			/// Ƽ  ü
			DeleteParty();

			/// Ƽ Ż
			HERO->SetPartyIndex( 0 );
			Message.Format( GAMERESOURCEMAN->GetGameText( 143 ) );
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );

			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_NONE, 
				GAMERESOURCEMAN->GetGameText( 143 ),	//  ü
				GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
				eSKIN_OK
				);
		}
		break;
	default:
		assert(0);
		break;
	}
}
