/* ==========================================================================
*      : PartyManager.h
*      : 
*    : 谡
*    : 2007-11-07
* ǻ :
*===========================================================================*/
#pragma once
#include "Player_Common.h"
#include "Party_Common.h"

const unsigned long PARTY_WAIT_TIME = 10000;
const unsigned long PARTY_UPDATETIME = 1000;
const unsigned long PARTY_HPMPUPDATE = 100;
const unsigned long PARTY_BUFFUPDATE = 1000;

const int MAX_PARTY = 6;
const int PARTY_NUM = 5;	/// ڽ  Ƽ

enum ePLAYER_JOB;
class cPartyData
{
public:
	void operator=( unsigned int i );
	void operator=( const cPartyData& other );

public:
	/// Ƽ ε
	unsigned long mIndex;

	/// 
	cStringT mName;

	/// 
	unsigned char mLevel;

	/// 
	ePLAYER_JOB mJob;

	/// HP, MP
	unsigned int mHP;
	unsigned int mMaxHP;
	unsigned int mMP;
	unsigned int mMaxMP;

	///  ȣ
	unsigned int mMapNum;

	/// ʱ ǥ
	float		mInitX;
	float		mInitY;

	///  UI 迭ȣ
	int			mUIIndex;
};

inline
void cPartyData::operator=( unsigned int i )
{
	if( i <= 0 )
	{
		mIndex	= 0;
		mLevel	= 0;
		mJob	= ePLAYER_NONEJOB;
		mHP		= 0;
		mMaxHP	= 0;
		mMP		= 0;
		mMapNum	= 0;
		mInitX  = 0;
		mInitY  = 0;
		mUIIndex = -1;
		mName.Clear();
	}
	else
	{
		assert(0);
	}
}

inline
void cPartyData::operator=( const cPartyData& other )
{
	mIndex	= other.mIndex;
	mLevel	= other.mLevel;
	mJob	= other.mJob;
	mHP		= other.mHP;
	mMaxHP	= other.mMaxHP;
	mMP		= other.mMP;
	mMapNum	= other.mMapNum;
	mName	= other.mName;
	mInitX  = other.mInitX;
	mInitY  = other.mInitY;
	mUIIndex = other.mUIIndex;
}

/// Ʈũ 
enum 
{
	eLOCK_PARTYADD,
	eLOCK_PARTYOUT,
	eLOCK_PARTYCHANGELEADER,
	eLOCK_PARTYCHANGEDIVIDE,
	eLOCK_PARTYTHROW,
};

/// Ƽ Ŵ
class cPartyManager
{
public:
	static cPartyManager* mpSingleton;

public:
	cPartyManager();
	~cPartyManager();

	bool Init();
	void Close();
	void Process( unsigned long accumTime );
	
	void RequestPartyAdd( LPCTSTR targetName );
	void RequestChangeLeader();
	void RequestChangeLeader( unsigned long playerIdx );

	void RequestPartyOut();
	void RequestChangeDivide( PARTY_DIVIDE_TYPE type );
	void RequestThrow();
	void RequestThrow( unsigned long playerIdx );


	/// ش  Ƽ ˻
	bool IsHeroParty( unsigned long userIndex );

	void ChangeTabTarget( unsigned long userIdx );

	/// Ƽ Ÿ 
	void ChangeTarget( unsigned long userIndex );

	/// Ÿٵ Ƽ  
	void UpdateTarget( int index );

	LPCTSTR GetSelectName();

	/// Ƽ ̸ ȹ
	LPCTSTR GetUserName( unsigned long userIdx );

	/// Ʈũ ޽
	void NetworkMsgParser( char* msg );

	/// Ƽ UI 
	void CreatePartyUI();

	/// Ƽ UI show / hide
	void HidePartyUI();
	void ShowPartyUI();

	void UpdateLevelUp( unsigned long userIndex, unsigned char level );
	void UpdateMinimap();
	void UpdateBuffList( unsigned long index );

	bool IsHeroLeader();

public:
	static cPartyManager* GetSingleton();

protected:
	void Clear();

	void UpdatePartyHP( unsigned int i, unsigned long hp, unsigned long maxhp );
	void UpdatePartyMP( unsigned int i, unsigned long mp, unsigned long maxmp );

	/// Ƽ 
	bool CreateParty( MSG_SYN_PARTY_LIST* msgData );
	void DeleteParty();
    
	/// Ƽ ߰ & 
	void AddUser( MSG_SYN_PARTY_ADDONE* msgData );
	void DeleteUser( int arrIdx );	
		
	void ChangeLeader();

	/// ε 迭 ε ˻
	int FindUser( unsigned long userIdx );
	int FindEmptyUI();

	/// Ƽ UI ǥ 
	void UpdateStateUI();

private:
	/// Ƽ й
	PARTY_DIVIDE_TYPE mDivideType;

	unsigned long mPartyIndex;

	/// Ƽ 
	unsigned char mPartyLevel;

	/// Ƽ  ε
	unsigned long mLeaderIndex;

	/// Ƽ 
	cPartyData mParty[PARTY_NUM];

	/// Ƽο
	int mCount;

	/// õ Ƽ
	int mSelectDataIndex;

	///
	unsigned long mLastAccumTime;

	/// HP, MP  ð
	unsigned long mHPMPAccumTime;

	/// Ʈ  ð
	unsigned long mBuffAccumTime;

	/// Ƽ û Ÿ ̸
	cStringT	mTempTargetName;
};

inline int cPartyManager::FindUser( unsigned long userIdx )
{
	for( int i = 0; i < mCount; ++i )
	{
		if( mParty[i].mIndex == userIdx )
			return i;
	}
	return -1;
}

inline bool cPartyManager::IsHeroParty( unsigned long userIndex )
{
	return ( FindUser( userIndex ) == -1 ) ? false : true;
}

inline cPartyManager* cPartyManager::GetSingleton()
{
	return mpSingleton;
}

#define PARTYMAN cPartyManager::GetSingleton()
