#include "stdafx.h"
#include "PartyStateWindow.h"
#include "Gauge.h"
#include "Label.h"
#include "GameUIManager.h"
#include "RButtonMenuWindow.h"
#include "PartyWindow.h"
#include "PartyBuff.h"
#include "UIImage.h"
#include "GameResourceManager.h"
#include "PartyManager.h"
#include "PVPManager.h"

cPartyStateWindow::cPartyStateWindow()
: mpHPGauge(0)
, mpMPGauge(0)
, mpName(0)
, mpLevel(0)
, mUserIndex(0)
, mpBuff(0)
, mLinkPartyIndex(-1)
, mpNodeSkin(0)
, mpBack(0)
, mShowLeader( false )
, mpLeaderSkin(0)
, mpLeaderImage(0)
, mpJobImage(0)
, mpJobSkin(0)
{
}

cPartyStateWindow::~cPartyStateWindow()
{
	SAFE_DELETE( mpJobImage );
	SAFE_DELETE( mpBack );
	SAFE_DELETE( mpLeaderImage );
}

void cPartyStateWindow::Clear()
{
	/// ʱȭ
	if( mpLevel )
		mpLevel->Clear();
	if( mpName )
		mpName->Clear();
	if( mpHPGauge )
		mpHPGauge->Clear();
	if( mpMPGauge )
		mpMPGauge->Clear();
	if( mpBuff )
	{
		mpBuff->Clear();
		mpBuff->Hide();
	}

	mMapName.Clear();
	mUserIndex = 0;
	mShowLeader = false;
	mLinkPartyIndex = -1;
}

void cPartyStateWindow::ClearBuff()
{
	if( mpBuff )
		mpBuff->Clear();
}

void cPartyStateWindow::ShowTop(bool hideOthers, bool onsound )
{
	if( mLinkPartyIndex == -1 )
		return;

	cUIWindow::ShowTop( hideOthers, onsound );
}

void cPartyStateWindow::OnShow()
{
	cUIWindow::OnShow();

	if( mpBuff )
		mpBuff->ShowTop();
}

void cPartyStateWindow::OnHide()
{
	cUIWindow::OnHide();

	if( mpBuff )
		mpBuff->Hide();
}

void cPartyStateWindow::AddBuff(unsigned long uniqueIdx, unsigned long influenceIdx )
{
	if( mpBuff )
	{
		mpBuff->AddBuff( uniqueIdx, influenceIdx );

		if( IsVisible() == true )
			mpBuff->ShowTop();
	}
}

void cPartyStateWindow::DelBuff(unsigned long uniqueIdx )
{
	if( mpBuff )
		mpBuff->DelBuff( uniqueIdx );
}

void cPartyStateWindow::DelDeBuff(unsigned long uniqueIdx )
{
	if( mpBuff )
		mpBuff->DelDeBuff( uniqueIdx );
}

void cPartyStateWindow::InitPosition( int i )
{
	/// ε  ġ
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return;
	}

	cUINodeSkin* pNodeSkin = pSkin->GetNodeSkin( mSkinName );
	if( pNodeSkin )
	{
		cUIPos pos;
		pos.mX = pNodeSkin->mSkinInfo->mX;
		pos.mY = pNodeSkin->mSkinInfo->mY + ( pNodeSkin->mSkinInfo->mHeight * i );

		SetRelativePos( pos );
	}
}

void cPartyStateWindow::LinkPartyIndex( int i )
{
	///  Ƽ ε 
	if( mLinkPartyIndex == i )
		return;

	mLinkPartyIndex = i;

	/// ġ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return;
	}

	cUINodeSkin* pNodeSkin = pSkin->GetNodeSkin( mSkinName );
	if( pNodeSkin )
	{
		cUIPos pos;
		pos.mX = pNodeSkin->mSkinInfo->mX;
		unsigned int y = ( GetScreenHeight() * pNodeSkin->mSkinInfo->mY ) / mDefaultHeight;
		pos.mY = y + ( pNodeSkin->mSkinInfo->mHeight * mLinkPartyIndex );

		SetRelativePos( pos );

		if( mpBuff )
			mpBuff->UpdatePos();
	}	
}

bool cPartyStateWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpLevel = (cLabel*)GetChild( eUIID_GAME_PARTYSTATE_USERLEVEL );
	mpName = (cLabel*)GetChild( eUIID_GAME_PARTYSTATE_USERNAME );
	mpHPGauge = (cGauge*)GetChild( eUIID_GAME_PARTYSTATE_HP );
	mpMPGauge = (cGauge*)GetChild( eUIID_GAME_PARTYSTATE_MP );
	mpBuff = (cPartyBuff*)GetChild( eUIID_GAME_PARTYBUFF );

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
		return false;

	mpNodeSkin = pSkin->GetNodeSkin( mSkinName );
	if( !mpNodeSkin )
		return false;

	/// ̹ 
	cUINodeSkin* imageSkin = pSkin->GetNodeSkin( "PartyState_Back" );
	if( imageSkin && imageSkin->mpTexture )
	{
		mpBack = new cUIImage;

		/// ؽó 
		mpBack->SetTexture( imageSkin->mpTexture );

		/// ؽó  
		unsigned int tx = imageSkin->mSkinInfo->mTexX;
		unsigned int ty = imageSkin->mSkinInfo->mTexY;
		unsigned int tw = imageSkin->mSkinInfo->mWidth;
		unsigned int th = imageSkin->mSkinInfo->mHeight;
		
		mpBack->SetTextureRect( tx, ty, tx + tw, ty + th );

		/// ̹  
		mpBack->SetScreenRect( mAbsoluteRect );
	}

	mpLeaderSkin = pSkin->GetNodeSkin( "PartyState_Leader" );
	if( mpLeaderSkin && mpLeaderSkin->mpTexture )
	{
		mpLeaderImage = new cUIImage( mpLeaderSkin->mpTexture );
		unsigned int tx = mpLeaderSkin->mSkinInfo->mTexX;
		unsigned int ty = mpLeaderSkin->mSkinInfo->mTexY;
		unsigned int x = mpLeaderSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpLeaderSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		unsigned int w = mpLeaderSkin->mSkinInfo->mWidth;
		unsigned int h = mpLeaderSkin->mSkinInfo->mHeight;
		mpLeaderImage->SetTextureRect( tx, ty, tx + w, ty + h );
		mpLeaderImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}

	mpJobSkin = pSkin->GetNodeSkin( "PartyState_JobPos" );
	if( mpJobSkin )
	{
		mpJobImage = new cUIImage;
		unsigned int x = mpJobSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpJobSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		unsigned int w = mpJobSkin->mSkinInfo->mWidth;
		unsigned int h = mpJobSkin->mSkinInfo->mHeight;
		mpJobImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}
	return true;
}

void cPartyStateWindow::UpdateRect()
{
	cUIWindow::UpdateRect();
	
	if( mpBack && mpNodeSkin )
	{
		cUIRect rc;
		rc.mLeft = GetAbsoluteRect().mLeft;
		rc.mTop = GetAbsoluteRect().mTop;
		rc.mRight = mpNodeSkin->mSkinInfo->mWidth + rc.mLeft;
		rc.mBottom = mpNodeSkin->mSkinInfo->mHeight + rc.mTop;
		mpBack->SetScreenRect( rc );
	}

	if( mpLeaderSkin && mpLeaderImage )
	{
		unsigned int x = mpLeaderSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpLeaderSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		mpLeaderImage->SetPos( x, y );
	}


	if( mpJobSkin && mpJobImage )
	{
		unsigned int x = mpJobSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpJobSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		mpJobImage->SetPos( x, y );
	}
}

void cPartyStateWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	if( mLinkPartyIndex > -1 )
	{
		/// ġ 
		cUISkin* pSkin = UIMAN->GetSkin();
		if( !pSkin )
		{
			assert(0);
			return;
		}

		cUINodeSkin* pNodeSkin = pSkin->GetNodeSkin( mSkinName );
		if( pNodeSkin )
		{
			cUIPos pos;
			pos.mX = pNodeSkin->mSkinInfo->mX;

			/// Ų ġ ´, ػ󵵿  Ѵ
			unsigned int y = ( GetScreenHeight() * pNodeSkin->mSkinInfo->mY ) / mDefaultHeight;
			pos.mY = y + ( pNodeSkin->mSkinInfo->mHeight * mLinkPartyIndex );

			SetRelativePos( pos );
		}
	}
}

void cPartyStateWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mpBack )
		mpBack->Draw();

	if( mpJobImage )
		mpJobImage->Draw();

	cUIWindow::OnRender( pKeeper );

	if( mpLeaderImage && mShowLeader )
		mpLeaderImage->Draw();
}

void cPartyStateWindow::UpdateSize()
{
	if( mpBuff && mpNodeSkin )
	{
		cUISize size;
		size.mWidth = mpNodeSkin->mSkinInfo->mWidth;
		size.mHeight = mpNodeSkin->mSkinInfo->mHeight;

		if( mpBuff->IsHaveBuff() )
			size.mWidth += mpBuff->GetAbsoluteRect().GetWidth();

		SetRelativeSize( size );
	}
}

void cPartyStateWindow::OnMouseHovered( const cUIPos& pos )
{
	if( !mMapName.IsEmpty() )
		UIMAN->ShowCommunityTip( GAMEUI->GetSimpleTip(), pos, mMapName );
}

void cPartyStateWindow::OnMouseLeft( const cUIPos& pos )
{
	UIMAN->HideTip();
}

void cPartyStateWindow::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shiftPress )
{
	cUIWindow::OnLButtonDown( pos, ctrl, alt, shiftPress );

	/// õ  
	if( mLinkPartyIndex > -1)
		PARTYMAN->UpdateTarget( mLinkPartyIndex );
}

void cPartyStateWindow::OnLButtonDoubleClick(const cUIPos& pos )
{
	OnLButtonDown( pos, 0, 0, 0 );
}

void cPartyStateWindow::OnRButtonUp( const cUIPos& pos )
{
	cRButtonMenuWindow* win = GAMEUI->GetRButtonMenuWindow();
	if( win )
		win->PopUp( pos.mX, pos.mY, mUserIndex, mpName->GetText(), ePopupPos_PartyWindow );
}

void cPartyStateWindow::SetMaxHP( int max )
{
	if( mpHPGauge )
		mpHPGauge->SetMaxValue( (float)max );
}

void cPartyStateWindow::SetHPGauge( int front )
{
	if( mpHPGauge )
		mpHPGauge->SetGaugeNoAni( (float)front );
}

void cPartyStateWindow::SetMaxMP( int max )
{
	if( mpMPGauge )
		mpMPGauge->SetMaxValue( (float)max );
}

void cPartyStateWindow::SetMPGauge( int front )
{
	if( mpMPGauge )
		mpMPGauge->SetGaugeNoAni( (float)front );
}

void cPartyStateWindow::SetName( LPCTSTR name, eText_Color color )
{
	if( mpName )
	{
		mpName->SetTextColor( color );
		mpName->SetText( name );
	}
}

void cPartyStateWindow::SetNameColor( eText_Color color )
{
	if( mpName )
		mpName->SetTextColor( color );
}

void cPartyStateWindow::SetLevel( unsigned char level )
{
	if( mpLevel )
		mpLevel->SetValue( level );
}

void cPartyStateWindow::SetMapNum( unsigned int mapnum )
{
	if( mapnum > 0 )
	{
		/// Ϲݸ
		if( PVPMAN->IsEnableBattle() == false )
		{
			mMapName = GAMERESOURCEMAN->GetMapName( mapnum );
		}
		/// PVP
		else
		{
			mMapName = GAMERESOURCEMAN->GetGameText( 841 );
		}
	}
}

void cPartyStateWindow::SetJob( ePLAYER_JOB job )
{
    ///  ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return;
	}

	sJobInfo* info = GAMERESOURCEMAN->GetJobInfo( job );
	if( info )
	{
		NiTexture* pTex = pSkin->GetTexture( info->jobImageIndex );
		if( pTex && mpJobSkin && mpJobImage )
		{
			mpJobImage->SetTexture( pTex );
			int tx = info->tx;
			int ty = info->ty;
			int w = info->tw;
			int h = info->th;
			mpJobImage->SetTextureRect( cUIRect( tx, ty, tx + w, ty + h ));
		}
	}
}

/// õ   ȯ
void cPartyStateWindow::SetTarget()
{
	if( mpBack )
		mpBack->SetColor( NiColorA(0.59f, 0.72f, 0.80f, 1.0f) );

	if( mpName )
		mpName->SetTextColor( eCOLOR_YELLOW );
}

void cPartyStateWindow::ReleaseTarget( unsigned long namecolor )
{
	if( mpBack )
		mpBack->SetColor( NiColorA::WHITE );

	if( mpName )
		mpName->SetTextColor( namecolor );
}

/// ,    
void cPartyStateWindow::ShowData( bool show )
{
	if( mpHPGauge && mpMPGauge && mpBuff )
	{
		if( show )
		{
			mpHPGauge->Show();
			mpMPGauge->Show();

			if( mpBuff->IsHaveBuff() )
				mpBuff->ShowTop();
		}
		else
		{
			mpHPGauge->Hide();
			mpMPGauge->Hide();
			mpBuff->Hide();
		}
	}
}