/* ==========================================================================
*      : PartyStateWindow.h
*      : 
*    : 谡
*    : 2007-11-07
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"

class cUIImage;
class cGauge;
class cLabel;
class cPartyBuff;
enum ePLAYER_JOB;

/// Ƽ  
class cPartyStateWindow : public cUIWindow
{
public:
	cPartyStateWindow();
	virtual ~cPartyStateWindow();

	void InitPosition( int i );

	void Clear();
	void ClearBuff();

	/// Ƽ õ ε  
	void LinkPartyIndex( int i );
	int GetLinkPartyIndex() { return mLinkPartyIndex; }

	/// õ 
	void SetTarget();
	void ReleaseTarget( unsigned long namecolor );

	/// ε 
	void SetUserIndex( unsigned long index );
	unsigned long GetUserIndex();

	/// 
	void SetLeader( bool set );

	///
	void SetMaxHP( int max );			/// hp max 
	void SetHPGauge( int front );		/// hp 
	void SetMaxMP( int max );			/// mp max 
	void SetMPGauge( int front );		/// mp 
	void SetName( LPCTSTR name, eText_Color color = eCOLOR_WHITE );
	void SetNameColor( eText_Color color );
	void SetLevel( unsigned char level );
	void SetJob( ePLAYER_JOB job );
	void SetMapNum( unsigned int mapnum );

	/// Ƽ   
	void AddBuff( unsigned long uniqueIdx, unsigned long influenceIdx );
	void DelBuff( unsigned long uniqueIdx );
	void DelDeBuff( unsigned long uniqueIdx );

	///   
	void UpdateSize();

	/// ,  ̱ 
	void ShowData( bool show );

	void ShowTop(bool hideOthers = false, bool onsound = true );

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnRender(cUIFontItemKeeper* pKeeper );
	void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shiftPress );
	void OnLButtonDoubleClick(const cUIPos& pos );
	virtual void OnRButtonUp( const cUIPos& pos );
	void OnMouseHovered( const cUIPos& pos );
	void OnMouseLeft( const cUIPos& pos );
	void UpdateRect();
	void UpdateSkin();
	void OnShow();
	void OnHide();

private:
	cUINodeSkin* mpNodeSkin;
	cUIImage*	mpBack;

	bool		mShowLeader;
	cUINodeSkin* mpLeaderSkin;
	cUIImage*	mpLeaderImage;

	/// Ŭ ̹
	cUIImage*		mpJobImage;
	cUINodeSkin*	mpJobSkin;

	/// ̸
	cStringT		mMapName;

	/// 
	unsigned long	mUserIndex;

	cGauge*	mpHPGauge;
	cGauge*	mpMPGauge;
	cLabel*		mpLevel;
	cLabel*		mpName;

	/// 
	cPartyBuff*	mpBuff;

	/// Ƽ  ε
	int mLinkPartyIndex;
};


inline void cPartyStateWindow::SetUserIndex( unsigned long index )
{
	mUserIndex = index;
}

inline unsigned long cPartyStateWindow::GetUserIndex()
{
	return mUserIndex;
}

inline void cPartyStateWindow::SetLeader(bool set )
{
	mShowLeader = set;
}
