#include "stdafx.h"
#include "PartyWindow.h"
#include "Label.h"
#include "Button.h"
#include "GameUIManager.h"
#include "PartyManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "PartyStateWindow.h"
#include "UIMsgboxEvent.h"
#include "ChatManager.h"

cPartyWindow::cPartyWindow()
: mpDivide(0)
, mpLeader(0)
, mpMenuButton(0)
{

}

cPartyWindow::~cPartyWindow()
{

}

void cPartyWindow::Clear()
{
	SetLeader( false );
	SetDivideType( PARTY_DIVIDE_TURN );
}

void cPartyWindow::ChangeTarget( cPartyStateWindow* w )
{
	/// Ÿ ؾϸ Ÿâ Ÿټ
	if( w && w->GetUserIndex() > 0 )
		HERO->SetTargetObject( eOBJECTTYPE_PLAYER, w->GetUserIndex() );
}

void cPartyWindow::OnHide()
{
	cUIWindow::OnHide();

	///
	GAMEUI->HidePartyMenu();
}

bool cPartyWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpDivide = (cLabel*)GetChild( eUIID_GAME_PARTY_DIVIDE );
	mpLeader = (cLabel*)GetChild( eUIID_GAME_PARTY_LEADER );
	mpMenuButton = (cButton*)GetChild( eUIID_GAME_PARTY_MENU );

	if( mpLeader )
		mpLeader->Hide();
	return true;
}

void cPartyWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();
}

void cPartyWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_PARTY_MENU:
		/// Ƽ  ޴ 
		GAMEUI->TogglePartyMenu();
		break;
	}
}

void cPartyWindow::SetLeader( bool set )
{
	cPartyMenu* pMenu = (cPartyMenu*)UIMAN->GetContainer( eUIID_GAME_PARTYMENU );
	if( pMenu )
	{
		pMenu->SetEnableButton( set );
	}
	else
	{
		assert(0);
	}
	
	/// ڱڽ   
	if( mpLeader )
	{
		if( set == true )
			mpLeader->Show();
		else
			mpLeader->Hide();
	}
}

void cPartyWindow::SetDivideType( PARTY_DIVIDE_TYPE type )
{
	unsigned int textId = 0;
	switch( type )
	{
	case PARTY_DIVIDE_TURN:
		textId = 265;
		break;
	case PARTY_DIVIDE_RANDOM:
		textId = 266;
		break;
	case PARTY_DIVIDE_DAMAGE:
		textId = 267;
		break;
	case PARTY_DIVIDE_FREE:
		textId = 268;
		break;
	}

	if( mpDivide && textId > 0 )
	{
		mpDivide->SetTextColor( eCOLOR_WHITE );
		mpDivide->SetText( UIMAN->GetUIText( textId ) );
	}
}

cUIRect cPartyWindow::GetButtonRect()
{
	if( mpMenuButton )
		return mpMenuButton->GetAbsoluteRect();
	else
		return cUIRect( 0, 0, 0, 0);
}

////////////////////////////////////////////////////////////////////////////////
cPartyMenu::cPartyMenu()
: mpInvite(0)
, mpChangeLeader(0)
, mpChangeDivide(0)
, mpThrowUser(0)
, mpOut(0)
, mSetEnable( false )
{

}

cPartyMenu::~cPartyMenu()
{

}

void cPartyMenu::OnHide()
{
	cUIWindow::OnHide();

	GAMEUI->HidePartyDivideMenu();
}

void cPartyMenu::SetEnableButton( bool set )
{
	mSetEnable = set;

	if( mpInvite )
		mpInvite->SetEnabled( set );

	if( mpChangeLeader )
		mpChangeLeader->SetEnabled( set );

	if( mpChangeDivide )
		mpChangeDivide->SetEnabled( set );

	if( mpThrowUser )
		mpThrowUser->SetEnabled( set );
}

bool cPartyMenu::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpInvite = (cButton*)GetChild( eUIID_GAME_PARTYMENU_INVITE );
	mpChangeLeader = (cButton*)GetChild( eUIID_GAME_PARTYMENU_CHANGELEADER );
	mpChangeDivide = (cButton*)GetChild( eUIID_GAME_PARTYMENU_CHANGEDIVDIE );
	mpThrowUser = (cButton*)GetChild( eUIID_GAME_PARTYMENU_THROWUSER );
	mpOut = (cButton*)GetChild( eUIID_GAME_PARTYMENU_OUT );

	if( mpOut )
		mpOut->SetEnabled( true );
	return true;
}

void cPartyMenu::OnMouseOtherClick( const cUIPos& pos )
{
	/// 
	cPartyWindow* party = GAMEUI->GetPartyWindow();
	if( !party )
	{
		assert(0);
		return;
	}

	cPartyDivideMenu* divide = GAMEUI->GetPartyDivideMenu();
	if( !divide )
	{
		assert(0);
		return;
	}

	cUIRect divideRc = divide->GetAbsoluteRect();
	cUIRect partyRc = party->GetButtonRect();
    
	if( divide->IsVisible() == true )
	{
		if( mAbsoluteRect.ContainPoint( pos ) == false && 
			divideRc.ContainPoint( pos ) == false &&
			partyRc.ContainPoint( pos) == false )
		{
			Hide();
		}
	}
	else
	{
		if( mAbsoluteRect.ContainPoint( pos ) == false && 
			partyRc.ContainPoint( pos) == false )
		{
			Hide();
		}
	}
}

void cPartyMenu::OnCommand( cUINode*, unsigned int id )
{
	cStringT Message;

	switch( id )
	{
	case eUIID_GAME_PARTYMENU_INVITE:
		{
			/// Ƽʴ
			/// /Ƽ + Ÿ  ˻
			cBaseObject* pTarget = HERO->GetTargetObject();
			if( pTarget )
			{
				/// Ÿ 
				PARTYMAN->RequestPartyAdd( pTarget->GetName() );
			}
			else
			{
				/// Ÿ .
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 102 ) );
			}

			Hide();
		}
		break;
	case eUIID_GAME_PARTYMENU_CHANGELEADER:
		{
			/// Ƽ 
			LPCTSTR name = PARTYMAN->GetSelectName();
			
			Message.Format( GAMERESOURCEMAN->GetGameText( 128 ), name );
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_PARTY_CHANGELEADER_REQ, 
								(LPCTSTR)Message.Cstr(),				// Ƽ   ȳ
								GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
								eSKIN_YESNO
								);
			Hide();
		}
		break;
	case eUIID_GAME_PARTYMENU_CHANGEDIVDIE:
		/// ƼйŸԺ
		GAMEUI->TogglePartyDivideMenu();
		break;
	case eUIID_GAME_PARTYMENU_THROWUSER:
		{
			LPCTSTR name = PARTYMAN->GetSelectName();

			/// Ƽ߹
			Message.Format( GAMERESOURCEMAN->GetGameText( 129 ), name );
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_PARTY_THROW, 
								(LPCTSTR)Message.Cstr(),				// Ƽ ߹
								GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
								eSKIN_YESNO
								);

			Hide();
		}
		break;
	case eUIID_GAME_PARTYMENU_OUT:
		{
			/// ƼŻ
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_PARTY_OUT, 
								GAMERESOURCEMAN->GetGameText( 130 ),	// Ƽ Ż
								GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
								eSKIN_YESNO
								);
			Hide();
		}
		break;
	}
}

void cPartyMenu::OnNetLock( int lockTry )
{
	if( mpInvite )
		mpInvite->NetLock( lockTry );

	if( mpChangeLeader )
		mpChangeLeader->NetLock( lockTry );

	if( mpChangeDivide )
		mpChangeDivide->NetLock( lockTry );

	if( mpThrowUser )
		mpThrowUser->NetLock( lockTry );

	if( mpOut )
		mpOut->NetLock( lockTry );
}

void cPartyMenu::OnNetUnLock( int lockTry )
{
	if( mpInvite )
		mpInvite->NetUnLock( lockTry );

	if( mpChangeLeader )
		mpChangeLeader->NetUnLock( lockTry );

	if( mpChangeDivide )
		mpChangeDivide->NetUnLock( lockTry );

	if( mpThrowUser )
		mpThrowUser->NetUnLock( lockTry );

	if( mpOut )
		mpOut->NetUnLock( lockTry );

	///  
	SetEnableButton( mSetEnable );

	if( mpOut )
		mpOut->SetEnabled( true );
}

////////////////////////////////////////////////////////////////////////////////
cPartyDivideMenu::cPartyDivideMenu()
: mpSequence(0)
, mpRandom(0)
, mpDamage(0)
, mpFree(0)
{
}

cPartyDivideMenu::~cPartyDivideMenu()
{

}

void cPartyDivideMenu::OnHide()
{
	cUIWindow::OnHide();

	GAMEUI->HidePartyMenu();
}

bool cPartyDivideMenu::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpSequence = (cButton*)GetChild( eUIID_GAME_PARTYDIVIDE_SEQUENCE );
	mpRandom = (cButton*)GetChild( eUIID_GAME_PARTYDIVIDE_RANDOM );
	mpDamage = (cButton*)GetChild( eUIID_GAME_PARTYDIVIDE_DAMAGE );
	mpFree = (cButton*)GetChild( eUIID_GAME_PARTYDIVIDE_FREE );
	return true;
}

void cPartyDivideMenu::OnCommand( cUINode*, unsigned int id )
{
	PARTY_DIVIDE_TYPE type = PARTY_DIVIDE_NONE;

	switch( id )
	{
	case eUIID_GAME_PARTYDIVIDE_SEQUENCE:
		/// й
		type = PARTY_DIVIDE_TURN;
		break;
	case eUIID_GAME_PARTYDIVIDE_RANDOM:
		/// й
		type = PARTY_DIVIDE_RANDOM;
		break;
	case eUIID_GAME_PARTYDIVIDE_DAMAGE:
		/// й
		type = PARTY_DIVIDE_DAMAGE;
		break;
	case eUIID_GAME_PARTYDIVIDE_FREE:
		/// й
		type = PARTY_DIVIDE_FREE;
		break;
	}

	PARTYMAN->RequestChangeDivide( type );
	Hide();
}

void cPartyDivideMenu::OnNetLock( int lockTry )
{
	if( mpSequence )
		mpSequence->NetLock( lockTry );

	if( mpRandom )
		mpRandom->NetLock( lockTry );

	if( mpDamage )
		mpDamage->NetLock( lockTry );

	if( mpFree )
		mpFree->NetLock( lockTry );
}

void cPartyDivideMenu::OnNetUnLock( int lockTry )
{
	if( mpSequence )
		mpSequence->NetUnLock( lockTry );

	if( mpRandom )
		mpRandom->NetUnLock( lockTry );

	if( mpDamage )
		mpDamage->NetUnLock( lockTry );

	if( mpFree )
		mpFree->NetUnLock( lockTry );
}
