/* ====================================================================
 *      :	PlaneObject.h
 *      :	2D  ⺻ ü
 *    :	̹
 *    :	2006.12
 * ǻ :	׻  Property  Ǵ ü  ϼ
 * =================================================================== */
#pragma once

class NiTexture;
class NiTexturingProperty;
class NiAlphaProperty;
class NiZBufferProperty;

class cPlaneObject
{
public:
	cPlaneObject();
	virtual ~cPlaneObject();

	/// 
	virtual bool Create( const char* pathName, 
				short screenX, short screenY, unsigned short screenW, unsigned short screenH,
				unsigned short texLeft, unsigned short texTop, unsigned short texRight, unsigned short texBottom );

	/// 
	virtual bool Create( NiTexture* pTexture, 
				short screenX, short screenY, unsigned short screenW, unsigned short screenH,
				unsigned short texLeft, unsigned short texTop, unsigned short texRight, unsigned short texBottom );

	/// º
	virtual void Draw();

	inline short GetScreenX() { return mScreenX; }
	inline short GetScreenY() { return mScreenY; }
	inline unsigned short GetScreenW() { return mScreenW; }
	inline unsigned short GetScreenH() { return mScreenH; }

	/// ũ ǥ 
	void SetScreenXY( short screenX, short screenY );
	void SetScreenX( short screenX );
	void SetScreenY( short screenY );

	/// ũ 󿡼 ũ
	void SetScreenWH( unsigned short screenW, unsigned short screenH );
	void SetScreenWidth( unsigned short screenW );
	void SetScreenHeight( unsigned short screenH );

	void SetScreenRect( short screenX, short screenY, unsigned short screenW, unsigned short screenH );

	/// ؽ UV 
	virtual void SetTextureRect( unsigned short texLeft, unsigned short texTop, unsigned short texRight, unsigned short texBottom );

	///  ÷  
	void SetColorA( float r, float g, float b, float a );
	void SetColorA( NiColorA color );

	/// ȸ  ̵
	/// ǥ.
	void UpdateImage();
	void SetTranslate( short x, short y );
	void SetRotate( float angle );

	inline NiAlphaProperty* GetAlphaProp() { return mpAlphaProp; }
	inline NiTexturingProperty* GetTexturingProp() { return mpTextureProp; }
	inline NiScreenElements* GetScreenElements() { return mpScreenElement; }

protected:
	///	     ⺻ ü
	NiScreenElements*		mpScreenElement;

	/// ؽ   ϰ ϱ     
	NiTexturingProperty*	mpTextureProp;

	///       
	NiAlphaProperty*		mpAlphaProp;

	///  ؽ ü ũ
	unsigned int	mTextureWidth;
	unsigned int	mTextureHeight;

	/// ؽĻ󿡼 ġ
	unsigned short	mTexLeft;
	unsigned short	mTexTop;
	unsigned short	mTexRight;
	unsigned short	mTexBottom;

	/// ȭ󿡼 ġ  ũ
	short			mScreenX;
	short			mScreenY;
	unsigned short	mScreenW;
	unsigned short	mScreenH;

	float mScaleX;
	float mScaleY;

	/// ȸ 
	float mAngle;
	NiPoint2 mVertex[4];
	NiPoint2 mCenter;
};