/* ====================================================================
*      :	Player.h
*      :	÷̾ 
*    :	
*    :	2006.08.29
* ǻ :	
* =================================================================== */
#pragma once
#include "BaseObject.h"
#include "Player_Common.h"
//#include "PathNodeSet.h"
#include "StatusCalc_Client.h"

enum eVEHICLE_ANIMATIONTYPE
{ 
	V_ANITYPE_IDLE1 = 1,	/// 
	V_ANITYPE_IDLE2 = 2,	/// ⺸
	V_ANITYPE_RUN = 3,		/// ޸
};


class cPathFinder;
class cPlayerSceneNodeParam;
class cActorManagerForPartition;

class cPlayer : public cBaseObject
{
public:
	cPlayer( unsigned char type = eOBJECTTYPE_PLAYER );
	virtual ~cPlayer();

	inline virtual unsigned long	GetObjectID() { return mPlayerInfo.CharacterIdx; }

	/// 
	virtual bool Create( sPlayerInfo* pBaseInfo, sPlayerWearInfo* pWearInfo, sPlayerWeaponInfo* pWeaponInfo, sPlayerExrInfo* pExrInfo,
		NiPoint3 sPos, NiMatrix3 sRot = NiMatrix3::IDENTITY, float fScale = 1.0f );

	virtual void ReCreate( char race, char gender );

	/// ü ׷ Ϳ  
	virtual void RemoveObjectSceneNode();

	/// ź
	virtual void Update( unsigned long deltaTime, unsigned long accumTime );

	/// °ź
	virtual void	IdleUpdate( unsigned long deltaTime );
	virtual void	DieUpdate() {}
	virtual void	MoveUpdate( unsigned long deltaTime );
	virtual	void	SitDownUpdate() {}

	/// ü ̵
	virtual bool	Move( float x, float y );

	virtual void	SetActionMove( float tPosX, float tPosY, float range );
	virtual void	ClearActionMoveRange()	{ mActionMoveRange = 0; }

	virtual bool	GetDummyPos( unsigned int dummyId, NiPoint3& pos );

	virtual inline LPTSTR	GetName() { return mPlayerInfo.strName; }
	virtual inline void		SetName( LPTSTR name );
	virtual inline char		GetGender() { return mPlayerInfo.Gender; }
	virtual inline char		GetRace() { return mPlayerInfo.Race; }
	virtual inline void		SetGender( char gender ) { mPlayerInfo.Gender = gender; }
	virtual inline void		SetRace( char race ) { mPlayerInfo.Race = race; }
	
	inline sPlayerInfo*		GetPlayerInfo() { return &mPlayerInfo; }
	inline sPlayerExrInfo*		GetPlayerExrInfo() { return &mPlayerExrInfo; }

	virtual void EquipWeaponInfo( eWEAPON_STATE state, sPlayerWeaponInfo* pInfo );
	virtual void EquipWearInfo( eWEAR_TYPE type, unsigned long itemIdx );

	inline eWEAPON_STATE	GetWeaponState() { return mPlayerWeaponState; }
	inline unsigned long	GetLeftWeaponIdx() { return mPlayerWeaponInfo.WeaponIdx[eHAND_LEFT]; }
	inline unsigned long	GetRightWeaponIdx() { return mPlayerWeaponInfo.WeaponIdx[eHAND_RIGHT]; }

	virtual void	SetAttackSpeed( float speed )	{ mPlayerExrInfo.mAttackSpeed = speed; }

	/// 061123 wonju 
	void				SetPathFinder( cPathFinder* pathFinder );

	bool				SetDesiredDir(NiPoint3 CurrentPos, NiPoint3 TargetPos, unsigned long delay = 0 );
	inline unsigned int	GetRaceGender(){ return (mPlayerInfo.Race*eGENDER_MAX + mPlayerInfo.Gender); }

	//////////////////////////////////////////////////////////////////////////
	/// Player   ȭ
	virtual unsigned int	GetState() { return mPlayerExrInfo.mState; }
	virtual void			SetState( unsigned int state , bool bShowAni = true );

	/// Ȱ ൿ
	virtual void Rebirth();

	/// ɱ/
	virtual	void SitDown();
	virtual void StandUp();

	virtual bool IsPossibleSitDown() { return (mSitDownFlag==false); }

	virtual void	SetIdleFlag( eIDLEFLAG flag );
	eSTOPFLAG		GetStopFlag() { return (eSTOPFLAG)mPlayerExrInfo.mStateStop; }
	virtual void	SetStopFlag( eSTOPFLAG flag );

	void ShowWeapon( bool show );
	void ShowNameGauge( bool show );
	void PartyIn_Init();
	void PartyOut_Init();

	//////////////////////////////////////////////////////////////////////////

	/// 070115 PKH 
	ePLAYER_JOB			GetJob() { return mPlayerInfo.Job; }
	virtual void		SetJob( ePLAYER_JOB job ) { mPlayerInfo.Job = job; }

	/// 070115 PKH ÷̾ 
	unsigned char		GetLevel() { return mPlayerInfo.Level; }
	virtual void		SetLevel( unsigned char level )	{ mPlayerInfo.Level = level; }


	/// HP, MP 
	unsigned long	GetHP()						{ return mPlayerExrInfo.RestHP; }
	unsigned long	GetMP()						{ return mPlayerExrInfo.RestMP; }

	void SetMaxHP( unsigned long maxHP )	{ mPlayerExrInfo.MaxHP = maxHP; }
	void SetMaxMP( unsigned long maxMP )	{ mPlayerExrInfo.MaxMP = maxMP; }

	virtual unsigned long		GetMaxHP()					{ return mPlayerExrInfo.MaxHP; }
	virtual unsigned long		GetMaxMP()					{ return mPlayerExrInfo.MaxMP; }

	virtual void	HPChange( sTargetDamageHP* damage, cBaseObject* attacker = 0 );
	virtual void	HPChange( unsigned long objectHP, unsigned long objectMaxHP, bool die );
	virtual void	MPChange( unsigned long objectMP, unsigned long objectMaxMP );

	virtual void AddBuff( unsigned long uniqueIdx, cInfluenceObject* p );
	virtual void DelBuff( unsigned long uniqueIdx );
	virtual void AddDeBuff( unsigned long uniqueIdx, cInfluenceObject* p );
	virtual void DelDeBuff( unsigned long uniqueIdx );

	virtual void ClearDieBuff();

	virtual long GetMoveSpeed() { return mPlayerExrInfo.mMoveSpeed; }
	virtual void SetMoveSpeed( long moveSpeed )	{ mPlayerExrInfo.mMoveSpeed = moveSpeed; }

	virtual unsigned long GetTitleIndex() { return mPlayerExrInfo.mTitleIndex; }

	void SetRemoveDropItem( unsigned int idx );

	bool ChangeBaseWear( unsigned int part );

	void ResetBaseFace();
	void SetEmotionFace( unsigned long faceIdx );
	void SetStaticFace( unsigned long faceIdx );

	///  ü
	bool UnEquipWearItem( unsigned long itemIdx );
	void UnEquipWeaponItem( eHAND_TYPE handType );

	void ActiveChatBubble( LPTSTR msg, unsigned long color );
	void ActiveTarotBubble( LPTSTR title, unsigned long color );
	void ActiveUserSellBubble( LPTSTR title, unsigned long color );
	void DeActiveTarotBubble();
	void DeActiveUserSellBubble();

	virtual cEffectSceneNode*	SetLinkdEffect( unsigned int num, const char* nif, NiTransform* trans, bool bLoop=false, bool bFollow=true );
	virtual cEffectSceneNode*	SetLinkdDamage( unsigned int num, const char* nif, NiTransform* trans, bool IsMiss, bool zFalse );
  
	virtual void PlayerAttack( unsigned long uIdx, unsigned long skillIdx, cBaseObject* pTarget );
	virtual void PlayerUseSkill( unsigned long uIdx, unsigned long skillIdx, cBaseObject* pTarget );
	virtual void PlayerUseSkill( unsigned long uIdx, unsigned long skillIdx, NiPoint3 fieldPos );
	virtual void PlayerMapChangeSkill( unsigned long uIdx, unsigned long skillIdx );
	virtual void PlayerVehicleSkill( unsigned long uIdx, unsigned long skillIdx );

	virtual void ApplyDamageDrama( unsigned int damage, unsigned int damageType, cBaseObject* pAttacker = 0 );

	/// SetState() skill->processActive()    ÿ!! 
	void ChangeAnimation( ePLAYER_ANIMATIONTYPE type );
	virtual void ChangeAnimation_TransMon( unsigned int type );

	///
	virtual void UpdateSkillAnimation( unsigned int aniIdx, bool checkWeapon = false );

	/// Ʈ Ÿ üũ  Ÿ -  
	float			GetFixedObjectSize();
	virtual void	SetFixedObjectSizeScale( unsigned short size );

	/// ̵
	virtual void SetCantMove( bool /*cantMove*/ ) {}
	virtual void SetSleep( bool /*sleep*/ )	{}
	virtual void SetStun( bool /*stun*/ )	{}


	void SetDuelEffect();
	void ClearDuelEffect();

	void SetItemMixEffect();
	void ClearItemMIxEffect();

	void SetItemEnhanceEffect();
	void ClearItemEnhanceEffect();

	///   
	virtual bool TransformMonster( unsigned long monsterClassIdx );
	virtual void RestoreMonster();

	bool IsTransformMonster() { return (mPlayerExrInfo.mChgMonsterIdx != 0); }
	unsigned long GetTransMonsterClassIdx() { return mPlayerExrInfo.mChgMonsterIdx; }
	void ReadyRestoreMonster() { mReadyRestoreMonster = true; }

	/// Ż ó
	virtual void RideVehicle( unsigned long vehicleIdx );
	virtual void AlightVehicle();

	bool IsRideVehicle();

	virtual bool IsDie() { return (GetState()==eOBJECT_STATE_DIE); }

	/// 
	virtual void SetForceType( unsigned char forceType ) { mPlayerExrInfo.mForceType = forceType; }
	unsigned char GetForceType() { return mPlayerExrInfo.mForceType; }

	inline unsigned char GetPVPTeam() { return mPlayerExrInfo.mPvPDMTeamType; }
	
	virtual inline void		SetTitle( unsigned long titleIdx );
	virtual inline void		SetPartyIndex( unsigned long partyIndex );
	unsigned long			GetPartyIndex() { return mPlayerExrInfo.mPartyIndex; }

	virtual inline void		SetGuild( unsigned long guildIndex, LPCTSTR guildName, unsigned char guildposition, unsigned long markIndex );
	virtual inline void		SetGuildPosition( unsigned char guildPosition );
	unsigned long			GetGuildIndex() { return mPlayerExrInfo.mGuildIndex; }
	unsigned char			GetGuildPosition() { return mPlayerExrInfo.mGuildPosition; }
	LPCTSTR					GetGuildName() { return mPlayerExrInfo.mGuildName; }
	void					ChangeGuildMark( unsigned long markIndex );

	void					SetTodayWord( LPCTSTR word, unsigned long color );

	///
	virtual bool GatheringStart( unsigned long gaderIdx, unsigned long gatherClassIdx, NiPoint3 targetPos );
	virtual void GatheringEnd();

	void UpdateHelmetState( bool show );

protected:

	/// ⺻ Ǵ Ӹ 󱼿  ü
	bool SetBaseFace();

	virtual bool ChangeBaseHair( unsigned int hairIdx );
	virtual bool ChangeFaceTexture( unsigned int faceIdx, bool base = false );

	///  
	virtual void EndAttack() {}

	/// ִϸ̼  ó
	virtual void Interpret( unsigned long time );
	virtual void InterpretEvent( unsigned long id, float checkTime, cActorManagerForPartition* pActor );
	virtual void InterpretVehicle( unsigned long time );

	///  
	bool EquipWearItem( unsigned long itemIndex );
	virtual bool EquipWeaponItem( sPlayerWeaponInfo* info );

	virtual void ChangeWeaponState( eWEAPON_STATE state );

	virtual cDynamicSceneNode* CreateSceneNode( cPlayerSceneNodeParam* param );

	void ResetState();

	void DesiredDirProcess( unsigned long delta );
	void FaceProcess( unsigned long delta );

	/// monster transform process
	virtual void Update_TransMon( unsigned long deltaTime, unsigned long accumTime );
	virtual void SetState_TransMon( unsigned int state , bool bShowAni );
	virtual void Interpret_TransMon( unsigned long time );
	virtual void ApplyDamageDrama_TransMon( unsigned int damage, unsigned int damageType, cBaseObject* pAttacker );

protected:
	/// ̵  ǥ
	float		mGotoX;
	float		mGotoY;

	/// ̵   
	NiPoint3	mDesiredDir;

	/// ̵ Ÿ üũ..
	float		mActionMoveRange;
	NiPoint3	mTargetPos; ///  ǥ

	/// ü  ü
	sPlayerInfo				mPlayerInfo;
	sPlayerExrInfo			mPlayerExrInfo;
	sPlayerWearInfo			mPlayerWearInfo;

	cStringT				mTarotTitle;
	cStringT				mSellTitle;

	///  
	sPlayerWeaponInfo		mPlayerWeaponInfo;

	unsigned long			mGatheringToolObj;

	///  ⿡   
	eWEAPON_STATE			mPlayerWeaponState;

	///  ׷ ε (ObjectDataManager ſ)
	unsigned long			mWeaponObjectIndex[eHAND_ALL];
	unsigned long			mWeaponObjectEffect[eHAND_ALL];
	unsigned long			mHatObjectIndex;

	/// ã
	cPathFinder* mPathFinder;
	//cPathNodeSet	mPathNodeSet;

	ePLAYER_ANIMATIONTYPE	mAnimationType;
	unsigned int			mDamageAfterAnim;

	/// () = true
	bool					mSitDownFlag;

	/// ִ  ÿ  ̹  ϱ  
	unsigned int	mRemoveDropItemIdx;

	bool				mShowWeapon;

	/// Ʈ Ÿ üũ  Ÿ -  
	float				mFixedObjectSize;

	/// 
	unsigned long		mDelay;
	float				mAngle;
	float				mAccumAngle;
	NiPoint3			mAxis;

	/// 3 ǥ
	unsigned long		mEmotionCommandIdx;
	unsigned long		mEmotionRemainTime;

	///  
	unsigned long		mWinkFaceIdx;
	unsigned long		mWinkTime;
	unsigned long		mWinkRemainTime;

	unsigned long		mDuelEffectIdx;
	cEffectSceneNode*	mDuelEffect;

	unsigned long		mSitDownEffectIdx;
	cEffectSceneNode*	mSitDownEffect;

	unsigned long		mItemMixEffectIdx;
	cEffectSceneNode*	mItemMixEffect;

	unsigned long		mItemEnhanceEffectIdx;
	cEffectSceneNode*	mItemEnhanceEffect;

	bool				mReadyRestoreMonster;

	///  
	unsigned char		mForceType;		/// eFORCE_TYPE

	float mRevisionVEndTime; 
};

inline void cPlayer::SetName( LPTSTR name ) 
{ 
	Sstrncpy( mPlayerInfo.strName, MAX_NAME_BUFFER_SIZE, name, MAX_NAME_SIZE ); 
	//	::_tcsncpy( mPlayerInfo.strName, name, MAX_NAME_SIZE ); 
	//	mPlayerInfo.strName[MAX_NAME_SIZE] = 0;
}

