#include "StdAfx.h"
#include "PlayerSceneNode.h"

#include "ResourceManager.h"

#include "ObjectNameCard.h"
#include "SceneManager.h"
#include "cameraManager.h"
#include "OptionManager.h"
#include "RenderSystem.h"

#include "ChatBubble.h"
#include "CenterMsgPlane.h"
#include "Signboard.h"
#include "BaseObject.h"
#include "PartyManager.h"
#include "NoticeMsgPlane.h"

#include "ObjectManager.h"
#include "Hero.h"

#include "ShadowGeometry.h"
#include "StageManager.h"

#include "EffectSceneNode.h"

#include "LightAgent.h"
#include "FogAgent.h"

#ifdef _DEVSYS
#include "DevSystem.h"
#endif


cPlayerSceneNode::cPlayerSceneNode( eType type )
: cDynamicSceneNode( type )
{
	mpTarotBoard = 0;
	mpUserSellBoard = 0;
}

cPlayerSceneNode::~cPlayerSceneNode()
{
	SAFE_DELETE( mpUserSellBoard );
	SAFE_DELETE( mpTarotBoard );
}

bool cPlayerSceneNode::Init( const cPlayerSceneNodeParam& param )
{
	if( cDynamicSceneNode::Init( param ) == false )
	{
		return false;
	}

	/// parts  
	const char* partName = 0;
	for( unsigned int i=0; i<ePART_MAX; i++ )
	{
		partName = RESOURCEMAN->GetManagedPartName( i );
		if( strlen(partName) == 0 )
		{
			assert(0);
			continue;
		}
		mpActorManager->AddPartsObject( i, partName );
	}

	/// ǳ ü 
	mpChatBubble = new cChatBubble;
	mpTarotBoard = new cTarotSignboard;
	mpUserSellBoard = new cUseSellSignboard;
	return true;
}

bool cPlayerSceneNode::InitLinkInfo()
{
	// ̺κ  ޸ Ҵ Ѵ. (߿  Ȯϰ Ͽ ߰ϰų ϰ..)
	// 뷫  :   2 +  1
	mpLinkInfo = NiNew NiTPrimitiveArray<sLinkInfo*>(15, 5);
	assert(mpLinkInfo);
	if( mpLinkInfo == 0 ) 
	{
		return false;
	}

	for( unsigned int i=0; i<mpLinkInfo->GetAllocatedSize(); ++i )
	{
		mpLinkInfo->SetAt( i,0 );
	}

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	InitializeRandomIdle()
*      :	 پ缺 ϱ ؼ
* ǻ :	
* ------------------------------------------------------------------ */
void cPlayerSceneNode::InitializeRandomIdle()
{
	mpRandomIdle = NiNew NiTPrimitiveArray<cActorManagerForPartition::EventCode>(1);

	mpRandomIdle->SetAt( 0, 0 );
}

void cPlayerSceneNode::ProcessTrail( unsigned long delta )
{
	unsigned long scaleDelta = (unsigned long)(delta * mScaleFactor);

	///
	NiTListIterator pos = mRibbonList.GetHeadPos();
	while( pos )
	{
		sTrailInfo* p = mRibbonList.GetNext(pos);
		cRibbonGeometry* geom = p->mRibbonGeom;
		if( p->mLoop == false )
		{
			if( p->mLifeTime <= 5 )
			{
				p->mLifeTime = 0;
				geom->SetPushEnabled( false );

				if( geom->GetNumVerts() == 0 )
				{
					/// delete
					mDeleteRibbonList.AddTail(p);
					continue;
				}
			}
			else
				p->mLifeTime -= 5;
		}

		if( geom )
		{
			/// push point
			NiAVObject* obj1 = GetDummyObject( p->mStartLink );
			NiAVObject* obj2 = GetDummyObject( p->mEndLink );

			if( obj1 && obj2 )
			{
				const NiPoint3& pos1 = obj1->GetWorldTranslate();
				const NiPoint3& pos2 = obj2->GetWorldTranslate();

				geom->SetPushPoint( pos1, pos2 );
			}

			geom->Process( float(delta) * 0.001f );
		}
	}
}

const NiPoint3& cPlayerSceneNode::GetObjectHead()
{
	NiNode* spine = GetDummyObject( eLINK_HEAD );

	if( spine )	
		return spine->GetWorldTranslate();
	else
		return NiPoint3::ZERO;
}

const NiPoint3& cPlayerSceneNode::GetObjectFoot()
{
	NiNode* spine = GetDummyObject( eLINK_FOOT );

	if( spine )	
		return spine->GetWorldTranslate();
	else
		return NiPoint3::ZERO;
}

const NiPoint3& cPlayerSceneNode::GetObjectCenter()
{
	NiNode* spine = GetDummyObject( eLINK_BODY );

	if( spine )	
		return spine->GetWorldTranslate();
	else
		return NiPoint3::ZERO;
}

/* ------------------------------------------------------------------
* Լ̸ :	ChangeParts( unsigned int index, const cString& pathName )
*      :	Ʈ ü ̽ 
* ǻ :	
* ------------------------------------------------------------------ */
bool cPlayerSceneNode::ChangeParts( unsigned int partIdx, const char* fileName )
{
	if( fileName == 0 )
		return false;

	///
	cString pathName;
	pathName.Format( "./Data/Character/%s", fileName );
	RESOURCEMAN->LoadNIF( pathName );

	///
	NiNode* pNode = RESOURCEMAN->CloneObjectByName( fileName );
	assert(pNode);
	if( !pNode ) 
	{
		return false;
	}

	if( partIdx == ePART_FACE )
		return cPlayerSceneNode::ChangeParts( partIdx, pNode );
	else
		return cDynamicSceneNode::ChangeParts( partIdx, pNode );
}

bool cPlayerSceneNode::ChangeParts( unsigned int partsIdx, NiNode* pNode )
{
	if( partsIdx != ePART_FACE )
		return cDynamicSceneNode::ChangeParts( partsIdx, pNode );


	//////////////////////////////////////////////////////////////////////////
	/// Clone Object ִ Bone Root Ѵ.
	if( pNode->DetachChild( pNode->GetObjectByName("foot_dummy") ) == 0)
	{
		assert(0);
	}


	/// 2 ̻ Geomü ִ 쿡  ó
	NiAVObject* oldFace = GetPartObject( partsIdx );
	if( oldFace == 0 )
	{
		assert(0);
		return false;
	}

	NiAVObject* oldEar = GetPartObject( ePART_EAR );

	//////////////////////////////////////////////////////////////////////////
	/// face process
	const char* partsName1 =RESOURCEMAN->GetManagedPartName( partsIdx );
	if( partsName1 == 0 || strlen(partsName1) == 0 )
	{
		assert(0);
		return false;
	}
	NiAVObject* newFace = pNode->GetObjectByName( partsName1 );
	if( newFace == 0 )
	{
		assert(0);
		return false;
	}
	else
	{
		NiTriBasedGeom* pOldGeom = NULL;
		if( NiIsKindOf(NiTriBasedGeom, oldFace) )
			pOldGeom = (NiTriBasedGeom*)oldFace;
		else
			pOldGeom = NiDynamicCast( NiTriBasedGeom, GetGeom(oldFace) );

		if( !pOldGeom )
		{
			assert(0);
			return false;
		}

		/// Ų ȹ
		NiSkinInstance* pOldSkinInst = pOldGeom->GetSkinInstance();
		assert(pOldSkinInst);
		if( !pOldSkinInst )
		{
			return false;
		}
		NiSkinData* pOldSkinData = pOldSkinInst->GetSkinData();
		assert(pOldSkinData);
		if( !pOldSkinData )
		{
			return false;
		}

		//	/// ü ü Geomü 
		NiTriBasedGeom* pGeom = NiDynamicCast(NiTriBasedGeom, GetGeom( newFace ) );
		assert(pGeom);
		if( !pGeom )
		{
			return false;
		}

		/// ü ü Ų
		NiSkinInstance* pSkinInst = pGeom->GetSkinInstance();
		assert(pSkinInst);
		if( !pSkinInst )
		{
			return false;
		}
		NiSkinData* pSkinData = pSkinInst->GetSkinData();
		assert(pSkinData);
		if( !pSkinData )
		{
			return false;
		}

		/// üǾ Bone
		NiAVObject*const* ppBones = pSkinInst->GetBones();
		assert(ppBones);
		if( !ppBones )
		{
			return false;
		}
		NiSkinData::BoneData* pBoneData = pSkinData->GetBoneData();
		assert(pBoneData);
		if( !pBoneData )
		{
			return false;
		}

		/// ο  Bone  Bone Hierachy Bone Node üѴ.
		/// ϳ ¿  ̹Ƿ   Ѵ.
		///  ü ü ü  ϵ   ´.
		/// !!    ,  ġ  ͷ ؾ Ѵ.
		/// (Ų ϴ ޸ ּҷ ̴.)
		unsigned int i;
		NiAVObject *pBone = NULL;
		NiAVObject *pNewBone = NULL;
		NiTPrimitiveSet<NiAVObject*> newBones;
		NiTPrimitiveSet<sBoneDataObj*> newBoneDataObjs;
		sBoneDataObj* pBoneDataObj = NULL;

		//	NiAVObject* pRoot= GetNiObj();
		for( i=0; i<pSkinData->GetBoneCount(); ++i )
		{
			pBone = ppBones[i];
			if( !pBone )
			{
				assert(0);
				continue;
			}

			pNewBone = GetNiObj()->GetObjectByName( pBone->GetName() );
			if( !pNewBone )
			{
				assert(0);
				continue;
			}

			newBones.Add( pNewBone );
			pBoneDataObj = NiNew sBoneDataObj;
			pBoneDataObj->pBoneData = &pBoneData[i];
			for( unsigned int k = 0; k < pBoneData[i].m_usVerts; ++k )
			{
				pBoneDataObj->BoneVertData.Add( &pBoneData[i].m_pkBoneVertData[k] );
			}
			newBoneDataObjs.Add( pBoneDataObj );
		}

		/// Create the new arrays.
		unsigned int numNewBones = newBones.GetSize();
		NiAVObject** ppNewBones = NiAlloc(NiAVObject*, numNewBones);
		NiSkinData::BoneData* pNewBoneData = NiNew NiSkinData::BoneData[numNewBones];

		/// Fill the new arrays.
		for( i = 0; i<numNewBones; ++i )
		{
			ppNewBones[i] = newBones.GetAt( i );

			pBoneDataObj = newBoneDataObjs.GetAt( i );
			pNewBoneData[i].m_kBound = pBoneDataObj->pBoneData->m_kBound;
			pNewBoneData[i].m_kSkinToBone = pBoneDataObj->pBoneData->m_kSkinToBone;

			///   ƴ,  üũ Ѵ!!
			assert( pBoneDataObj->BoneVertData.GetSize() < (unsigned int) (unsigned short) ~0 );
			pNewBoneData[i].m_usVerts = (unsigned short)pBoneDataObj->BoneVertData.GetSize();
			pNewBoneData[i].m_pkBoneVertData = NiNew NiSkinData::BoneVertData[pNewBoneData[i].m_usVerts];

			for ( unsigned short k = 0; k<pNewBoneData[i].m_usVerts; ++k )
			{
				pNewBoneData[i].m_pkBoneVertData[k].m_fWeight = pBoneDataObj->BoneVertData.GetAt( k )->m_fWeight;
				pNewBoneData[i].m_pkBoneVertData[k].m_usVert = pBoneDataObj->BoneVertData.GetAt( k )->m_usVert;
			}
		}

		/// Create the new NiSkinData and NiSkinInstance objects.
		NiSkinData* pNewSkinData = NiNew NiSkinData( numNewBones, pNewBoneData, 
			pSkinData->GetRootParentToSkin(), pGeom->GetVertices() );
		pNewSkinData->SortAndMergeBoneData();
		NiSkinInstance* pNewSkinInst = NiNew NiSkinInstance( pNewSkinData,
			pOldSkinInst->GetRootParent(), ppNewBones );

		/// Delete allocated memory.
		for( i = 0; i< newBoneDataObjs.GetSize(); ++i )
		{
			NiDelete newBoneDataObjs.GetAt( i );
		}

		/// Skin Instance 
		pGeom->SetSkinInstance( pNewSkinInst );

		/// Bone LOD  ..
		NiBoneLODController* pOldCtrl = NULL;
		pOldCtrl = mpActorManager->GetBoneLODController();
		if( pOldCtrl )
		{
			int curLOD = pOldCtrl->GetBoneLOD();
			pOldCtrl->ProcessScene( GetNiNode() );
			pOldCtrl->ReplaceSkin( pOldGeom, pGeom );

			mpActorManager->RefreshControllerManager();

			NiBoneLODController* pNewCtrl = mpActorManager->GetBoneLODController();
			pNewCtrl->SetBoneLOD( curLOD );
		}
	}


	//////////////////////////////////////////////////////////////////////////
	/// ear process
	const char* partsName2 =RESOURCEMAN->GetManagedPartName( ePART_EAR );
	if( partsName2 == 0 || strlen(partsName2) == 0 )
	{
		assert(0);
		return false;
	}
	NiAVObject* newEar = pNode->GetObjectByName( partsName2 );
	if( newEar )
	{
		NiTriBasedGeom* pOldGeom = NULL;
		if( oldEar )
		{
			if( NiIsKindOf(NiTriBasedGeom, oldEar) )
				pOldGeom = (NiTriBasedGeom*)oldEar;
			else
				pOldGeom = NiDynamicCast( NiTriBasedGeom, GetGeom(oldEar) );
		}
		else
		{
			if( NiIsKindOf(NiTriBasedGeom, oldFace) )
				pOldGeom = (NiTriBasedGeom*)oldFace;
			else
				pOldGeom = NiDynamicCast( NiTriBasedGeom, GetGeom(oldFace) );
		}

		if( !pOldGeom )
		{
			assert(0);
			return false;
		}

		/// Ų ȹ
		NiSkinInstance* pOldSkinInst = pOldGeom->GetSkinInstance();
		assert(pOldSkinInst);
		if( !pOldSkinInst )
		{
			return false;
		}
		NiSkinData* pOldSkinData = pOldSkinInst->GetSkinData();
		assert(pOldSkinData);
		if( !pOldSkinData )
		{
			return false;
		}

		//	/// ü ü Geomü 
		NiTriBasedGeom* pGeom = NiDynamicCast(NiTriBasedGeom, GetGeom( newEar ) );
		assert(pGeom);
		if( pGeom )
		{
			/// ü ü Ų
			NiSkinInstance* pSkinInst = pGeom->GetSkinInstance();
			assert(pSkinInst);
			if( !pSkinInst )
			{
				return false;
			}
			NiSkinData* pSkinData = pSkinInst->GetSkinData();
			assert(pSkinData);
			if( !pSkinData )
			{
				return false;
			}

			/// üǾ Bone
			NiAVObject*const* ppBones = pSkinInst->GetBones();
			assert(ppBones);
			if( !ppBones )
			{
				return false;
			}
			NiSkinData::BoneData* pBoneData = pSkinData->GetBoneData();
			assert(pBoneData);
			if( !pBoneData )
			{
				return false;
			}

			/// ο  Bone  Bone Hierachy Bone Node üѴ.
			/// ϳ ¿  ̹Ƿ   Ѵ.
			///  ü ü ü  ϵ   ´.
			/// !!    ,  ġ  ͷ ؾ Ѵ.
			/// (Ų ϴ ޸ ּҷ ̴.)
			unsigned int i;
			NiAVObject *pBone = NULL;
			NiAVObject *pNewBone = NULL;
			NiTPrimitiveSet<NiAVObject*> newBones;
			NiTPrimitiveSet<sBoneDataObj*> newBoneDataObjs;
			sBoneDataObj* pBoneDataObj = NULL;

			//	NiAVObject* pRoot= GetNiObj();
			for( i=0; i<pSkinData->GetBoneCount(); ++i )
			{
				pBone = ppBones[i];
				if( !pBone )
				{
					assert(0);
					continue;
				}

				pNewBone = GetNiObj()->GetObjectByName( pBone->GetName() );
				if( !pNewBone )
				{
					assert(0);
					continue;
				}

				newBones.Add( pNewBone );
				pBoneDataObj = NiNew sBoneDataObj;
				pBoneDataObj->pBoneData = &pBoneData[i];
				for( unsigned int k = 0; k < pBoneData[i].m_usVerts; ++k )
				{
					pBoneDataObj->BoneVertData.Add( &pBoneData[i].m_pkBoneVertData[k] );
				}
				newBoneDataObjs.Add( pBoneDataObj );
			}

			/// Create the new arrays.
			unsigned int numNewBones = newBones.GetSize();
			NiAVObject** ppNewBones = NiAlloc(NiAVObject*, numNewBones);
			NiSkinData::BoneData* pNewBoneData = NiNew NiSkinData::BoneData[numNewBones];

			/// Fill the new arrays.
			for( i = 0; i<numNewBones; ++i )
			{
				ppNewBones[i] = newBones.GetAt( i );

				pBoneDataObj = newBoneDataObjs.GetAt( i );
				pNewBoneData[i].m_kBound = pBoneDataObj->pBoneData->m_kBound;
				pNewBoneData[i].m_kSkinToBone = pBoneDataObj->pBoneData->m_kSkinToBone;

				///   ƴ,  üũ Ѵ!!
				assert( pBoneDataObj->BoneVertData.GetSize() < (unsigned int) (unsigned short) ~0 );
				pNewBoneData[i].m_usVerts = (unsigned short)pBoneDataObj->BoneVertData.GetSize();
				pNewBoneData[i].m_pkBoneVertData = NiNew NiSkinData::BoneVertData[pNewBoneData[i].m_usVerts];

				for ( unsigned short k = 0; k<pNewBoneData[i].m_usVerts; ++k )
				{
					pNewBoneData[i].m_pkBoneVertData[k].m_fWeight = pBoneDataObj->BoneVertData.GetAt( k )->m_fWeight;
					pNewBoneData[i].m_pkBoneVertData[k].m_usVert = pBoneDataObj->BoneVertData.GetAt( k )->m_usVert;
				}
			}

			/// Create the new NiSkinData and NiSkinInstance objects.
			NiSkinData* pNewSkinData = NiNew NiSkinData( numNewBones, pNewBoneData, 
				pSkinData->GetRootParentToSkin(), pGeom->GetVertices() );
			pNewSkinData->SortAndMergeBoneData();
			NiSkinInstance* pNewSkinInst = NiNew NiSkinInstance( pNewSkinData,
				pOldSkinInst->GetRootParent(), ppNewBones );

			/// Delete allocated memory.
			for( i = 0; i< newBoneDataObjs.GetSize(); ++i )
			{
				NiDelete newBoneDataObjs.GetAt( i );
			}

			/// Skin Instance 
			pGeom->SetSkinInstance( pNewSkinInst );

			/// Bone LOD  ..
			NiBoneLODController* pOldCtrl = NULL;
			pOldCtrl = mpActorManager->GetBoneLODController();
			if( pOldCtrl )
			{
				int curLOD = pOldCtrl->GetBoneLOD();
				pOldCtrl->ProcessScene( GetNiNode() );
				pOldCtrl->ReplaceSkin( pOldGeom, pGeom );

				mpActorManager->RefreshControllerManager();

				NiBoneLODController* pNewCtrl = mpActorManager->GetBoneLODController();
				pNewCtrl->SetBoneLOD( curLOD );
			}
		}
	}

	/// ο ü ٲ۴.
	mpActorManager->ChangePartsObject( partsIdx, pNode );

	///   
	mUpdateGeomInfo = true;

	return true;


/*
	/// 1.  Ʈ   Ѵ.
	NiAVObject* pOldNode = mpActorManager->GetParts( partsIdx );
	if( !pOldNode )
	{
		assert(0);
		return false;
	}

	/// Geomü ȹѴ.

	NiTriBasedGeom* pOldGeom = NULL;
	if( NiIsKindOf(NiTriBasedGeom, pOldNode) )
	{
		pOldGeom = (NiTriBasedGeom*)pOldNode;
	}
	else
	{
		pOldGeom = NiDynamicCast( NiTriBasedGeom, GetGeom(pOldNode) );
	}

	if( !pOldGeom )
	{
		assert(0);
		return false;
	}

	/// Ų ȹ
	NiSkinInstance* pOldSkinInst = pOldGeom->GetSkinInstance();
	assert(pOldSkinInst);
	if( !pOldSkinInst )
	{
		return false;
	}
	NiSkinData* pOldSkinData = pOldSkinInst->GetSkinData();
	assert(pOldSkinData);
	if( !pOldSkinData )
	{
		return false;
	}

	/// 2. ü Ǿ Ʈ   
	const char* partsName =RESOURCEMAN->GetManagedPartName( partsIdx );
	if( partsName == 0 || strlen(partsName) == 0 )
	{
		assert(0);
		return false;
	}

	//	/// ü ü Geomü 
	NiTriBasedGeom* pGeom = NiDynamicCast(NiTriBasedGeom, GetGeom( pNode ) );
	assert(pGeom);
	if( !pGeom )
	{
		return false;
	}

	/// ü ü Ų
	NiSkinInstance* pSkinInst = pGeom->GetSkinInstance();
	assert(pSkinInst);
	if( !pSkinInst )
	{
		return false;
	}
	NiSkinData* pSkinData = pSkinInst->GetSkinData();
	assert(pSkinData);
	if( !pSkinData )
	{
		return false;
	}

	/// üǾ Bone
	NiAVObject*const* ppBones = pSkinInst->GetBones();
	assert(ppBones);
	if( !ppBones )
	{
		return false;
	}
	NiSkinData::BoneData* pBoneData = pSkinData->GetBoneData();
	assert(pBoneData);
	if( !pBoneData )
	{
		return false;
	}

	/// ο  Bone  Bone Hierachy Bone Node üѴ.
	/// ϳ ¿  ̹Ƿ   Ѵ.
	///  ü ü ü  ϵ   ´.
	/// !!    ,  ġ  ͷ ؾ Ѵ.
	/// (Ų ϴ ޸ ּҷ ̴.)
	unsigned int i;
	NiAVObject *pBone = NULL;
	NiAVObject *pNewBone = NULL;
	NiTPrimitiveSet<NiAVObject*> newBones;
	NiTPrimitiveSet<sBoneDataObj*> newBoneDataObjs;
	sBoneDataObj* pBoneDataObj = NULL;

	//	NiAVObject* pRoot= GetNiObj();
	for( i=0; i<pSkinData->GetBoneCount(); ++i )
	{
		pBone = ppBones[i];
		if( !pBone )
		{
			assert(0);
			continue;
		}

		pNewBone = GetNiObj()->GetObjectByName( pBone->GetName() );
		if( !pNewBone )
		{
			assert(0);
			continue;
		}

		newBones.Add( pNewBone );
		pBoneDataObj = NiNew sBoneDataObj;
		pBoneDataObj->pBoneData = &pBoneData[i];
		for( unsigned int k = 0; k < pBoneData[i].m_usVerts; ++k )
		{
			pBoneDataObj->BoneVertData.Add( &pBoneData[i].m_pkBoneVertData[k] );
		}
		newBoneDataObjs.Add( pBoneDataObj );
	}

	/// Create the new arrays.
	unsigned int numNewBones = newBones.GetSize();
	NiAVObject** ppNewBones = NiAlloc(NiAVObject*, numNewBones);
	NiSkinData::BoneData* pNewBoneData = NiNew NiSkinData::BoneData[numNewBones];

	/// Fill the new arrays.
	for( i = 0; i<numNewBones; ++i )
	{
		ppNewBones[i] = newBones.GetAt( i );

		pBoneDataObj = newBoneDataObjs.GetAt( i );
		pNewBoneData[i].m_kBound = pBoneDataObj->pBoneData->m_kBound;
		pNewBoneData[i].m_kSkinToBone = pBoneDataObj->pBoneData->m_kSkinToBone;

		///   ƴ,  üũ Ѵ!!
		assert( pBoneDataObj->BoneVertData.GetSize() < (unsigned int) (unsigned short) ~0 );
		pNewBoneData[i].m_usVerts = (unsigned short)pBoneDataObj->BoneVertData.GetSize();
		pNewBoneData[i].m_pkBoneVertData = NiNew NiSkinData::BoneVertData[pNewBoneData[i].m_usVerts];

		for ( unsigned short k = 0; k<pNewBoneData[i].m_usVerts; ++k )
		{
			pNewBoneData[i].m_pkBoneVertData[k].m_fWeight = pBoneDataObj->BoneVertData.GetAt( k )->m_fWeight;
			pNewBoneData[i].m_pkBoneVertData[k].m_usVert = pBoneDataObj->BoneVertData.GetAt( k )->m_usVert;
		}
	}

	/// Create the new NiSkinData and NiSkinInstance objects.
	NiSkinData* pNewSkinData = NiNew NiSkinData( numNewBones, pNewBoneData, 
		pSkinData->GetRootParentToSkin(), pGeom->GetVertices() );
	pNewSkinData->SortAndMergeBoneData();
	NiSkinInstance* pNewSkinInst = NiNew NiSkinInstance( pNewSkinData,
		pOldSkinInst->GetRootParent(), ppNewBones );

	/// Delete allocated memory.
	for( i = 0; i< newBoneDataObjs.GetSize(); ++i )
	{
		NiDelete newBoneDataObjs.GetAt( i );
	}

	/// Clone Object ִ Bone Root Ѵ.
	if( pNode->DetachChild( pNode->GetObjectByName("foot_dummy") ) == 0)
		assert(0);

	/// Skin Instance 
	pGeom->SetSkinInstance( pNewSkinInst );

	/// ο ü ٲ۴.
	mpActorManager->ChangePartsObject( partsIdx, pNode );

	/// Bone LOD  ..
	NiBoneLODController* pOldCtrl = NULL;
	pOldCtrl = mpActorManager->GetBoneLODController();
	if( pOldCtrl )
	{
		int curLOD = pOldCtrl->GetBoneLOD();
		pOldCtrl->ProcessScene( GetNiNode() );
		pOldCtrl->ReplaceSkin( pOldGeom, pGeom );

		mpActorManager->RefreshControllerManager();

		NiBoneLODController* pNewCtrl = mpActorManager->GetBoneLODController();
		pNewCtrl->SetBoneLOD( curLOD );
	}

	///   
	mUpdateGeomInfo = true;

	return true;
*/
	return true;
}


bool cPlayerSceneNode::ChangePartsTexture( unsigned int partsIdx, const char* fileName )
{
	cString pathName;
	pathName.Format( "./Data/Character/%s", fileName );
	NiTexture* pTexture = RESOURCEMAN->LoadTexture( pathName );
	if( pTexture == 0 )
	{
		return false;
	}

	return cDynamicSceneNode::ChangePartsTexture( partsIdx, pTexture );
}


/* ------------------------------------------------------------------
* Լ̸ :	LinkToDummy( unsigned int index, const cString& pathName )
*      :	ü ũ ̽
* ǻ :	
* ------------------------------------------------------------------ */
unsigned int cPlayerSceneNode::LinkObject( unsigned int dummyIdx, const char* fileName )
{
	if( fileName == 0 )
		return UINT_MAX;

	///
	cString pathName;
	pathName.Format( "./Data/Character/%s", fileName );
	if( RESOURCEMAN->LoadNIF( pathName ) == false )
		return UINT_MAX;

	///
	NiNode* n = RESOURCEMAN->GetObjectByName( fileName );
	if( n == 0 ) 
	{
		assert(0);
		return UINT_MAX;
	}

	return cDynamicSceneNode::LinkObject( dummyIdx, n );
}

NiAVObject* cPlayerSceneNode::GetWeaponDummy( unsigned int objectIdx, bool left )
{
	NiAVObject* pObj = GetLinkObject( objectIdx );
	if( pObj == 0 )
		return 0;

	unsigned int dummyIdx = (left == true)? eLINK_LWEAPON:eLINK_RWEAPON;
	const char* dummyName = RESOURCEMAN->GetManagedDummyName( dummyIdx );
	if( strlen( dummyName ) == 0 )
		return 0;

	return pObj->GetObjectByName( dummyName );
}

cObjectNameCard* cPlayerSceneNode::CreateNameCard( cBaseObject* pObj )
{
	if( !pObj )
	{
		assert(0);
		return 0;
	}
	return new cPlayerNameCard( pObj );
}

void cPlayerSceneNode::AddDepthPlaneObject()
{
	bool showName = true;
	unsigned int optionHeight = 0;

	/// Ÿ &   ߰
	if( mpTarotBoard && mpTarotBoard->IsActive() )
	{
		SCENEMAN->AddPlane( mpTarotBoard );

		mpTarotBoard->SetPos( mHeadScreenPosX, mHeadScreenPosY );
		optionHeight += mpTarotBoard->GetBoardHeight();

		showName = false;
	}
	else if( mpUserSellBoard && mpUserSellBoard->IsActive() )
	{
		SCENEMAN->AddPlane( mpUserSellBoard );
		mpUserSellBoard->SetPos( mHeadScreenPosX, mHeadScreenPosY );

		optionHeight += mpUserSellBoard->GetBoardHeight();
		showName = false;
	}

	if( mpHead == 0 )
	{
		assert( 0 );
		return;
	}

	NiPoint3 pos = this->GetWorldTranslate();
	pos.z = mpHead->GetWorldTranslate().z;
	pos.z += mHeadDist;

	NiPoint3 camPos = CAMERAMAN->GetCurrentNi()->GetWorldTranslate();

	float distCam = (pos - camPos).Length();
	float distHero = distCam;
	if( HERO )
	{
		distHero = (GetWorldTranslate() - HERO->GetPos()).Length();
	}

	/// ǳ ̱ 
	if( OPTIONMAN->IsShowBubble() )
	{
		if( mpChatBubble && mpChatBubble->IsActive() )
		{
			if( distCam <= 3000.0f)
			{
				/// ǳ 
				SCENEMAN->AddPlane( mpChatBubble );
				mpChatBubble->SetPos( mHeadScreenPosX, mHeadScreenPosY - (optionHeight+5) );

				optionHeight += mpChatBubble->GetBubbleHeight();
			}
		}
	}

	/// NameCard
	if( mpNameCard && showName == true )
	{
		if( distHero <= 1500 )
		{
			if( mShowNameGauge )
			{
				mpNameCard->SetEnableGauge( true );
				if( distHero > 500.0f )
				{
					if( HERO->GetTargetObject() != mpGameObject )
						mpNameCard->SetEnableGauge( false );
				}
			}
			else
			{
				mpNameCard->SetEnableGauge( false );
			}

			if( mpGameObject->IsDie() )
				mpNameCard->SetEnableGauge( false );

			mpNameCard->Set2DPos( mHeadScreenPosX, mHeadScreenPosY - (optionHeight+5), mFootScreenPosX, mFootScreenPosY+20 );
			SCENEMAN->AddPlane( mpNameCard );
		}
		else
		{
			mpNameCard->SetEnableGauge( false );

			/// over 
			cBaseObject* o = OBJECTMAN->GetOverObject();
			if( o == mpGameObject && distHero <= 5000 )
			{
				mpNameCard->SetEnableGauge( false );

				mpNameCard->Set2DPos( mHeadScreenPosX, mHeadScreenPosY - (optionHeight+5), mFootScreenPosX, mFootScreenPosY+20 );
				SCENEMAN->AddPlane( mpNameCard );
			}
		}
	}
}

void cPlayerSceneNode::ActiveTarotBubble( LPTSTR title, unsigned long color )
{
	if( mpTarotBoard )
		mpTarotBoard->Active( mpGameObject->GetName(), title, color, true );
}

void cPlayerSceneNode::DeActiveTarotBubble()
{
	if( mpTarotBoard )
		mpTarotBoard->DeActive();
}

void cPlayerSceneNode::ActiveUserSellBubble( LPTSTR title, unsigned long color )
{
	if( mpUserSellBoard )
		mpUserSellBoard->Active( mpGameObject->GetName(), title, color, true );
}

void cPlayerSceneNode::DeActiveUserSellBubble()
{
	if( mpUserSellBoard )
		mpUserSellBoard->DeActive();
}

void cPlayerSceneNode::UpdateLinkEffect()
{
	if( mEffectList.IsEmpty() )
		return;

	cLinkIndexList::cIterator i = mEffectList.Begin();
	cLinkIndexList::cIterator end = mEffectList.End();
	for( ; i != end; ++i )
	{
		unsigned long idx = (unsigned long)*i;
		cEffectSceneNode* n = SCENEMAN->GetEffectSceneNode( idx );
		if( n )
		{
			unsigned int dummyIdx = n->GetDummyIdx();

			if( dummyIdx != eLINK_RWEAPON && dummyIdx != eLINK_LWEAPON )
				continue;

			NiNode* parent = n->GetNiObj()->GetParent();
			NiNode* check = GetDummyObject( dummyIdx );
			if( check )
			{
				if( check != parent )
				{
					/// new dummy
					if( parent )
						parent->DetachChild( n->GetNiObj() );
					else
						n->GetNiObj()->DetachParent();

					check->AttachChild( n->GetNiObj() );
				}
			}
			else
			{
				/// hand dummy check
				if( dummyIdx == eLINK_RWEAPON )
					check = GetDummyObject( eLINK_RHAND );
				else
					check = GetDummyObject( eLINK_LHAND );

				assert(check);
				if( check )
				{
					if( check != parent )
					{
						if( parent )
							parent->DetachChild( n->GetNiObj() );
						else
							n->GetNiObj()->DetachParent();

						check->AttachChild( n->GetNiObj() );
					}
				}
			}
		}
	}

}

void cPlayerSceneNode::OnProcessVehicle( unsigned long deltaTime, unsigned long accumTime )
{
	if( mUpdateGeomInfo )
	{
		/// Clear collect info
		ClearCollectInfo();

		/// collect info
		CollectGeomInfo( GetNiObj() );

		mUpdateGeomInfo = false;
	}

	/// Ƿ  ϴ 쿡 Ѵ.
	UpdateBipedRootTransforms( accumTime );

	/// Alpha Fade In/Out ó
	ProcessAlpha( deltaTime );

	if( mAlpha < 0.000001f )
		mCheckFrustum = false;
	else
		mCheckFrustum = true;

	///  ð * ӵ 
	unsigned long delta = accumTime - mLastTime;
	delta = (unsigned long)(delta * mScaleFactor);

	/// actormanager  ð 
	if( mLastTime == ULONG_MAX )
		mScaleAccumTime = accumTime;
	else
		mScaleAccumTime += delta;

	float fScaleTime = mScaleAccumTime*0.001f;

	/// ü Update
	mpActorManager->Update( fScaleTime );

	GetNiNode()->Update( fScaleTime );

	/// 豸 
	mBoundSphere.Set( GetCenter(), GetRadius() );

	///  Ʈ 
	if( mContainer )
		mContainer->Update( this );

	ProcessTrail( accumTime - mLastTime );

	/// delete trail....
	if( mDeleteRibbonList.GetSize() )
	{
		NiTListIterator pos = mDeleteRibbonList.GetHeadPos();
		while( pos )
		{
			sTrailInfo* p = mDeleteRibbonList.GetNext(pos);
			mRibbonList.Remove(p);

			SAFE_DELETE(p);
		}
		mDeleteRibbonList.RemoveAll();
	}

	///
	if( mpChatBubble )
		mpChatBubble->Update( accumTime );

	///
	if( mNeedUpdateTransform )
	{
		mNeedUpdateTransform = false;
		mNeedUpdateShadow = true;
	}

	///  ð 
	mLastTime = accumTime;
}

bool cPlayerSceneNode::OnVisibleVehicle( bool update, NiPoint3 pos )
{
	if( SCENEMAN->IsScreenShotMode() == true )
		return false;

	if( mAlpha < 0.00001f )
		return false;

	/// ׸
	if( mpGameObject )
	{
		if( mpGameObject->IsDie() == false && mShadowGeom )
		{
			if( mAlpha > 0.00001f )
				mShadowGeom->Process( update, pos, mAlpha );

			mNeedUpdateShadow = false;
		}
	}
	return true;
}

void cPlayerSceneNode::HideHair( bool hide )
{
	if( mHideHair == hide )
		return;

	mHideHair = hide;

	NiAVObject* obj = GetPartObject( ePART_HAIR );
	if( obj )
		obj->SetAppCulled( mHideHair );

	/// Ͱ   ó
	obj = GetPartObject( ePART_EAR );
	if( obj )
		obj->SetAppCulled( mHideHair );
}



//////////////////////////////////////////////////////////////////////////
/// Hero SceneNode


cHeroSceneNode::cHeroSceneNode( eType type )
: cPlayerSceneNode( type )
, mpQuestPlane(0)
, mpNoticePlane(0)
, mpFieldTargetEffect(0)
{
	mAlphaSpeed = 4.0f;
	mFieldEffectOn = false;
	mAlpha = 1.0f;
}

cHeroSceneNode::~cHeroSceneNode()
{
	SAFE_DELETE( mpFieldTargetEffect );
	SAFE_DELETE( mpNoticePlane );
	SAFE_DELETE( mpQuestPlane );
}

bool cHeroSceneNode::Init( const cPlayerSceneNodeParam& param )
{
	if( cPlayerSceneNode::Init( param ) == false )
		return false;

	mpQuestPlane = new cCenterMsgPlane;
	if( mpQuestPlane == 0 )
	{
		assert(mpQuestPlane);
		return false;
	}

	mpNoticePlane = new cNoticeMsgPlane;
	if( mpNoticePlane == 0 )
	{
		assert(mpNoticePlane);
		return false;
	}

	mpFieldTargetEffect = new cShadowGeometry();
	if( mpFieldTargetEffect->Init( RESOURCEMAN->GetFieldTargetTexture(), 1000.0f, 1.0f ) == false )
	{
		assert(mpFieldTargetEffect);
		return false;
	}

	mAlpha = 1.0f;
	mTargetAlpha = 1.0f;

	return true;
}


void cHeroSceneNode::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	cPlayerSceneNode::OnProcess( deltaTime, accumTime );

	///
	if( mpQuestPlane )
		mpQuestPlane->Update( deltaTime );

	if( mpNoticePlane )
		mpNoticePlane->Update( deltaTime, accumTime );
}

void cHeroSceneNode::ActiveQuestText( LPCTSTR msg, unsigned long color )
{
	if( mpQuestPlane == 0 )
		return;

	if( mpHead == 0 )
	{
		assert(0);
		return;
	}

	NiPoint3 pos = mpFoot->GetWorldTranslate();
	pos.z += mpGameObject->GetStatureValue() + mHeadDist;

	mpQuestPlane->ActiveMsg( msg, pos, color );
}

void cHeroSceneNode::ActiveNoticeText( LPCTSTR msg, unsigned long color )
{
	if( mpNoticePlane == 0 )
		return;

	mpNoticePlane->ActiveMsg( msg, color );
}

void cHeroSceneNode::AddToVisibleArray()
{
#ifdef _DEVSYS
	DEVSYSTEM->mShowHero = true;
#endif 

	if( SCENEMAN->IsScreenShotMode() == true )
		return;

	cDynamicSceneNode::AddToVisibleArray();
}

void cHeroSceneNode::AddDepthPlaneObject()
{
	if( mpQuestPlane && mpQuestPlane->IsActive() )
	{
		SCENEMAN->AddPlane( mpQuestPlane );
	}

	if( mpNoticePlane && mpNoticePlane->IsActive() )
	{
		SCENEMAN->AddPlane( mpNoticePlane );
	}

	///
	bool showName = true;
	unsigned int optionHeight = 0;

	/// Ÿ &   ߰
	if( mpTarotBoard && mpTarotBoard->IsActive() )
	{
		SCENEMAN->AddPlane( mpTarotBoard );

		mpTarotBoard->SetPos( mHeadScreenPosX, mHeadScreenPosY );
		optionHeight += mpTarotBoard->GetBoardHeight()+5;

		showName = false;
	}
	else if( mpUserSellBoard && mpUserSellBoard->IsActive() )
	{
		SCENEMAN->AddPlane( mpUserSellBoard );
		mpUserSellBoard->SetPos( mHeadScreenPosX, mHeadScreenPosY );

		optionHeight += mpUserSellBoard->GetBoardHeight()+5;
		showName = false;
	}

	NiPoint3 pos = this->GetWorldTranslate();
	pos.z = mpHead->GetWorldTranslate().z;
	pos.z += mHeadDist;

	NiPoint3 camPos = CAMERAMAN->GetCurrentNi()->GetWorldTranslate();
	float distCam = (pos - camPos).Length();

	/// ǳ ̱ 
	if( OPTIONMAN->IsShowBubble() )
	{
		if( mpChatBubble && mpChatBubble->IsActive() )
		{
			/// ǳ 
			SCENEMAN->AddPlane( mpChatBubble );
			mpChatBubble->SetPos( mHeadScreenPosX, mHeadScreenPosY - (optionHeight+5) );

			optionHeight += mpChatBubble->GetBubbleHeight()+5;
		}
	}

	if( STAGEMAN->GetCurrentStage() == eStage_Select )
	{
		if( mpNameCard && showName == true )
		{
			if( mShowNameGauge )
				mpNameCard->SetEnableGauge( true );
			else
				mpNameCard->SetEnableGauge( false );

			if( mpGameObject->IsDie() )
				mpNameCard->SetEnableGauge( false );

			mpNameCard->Set2DPos( mHeadScreenPosX, mHeadScreenPosY - (optionHeight+5), mFootScreenPosX, mFootScreenPosY+20 );
			SCENEMAN->AddPlane( mpNameCard );
		}
	}
	else
	{
		if( OPTIONMAN->IsShowHeroNameCard() || OPTIONMAN->IsShowGauge() )
		{
			if( mpNameCard && showName == true )
			{
				if( mShowNameGauge )
					mpNameCard->SetEnableGauge( true );
				else
					mpNameCard->SetEnableGauge( false );

				if( mpGameObject->IsDie() )
					mpNameCard->SetEnableGauge( false );

				mpNameCard->Set2DPos( mHeadScreenPosX, mHeadScreenPosY - (optionHeight+5), mFootScreenPosX, mFootScreenPosY+20 );
				SCENEMAN->AddPlane( mpNameCard );
			}
		}
	}
}

void cHeroSceneNode::SetFieldEffRadius( float r )
{
	if( mpFieldTargetEffect == 0 )
		return;
	mpFieldTargetEffect->SetRadius( r );
}

void cHeroSceneNode::UpdateFieldTargetEffect( NiPoint3 center )
{
	if( mpFieldTargetEffect == 0 )
		return;

	mFieldEffectOn = true;
	mFieldEffectCenter = center;
}

bool cHeroSceneNode::OnVisible()
{
	bool check = cPlayerSceneNode::OnVisible();

	if( check && mFieldEffectOn )
	{
		mFieldEffectOn = false;
		mpFieldTargetEffect->Process( true, mFieldEffectCenter, 0.9f );
	}
	return check;
}