/* ====================================================================
*      :	PlayerSceneNode.h
*      :	÷̾ ĳͿ    Ѵ.
*    :	̹
*    :	2006.5
*
* ߰ :
*		߰¥ 	۾		߰
*		2006.06     ̹	    
* 
* ǻ :
* =================================================================== */
#pragma once

#include "DynamicSceneNode.h"

class cPlayer;
class cSignboard;

/// ÷̾   
class cPlayerSceneNodeParam : public cDynamicSceneNodeParam
{
public:
	cPlayerSceneNodeParam();
};

inline cPlayerSceneNodeParam::cPlayerSceneNodeParam()
{
}

/// ÷̾  
class cPlayerSceneNode : public cDynamicSceneNode
{
	friend class cSceneManager;

public:
	virtual ~cPlayerSceneNode();

	/// ʱȭ
	virtual bool Init( const cPlayerSceneNodeParam& param );

	/// Ʈ ü
	virtual bool ChangeParts( unsigned int partIdx, const char* fileName );
	virtual bool ChangeParts( unsigned int partsIdx, NiNode* pNode );

	virtual bool ChangePartsTexture( unsigned int partsIdx, const char* fileName );

	/// ̿ ü ũ
	virtual unsigned int LinkObject( unsigned int dummyIdx, const char* fileName );

	virtual NiAVObject*		GetWeaponDummy( unsigned int objectIdx, bool left );

	/// ü ߽ǥ ȯѴ.
	virtual const NiPoint3& GetObjectCenter();
	virtual const NiPoint3& GetObjectFoot();
	virtual const NiPoint3& GetObjectHead();

	/// ǳ ǥ.
	virtual void ActiveTarotBubble( LPTSTR title, unsigned long color );
	virtual void DeActiveTarotBubble();
	virtual void ActiveUserSellBubble( LPTSTR title, unsigned long color );
	virtual void DeActiveUserSellBubble();

	virtual void UpdateLinkEffect();

	virtual void OnProcessVehicle( unsigned long deltaTime, unsigned long accumTime );
	virtual bool OnVisibleVehicle( bool update, NiPoint3 pos );

	///
	virtual void AddDepthPlaneObject();

	virtual void HideHair( bool hide );

protected:
	cPlayerSceneNode( eType type = ePLAYER );

	/// ũ Ѵ.
	virtual bool		InitLinkInfo();

	/// ⺻ ִϸ̼ Ѵ.
	virtual void		InitializeRandomIdle();

	///
	virtual cObjectNameCard* CreateNameCard( cBaseObject* pObj );

	virtual void ProcessTrail( unsigned long delta );

protected:

	cSignboard*				mpTarotBoard;
	cSignboard*				mpUserSellBoard;
};


class cCenterMsgPlane;
class cNoticeMsgPlane;

///
class cHeroSceneNode : public cPlayerSceneNode
{
	friend class cSceneManager;

public:
	virtual ~cHeroSceneNode();

	/// ʱȭ
	virtual bool Init( const cPlayerSceneNodeParam& param );

	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual bool OnVisible();

	/// Ʈ Ʈ
	void ActiveQuestText( LPCTSTR msg, unsigned long color );
	void ActiveNoticeText( LPCTSTR msg, unsigned long color );

	void SetFieldEffRadius( float r );
	void UpdateFieldTargetEffect( NiPoint3 center );

	virtual void AddDepthPlaneObject();

protected:
	cHeroSceneNode( eType type = eHERO );

	///
	virtual void AddToVisibleArray();

protected:
	/// Ʈ 
	cCenterMsgPlane*		mpQuestPlane;
	cNoticeMsgPlane*		mpNoticePlane;

	cShadowGeometry*		mpFieldTargetEffect;
	bool					mFieldEffectOn;
	NiPoint3				mFieldEffectCenter;
};