#include "StdAfx.h"
#include "PushButton.h"

#include "UIEvent.h"
#include "UIImage.h"
#include "UIContainer.h"
#include "FontAgent.h"
#include "SoundSystem.h"

cPushButton::cPushButton( eUINodeType type )
: cButton( type )
{
	mPressed = false;
	mHovered = false;

	mUpColor = mDefaultColor;
	mDownColor = mDefaultColor;

	mProcessEnable = false;
}

cPushButton::~cPushButton()
{
}

void cPushButton::Hide()
{
	cUINode::Hide();
}

/// ǻ : 
void cPushButton::OnRender( cUIFontItemKeeper* pKeeper )
{
	/// ̹ 
	if( mpImage )
		mpImage->Draw();

	if( mPressed )
		pKeeper->AddFontItem( cFontAgent::eFont_UI, const_cast<LPTSTR>(mText.Cstr()), mTextPosX, mTextPosY+1, mDownColor );
	else
		pKeeper->AddFontItem( cFontAgent::eFont_UI, const_cast<LPTSTR>(mText.Cstr()), mTextPosX, mTextPosY, mUpColor );
}

/// ǻ : ȣ  ̺Ʈ  
void cPushButton::OnMouseMove( const cUIPos& )
{
}

/// ǻ : 
void cPushButton::OnMouseHovered( const cUIPos& pos )
{
	cUINode::OnMouseHovered( pos );

	mHovered = true;

	if( mPressed )
	{
		mpImage->SetTextureRect( (unsigned short)mDownOverPos.mX, (unsigned short)mDownOverPos.mY, 
								 (unsigned short)(mDownOverPos.mX + mOriginalTexWidth), (unsigned short)(mDownOverPos.mY + mOriginalTexHeight) );
	}
	else
	{
		mpImage->SetTextureRect( (unsigned short)mUpOverPos.mX, (unsigned short)mUpOverPos.mY, 
								 (unsigned short)(mUpOverPos.mX + mOriginalTexWidth), (unsigned short)(mUpOverPos.mY + mOriginalTexHeight) );
	}
}

/// ǻ : 
void cPushButton::OnMouseLeft( const cUIPos& pos )
{
	cUINode::OnMouseLeft( pos );

	mHovered = false;

	if( mPressed )
	{
		mpImage->SetTextureRect( (unsigned short)mDownPos.mX, (unsigned short)mDownPos.mY, 
								 (unsigned short)(mDownPos.mX + mOriginalTexWidth), (unsigned short)(mDownPos.mY + mOriginalTexHeight) );
	}
	else
	{
		mpImage->SetTextureRect( (unsigned short)mUpPos.mX, (unsigned short)mUpPos.mY, 
								 (unsigned short)(mUpPos.mX + mOriginalTexWidth), (unsigned short)(mUpPos.mY + mOriginalTexHeight) );
	}
}

/// ǻ : 
void cPushButton::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{	
	cUINode::OnLButtonDown( pos, ctrl, alt, shift );

	mPressed = !mPressed;

	if( mPressed )
	{
		SOUNDSYS->Play2DSound( mDownSoundIdx );

		mpImage->SetTextureRect( (unsigned short)mDownOverPos.mX, (unsigned short)mDownOverPos.mY, 
								 (unsigned short)(mDownOverPos.mX + mOriginalTexWidth), (unsigned short)(mDownOverPos.mY + mOriginalTexHeight) );
	}
	else
	{
		SOUNDSYS->Play2DSound( mUpSoundIdx );

		mpImage->SetTextureRect( (unsigned short)mUpOverPos.mX, (unsigned short)mUpOverPos.mY, 
								 (unsigned short)(mUpOverPos.mX + mOriginalTexWidth), (unsigned short)(mUpOverPos.mY + mOriginalTexHeight) );
	}

	/// ̺Ʈ ߻
	cUIEvent event;
	event.mType = eUIEVENT_PUSHBUTTON_PRESSED;
	event.mpCaller = this;
	event.mID = mID;
	mpParent->HandleEvent( event );
}

/// ǻ :
void cPushButton::OnLButtonDoubleClick( const cUIPos& pos )
{
	/// cPushButton  OnLButtonDown 
	OnLButtonDown( pos, 0, 0, 0 );
}

/// ǻ : 
void cPushButton::OnLButtonUp( const cUIPos& )
{
}

/// ǻ :
void cPushButton::SetPress( bool press )
{
	mPressed = press;

	/// ȴ ȴǴ Ǵؼ ҽ ̹ ٲ
	if( mPressed )
	{
		mpImage->SetTextureRect( (unsigned short)mDownPos.mX, (unsigned short)mDownPos.mY, 
								 (unsigned short)(mDownPos.mX + mOriginalTexWidth), (unsigned short)(mDownPos.mY + mOriginalTexHeight) );
	}
	else 
	{
		mpImage->SetTextureRect( (unsigned short)mUpPos.mX, (unsigned short)mUpPos.mY, 
								 (unsigned short)(mUpPos.mX + mOriginalTexWidth), (unsigned short)(mUpPos.mY + mOriginalTexHeight) );
	}
}
