#include "StdAfx.h"
#include "PutCardWindow.h"
#include "ItemManager.h"
#include "Label.h"
#include "GameResourceManager.h"
#include "GameUIManager.h"
#include "TipWindow.h"
#include "UIMsgboxEvent.h"
#include "ItemIcon.h"
#include "UIImage.h"
#include "ObjectManager.h"
#include "Hero.h"

cPutCardWindow::cPutCardWindow()
: mItemSlotIndex( UINT_MAX )
, mpCount( 0 )
, mItemSlot( 0 )
, mSlotCount( 0 )
{
	::memset( mCardSlot, 0, sizeof(mCardSlot) );
	::memset( mSlotImage, 0, sizeof(mSlotImage) );
	::memset( mSlotImageSkin, 0, sizeof(mSlotImageSkin) );
}

cPutCardWindow::~cPutCardWindow()
{
	for( int i = 0; i < MAX_CARD_SLOT; ++i )
		SAFE_DELETE( mSlotImage[i] );
}

///
void cPutCardWindow::Clear()
{
	mItemSlot->ChangeImage( 0 );
	mItemSlot->SetItemIndex( 0 );
	mItemSlot->SetTipType( eTOOLTIP_NONE );
	
	///   ʱȭ
	if( mItemSlotIndex <= MAX_INVENTORY )
	{
		cItem& oldItem = ITEMMAN->GetItem( mItemSlotIndex );
		oldItem.SetLock( false );
		mItemSlotIndex = UINT_MAX;
	}

	for( unsigned int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		mCardSlot[i]->ChangeImage( 0 );
		mCardSlot[i]->SetItemIndex( 0 );
		mCardSlot[i]->SetTipType( eTOOLTIP_NONE );
	}

	/// īƮ ʱȭ
	SetCount( 0 );
}

void cPutCardWindow::ShowTop(bool hideOthers, bool onsound )
{
	if( HERO->GetStopFlag() != eSTOP_ITEMMIX )
		cUIWindow::ShowTop( hideOthers, onsound );
}

void cPutCardWindow::OnShow()
{
	cUIWindow::OnShow();
	GAMEUI->HideItemSetWindow( this );
}

///
void cPutCardWindow::OnHide()
{
	cUIWindow::OnHide();

	Clear();
}

///
bool cPutCardWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpCount = (cLabel*)GetChild( eUIID_GAME_PUTCARD_COUNT );

	///   
	mItemSlot = new cItemIcon;
	if( mItemSlot->CreateBySkinName( "PutCard_ItemSlot", this, 1 ) == false )
		return false;

	mItemSlot->SetUsedFlag( false, false );
	mItemSlot->SetSlotIndex( PUTCARD_ITEM_SLOT );
	mItemSlot->SetLinked( true );		///  ̾ƴ϶ κκ  

	/// ī  
	cString str;
	unsigned int slotIndex = PUTCARD_CARD_SLOT_BEGIN;
	for( unsigned int i = 0; i < MAX_CARD_SLOT; ++i, ++slotIndex )
	{
		str.Format( "PutCard_Slot%d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, slotIndex ) == false )
			return false;

		icon->SetLinked( true );
		icon->SetSlotIndex( slotIndex );
		mCardSlot[i] = icon;
	}

	///  Ÿ ̹ б
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	NiTexture* texture = 0;
	for( unsigned int i = 0; i < MAX_CARD_SLOT-1; ++i )
	{
		str.Format( "PutCard_SlotType%d", i );
		cUINodeSkin* pSlotSkin = pSkin->GetNodeSkin( str );
		if( pSlotSkin )
		{
			mTexPos[i].mX = pSlotSkin->mSkinInfo->mTexX;
			mTexPos[i].mY = pSlotSkin->mSkinInfo->mTexY;

			texture = pSlotSkin->mpTexture;
		}
	}

	if( !texture )
	{
		assert(0);
		return false;
	}

	///  ̹ 
	for( int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		str.Format( "PutCard_SlotPos%d", i );
		mSlotImageSkin[i] = pSkin->GetNodeSkin( str );
		if( mSlotImageSkin[i] && texture )
		{
			mSlotImage[i] = new cUIImage( texture );
			unsigned int x = mSlotImageSkin[i]->mSkinInfo->mX + GetAbsoluteRect().mLeft;
			unsigned int y = mSlotImageSkin[i]->mSkinInfo->mY + GetAbsoluteRect().mTop;
			unsigned int w = mSlotImageSkin[i]->mSkinInfo->mWidth;
			unsigned int h = mSlotImageSkin[i]->mSkinInfo->mHeight;
			mSlotImage[i]->SetScreenRect( cUIRect(x, y, x+w, y+h) );
		}
	}

	///
	SetCount( 0 );

	if( !mItemSlot )
		return false;

	for( int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		if( !mCardSlot[i] )
			return false;
	}
	return true;
}

void cPutCardWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	for( unsigned int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		if( mSlotImage[i] && mSlotImageSkin[i] )
		{
			unsigned int x = mSlotImageSkin[i]->mSkinInfo->mX + GetAbsoluteRect().mLeft;
			unsigned int y = mSlotImageSkin[i]->mSkinInfo->mY + GetAbsoluteRect().mTop;
			mSlotImage[i]->SetPos( x, y );
		}
	}
}

void cPutCardWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	for( unsigned int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		if( mSlotImage[i] && mSlotImageSkin[i] )
		{
			unsigned int x = mSlotImageSkin[i]->mSkinInfo->mX + GetAbsoluteRect().mLeft;
			unsigned int y = mSlotImageSkin[i]->mSkinInfo->mY + GetAbsoluteRect().mTop;
			mSlotImage[i]->SetPos( x, y );
		}
	}
}

void cPutCardWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mVisible == false )
		return;

	/// ̹ 
	if( mpImage )
		mpImage->Draw();

	for( unsigned int i = 0; i < mSlotCount; ++i )
	{
		if( mSlotImage[i] )
			mSlotImage[i]->Draw();
	}

	/// ڽ 
	cChildList::cIterator mi = mChildList.Begin();
	cChildList::cIterator mend = mChildList.End();

	for( ; mi != mend; ++mi )
	{
		if( ((cUINode*)(*mi))->IsVisible() == true )
		{
			((cUINode*)(*mi))->OnRender(pKeeper);
		}
	}
	pKeeper->DrawAll();
}

///
void cPutCardWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_PUTCARD_CLOSE:
		Hide();
		break;
	}
}

void cPutCardWindow::OnIconHovered( cUINode* caller, unsigned int id, const cUIPos& pos )
{
	cItemIcon* hoverIcon = (cItemIcon*)caller;
	
	if( mItemSlotIndex <= MAX_INVENTORY && hoverIcon == mItemSlot )
	{
		cItem& item = ITEMMAN->GetItem( mItemSlotIndex );
		UIMAN->ShowItemTip( eTIP_ITEM, pos, item.GetIndex(), mItemSlotIndex, 0 );
	}
	else
	{
		for( int i = 0; i < MAX_CARD_SLOT; ++i )
		{
			if( hoverIcon == mCardSlot[i] )
			{
				UIMAN->ShowItemTip( eTIP_ITEM, pos, mCardSlot[i]->GetItemIndex(), UINT_MAX, 0 );
				return;
			}
		}
	}
}


/// ī  (slot0 : , slot1 :  )
bool cPutCardWindow::TestAddCard( unsigned int slot0, unsigned int slot1 )
{
	if( IsNetLock() == true )
		return false;

	if( slot0 > MAX_INVENTORY )
		return false;
		
	cItem& card = ITEMMAN->GetItem( slot0 );
	cItemDefine* cardDefine = card.GetDefine();
	if( !cardDefine )
	{
		assert(0);
		return false;
	}

	if( mItemSlotIndex > MAX_INVENTORY )
		return false;

	cItem& item = ITEMMAN->GetItem( mItemSlotIndex );
	cItemDefine* itemDefine = item.GetDefine();
	if( !itemDefine )
	{
		assert(0);
		return false;
	}

	///  ī ƴϸ 
	if( cardDefine->GetType() != ITEM_CARD )
		return false;

	///  Ÿ ī ƴϸ 
	if( !(cardDefine->GetSubType() == ITEM_CARD_EQUIP_A || 
		cardDefine->GetSubType() == ITEM_CARD_EQUIP_B || 
		cardDefine->GetSubType() == ITEM_CARD_EQUIP_AB ||
		cardDefine->GetSubType() == ITEM_CARD_EQUIP_O ) )
		return false;

	///   
	sItemPutCardSlot* data = itemDefine->GetPutCard();
	if( !data )
		return false;

	///   
	unsigned int i = slot1 - PUTCARD_CARD_SLOT_BEGIN;
	short cardType = cardDefine->GetSubType();

	/// ŸԺ
	short slotType = data->mSlotType[i];
	if( slotType == ITEM_CARD_SLOT_NONE )
		return false;

	switch( slotType )
	{
	case ITEM_CARD_SLOT_A:
		{
			if( !(cardType == ITEM_CARD_EQUIP_A || cardType == ITEM_CARD_EQUIP_O) )
				return false;
		}
		break;
	case ITEM_CARD_SLOT_B:
		{
			if( !(cardType == ITEM_CARD_EQUIP_B || cardType == ITEM_CARD_EQUIP_O) )
				return false;
		}
		break;
	case ITEM_CARD_SLOT_O:
		{
			if( cardType != ITEM_CARD_EQUIP_O )
				return false;
		}
		break;
	case ITEM_CARD_SLOT_AB:
		break;
	case ITEM_CARD_SLOT_NONE:
		return false;
	default:
		assert(0);
		return false;
	}

	int putSlot = slot1 - PUTCARD_CARD_SLOT_BEGIN + MIN_CARD_SLOT;

	/// Կ ̹ ī尡 ,
	if( mCardSlot[i]->GetItemIndex() > 0 )
		GAMEUI->ShowItemPutCard( eMBEVENT_ITEM_PUTCARD_UPDATE, slot0, putSlot, mCardSlot[i]->GetItemIndex() );
	/// Կ ο ī ,
	else
		GAMEUI->ShowItemPutCard( eMBEVENT_ITEM_PUTCARD_NEW, slot0, putSlot, 0 );
	return false;
}


/// ī  
bool cPutCardWindow::AddItem( unsigned int slotIndex )
{
	if( slotIndex > MAX_INVENTORY )
		return false;

	cItem& item = ITEMMAN->GetItem( slotIndex );
	cItemDefine* define = item.GetDefine();
	if( !define )
	{
		assert(0);
		return false;
	}

	/// ,  Ÿ ƴϸ 
	if( !(define->GetType() == ITEM_WEAPON || define->GetType() == ITEM_WEAR) )
		return false;

	///   ʱȭ
	for( unsigned int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		mCardSlot[i]->ChangeImage( 0 );
		mCardSlot[i]->SetItemIndex( 0 );
		mCardSlot[i]->SetTipType( eTOOLTIP_NONE );
	}

	/// ԰ 
	short slotCount = define->GetPutSlotCount();
	SetCount( slotCount );

	///  ̹ 
	sItemPutCardSlot* data = define->GetPutCard();
	if( data && slotCount > 0 )
	{
		cUIPos texpos;
		for( int i = 0; i < slotCount; ++i )
		{
			if( !(mSlotImage[i] && mSlotImageSkin[i]) )
			{
				assert(0);
				continue;
			}

			switch( data->mSlotType[i] )
			{
			case ITEM_CARD_SLOT_NONE:	continue;
			case ITEM_CARD_SLOT_A:	texpos = mTexPos[0]; break;
			case ITEM_CARD_SLOT_B:	texpos = mTexPos[1]; break;
			case ITEM_CARD_SLOT_AB:	texpos = mTexPos[2]; break;
			case ITEM_CARD_SLOT_O:	texpos = mTexPos[3]; break;
			}

			unsigned int w = mSlotImageSkin[i]->mSkinInfo->mWidth;
			unsigned int h = mSlotImageSkin[i]->mSkinInfo->mHeight;
			mSlotImage[i]->SetTextureRect( cUIRect(texpos.mX, texpos.mY, texpos.mX + w, texpos.mY + h ) );
		}
	}

	///     ( ī  )
	if( item.GetCardIndex1() > 0 )
	{
		mCardSlot[0]->SetItemIndex( item.GetCardIndex1() );
	}
	if( item.GetCardIndex2() > 0 )
	{
		mCardSlot[1]->SetItemIndex( item.GetCardIndex2() );
	}
	if( item.GetCardIndex3() > 0 )
	{
		mCardSlot[2]->SetItemIndex( item.GetCardIndex3() );
	}
	if( item.GetCardIndex4() > 0 )
	{
		mCardSlot[3]->SetItemIndex( item.GetCardIndex4() );
	}
	if( item.GetCardIndex5() > 0 )
	{
		mCardSlot[4]->SetItemIndex( item.GetCardIndex5() );
	}

	/// ̹ 
	for( short i = 0; i < slotCount; ++i )
	{
		cItemDefine* cardDefine = ITEMMAN->GetItemDefine( mCardSlot[i]->GetItemIndex() );
		if( cardDefine )
		{
			mCardSlot[i]->ChangeImage( cardDefine->GetIconParam() );
			mCardSlot[i]->SetTipType( cardDefine->GetTipType() );
		}
	}

	/// 
	if( mItemSlotIndex != slotIndex )
	{
		if( mItemSlotIndex <= MAX_INVENTORY )
		{
			cItem& oldItem = ITEMMAN->GetItem( mItemSlotIndex );
			oldItem.SetLock( false );
		}

		///   ε
		mItemSlotIndex = slotIndex;
		item.SetLock( true );
	}

	///  ̹ ü
	mItemSlot->SetItemIndex( item.GetIndex() );
	mItemSlot->ChangeImage( define->GetIconParam() );
	mItemSlot->SetTipType( define->GetTipType() );
	return true;
}

///  ī 
bool cPutCardWindow::AddCard( sInventory& inv )
{
	if( inv.cardSlot1 > 0 )
		mCardSlot[0]->SetItemIndex( inv.cardSlot1 );
	if( inv.cardSlot2 > 0 )
		mCardSlot[1]->SetItemIndex( inv.cardSlot2 );
	if( inv.cardSlot3 > 0 )
		mCardSlot[2]->SetItemIndex( inv.cardSlot3 );
	if( inv.cardSlot4 > 0 )
		mCardSlot[3]->SetItemIndex( inv.cardSlot4 );
	if( inv.cardSlot5 > 0 )
		mCardSlot[4]->SetItemIndex( inv.cardSlot5 );

	/// ̹ 
	for( unsigned int i = 0; i < MAX_CARD_SLOT; ++i )
	{
		cItemDefine* cardDefine = ITEMMAN->GetItemDefine( mCardSlot[i]->GetItemIndex() );
		if( cardDefine )
		{
			mCardSlot[i]->ChangeImage( cardDefine->GetIconParam() );
			mCardSlot[i]->SetTipType( cardDefine->GetTipType() );
		}
	}
	return true;
}

/// ԰ 
void cPutCardWindow::SetCount( short count )
{
	mSlotCount = count;

	if( mpCount )
	{
		cStringT str;
		str.Format( _T("%d"), count );

		mpCount->SetText( (LPCTSTR)str.Cstr() );
	}
}
