#include "stdafx.h"
#include "QuestManager.h"

#include "UIFuncText.h"
#include "Protocol.h"
#include "ChatManager.h"
#include "GameUIManager.h"
#include "QuestWindow.h"
#include "UIMsgboxEvent.h"
#include "UIFuncText.h"
#include "NpcWindow.h"
#include "NpcRewardWindow.h"
#include "QuestSimpleWindow.h"
#include "ItemManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "Npc.h"
#include "Application.h"
#include "StageManager.h"
#include "TriggerManager.h"

cQuestManager* cQuestManager::mpSingleton = 0;

cQuestManager::cQuestManager()
: mpQuestText(0)
, mTotalKeepCount(0)
, mCompleteCount(0)
, mProgressCount(0)
, mCheckQuestIndex(-1)
, mTimeMap( 64 )
, mNetLock( false )
, mLockTry( eLOCK_QUESTNONE )
, mTempQuestIndex(0)
, mTempNpcIndex(0)
, mTempArrIndex(0)
{
	assert( mpSingleton == 0 && "bad singleton!" );
	mpSingleton = this;

	memset( mQuest, 0, sizeof(sQuestList) * MAX_KEEPQUEST );
}

cQuestManager::~cQuestManager()
{
	SAFE_DELETE( mpQuestText );

	/// 
	cQuestDefineMap::cIterator i = mQuestDefine.Begin();
	cQuestDefineMap::cIterator end = mQuestDefine.End();

	for( ; i != end; ++i )
	{
		cQuestDefine* p = (cQuestDefine*)(i->mSecond);

		SAFE_DELETE( p );
	}
	mQuestDefine.Clear();

	/// ð Ŭ
	ClearQuestTime();
}

/// ð Ŭ
void cQuestManager::ClearQuestTime()
{
	cTimeMap::cIterator b = mTimeMap.Begin();
	cTimeMap::cIterator end = mTimeMap.End();

	for( ; b != end; ++b )
	{
		sQuestTime* data = (sQuestTime*)(b->mSecond);
		SAFE_DELETE( data );
	}
	mTimeMap.Clear();
}

void cQuestManager::Close()
{
	/// ü
	memset( mQuest, 0, sizeof(mQuest) );
	mTotalKeepCount = 0;
	mCompleteCount = 0;
	mProgressCount = 0;

	mNetLock = false;
	mLockTry = eLOCK_QUESTNONE;

	/// ð Ŭ
	{
		cTimeMap::cIterator b = mTimeMap.Begin();
		cTimeMap::cIterator end = mTimeMap.End();

		for( ; b != end; ++b )
		{
			sQuestTime* data = (sQuestTime*)(b->mSecond);
			SAFE_DELETE( data );
		}
		mTimeMap.Clear();
	}

	///
	mCountMap.Clear();
}

bool cQuestManager::Init()
{
	mpQuestText = new cUIFuncText;

	/// Ʈ  ڿ ε
	if( mpQuestText->Load( "./Script/Language/Quest_Note.txt" ) == false )
	{
		assert( 0 && "failed to load quest description" );
		return false;
	}

	/// Ʈ  ε
	if( Load( "./Script/Resource/List_Quest.txt"  ) == false )
	{
		assert( 0 && "failed to load quest script" );
		return false;
	}
	return true;
}

const cUIFuncTextNode* cQuestManager::GetNpcTextNode( unsigned int textid )
{
	return mpQuestText->GetNode( textid );
}

void cQuestManager::OpenLoad()
{
	/// س  
	mSelectSet.Clear();
	UpdateUIAll();

	GAMEUI->ApplyWinodwOption_Character();
}

void cQuestManager::OpenMapChange()
{
	UpdateUIAll();
}

/// Ʈ 츸  - quest add
void cQuestManager::UpdateUI()
{
	cQuestWindow* window = GAMEUI->GetQuestWindow();
	if( !window )
	{
		assert( 0 && "error quest ui" );
		return;
	}

	/// UI   
	window->Clear();

	///
	for( unsigned int i = 0; i < mTotalKeepCount; ++i )
	{
		cQuestDefine* define = GetQuestDefine( mQuest[i].questIdx );
		if( define )
			window->AddQuest( i, mQuest[i].questIdx, (mQuest[i].check == define->mComplete) );
	}

	///  
	CheckQuestCount();
}

/// Ʈ UI Ʈ  - quest list
void cQuestManager::UpdateUIAll() 
{
	cQuestWindow* window = GAMEUI->GetQuestWindow();
	cQuestSimpleWindow* simple = GAMEUI->GetQuestSimpleWindow();
	if( !window || !simple )
	{
		assert( 0 && "error quest ui" );
		return;
	}

	/// UI   
	window->Clear();
	simple->Clear();
	simple->Hide();

	///
	for( unsigned int i = 0; i < mTotalKeepCount; ++i )
	{
		cQuestDefine* define = GetQuestDefine( mQuest[i].questIdx );
		if( !define )
		{
			assert(0);
			continue;
		}

		window->AddQuest( i, mQuest[i].questIdx, (mQuest[i].check == define->mComplete) );

		if( IsSelectQuest( mQuest[i].questIdx ) == true )
			simple->AddQuestInfo( mQuest[i].questIdx, &mQuest[i].check );
	}

	///  
	CheckQuestCount();
}

/// Ʈ , Ϸᰡ  
void cQuestManager::CheckQuestCount()
{
	mCompleteCount = 0;
	mProgressCount = 0;
	for( unsigned int i = 0; i < mTotalKeepCount; ++i )
	{
		cQuestDefine* define = GetQuestDefine( mQuest[i].questIdx );
		if( !define )
		{
			assert(0);
			continue;
		}

		/// Ϸᰡ,   üũ
		if( mQuest[i].check >= define->mComplete )
			mCompleteCount++;
		else
			mProgressCount++;
	}

	///   ˻
	if( mTotalKeepCount < mCompleteCount + mProgressCount )
	{
		assert(0);
		return;
	}

	/// UI Ʈ
	cQuestWindow* window = GAMEUI->GetQuestWindow();
	if( window )
		window->UpdateCount( mProgressCount, mCompleteCount );
}

void cQuestManager::UpdateNpcQuest( unsigned long npcId, unsigned int status )
{
	/// npc 쿡 Ʈ з 
	cNpcWindow* pNpcWindow = GAMEUI->GetNpcWindow();
	if( !pNpcWindow )
	{
		assert(0);
		return;
	}

	if( mTotalKeepCount == 0 )
		return;

	if( status == eNPCQUEST_PLAYING )
	{
		/// 
		for( unsigned int i = 0; i < mTotalKeepCount; ++i )
		{
			cQuestDefine* define = GetQuestDefine( mQuest[i].questIdx );
			if( define && define->mTakeNpcIndex == npcId )
			{
				if( mQuest[i].status == eQUEST_PLAYING && mQuest[i].check < define->mComplete )
					pNpcWindow->AddQuest( mQuest[i].questIdx, eNPCQUEST_PLAYING );
			}
		}
	}
	else
	{
		/// 󰡴
		for( unsigned int i = 0; i < mTotalKeepCount; ++i )
		{
			cQuestDefine* define = GetQuestDefine( mQuest[i].questIdx );
			if( define && define->mTakeNpcIndex == npcId )
			{
				if( mQuest[i].status == eQUEST_COMPLETE )
					pNpcWindow->AddQuest( mQuest[i].questIdx, eNPCQUEST_REWARD );
			}
		}

		/// Ϸᰡ
		for( unsigned int i = 0; i < mTotalKeepCount; ++i )
		{
			cQuestDefine* define = GetQuestDefine( mQuest[i].questIdx );
			if( define && define->mTakeNpcIndex == npcId )
			{
				if( mQuest[i].status == eQUEST_PLAYING && mQuest[i].check >= define->mComplete )
					pNpcWindow->AddQuest( mQuest[i].questIdx, eNPCQUEST_COMPLETE );
			}
		}
	}
}

/// Ʈ ű ߰
bool cQuestManager::QuestAddByNpc( unsigned long questIdx, unsigned long npcIndex )
{
	if( IsNetLock() )
		return false;

	/// ȿ ˻
	cQuestDefine* define = GetQuestDefine( questIdx );
	if( !define )
	{
		assert(0);
		return false;	
	}

	/// ̹  Ʈ ˻
	int arrIdx = GetQuestArrIdx( questIdx );
	if( arrIdx != -1 )
	{
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 402 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		return false;
	}

	MSG_REQ_QUEST_ADD msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_NPC;
	msg.Protocol = NM_NPC_QUEST_ADD_REQ;
	msg.questIndex = questIdx;
	msg.npcIndex = npcIndex;
	msg.type = eQUESTADD_NPC;

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// ɱ
	NetLock( eLOCK_QUESTADD );
	return true;
}

bool cQuestManager::QuestAdd( unsigned long questIdx )
{
	if( IsNetLock() )
		return false;

	/// ȿ ˻
	cQuestDefine* define = GetQuestDefine( questIdx );
	if( !define )
	{
		assert(0);
		return false;	
	}

	/// ̹  Ʈ ˻
	int arrIdx = GetQuestArrIdx( questIdx );
	if( arrIdx != -1 )
	{
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 402 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		return false;
	}

	MSG_REQ_QUEST_ADD msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_QUEST;
	msg.Protocol = NM_QUEST_ADD_REQ;
	msg.questIndex = questIdx;
	msg.type = eQUESTADD_ETC;

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// ɱ
	NetLock( eLOCK_QUESTADD );
	return true;
}

bool cQuestManager::QuestAddByItem( unsigned int number )
{
	if( IsNetLock() )
		return false;

	cItem& item = ITEMMAN->GetItem( number );
	cItemDefine* itemDefine = ITEMMAN->GetItemDefine( item.GetIndex() );
	if( !itemDefine )
	{
		assert(0);
		return false;
	}

	cItemAbility* itemAbil = itemDefine->GetAbililty();
	if( !itemAbil )
	{
		assert(0);
		return false;
	}

	long questIndex = itemAbil->GetInfluenceIndex();
	if( questIndex <= 0 )
	{
		assert(0);
		return false;
	}

	/// 
	cQuestDefine* define = GetQuestDefine( questIndex );
	if( !define )
	{
		assert(0);
		return false;	
	}

	/// ̹  Ʈ ˻
	int arrIdx = GetQuestArrIdx( questIndex );
	if( arrIdx != -1 )
	{
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 402 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		return false;
	}

	/// Ƿھ ̿ Ʈ ο
	MSG_REQ_QUEST_ADDBYITEM msg;
	::memset( &msg, 0, sizeof(msg) );

	msg.Category = NM_QUEST;
	msg.Protocol = NM_QUEST_ADDBYITEM_REQ;
	msg.number = (unsigned int)number;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// Ʈ 
	NetLock( eLOCK_QUESTADDBYITEM, number );
	return true;
}

/// Ʈ  - Ʈ ui 
void cQuestManager::QuestDelete( unsigned int arrIdx )
{
	if( IsNetLock() )
		return;

	if( mTotalKeepCount == 0 )
		return;

	/// 迭 ũ 
	if( arrIdx >= mTotalKeepCount )
	{
		assert(0);
		return;
	}

	///  Ʈ ƴ
	if( mQuest[arrIdx].questIdx == 0 )
	{
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 407 ),
			GAMERESOURCEMAN->GetGameText( 301 ),
			eSKIN_OK
			);
		return;
	}

	MSG_REQ_QUEST_DEL msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_QUEST;
	msg.Protocol = NM_QUEST_DEL_REQ;
	msg.arrayIdx = arrIdx;
	msg.questIndex = mQuest[arrIdx].questIdx;

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// 
	mCheckQuestIndex = mQuest[arrIdx].questIdx;
	NetLock( eLOCK_QUESTDELETE );
}

void cQuestManager::QuestDeleteAuto( unsigned int arrIdx )
{
	if( IsNetLock() )
		return;

	if( mTotalKeepCount == 0 )
		return;

	/// 迭 ũ 
	if( arrIdx >= mTotalKeepCount )
	{
		assert(0);
		return;
	}

	///  Ʈ ƴ
	if( mQuest[arrIdx].questIdx == 0 )
	{
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 407 ),
			GAMERESOURCEMAN->GetGameText( 301 ),
			eSKIN_OK
			);
		return;
	}

	MSG_REQ_QUEST_DELAUTO msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_QUEST;
	msg.Protocol = NM_QUEST_DELAUTO_REQ;
	msg.arrayIdx = arrIdx;
	msg.questIndex = mQuest[arrIdx].questIdx;

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// 
	mCheckQuestIndex = mQuest[arrIdx].questIdx;
	NetLock( eLOCK_QUESTDELETE );
}

/// Ʈ Ϸû
bool cQuestManager::QuestComplete( unsigned long questIdx, unsigned long npcIndex )
{
	if( IsNetLock() )
		return false;

	cQuestDefine* define = GetQuestDefine( questIdx );
	if( !define )
	{
		assert(0);
		return false;	
	}

	///  Ʈ ˻
	int arrIdx = GetQuestArrIdx( questIdx );
	if( arrIdx == -1 )
	{
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 407 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		return false;
	}

	/// Ϸᰡ  ˻
	if( mQuest[arrIdx].status != eQUEST_PLAYING )
	{
		/// ̹ Ϸ Ʈ
		if( mQuest[arrIdx].status == eQUEST_COMPLETE )
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 428 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK
								);
		}
		///   ߸ 
		else
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 426 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK
								);
		}
		return false;
	}

	///
	if( define->mDefaultReward )
	{
		cQuestReward* reward = define->mDefaultReward;

		TCHAR temp[256]={0,};

		///   ˻
		if( reward->mChangeJobIndex > 0 )
		{
			LPCTSTR jobStr = GAMERESOURCEMAN->GetJobName( reward->mChangeJobIndex );
			::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 435 ), jobStr );

			mTempQuestIndex = questIdx;
			mTempNpcIndex = npcIndex;
			mTempArrIndex = arrIdx;

			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_QUEST_REWARDJOB, 
				temp,
				GAMERESOURCEMAN->GetGameText( 301 ),
				eSKIN_YESNO
				);
			return true;
		}
		///   ˻
		else if( reward->mForceType != eFORCETYPE_NONE )
		{
			int textIdx = 0;
			switch( reward->mForceType )
			{
			case eFORCETYPE_NONE:	textIdx = 119;	break;
			case eFORCETYPE_FIRE:	textIdx = 120;	break;
			case eFORCETYPE_WATER:  textIdx = 121;	break;
			case eFORCETYPE_WIND:	textIdx = 122;	break;
			case eFORCETYPE_EARTH:	textIdx = 123;	break;
			default: assert(0); return false;
			}

			LPCTSTR forceStr = UIMAN->GetUIText( textIdx );
			::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 436 ), forceStr );
			
			mTempQuestIndex = questIdx;
			mTempNpcIndex = npcIndex;
			mTempArrIndex = arrIdx;

			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_QUEST_REWARDJOB, 
				temp,
				GAMERESOURCEMAN->GetGameText( 301 ),
				eSKIN_YESNO
				);
			return true;
		}
	}
	
	/// 
	MSG_REQ_NPC_QUEST_COMPLETE msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_NPC;
	msg.Protocol = NM_NPC_QUEST_COMPLETE_REQ;
	msg.arrayIdx = arrIdx;
	msg.questIndex = questIdx;
	msg.npcIndex = npcIndex;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// 
	mCheckQuestIndex = questIdx;

	NetLock( eLOCK_QUESTCOMPLETE );
	return true;
}

bool cQuestManager::QuestComplete()
{
	if( !(mTempQuestIndex > 0 && mTempNpcIndex > 0) )
	{
		assert(0);
		return false;
	}

	/// 
	MSG_REQ_NPC_QUEST_COMPLETE msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_NPC;
	msg.Protocol = NM_NPC_QUEST_COMPLETE_REQ;
	msg.arrayIdx = mTempArrIndex;
	msg.questIndex = mTempQuestIndex;
	msg.npcIndex = mTempNpcIndex;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// 
	mCheckQuestIndex = mTempQuestIndex;

	mTempQuestIndex = 0;
	mTempNpcIndex = 0;
	mTempArrIndex = 0;

	NetLock( eLOCK_QUESTCOMPLETE );
	return true;
}

bool cQuestManager::QuestReward( unsigned long questIdx, unsigned long npcIndex )
{
	if( IsNetLock() )
		return false;

	cQuestDefine* define = GetQuestDefine( questIdx );
	if( !define )
	{
		assert(0);
		return false;	
	}

	///  Ʈ ˻
	int arrIdx = GetQuestArrIdx( questIdx );
	if( arrIdx == -1 )
	{
		UIMAN->CreateModal(	eStage_Game,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 407 ),
			GAMERESOURCEMAN->GetGameText( 301 ),
			eSKIN_OK
			);
		return false;
	}

	/// ϷḦ ģ Ʈ ˻
	if( mQuest[arrIdx].status != eQUEST_COMPLETE )
	{
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 427 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		return false;
	}

	cNpcRewardWindow* pReward = GAMEUI->GetNpcRewardWindow();
	if( !pReward )
	{
		assert(0);
		return false;
	}

	///   ˻
	if( define->mSelectCount != pReward->GetSelectCount() )
	{
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 413 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		return false;
	}

	/// ԰˻
	unsigned int weight = 0;
	cQuestReward* defaultReward = define->mDefaultReward;
	if( defaultReward )
	{
		for( int i = 0; i < 5; ++i )
		{
			sQuestItem& item = defaultReward->mRewardItem[i];
			if( item.itemIndex == 0 )
				break;

			cItemDefine* itemDefine = ITEMMAN->GetItemDefine( item.itemIndex );
			if( itemDefine )
				weight += (itemDefine->GetWeight() * item.count);
		}		
	}

	///   
	sRewardData selectData[5];
	long rowCount = 0;

	if( define->mSelectCount > 0 )
	{
		///   
		sRewardIcon* data = pReward->GetSelectData();
		for( unsigned int i = 0; i < 5; ++i, ++data )
		{
			cIcon* icon = data->icon;
			if( icon && data->select == true )
			{
				selectData[rowCount].type = ( icon->GetIconType() == eICON_ITEM )? eREWARD_ITEM : eREWARD_SKILL;
				selectData[rowCount].index = data->index;

				///  ջ
				cItemDefine* itemDefine = ITEMMAN->GetItemDefine( data->index );
				if( itemDefine )
					weight += (itemDefine->GetWeight() * icon->GetNumber() );

				if( rowCount < define->mSelectCount )
					rowCount++;
			}
		}
	}

	if( weight > HERO->GetMaxWeight() )
	{
		/// ԰ Ǯ
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 201 ),	// ԰ Ǯ
							GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
							eSKIN_OK
							);
		return false;
	}

	/// 
	MSG_REQ_NPC_QUEST_REWARD msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_NPC;
	msg.Protocol = NM_NPC_QUEST_REWARD_REQ;
	msg.arrayIdx = arrIdx;
	msg.questIndex = questIdx;
	msg.npcIndex = npcIndex;
	msg.rowCount = pReward->GetSelectCount();

	if( define->mSelectCount > 0 )
	{
		for( long i = 0; i < rowCount; ++i )
		{
			msg.table[i].type = selectData[i].type;
			msg.table[i].index = selectData[i].index;
		}
	}

	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(MSG_REQ_NPC_QUEST_REWARD) );

	/// 
	mCheckQuestIndex = questIdx;
	NetLock( eLOCK_QUESTREWARD );
	return true;
}


/// űƮ Ʈ û
void cQuestManager::QuestNewListReSend( unsigned long npcIndex )
{	
	MSG_REQ_NPC_QUESTLIST_RESEND msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_NPC;
	msg.Protocol = NM_NPC_QUESTLIST_RESEND_REQ;
	msg.npcIndex = npcIndex;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(MSG_REQ_NPC_QUESTLIST_RESEND) );

	/// ɱ
}

/// ű Ʈ  
void cQuestManager::ResQuestAdd( MSG_RES_QUEST_ADD* pmsg )
{
	switch( pmsg->ErrorCode )
	{
	case ERROR_QUEST_ADD_SUCCESS:
		{
			sQuestList* table = &pmsg->table;
			sQuestList* quest = mQuest + mTotalKeepCount;

			/// 
			(*quest) = (*table);
			mTotalKeepCount++;

			/// UI Ʈ
			UpdateUI();

			///  ʿ Ե Ʈ  
			CheckCountMap();

			///  ߰ Ʈ ⺻ ó
			AddQuestSelect( table->questIdx, true );
			
			/// NPC  
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->UpdateDialog();

			///
			CHATMANAGER->AddSystemMsg( eSYSTEM_QUEST, GAMERESOURCEMAN->GetGameText( 400 ) );

			/// ð 
			if( quest->status == eQUEST_PLAYING )
				AddQuestTime( quest->questIdx, quest->restTime );

			/// Ʈ ű ȹ ȿ
			NiTransform trans;
			trans.MakeIdentity();
			trans.m_Translate = NiPoint3( 0.0f, 0.0f, 0.0f );
			HERO->SetLinkdEffect( eLINK_BODY, "./Data/Effect/Eff_PC_Get_04.nif", &trans, false, false );
		}
		break;
	case ERROR_QUEST_ADD_FAIL:		//  - ˼  
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 401 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	case ERROR_QUEST_ADD_NOTYET:	//  - DB 
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 401 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	case ERROR_QUEST_ADD_EXIST:		//  - ̹ ش Ʈ 
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 402 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;	
	case ERROR_QUEST_ADD_COMPLETE:	//  - ̹ Ϸ Ʈ
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 403 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	case ERROR_QUEST_ADD_TRIGGER:	//  - Ʈ   ȵ
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 404 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	case ERROR_QUEST_ADD_MAX:		//  - Ʈ  FULL 
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 405 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	case ERROR_QUEST_ADD_ITEM:		///  - κ 
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 409 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	default:
		assert(0);
		break;
	}

	NetUnLock( eLOCK_QUESTADD );
}

/// Ʈ Ϸ û 
void cQuestManager::ResQuestComplete( MSG_RES_NPC_QUEST_COMPLETE* pmsg )
{
	switch( pmsg->ErrorCode )
	{
	case ERROR_QUEST_COMPLETE_SUCCESS:		//  -  Ϸ û 
		{
			///   
			sQuestList* quest = mQuest + pmsg->arrayIdx;
			if( quest->questIdx > 0 )
			{
				quest->status = pmsg->status;

				/// Ϸ
				CHATMANAGER->AddSystemMsg( eSYSTEM_QUEST, GAMERESOURCEMAN->GetGameText( 406 ) );

				/// ȭ  ѱ ( Ϸ  )
				cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
				if( npcWin )
					npcWin->UpdateDialog();

				/// Ʈ Ϸ ȿ
				HERO->SetLinkdEffect( eLINK_BODY, "./Data/Effect/Eff_PC_Get_05.nif", 0 );
			}
		}
		break;
	case ERROR_QUEST_COMPLETE_NOTYET:		//  - DB 
	case ERROR_QUEST_COMPLETE_FAIL:			//  - 
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 424 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	case ERROR_QUEST_COMPLETE_POSSIBLE:		//  - Ϸ ƴ
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 421 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	case ERROR_QUEST_COMPLETE_TAKE:			//  -  ȸ 
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 423 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	case ERROR_QUEST_COMPLETE_NPC:			//  - NPC 
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 420 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	case ERROR_QUEST_COMPLETE_TIME:			//  - ð 
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 425 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK
								);
		}
		break;
	case ERROR_QUEST_COMPLETE_ALREADY:		//  - ̹ Ϸ Ʈ
		UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 424 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
		break;
	}

	NetUnLock( eLOCK_QUESTCOMPLETE );
	
	/// ʱȭ
	mCheckQuestIndex = -1;
}

/// Ʈ  û 
void cQuestManager::ResQuestReward( MSG_RES_NPC_QUEST_REWARD* pmsg )
{
	switch( pmsg->ErrorCode )
	{
	case ERROR_QUEST_REWARD_SUCCESS:	//  - Ϸ û 
		{
			/// NPC  
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->UpdateDialog();
			
			CHATMANAGER->AddSystemMsg( eSYSTEM_QUEST, GAMERESOURCEMAN->GetGameText( 429 ) );
		}
		break;
	case ERROR_QUEST_REWARD_NOTYET:		//  - DB 
	case ERROR_QUEST_REWARD_FAIL:		//  - 
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 424 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK
								);
		}
		break;
	case ERROR_QUEST_REWARD_ITEM:		//  -    
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 422 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK
								);
		}
		break;
	case ERROR_QUEST_REWARD_MONEY:		//  -  ݾ  
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 414 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK
								);
		}
		break;
	case ERROR_QUEST_REWARD_COUNT:		//  - ð 
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 413 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK
								);
		}
		break;
	case ERROR_QUEST_REWARD_NPC:		//  - NPC 
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 420 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK
								);
		}
		break;
	default:
		assert(0);
		break;
	}

	NetUnLock( eLOCK_QUESTREWARD );
	
	/// ʱȭ
	mCheckQuestIndex = -1;
}

/// Load, MapChange ÿ  ޼ ó
void cQuestManager::NetworkMsgParserLoad( char* msg )
{
	MSGROOT* tempMsg = (MSGROOT*)msg;

	if( tempMsg->Protocol == NM_QUEST_LIST_RES )
	{
		MSG_RES_QUEST_LIST* pmsg = (MSG_RES_QUEST_LIST*)msg;

		/// ʱȭ
		memset( mQuest, 0, sizeof(mQuest) );
		ClearQuestTime();

		mTotalKeepCount = 0;
		mCompleteCount = 0;
		mProgressCount = 0;

		if( pmsg->rowCount > 0 )
		{
			/// ӽû
			sQuestList* quest = mQuest;
			sQuestList* table = pmsg->table;
			for( int i = 0; i < pmsg->rowCount; i++, table++, quest++ )
			{
				(*quest) = (*table);

				/// ðʿ 
				if( quest->status == eQUEST_PLAYING )
					AddQuestTime( quest->questIdx, quest->restTime );
			}

			mTotalKeepCount = pmsg->rowCount;

			///  ʿ Ե Ʈ  
			CheckCountMap();
		}
	}
}

///
void cQuestManager::NetworkMsgParser( char* msg )
{
	MSGROOT* tempMsg = (MSGROOT*)msg;

	switch( tempMsg->Protocol )
	{
	case NM_QUEST_ADD_RES:
		{
			MSG_RES_QUEST_ADD* pmsg = (MSG_RES_QUEST_ADD*)msg;

			/// Ʈ  
			ResQuestAdd( pmsg );
		}
		break;
	case NM_QUEST_LIST_RES:		/// ƮƮ, Ʈ  ´
		{
			MSG_RES_QUEST_LIST* pmsg = (MSG_RES_QUEST_LIST*)msg;

			/// ʱȭ
			memset( mQuest, 0, sizeof(mQuest) );
			mTotalKeepCount = 0;

			if( pmsg->rowCount > 0 )
			{
				/// ӽû
				sQuestList* quest = mQuest;
				sQuestList* table = pmsg->table;
				for( int i = 0; i < pmsg->rowCount; i++, table++ )
				{
					(*quest) = (*table);
					quest++;
				}

				mTotalKeepCount = pmsg->rowCount;
			}

			///  ʿ Ե Ʈ  
			CheckCountMap();

			/// UI Ʈ
			UpdateUIAll();
		}
		break;
	case NM_QUEST_UPDATE_RES:
		{
			/// Ʈ  Ʈ 
			MSG_RES_QUEST_UPDATE* pmsg = (MSG_RES_QUEST_UPDATE*)msg;

			cQuestWindow* window = GAMEUI->GetQuestWindow();

			sQuestList* table = pmsg->table;
			for( int i = 0; i < pmsg->rowCount; i++, table++ )
			{
				sQuestList* quest = mQuest + pmsg->table[i].arrIdx;

				/// Ʈ   
				ActiveQuestText( quest, table );

				/// Ʈ
				(*quest) = (*table);

				/// UI 
				cQuestDefine* define = GetQuestDefine( quest->questIdx );
				if( window && define )
				{
					/// Ϸ Ʈ̸ Ʈ Ʈ 
					if( quest->check == define->mComplete )
						window->SetCompleteQuest( quest->arrIdx, quest->questIdx );
				}
			}

			///  
			CheckQuestCount();
		}
		break;
	case NM_QUEST_DEL_RES:
		{
			/// Ʈ  û  
			MSG_RES_QUEST_DEL* pmsg = (MSG_RES_QUEST_DEL*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_QUEST_DEL_SUCCESS:
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_QUEST, GAMERESOURCEMAN->GetGameText( 410 ) );

					/// ð 
					if( mCheckQuestIndex > -1 )
						DeleteQuestTime( mCheckQuestIndex );
				}
				break;
			case ERROR_QUEST_DEL_NOTYET:	//  - DB 
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 411 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_DEL_FAIL:		//  - 
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 411 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_DEL_QUEST:		//  - ߸ Ʈ
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 412 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			default:
				assert(0);
				break;
			}

			NetUnLock( eLOCK_QUESTDELETE );
			/// ʱȭ
			mCheckQuestIndex = -1;
		}
		break;
	case NM_QUEST_DELAUTO_RES:	/// ð  ڵ
		{
			/// Ʈ  û  
			MSG_RES_QUEST_DEL* pmsg = (MSG_RES_QUEST_DEL*)msg;

			/// ڵ   ˸
			if( pmsg->ErrorCode == ERROR_QUEST_DELAUTO_SUCCESS )
			{
				cStringT str;
				str.Format( GAMERESOURCEMAN->GetGameText( 415 ), GAMERESOURCEMAN->GetQuestTitle( mCheckQuestIndex ));
				CHATMANAGER->AddSystemMsg( eSYSTEM_QUEST, (LPCTSTR)str.Cstr() );

				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					(LPCTSTR)str.Cstr(),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);

				/// ð 
				if( mCheckQuestIndex > -1 )
					DeleteQuestTime( mCheckQuestIndex );

				cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
				if( npcWin && npcWin->IsVisible() == true )
					npcWin->Hide();

				/// Ʈ  ȿ
				HERO->SetLinkdEffect( eLINK_FOOT, "./Data/Effect/Eff_Mon_Regen_01.nif", 0 );
			}
			else
			{
				assert(0);
			}

			NetUnLock( eLOCK_QUESTDELETE );
			/// ʱȭ
			mCheckQuestIndex = -1;
		}
		break;
	case NM_QUEST_ADDBYITEM_RES:
		{
			/// Ƿھ Ʈ ο
			MSG_RES_QUEST_ADDBYITEM* pmsg = (MSG_RES_QUEST_ADDBYITEM*)msg;

			switch( pmsg->ErrorCode )
			{
			case ERROR_QUEST_ADDBYITEM_SUCCESS:	//  - Ƿھ 
				{
					sQuestList* table = &pmsg->table;
					sQuestList* quest = mQuest + mTotalKeepCount;

					/// 
					(*quest) = (*table);
					mTotalKeepCount++;

					UpdateUI();

					///  ʿ Ե Ʈ  
					CheckCountMap();

					///  ߰ Ʈ ⺻ ó
					AddQuestSelect( table->questIdx, true );                 

					CHATMANAGER->AddSystemMsg( eSYSTEM_QUEST, GAMERESOURCEMAN->GetGameText( 400 ) );

					/// ð 
					if( quest->status == eQUEST_PLAYING )
						AddQuestTime( quest->questIdx, quest->restTime );

					/// Ʈ   
					ITEMMAN->DeleteQuestInsertItem();

					/// Ʈ ű ȹ ȿ
					NiTransform trans;
					trans.MakeIdentity();
					trans.m_Translate = NiPoint3( 0.0f, 0.0f, 0.0f );
					HERO->SetLinkdEffect( eLINK_HEAD, "./Data/Effect/Eff_PC_Get_02.nif", &trans, false, false );
				}
				break;
			case ERROR_QUEST_ADDBYITEM_NOTYET:	//  - DB 
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 401 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_ADDBYITEM_FAIL:	//  - Ʈ
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 401 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_ADDBYITEM_ITEMFAIL:	//  - 
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 225 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_ADDBYITEM_COOLTIME:	//  -  Ÿ
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 226 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_ADDBYITEM_EXIST:		//  - ̹ ش Ʈ 
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 402 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_ADDBYITEM_COMPLETE:	//  - ̹ Ϸ Ʈ
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 403 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_ADDBYITEM_TRIGGER:		//  - Ʈ   ȵ
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 404 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_ADDBYITEM_MAX:			//  - Ʈ  FULL 
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 405 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			case ERROR_QUEST_ADDBYITEM_ITEM:		//  - Ʈ   
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 409 ),
					GAMERESOURCEMAN->GetGameText( 301 ),
					eSKIN_OK
					);
				break;
			default:
				assert(0);
				break;
			}

			/// Ʈ 
			NetUnLock( eLOCK_QUESTADDBYITEM );
		}
		break;
	default:
		assert(0);
		break;
	}
}

/// 
void cQuestManager::ActiveQuestText( sQuestList* oldQuest, sQuestList* newQuest )
{
	if( !oldQuest || !newQuest )
	{
		assert(0);
		return;
	}

	if( oldQuest->questIdx != newQuest->questIdx )
	{
		assert(0);
		return;
	}

	/// Ʈ 
	cQuestDefine* define = GetQuestDefine( oldQuest->questIdx );
	if( !define )
	{
		assert(0);
		return;
	}

	cQuestDuty* duty = define->mQuestDuty;
	if( !duty )
		return;

	/// ޶  Ѵ
	if( oldQuest->check == newQuest->check )
		return;

	__int64 changedata = newQuest->check - oldQuest->check;
	__int64 end = 0xFF;

	cStringT str;

	/// ٲﵥ ٲ κ Ѵ
	for( unsigned int i = 0; i < MAX_DUTY; ++i )
	{
		eDutyType type = duty->mDuty[i].dutyType;
		unsigned long targetIdx = duty->mDuty[i].targetIdx;
		unsigned int count = duty->mDuty[i].count;

		/// ǹ °  ڿ Ƿ 
		if( type == eDUTY_NONE )
			break;

		///   븸 
		if( (changedata & end) > 0 )
		{
			switch( type )
			{
			case eDUTY_HUNT:
				{
					LPCTSTR monName = GAMERESOURCEMAN->GetMonsterName( targetIdx );
					str.Format( GAMERESOURCEMAN->GetGameText( 451 ), monName, count );

					/// Ϸ
					if( (newQuest->check & end) >= (define->mComplete & end) )
					{
						str.Append( GAMERESOURCEMAN->GetGameText( 445 ) );
					}
					/// 
					else
					{
						__int64 cnt = (newQuest->check & end);
						for( unsigned int b = 0; b < i; ++b)
							cnt = cnt >> 8;

						cStringT str1;
						str1.Format( GAMERESOURCEMAN->GetGameText( 459 ), (unsigned int)cnt, count );

						str += str1;
					}

					HERO->ActiveQuestText( (LPCTSTR)str.Cstr(), (unsigned long)eCOLOR_WHITE );
				}
				break;
			case eDUTY_COLLECT:
				{
					LPCTSTR itemName = ITEMMAN->GetItemName( targetIdx );
					str.Format( GAMERESOURCEMAN->GetGameText( 453 ), itemName, count );

					/// Ϸ
					if( (newQuest->check & end) >= (define->mComplete & end) )
						str.Append( GAMERESOURCEMAN->GetGameText( 445 ) );
					/// 
					else
					{
						__int64 cnt = (newQuest->check & end);
						for( unsigned int b = 0; b < i; ++b)
							cnt = cnt >> 8;

						cStringT str1;
						str1.Format( GAMERESOURCEMAN->GetGameText( 459 ), (unsigned int)cnt, count );

						str += str1;
					}

					HERO->ActiveQuestText( (LPCTSTR)str.Cstr(), (unsigned long)eCOLOR_WHITE );
				}
				break;
			}
		}

		/// Ϸ üũ
		end = end << 8;
	}
}

/// ð ȹ
long cQuestManager::GetQuestRestTime( unsigned long questIdx )
{
	sQuestTime* p = (sQuestTime*)mTimeMap.GetAt( questIdx );
	return ( p ) ? p->restTime : 0;
}

/// Ʈ ð
void cQuestManager::AddQuestTime( unsigned long questIdx, unsigned long restTime )
{
	cQuestDefine* define = GetQuestDefine( questIdx );
	if( !define )
		return;

	/// ðüũ Ʈ 
	cQuestLimit* limit = define->mQuestLimit;
	if( limit && limit->mTimeType != eTIME_NONE )
	{
		sQuestTime* p = new sQuestTime;
		p->restTime = restTime;
		p->startTime = THEAPP->GetWorldAccumTime();

		/// ðʿ 
		if( mTimeMap.Insert( questIdx, p ) == false )
		{
			assert(0);
			return;
		}
	}
}

/// 
void cQuestManager::DeleteQuestTime( unsigned long questIdx )
{
	sQuestTime* p = (sQuestTime*)mTimeMap.GetAt( questIdx );
	if( p )
	{
		mTimeMap.Erase( questIdx );
		SAFE_DELETE( p );
	}
}

void cQuestManager::Process( unsigned long accumTime )
{
	if( mTimeMap.GetSize() == 0 )
		return;

	/// ð üũ
	cTimeMap::cIterator i = mTimeMap.Begin();
	cTimeMap::cIterator end = mTimeMap.End();
	for( ; i != end; )
	{
		sQuestTime* p = (sQuestTime*)(i->mSecond);
		unsigned long questIdx = (unsigned long)(i->mFirst);
		if( !p )
			continue;

		++i;

		long elasedTime = accumTime - p->startTime;
		
		///  
		p->restTime -= elasedTime;
		p->startTime = accumTime;

		if( p->restTime < 0 )
			p->restTime = 0;

		/// ѹ  
		if( p->restTime <= 0 && IsNetLock() == false && STAGEMAN->GetCurrentStage() == eStage_Game )
		{
			int arrIdx = GetQuestArrIdx( questIdx );
			if( arrIdx > -1 )
				QuestDeleteAuto( arrIdx );
		}
	}
}

bool cQuestManager::IsSelectQuest( unsigned long questIdx )
{
	cSelectSet::cIterator i = mSelectSet.Find( questIdx );
	return ( i == mSelectSet.End() ) ? false : true;
}

bool cQuestManager::IsCompleteGathering( unsigned long questIndex )
{
	cQuestDefine* define = GetQuestDefine( questIndex );
	if( !define )
	{
		assert(0);
		return true;
	}

	cQuestDuty* duty = define->mQuestDuty;
	if( !duty )
	{
		assert(0);
		return true;
	}

	int arrIdx = GetQuestArrIdx( questIndex );
	if( arrIdx == -1 )
		return true;

	/// Ʈ ü ϷǾ 
	if( mQuest[arrIdx].check == define->mComplete )
		return true;

	/// ä úκ ϷǾ ˻
	__int64 mask = 0x00;
	for( unsigned int i = 0; i < MAX_DUTY; ++i )
	{
		eDutyType type = duty->mDuty[i].dutyType;

		/// ǹ °  ڿ Ƿ 
		if( type == eDUTY_NONE )
			break;
	
		if( type == eDUTY_COLLECT )
		{
			__int64 bit = 0xFF << ( i * 8 );
			mask = mask | bit;
		}
	}

	///  ä  ϷϿ
	if( (mQuest[arrIdx].check & mask) == (define->mComplete & mask) )
		return true;
	return false;
}

void cQuestManager::AddQuestSelect( unsigned long questIndex, bool setQuestWindow )
{
	int arrIdx = GetQuestArrIdx( questIndex );

	if( arrIdx == -1 )
		return;

	mSelectSet.Insert( questIndex );

	/// UI 
	cQuestSimpleWindow* simple = GAMEUI->GetQuestSimpleWindow();
	if( simple )
		simple->AddQuestInfo( questIndex, &mQuest[arrIdx].check );

	/// üũ 
	if( setQuestWindow == true )
	{
		cQuestWindow* win = GAMEUI->GetQuestWindow();
		if( win )
			win->SetCheck( arrIdx, questIndex, true );
	}
}

void cQuestManager::DeleteQuestSelect( unsigned long questIndex, bool setQuestWindow )
{
	int arrIdx = GetQuestArrIdx( questIndex );

	if( arrIdx == -1 )
		return;

	mSelectSet.Erase( questIndex );

	/// UI 
	cQuestSimpleWindow* simple = GAMEUI->GetQuestSimpleWindow();
	if( simple )
		simple->DeleteQuestInfo( questIndex );

	/// üũ Ǯ
	if( setQuestWindow == true )
	{
		cQuestWindow* win = GAMEUI->GetQuestWindow();
		if( win )
			win->SetCheck( arrIdx, questIndex, false );
	}
}

///  ʺ Ʈ   ˻
void cQuestManager::CheckCountMap()
{
	mCountMap.Clear();

	for( unsigned int i = 0; i < mTotalKeepCount; ++i )
	{
		cQuestDefine* define = GetQuestDefine( mQuest[i].questIdx );
		if( !define )
		{
			assert(0);
			continue;
		}

		/// ̹   ϱ
		cCountMap::cIterator b = mCountMap.Find( define->mTakeMapIndex );
		if( b != mCountMap.End() )
		{
			///  ϱ
			unsigned int& total = (unsigned int)(b->mSecond);
			total += 1;
		}
		else
		{
			///  λ
			if( mCountMap.Insert( define->mTakeMapIndex, 1 ) == false )
				assert(0 && "error to insert quest count");
		}
	}
}

unsigned int cQuestManager::GetCount( unsigned int mapIdx )
{
	cCountMap::cIterator i = mCountMap.Find( mapIdx );
	return ( i == mCountMap.End() ) ? 0 : (unsigned int)(i->mSecond);
}

void cQuestManager::NetLock( int lockTry, unsigned long slotIndex0 )
{
	switch( lockTry )
	{
	case eLOCK_QUESTADD:
		{
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->NetLock( eLOCK_QUESTADD );

			ITEMMAN->LockItemTry( ITEM_TRY_QUEST_REWARDTAKE );
		}
		break;
	case eLOCK_QUESTADDBYITEM:
		{
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->NetLock( eLOCK_QUESTADDBYITEM );

			ITEMMAN->LockItemTry( ITEM_TRY_QUEST_ADDBYITEM, slotIndex0 );
		}
		break;
	case eLOCK_QUESTCOMPLETE:
		{
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->NetLock( eLOCK_QUESTCOMPLETE );

			ITEMMAN->LockItemTry( ITEM_TRY_QUEST_REWARDTAKE );
		}
		break;
	case eLOCK_QUESTREWARD:
		{
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->NetLock( eLOCK_QUESTREWARD );

			ITEMMAN->LockItemTry( ITEM_TRY_QUEST_REWARDTAKE );
		}
		break;
	case eLOCK_QUESTDELETE: /// ʷε ߿ û ü Ƿ 
		if( STAGEMAN->GetCurrentStage() == eStage_Game )
		{
			cQuestWindow* questWin = GAMEUI->GetQuestWindow();
			if( questWin )
				questWin->NetLock( eLOCK_QUESTDELETE );

			ITEMMAN->LockItemTry( ITEM_TRY_QUEST_TAKE );
		}
		break;
	default:
		assert(0);
		return;
	}

	mNetLock = true;
	mLockTry = lockTry;
}

void cQuestManager::NetUnLock( int lockTry )
{
	if( mNetLock == false )
		return;

	if( mLockTry != lockTry )
	{
		assert(0);
		return;
	}

	switch( lockTry )
	{
	case eLOCK_QUESTADD:
		{
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->NetUnLock( eLOCK_QUESTADD );

			ITEMMAN->UnlockItemTry( ITEM_TRY_QUEST_REWARDTAKE );
		}
		break;
	case eLOCK_QUESTADDBYITEM:
		{
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->NetUnLock( eLOCK_QUESTADDBYITEM );

			ITEMMAN->UnlockItemTry( ITEM_TRY_QUEST_ADDBYITEM );
		}
		break;
	case eLOCK_QUESTCOMPLETE:
		{
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->NetUnLock( eLOCK_QUESTCOMPLETE );

			ITEMMAN->UnlockItemTry( ITEM_TRY_QUEST_REWARDTAKE );
		}
		break;
	case eLOCK_QUESTREWARD:
		{
			cNpcWindow* npcWin = GAMEUI->GetNpcWindow();
			if( npcWin )
				npcWin->NetUnLock( eLOCK_QUESTREWARD );

			ITEMMAN->UnlockItemTry( ITEM_TRY_QUEST_REWARDTAKE );
		}
		break;
	case eLOCK_QUESTDELETE:	/// ʷε ߿ û ü Ƿ
		if( STAGEMAN->GetCurrentStage() == eStage_Game )
		{
			cQuestWindow* questWin = GAMEUI->GetQuestWindow();
			if( questWin )
				questWin->NetUnLock( eLOCK_QUESTDELETE );

			ITEMMAN->UnlockItemTry( ITEM_TRY_QUEST_TAKE );
		}
		break;
	default:
		assert(0);
		return;
	}

	mLockTry = eLOCK_QUESTNONE;
	mNetLock = false;
}
