/* ==========================================================================
*      : QuestManager.h
*      : 
*    : 谡
*    : 2008-01-18
* ǻ :
*===========================================================================*/
#pragma once
#include "Lexer.h"
#include "BaseStage.h"
#include "QuestDefine.h"

/// Ʈ Ŵ
class cParser;
class cQuestDefine;
class cUIFuncText;
class cUIFuncTextNode;
class cTrigger;

/// Ʈũ 
enum
{
	eLOCK_QUESTNONE,
	eLOCK_QUESTADD,
	eLOCK_QUESTADDBYITEM,
	eLOCK_QUESTCOMPLETE,
	eLOCK_QUESTREWARD,
	eLOCK_QUESTDELETE,
};

/// Ʈ ð
struct sQuestTime
{
	long restTime;
	long startTime;
	
	sQuestTime()
	{
		restTime = 0;
		startTime = 0;
	}
};

struct MSG_RES_NPC_QUEST_REWARD;
struct MSG_RES_NPC_QUEST_COMPLETE;
struct MSG_RES_NPC_QUEST_FAIL;

class cQuestManager
{
public:
	static cQuestManager* mpSingleton;

public:
	cQuestManager();
	~cQuestManager();

	bool Init();
	void Close();		/// ü
	void OpenLoad();	///   
	void OpenMapChange();
	void Process( unsigned long accumTime );

	void UpdateNpcQuest( unsigned long npcId, unsigned int status );		/// NPC Ʈ Ʈ 

	void AddQuestSelect( unsigned long questIndex, bool setQuestWindow = false );
	void DeleteQuestSelect( unsigned long questIndex, bool setQuestWindow = false );
	bool IsSelectQuest( unsigned long questIdx );

	/// ش ä  Ʈ ϷǾ ˻
	bool IsCompleteGathering( unsigned long questIndex );

	__int64& GetProgress( unsigned int arrIdx );		/// Ʈ 
	unsigned long GetQuestIndex( unsigned int arrIdx );
	unsigned char GetQuestStatus( unsigned int arrIdx );
	int GetQuestArrIdx( unsigned long questIdx );
	cQuestDefine* GetQuestDefine( unsigned long questIdx );
	long GetQuestRestTime( unsigned long questIdx );
	unsigned int GetCount( unsigned int mapIdx );		/// ʿ  Ʈ   
	
	/// Ʈ  ؽƮ ȹ
	const cUIFuncTextNode* GetNpcTextNode( unsigned int textid );

	/// Ʈũ ޽
	void NetworkMsgParserLoad( char* msg );			/// Load, MapChange   Ŷ
	void NetworkMsgParser( char* msg );
	void ResQuestAdd( MSG_RES_QUEST_ADD* pmsg );
	void ResQuestComplete( MSG_RES_NPC_QUEST_COMPLETE* pmsg );
	void ResQuestReward( MSG_RES_NPC_QUEST_REWARD* pmsg );

	/// Ŷ 
	bool QuestAddByNpc( unsigned long questIdx, unsigned long npcIndex );	/// Ʈ ߰ (NPC )
	bool QuestAdd( unsigned long questIdx );								/// Ʈ ߰ (NPC )
	bool QuestAddByItem( unsigned int number );								/// Ʈ ߰ (ۿ )
	bool QuestComplete( unsigned long questIdx, unsigned long npcIndex );	/// Ʈ  Ϸ
	bool QuestComplete();
	bool QuestReward( unsigned long questIdx, unsigned long npcIndex );		/// Ʈ 
	void QuestDelete( unsigned int arrIdx );		/// Ʈ 
	void QuestDeleteAuto( unsigned int arrIdx );	/// Ʈ ڵ 
	void QuestNewListReSend( unsigned long npcIndex );

	tHashSet<unsigned long>& GetSelectedSet() { return mSelectSet; }

protected:
	void UpdateUIAll();						/// ü Ʈ Ʈ 
	void UpdateUI();						/// Ʈ 츸 

	/// , Ϸᰡ  
	void CheckQuestCount();

	///
	void ActiveQuestText( sQuestList* oldQuest, sQuestList* newQuest );

	///
	void AddQuestTime( unsigned long questIdx, unsigned long restTime );
	void DeleteQuestTime( unsigned long questIdx );
	void ClearQuestTime();

	///  ʺ  Ʈ  
	void CheckCountMap();
	
	/// ɱ
	void NetLock( int lockTry, unsigned long slotIndex0 = 0 );
	void NetUnLock( int lockTry );
	bool IsNetLock();

public:
	static cQuestManager* GetSingleton();

protected:
	bool Load( const cString& pathname );
	bool LoadQuests( const cString& pathname );
	bool LoadQuestData( cParser& parser, cQuestDefine* p, cTrigger* trigger );

	/// 
	bool LoadTrigger( cParser& parser, cTrigger* trigger );
	bool LoadDuty( cParser& parser, cQuestDuty* duty, __int64& complete );
	bool LoadLimit( cParser& parser, cQuestLimit* limit );
	bool LoadEnd( cParser& parser, cQuestEnd* end );
	bool LoadDefault( cParser& parser, cQuestReward* reward );
	bool LoadSelect( cParser& parser, cQuestReward* select );
	bool LoadFail( cParser& parser, cQuestFail* fail );

	/// ȿ ˻
	bool IsValid( cQuestDefine* define );

private:
	/// Ʈ ũƮ  
	typedef tPointerHashMap<unsigned long, void*> cQuestDefineMap;
	cQuestDefineMap mQuestDefine;

	/// Ʈ  ð  ()
	typedef tPointerHashMap<unsigned long, void*> cTimeMap;
	cTimeMap	mTimeMap;

	/// Ʈ  ڿ
	cUIFuncText* mpQuestText;

	/// Ʈ  
	sQuestList mQuest[MAX_KEEPQUEST];
	unsigned int mTotalKeepCount;

	/// Ϸᰡɸ 
	unsigned int mCompleteCount;

	///   
	unsigned int mProgressCount;

	///  Ϸ , check  Ǯϴ Ʈ
	long mCheckQuestIndex;

	/// ӽ
	long mTempQuestIndex;
	long mTempNpcIndex;
	unsigned int mTempArrIndex;

	/// Ʈũ  
	bool	mNetLock;
	int		mLockTry;

	/// õ Ʈ  
	typedef tHashSet<unsigned long> cSelectSet;
	cSelectSet mSelectSet;

	/// ʴ Ʈ   ( ε,  )
	typedef tHashMap<unsigned int, unsigned int> cCountMap;
	cCountMap mCountMap;
};

inline bool cQuestManager::IsNetLock()
{
	return mNetLock;
}

inline __int64& cQuestManager::GetProgress( unsigned int arrIdx )
{
	return mQuest[arrIdx].check;
}

inline int cQuestManager::GetQuestArrIdx( unsigned long questIdx )
{
	for( unsigned int i = 0; i < mTotalKeepCount; ++i )
	{
		if( mQuest[i].questIdx == questIdx )
			return i;
	}
	return -1;
}

inline unsigned long cQuestManager::GetQuestIndex( unsigned int arrIdx )
{
	return mQuest[arrIdx].questIdx;
}

inline unsigned char cQuestManager::GetQuestStatus( unsigned int arrIdx )
{
	return mQuest[arrIdx].status;
}

inline cQuestManager* cQuestManager::GetSingleton()
{
	return mpSingleton;
}

#define QUESTMAN cQuestManager::GetSingleton()


//////////////////////////////////////////////////////////////////
// Ʈ ũƮ ū
enum
{
	/// Ʈ 
	eTOKEN_QUESTDATA = 100,
	eTOKEN_TITLE,
	eTOKEN_TYPE,
	eTOKEN_DESC,
	eTOKEN_REPEAT,
	eTOKEN_GROUP,
	eTOKEN_SHARETYPE,
	
	eTOKEN_GIVENPC,
	eTOKEN_TAKENPC,
	eTOKEN_TAKEMAP,
	eTOKEN_GIVEITEM,
	eTOKEN_TAKEITEM,
	eTOKEN_SELECTCOUNT,
	eTOKEN_LEVEL,
	
	eTOKEN_NORMALTYPE,
	eTOKEN_SCENARIOTYPE,
	eTOKEN_RACETYPE,
	eTOKEN_CHANGEJOBTYPE,
	
	eTOKEN_CHALLEANGE,
	eTOKEN_REPETITION,

	eTOKEN_ALL,
	eTOKEN_ORDER,

	eTOKEN_DUTY,
	eTOKEN_LIMIT,
	eTOKEN_END,
	eTOKEN_DEFAULTREWARD,
	eTOKEN_SELECTREWARD,
	eTOKEN_FAIL,

	eTOKEN_TALKNPC,
	eTOKEN_HUNT,
	eTOKEN_COLLECT,
	
	eTOKEN_BUFF,
	eTOKEN_DEBUFF,
	eTOKEN_EQUIPITEM,
	eTOKEN_TIMETYPE,
	eTOKEN_TIME,
	eTOKEN_MAPCHANGEPOS,
	eTOKEN_MONSTER,
	eTOKEN_MONSTERTIME, 

	eTOKEN_EXP,
	eTOKEN_SXP,
	eTOKEN_MONEY,
	eTOKEN_SKILLPOINT,
	eTOKEN_ITEM,
	eTOKEN_CHANGEJOB,
	eTOKEN_FORCETYPE,
	eTOKEN_GIVETITLE,

	/// Ʈ ̺Ʈ 
	eTOKEN_TRIGGER,
	eTOKEN_TE_LEVEL,
	eTOKEN_TE_RACE,
	eTOKEN_TE_JOB,
	eTOKEN_TE_HAVEITEM,
	eTOKEN_TE_LINKQUEST,
	eTOKEN_TE_SKILL,

	eTOKEN_HUMAN,
	eTOKEN_ELF,
	eTOKEN_BEAST,

	eTOKEN_TRUE,
	eTOKEN_FALSE,
};

/// Ʈ ũƮ  м
class cQuestLexer : public cLexer
{
public:
	cQuestLexer( const char* buffer, unsigned int size );
};
