#include "StdAfx.h"
#include "QuestSimpleWindow.h"
#include "PlaneObject.h"

#include "QuestManager.h"
#include "GameResourceManager.h"
#include "ItemManager.h"
#include "FontAgent.h"

#include "PVPManager.h"

cQuestSimpleWindow::cQuestSimpleWindow()
: mpHighImage(0)
, mpLowImage(0)
, mHighCheckPos(0, 0)
, mHighNoCheckPos(0, 0)
, mLowCheckPos(0, 0)
, mImageSize(0, 0)
, mInitWidth(0)
, mInitX(0)
{
	memset( mpBackImage, 0, sizeof(mpBackImage) );
	memset( mpBackSkin, 0, sizeof(mpBackSkin) );
}

cQuestSimpleWindow::~cQuestSimpleWindow()
{
	for( int i = 0; i < eBACKIMAGE_MAX; ++i )
		SAFE_DELETE( mpBackImage[i] );

	SAFE_DELETE( mpLowImage );
	SAFE_DELETE( mpHighImage );

	Clear();
}

void cQuestSimpleWindow::Clear()
{
	/// Ŭ
	typedef tPointerList<void*> cProgressList;

	cQuestMap::cIterator i = mQuestMap.Begin();
	cQuestMap::cIterator end = mQuestMap.End();
	for( ; i != end; ++i )
	{
		sQuestHaveData* data = (sQuestHaveData*)(i->mSecond);
		if( data )
		{
			cProgressList::cIterator b = data->mQuestProgressList.Begin();
			cProgressList::cIterator bend = data->mQuestProgressList.End();
			for( ; b != bend; ++b )
			{
				sQuestProgress* progress = (sQuestProgress*)(*b);
				SAFE_DELETE( progress );
			}
			data->mQuestProgressList.Clear();
		}

		SAFE_DELETE( data );
	}
	mQuestMap.Clear();
}

void cQuestSimpleWindow::ShowTop(bool hideOthers , bool onsound )
{
	if( PVPMAN->IsEnableBattle() == true )
		return;

	cUIWindow::ShowTop( hideOthers, onsound );
}

void cQuestSimpleWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	int x = GetScreenWidth() - GetAbsoluteRect().GetWidth() - mInitX;
	int y = GetAbsoluteRect().mTop;
	SetRelativePos( cUIPos(x, y) );

	UpdateSize();
}

bool cQuestSimpleWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	/// ٸ   ϵ 
	SetExceptSnap( true );

	/// ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	cUINodeSkin* pHighSkin = pSkin->GetNodeSkin( "Quest_FolderHigh" );
	cUINodeSkin* pHighNoSkin = pSkin->GetNodeSkin( "Quest_FolderHighNoCheck" );
	if( pHighSkin && pHighNoSkin )
	{
		mpHighImage = new cUIImage( pHighSkin->mpTexture );

		mHighNoCheckPos.mX = pHighSkin->mSkinInfo->mTexX;
		mHighNoCheckPos.mY = pHighSkin->mSkinInfo->mTexY;
		unsigned int w = pHighSkin->mSkinInfo->mWidth;
		unsigned int h = pHighSkin->mSkinInfo->mHeight;
		unsigned int x = pHighSkin->mSkinInfo->mX;
		unsigned int y = pHighSkin->mSkinInfo->mY;

		mpHighImage->SetTextureRect( mHighCheckPos.mX, mHighCheckPos.mY, mHighCheckPos.mX + w, mHighCheckPos.mY + h );
		mpHighImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );

		mHighCheckPos.mX = pHighNoSkin->mSkinInfo->mTexX;
		mHighCheckPos.mY = pHighNoSkin->mSkinInfo->mTexY;

		mImageSize.mWidth = w;
		mImageSize.mHeight = h;
	}

	cUINodeSkin* pLowSkin = pSkin->GetNodeSkin( "Quest_FolderLow" );
	if( pLowSkin )
	{
		mpLowImage = new cUIImage( pLowSkin->mpTexture );

		mLowCheckPos.mX = pLowSkin->mSkinInfo->mTexX;
		mLowCheckPos.mY = pLowSkin->mSkinInfo->mTexY;
		unsigned int w = pLowSkin->mSkinInfo->mWidth;
		unsigned int h = pLowSkin->mSkinInfo->mHeight;
		unsigned int x = pLowSkin->mSkinInfo->mX;
		unsigned int y = pLowSkin->mSkinInfo->mY;

		mpLowImage->SetTextureRect( mLowCheckPos.mX, mLowCheckPos.mY, mLowCheckPos.mX + w, mLowCheckPos.mY + h );
		mpLowImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}
	
	///  ̹ 
	mpBackSkin[eBACKIMAGE_TOP] = pSkin->GetNodeSkin( "QuestSimple_Top" );
	mpBackSkin[eBACKIMAGE_BOTTOM] = pSkin->GetNodeSkin( "QuestSimple_Bottom" );
	mpBackSkin[eBACKIMAGE_CENTER] = pSkin->GetNodeSkin( "QuestSimple_Back" );
	mpBackSkin[eBACKIMAGE_LEFT] = pSkin->GetNodeSkin( "QuestSimple_Left" );
	mpBackSkin[eBACKIMAGE_RIGHT] = pSkin->GetNodeSkin( "QuestSimple_Right" );

	for( int i = 0; i < eBACKIMAGE_MAX; ++i )
	{
		if( mpBackSkin[i] && mpBackSkin[i]->mpTexture )
		{
			/// ؽó  
			unsigned short tx = (unsigned short)mpBackSkin[i]->mSkinInfo->mTexX;
			unsigned short ty = (unsigned short)mpBackSkin[i]->mSkinInfo->mTexY;
			unsigned short tw = (unsigned short)mpBackSkin[i]->mSkinInfo->mTexWidth;
			unsigned short th = (unsigned short)mpBackSkin[i]->mSkinInfo->mTexHeight;
			unsigned int x = GetAbsoluteRect().mLeft;
			unsigned int y = GetAbsoluteRect().mTop;

			mpBackImage[i] = new cPlaneObject;

			if( mpBackImage[i]->Create( mpBackSkin[i]->mpTexture, x, y, x+1, y+1, tx, ty, tx + tw, ty + th ) == false )
			{
				assert( 0 && "failed to create back image");
				return false;
			}
		}
	}

	mInitWidth = mAbsoluteRect.GetWidth();
	cUINodeSkin* winSkin = pSkin->GetNodeSkin( mSkinName );
	if( winSkin )
		mInitX = winSkin->mSkinInfo->mX;

	int x = GetScreenWidth() - GetAbsoluteRect().GetWidth() - mInitX;
	int y = GetAbsoluteRect().mTop;
	SetRelativePos( cUIPos(x, y) );
	return true;
}

void cQuestSimpleWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mQuestMap.GetSize() > 0 )
	{
		///   
		int x = GetAbsoluteRect().mLeft;
		int y = GetAbsoluteRect().mTop;

		/// ̹ 
		if( mpBackImage[eBACKIMAGE_TOP] )
		{
			int skinHeight = mpBackSkin[eBACKIMAGE_TOP]->mSkinInfo->mHeight;
			mpBackImage[eBACKIMAGE_TOP]->SetScreenXY( x, y );
		}
		if( mpBackImage[eBACKIMAGE_CENTER] )
		{
			mpBackImage[eBACKIMAGE_CENTER]->SetScreenXY( x + START_GAPX, y + START_GAPY );
		}
		if( mpBackImage[eBACKIMAGE_BOTTOM] )
		{
			int backHeight = GetAbsoluteRect().GetHeight() - ( 2 * START_GAPY );
			mpBackImage[eBACKIMAGE_BOTTOM]->SetScreenXY( x, y + backHeight + START_GAPY );
		}
		if( mpBackImage[eBACKIMAGE_LEFT] )
		{
			mpBackImage[eBACKIMAGE_LEFT]->SetScreenXY( x, y + START_GAPY );
		}
		if( mpBackImage[eBACKIMAGE_RIGHT] )
		{
			mpBackImage[eBACKIMAGE_RIGHT]->SetScreenXY( x + START_GAPX + mInitWidth, y + START_GAPY );
		}
	}
}

void cQuestSimpleWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mVisible == false )
		return;

	///  
	if( mQuestMap.GetSize() == 0 )
		return;

	/// ̹ 
	for( int i = 0; i < eBACKIMAGE_MAX; ++i )
	{
		if( mpBackImage[i] )
			mpBackImage[i]->Draw();
	}

	int textposX = GetAbsoluteRect().mLeft + START_GAPX;
	int textPosY = GetAbsoluteRect().mTop + START_GAPY;
	int rowHeight = FONTAGENT->GetTextHeight( cFontAgent::eFont_UI );
	
	typedef tPointerList<void*> cProgressList;

	/// 
	cQuestMap::cIterator b = mQuestMap.Begin();
	cQuestMap::cIterator end = mQuestMap.End();
	for( ; b != end; ++b )
	{
		sQuestHaveData* data = (sQuestHaveData*)(b->mSecond);
		if( !data )
		{
			assert(0);
			return;
		}

		int addX = 0;
		if( data->mCloseImage )
		{
			/// ̹ ؽ ǥ 
			cUIPos texPos = ( data->mClose == false ) ? mHighCheckPos : mHighNoCheckPos;
			data->mCloseImage->SetTextureRect( cUIRect( texPos.mX, texPos.mY,texPos.mX + data->mCloseImage->GetWidth(), texPos.mY + data->mCloseImage->GetHeight() ) );
			data->mCloseImage->SetPos( textposX, textPosY );
			data->mCloseImage->Draw();

			addX = (data->mCloseImage->GetWidth() + 2);
		}

		///   /   
		int have = data->mQuestProgressList.GetSize();

		TCHAR temp[128] = {0,};
		::_stprintf( temp, GAMERESOURCEMAN->GetGameText(446), (LPTSTR)data->mMapName.Cstr(), have, data->mTotalCount );

		///  ̸ 
		pKeeper->AddFontItem( cFontAgent::eFont_UI, temp, textposX + addX, textPosY, eCOLOR_YELLOW );
		textPosY += rowHeight;

		///   Ʈ Ʈ 
		if( data->mClose == false )
		{
			addX = 0;

			cProgressList::cIterator b = data->mQuestProgressList.Begin();
			cProgressList::cIterator bend = data->mQuestProgressList.End();
			for( ; b != bend; ++b )
			{
				sQuestProgress* progress = (sQuestProgress*)(*b);
				if( !progress )
				{
					assert(0);
					return;
				}
				
				/// üũ ȵ Ʈ  ü 
				if( progress->mCloseImage && progress->mClose == false )
				{
					/// ̹ ؽ ǥ 
					cUIPos texPos = mLowCheckPos;
					progress->mCloseImage->SetTextureRect( cUIRect( texPos.mX, texPos.mY,texPos.mX + progress->mCloseImage->GetWidth(), texPos.mY + progress->mCloseImage->GetHeight() ) );
					progress->mCloseImage->SetPos( textposX, textPosY );
					progress->mCloseImage->Draw();

					addX = (progress->mCloseImage->GetWidth() + 2);
				}

				/// Ʈ ̸ 
				pKeeper->AddFontItem( cFontAgent::eFont_UI, (LPTSTR)progress->mQuestName.Cstr(), textposX + addX, textPosY, eCOLOR_GREEN );
				textPosY += rowHeight;

				/// Ʈ ǹ
				if( progress->mClose == false && progress->mDefine )
				{
					/// 1. ð  
					cQuestDefine* define = progress->mDefine;
					cQuestLimit* limit = define->mQuestLimit;
					if( limit && limit->mTime > 0 )
					{
						long restTime = QUESTMAN->GetQuestRestTime( progress->mIndex );
						int time = (int)(restTime*0.001);
						if( time >= 0 )
						{
							int h = time / 3600;
							int m = time / 60;
							int s = time % 60;

							cStringT th,tm,ts;
							if( h != 0 )
								th.Format(_T("%d"), h );

							if( m != 0 )
								tm.Format(_T("%d"), m );
							ts.Format(_T("%d"), s );

							th = (th+tm+ts);

							cStringT timeStr;
							timeStr.Format( GAMERESOURCEMAN->GetGameText( 471 ), (LPCTSTR)th.Cstr() );

							pKeeper->AddFontItem( cFontAgent::eFont_UI, (LPCTSTR)timeStr.Cstr(), textposX + addX, textPosY, eCOLOR_ORANGE );
							textPosY += rowHeight;
						}
					}

					/// 2. ǹ  ǥ
					cQuestDuty* duty = define->mQuestDuty;
					if( duty )
					{
						cStringT str;

						__int64 end = 0xFF;
						__int64 check = *progress->mCheck;	/// 

						for( unsigned int i = 0; i < MAX_DUTY; ++i )
						{
							eDutyType type = duty->mDuty[i].dutyType;
							unsigned long targetIdx = duty->mDuty[i].targetIdx;
							unsigned int count = duty->mDuty[i].count;

							if( type == eDUTY_NONE )
								break;

							///  
							switch( type )
							{
							case eDUTY_HUNT:		/// 
								{
									LPCTSTR monName = GAMERESOURCEMAN->GetMonsterName( targetIdx );
									str.Format( GAMERESOURCEMAN->GetGameText( 451 ), monName, count );

									/// Ϸ
									if( (check & end) >= (define->mComplete & end) )
										str.Append( GAMERESOURCEMAN->GetGameText( 445 ) );
									/// 
									else
									{
										__int64 cnt = check & end;
										for( unsigned int b = 0; b < i; ++b)
											cnt = cnt >> 8;

										cStringT str1;
										str1.Format( GAMERESOURCEMAN->GetGameText( 459 ), (unsigned int)cnt, count );

										str += str1;
									}

									pKeeper->AddFontItem( cFontAgent::eFont_UI, (LPCTSTR)str.Cstr(), textposX + addX, textPosY, mDefaultColor );
									textPosY += rowHeight;
								}
								break;
							case eDUTY_COLLECT:		/// 
								{
									LPCTSTR itemName = ITEMMAN->GetItemName( targetIdx );
									str.Format( GAMERESOURCEMAN->GetGameText( 453 ), itemName, count );

									/// Ϸ
									if( (check & end) >= (define->mComplete & end) )
										str.Append( GAMERESOURCEMAN->GetGameText( 445 ) );
									/// 
									else
									{
										__int64 cnt = check & end;
										for( unsigned int b = 0; b < i; ++b)
											cnt = cnt >> 8;

										cStringT str1;
										str1.Format( GAMERESOURCEMAN->GetGameText( 459 ), (unsigned int)cnt, count );

										str += str1;
									}

									pKeeper->AddFontItem( cFontAgent::eFont_UI, (LPCTSTR)str.Cstr(), textposX + addX, textPosY, mDefaultColor );
									textPosY += rowHeight;
								}
								break;
							case eDUTY_MEET:		/// npc 
								{
									LPCTSTR npcName = GAMERESOURCEMAN->GetNpcName( targetIdx );
									str.Format( GAMERESOURCEMAN->GetGameText( 455 ), npcName );

									/// Ϸ
									if( (check & end) >= (define->mComplete & end) )
										str.Append( GAMERESOURCEMAN->GetGameText( 445 ) );

									pKeeper->AddFontItem( cFontAgent::eFont_UI, (LPCTSTR)str.Cstr(), textposX + addX, textPosY, mDefaultColor );
									textPosY += rowHeight;
								}
								break;
							}

							/// Ϸ üũ
							end = end << 8;
						}
					} /// ǥ Ϸ
				}/// ǹ ǥ Ϸ
			}
		}
	}

	///
	pKeeper->DrawAll();
}

void cQuestSimpleWindow::OnLButtonDoubleClick( const cUIPos& pos )
{
	OnLButtonDown( pos, false, false, false );
}

void cQuestSimpleWindow::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool )
{
	cUIWindow::OnLButtonDown( pos, ctrl, alt, false );

	/// ̹  üũ
	if( pos.mX < GetAbsoluteRect().mLeft + START_GAPX || pos.mX > GetAbsoluteRect().mLeft + START_GAPX + mImageSize.mWidth )
		return;

	if( pos.mY < GetAbsoluteRect().mTop + START_GAPY )
		return;

	int rowHeight = FONTAGENT->GetTextHeight( cFontAgent::eFont_UI );
	unsigned int selectRow = (pos.mY - (GetAbsoluteRect().mTop + START_GAPY) ) / rowHeight;
	int row = 0;

	/// õ ̹ ã
	typedef tPointerList<void*> cProgressList;

	cQuestMap::cIterator i = mQuestMap.Begin();
	cQuestMap::cIterator end = mQuestMap.End();
	for( ; i != end; ++i )
	{
		sQuestHaveData* data = (sQuestHaveData*)(i->mSecond);
		if( !data )
		{
			assert(0);
			return;
		}
		
		/// õ ̹ 
		if( selectRow == row && data->mCloseImage )
		{
			data->mClose = !data->mClose;

			///   ų ϱ ϰ,
			/// ǹ    Ƿ  Ѵ
			UpdateSize();
			return;
		}

		row++;

		///   
		if( data->mClose == false )
		{
			cProgressList::cIterator b = data->mQuestProgressList.Begin();
			cProgressList::cIterator bend = data->mQuestProgressList.End();
			for( ; b != bend; ++b )
			{
				sQuestProgress* progress = (sQuestProgress*)(*b);
				if( !progress )
				{
					assert(0);
					return;
				}

				/// õ ̹  ˻
				if( selectRow == row && progress->mCloseImage )
				{
					QUESTMAN->DeleteQuestSelect( progress->mIndex, true );
					return;
				}

				row++;

				/// ǹ  ߰
				if( progress->mClose == false )
				{
					cQuestDefine* define = progress->mDefine;
					cQuestDuty* duty = define->mQuestDuty;
					cQuestLimit* limit = define->mQuestLimit;
					if( limit && limit->mTime > 0 )
						row++;

					if( duty )
					{
						for( unsigned int i = 0; i < MAX_DUTY; ++i )
						{
							eDutyType type = duty->mDuty[i].dutyType;
							if( type != eDUTY_NONE )
								row++;
						}
					}
				}
			}
		}
	}
}

/// Ʈ 
void cQuestSimpleWindow::AddQuestInfo( unsigned long questIndex, __int64* check )
{
	cQuestDefine* define = QUESTMAN->GetQuestDefine( questIndex );
	if( !define )
	{
		assert(0);
		return;
	}

	/// Ͱ  λ
	sQuestHaveData* data = (sQuestHaveData*)mQuestMap.GetAt( define->mTakeMapIndex );
	if( !data )
	{
		data = new sQuestHaveData;
		data->mMapName = GAMERESOURCEMAN->GetMapName( define->mTakeMapIndex );
		data->mClose = false;
		data->mCloseImage = mpHighImage;

		if( mQuestMap.Insert( define->mTakeMapIndex, data ) == false )
		{
			assert(0);
			SAFE_DELETE( data );
			return;
		}
	}

	/// Ʈ  
	data->mTotalCount = QUESTMAN->GetCount( define->mTakeMapIndex );

	///   
	sQuestProgress* progress = new sQuestProgress;
	progress->mIndex = questIndex;
	progress->mDefine = define;
	progress->mCheck = check;
	progress->mClose = false;
	progress->mCloseImage = mpLowImage;
	progress->mTime = 0;
		
	TCHAR temp[128]={0,};
	::_stprintf( temp, _T( "[%d] %s" ), define->mLevel, GAMERESOURCEMAN->GetQuestTitle( define->mTitleIndex ) );
	progress->mQuestName = temp;
	
	data->mQuestProgressList.PushBack( progress );

	///   
	UpdateSize();

	///
	if( mQuestMap.GetSize() > 0 && mVisible == false )
	{
		/// npc 찡 ̸ 켱 
		if( UIMAN->IsShowNpcBack() == false )
			ShowTop();
		else
			UIMAN->SetRestoreShow( this );
	}
}

/// 
void cQuestSimpleWindow::DeleteQuestInfo( unsigned long questIndex )
{
	cQuestDefine* define = QUESTMAN->GetQuestDefine( questIndex );
	if( !define )
	{
		assert(0);
		return;
	}

	/// Ͱ  λ
	sQuestHaveData* data = (sQuestHaveData*)mQuestMap.GetAt( define->mTakeMapIndex );
	if( !data )
	{
		assert(0);
		return;
	}

	typedef tPointerList<void*> cProgressList;
	cProgressList::cIterator b = data->mQuestProgressList.Begin();
	cProgressList::cIterator bend = data->mQuestProgressList.End();
	for( ; b != bend; ++b )
	{
		sQuestProgress* progress = (sQuestProgress*)(*b);
		if( progress && progress->mIndex == questIndex )
		{
			SAFE_DELETE( progress );
			data->mQuestProgressList.Erase( b );
			break;
		}
	}

	///  Ͱ     
	if( data->mQuestProgressList.GetSize() == 0 )
	{
		mQuestMap.Erase( define->mTakeMapIndex );
	}

	///   
	if( mQuestMap.GetSize() == 0 )
		Hide();
	else
		UpdateSize();
}	

void cQuestSimpleWindow::UpdateSize()
{
	int totalLine = 0;
	int rowHeight = FONTAGENT->GetTextHeight( cFontAgent::eFont_UI );

	typedef tPointerList<void*> cProgressList;

	/// 
	cQuestMap::cIterator i = mQuestMap.Begin();
	cQuestMap::cIterator end = mQuestMap.End();
	for( ; i != end; ++i )
	{
		sQuestHaveData* data = (sQuestHaveData*)(i->mSecond);
		if( !data )
		{
			assert(0);
			return;
		}
	
		/// 1. ̸   ߰
		totalLine++;

		///   Ʈ Ʈ 
		if( data->mClose == false )
		{
			cProgressList::cIterator b = data->mQuestProgressList.Begin();
			cProgressList::cIterator bend = data->mQuestProgressList.End();
			for( ; b != bend; ++b )
			{
				sQuestProgress* progress = (sQuestProgress*)(*b);
				if( !progress )
				{
					assert(0);
					return;
				}	

				/// 1. Ʈ ̸   ߰
				totalLine++;

				/// Ʈ ǹ
				if( progress->mClose == false && progress->mDefine )
				{
					/// 1. ð  
					cQuestDefine* define = progress->mDefine;
					cQuestLimit* limit = define->mQuestLimit;
					if( limit && limit->mTime > 0 )
					{
						long restTime = QUESTMAN->GetQuestRestTime( progress->mIndex );
						int time = (int)(restTime*0.001);
						if( time >= 0 )
						{
							/// 3. ǹ - ð   ߰
							totalLine++;
						}
					}

					cQuestDuty* duty = define->mQuestDuty;
					if( duty )
					{
						__int64 end = 0xFF;
						__int64 check = *progress->mCheck;	/// 

						for( unsigned int i = 0; i < MAX_DUTY; ++i )
						{
							eDutyType type = duty->mDuty[i].dutyType;
							if( type == eDUTY_NONE )
								break;

							/// 4. ǹ   ߰
							switch( type )
							{
							case eDUTY_HUNT:	totalLine++; break;
							case eDUTY_COLLECT:	totalLine++; break;
							case eDUTY_MEET:	totalLine++; break;
							}

							/// Ϸ üũ
							end = end << 8;
						}
					}
				}
			}
		}
	}

	///   
	int w = mInitWidth + (START_GAPX * 2);
	int h = totalLine * rowHeight + (START_GAPY * 2);
	SetRelativeSize( cUISize(w, h) );
	
	int x = GetAbsoluteRect().mLeft;
	int y = GetAbsoluteRect().mTop;

	/// ̹ 
	if( mpBackImage[eBACKIMAGE_TOP] )
	{
		int skinHeight = mpBackSkin[eBACKIMAGE_TOP]->mSkinInfo->mHeight;
		mpBackImage[eBACKIMAGE_TOP]->SetScreenRect( x, y, w, skinHeight );
	}
	if( mpBackImage[eBACKIMAGE_CENTER] )
	{
		int backHeight = totalLine * rowHeight;
		mpBackImage[eBACKIMAGE_CENTER]->SetScreenRect( x + START_GAPX, y + START_GAPY, mInitWidth, backHeight );
	}
	if( mpBackImage[eBACKIMAGE_BOTTOM] )
	{
		int backHeight = totalLine * rowHeight;
		int skinHeight = mpBackSkin[eBACKIMAGE_BOTTOM]->mSkinInfo->mHeight;
		mpBackImage[eBACKIMAGE_BOTTOM]->SetScreenRect( x, y + backHeight + START_GAPY, w, skinHeight );
	}
	if( mpBackImage[eBACKIMAGE_LEFT] )
	{
		int backHeight = totalLine * rowHeight;
		int skinWidth = mpBackSkin[eBACKIMAGE_LEFT]->mSkinInfo->mWidth;
		mpBackImage[eBACKIMAGE_LEFT]->SetScreenRect( x, y + START_GAPY, skinWidth, backHeight );
	}
	if( mpBackImage[eBACKIMAGE_RIGHT] )
	{
		int backHeight = totalLine * rowHeight;
		int skinWidth = mpBackSkin[eBACKIMAGE_RIGHT]->mSkinInfo->mWidth;
		mpBackImage[eBACKIMAGE_RIGHT]->SetScreenRect( x + START_GAPX + mInitWidth, y + START_GAPY, skinWidth, backHeight );
	}

	/// ü ĸ 
	mCaptionRect.Set( 0, 0, w, h );
}
