/* ==========================================================================
*      : QuestSimpleWindow.h
*      : 
*    : 谡
*    : 2008-04-21
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "QuestWindow.h"

const int START_GAPX = 7;
const int START_GAPY = 9;

struct sSimpleData
{
	unsigned long	mTimeLine;	 /// ؾ 
	unsigned long	mQuestIndex; /// Ʈ ε
};

/// 
struct sQuestHaveData
{
	tPointerList<void*> mQuestProgressList;	/// Ʈ Ʈ
	bool				mClose;				/// close  (Ʈ Ʈ  )
	cUIImage*			mCloseImage;		/// close  ̹
	cStringT			mMapName;			/// ̸
	unsigned int		mTotalCount;		///  Ʈ 

	sQuestHaveData()
	{
		mClose = false;
		mCloseImage = 0;
		mTotalCount = 0;
	}
};

/// Ʈ 
struct sQuestProgress
{
	unsigned long	mIndex;		/// Ʈ ε
	cQuestDefine*	mDefine;	/// Ʈ 
	cStringT		mQuestName;	/// Ʈ
	__int64*		mCheck;		///  
	unsigned long	mTime;		/// ð
	bool			mClose;		/// close  (ǹ  )
	cUIImage*		mCloseImage;/// close  ̹

	sQuestProgress()
	{
		mIndex = 0;
		mDefine = 0;
		mCheck = 0;
		mTime = 0;
		mClose = false;
		mCloseImage = 0;
	}
};

class cPlaneObject;
class cQuestSimpleWindow : public cUIWindow
{
public:
	cQuestSimpleWindow();
	virtual ~cQuestSimpleWindow();

	void Clear();

	void AddQuestInfo( unsigned long questIndex, __int64* check );
	void DeleteQuestInfo( unsigned long questIndex );

	void ShowTop(bool hideOthers = false, bool onsound = true );

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnRender( cUIFontItemKeeper* pKeeper );
	void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool );
	void OnLButtonDoubleClick( const cUIPos& pos );
	void UpdateRect();
	void UpdateSkin();

	///    
	void UpdateSize();

private:
	enum
	{
		eBACKIMAGE_TOP = 0,
		eBACKIMAGE_CENTER,
		eBACKIMAGE_BOTTOM,
		eBACKIMAGE_LEFT,
		eBACKIMAGE_RIGHT,

		eBACKIMAGE_MAX
	};

	///   Ʈ  ( ε, Ʈ Ʈ sQuestHaveData )
	typedef tPointerHashMap<unsigned int, void*> cQuestMap;
	cQuestMap	mQuestMap;

	cUIImage*	mpHighImage;
	cUIImage*	mpLowImage;

	/// üũ, üũ ؽ ġ
	cUIPos			mHighCheckPos;
	cUIPos			mHighNoCheckPos;
	cUIPos			mLowCheckPos;

	cUISize			mImageSize;

	///  ̹
	cUINodeSkin*	mpBackSkin[eBACKIMAGE_MAX];
	cPlaneObject*	mpBackImage[eBACKIMAGE_MAX];

	/// ⺻ 
	unsigned int	mInitWidth;
	unsigned int	mInitX;
};