#include "StdAfx.h"
#include "QuestWindow.h"
#include "QuestManager.h"
#include "GameResourceManager.h"
#include "SkillScript.h"
#include "TipWindow.h"
#include "GameUIManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "UIFuncText.h"
#include "Quest_Common.h"
#include "ItemManager.h"
#include "UIMsgboxEvent.h"
#include "NpcScript.h"
#include "Npc_Common.h"
#include "QuestSimpleWindow.h"
#include "TitleManager.h"

#include "ListFolderBox.h"
#include "Label.h"
#include "TextBox.h"
#include "Button.h"

cQuestWindow::cQuestWindow()
: mpListBox(0)
, mpEXP(0)
, mpSXP(0)
, mpSkillPoint(0)
, mpMoney(0)
, mpCount(0)
, mpCompleteCount(0)
, mpProgressCount(0)
, mpDescBox(0)
, mpDelete(0)
, mpHighImage(0)
, mpLowImage(0)
, mTimeLine(-1)
, mSelectQuestIndex(0)
{
}

cQuestWindow::~cQuestWindow()
{
	SAFE_DELETE( mpLowImage );
	SAFE_DELETE( mpHighImage );
}

/// Ʈ Ʈ ŵɶ ȣ
void cQuestWindow::Clear()
{
	if( mpListBox )
		mpListBox->Clear();

	/// ʱȭ 
	if( mpDescBox )
		mpDescBox->Clear();

	/// ʱȭ
	ClearIcon();

	mTimeLine = -1;
	mSelectQuestIndex = 0;
	SetExp( 0 );
	SetSxp( 0 );
	SetMoney( 0 );
	SetSkillPoint( 0 );
	SetSelectCount( 0 );

	UpdateCount( 0, 0 );
}

///  ʱȭ
void cQuestWindow::ClearIcon()
{
	for( unsigned int i = 0; i < 5; ++i )
	{
		cIcon* icon = mDefaultIcon[i].icon;
		if( icon )
		{
			mDefaultIcon[i].index = 0;
			icon->SetIconType( eICON_NORMAL );
			icon->ChangeImage(0);
		}

		cIcon* selectIcon = mSelectIcon[i].icon;
		if( selectIcon )
		{
			mSelectIcon[i].index = 0;
			selectIcon->SetIconType( eICON_NORMAL );
			selectIcon->ChangeImage(0);
		}
	}
}

void cQuestWindow::OnShow()
{
	cUIWindow::OnShow();

	/// ϶ 
	UpdateQuestInfo();
}

bool cQuestWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpListBox = (cListFolderBox*)GetChild( eUIID_QUEST_FOLDER );
	if( !mpListBox )
		return false;

	///   
	cString str;
	for( unsigned int i = 0; i < 5; ++i )
	{
		str.Format( "RewardDefault_Icon%d", i );
		cIcon* icon = new cIcon;
		if( icon->CreateBySkinName( str, this, i, true ) == false )
			return false;

		mDefaultIcon[i].icon = icon;
	}

	for( unsigned int i = 0; i < 5; ++i )
	{
		str.Format( "RewardSelect_Icon%d", i );
		cIcon* icon = new cIcon;
        if( icon->CreateBySkinName( str, this, i+10, true ) == false )
			return false;
			
		mSelectIcon[i].icon = icon;
	}
	
	mpEXP = (cLabel*)GetChild( eUIID_QUEST_EXP );
	mpSXP = (cLabel*)GetChild( eUIID_QUEST_SXP );
	mpSkillPoint = (cLabel*)GetChild( eUIID_QUEST_SKILLPOINT );
	mpMoney = (cLabel*)GetChild( eUIID_QUEST_MONEY );
	mpCount = (cLabel*)GetChild( eUIID_QUEST_COUNT );

	mpCompleteCount = (cLabel*)GetChild( eUIID_QUEST_COMPLETE );
	mpProgressCount = (cLabel*)GetChild( eUIID_QUEST_PROGRESS );
	mpDescBox = (cTextBox*)GetChild( eUIID_QUEST_DESCBOX );
	mpDelete = (cButton*)GetChild( eUIID_QUEST_DELETE );

	if( mpProgressCount )
		mpProgressCount->SetTextColor( eCOLOR_GREEN );

	if( mpCompleteCount )
		mpCompleteCount->SetTextColor( eCOLOR_GREEN );

	if( mpDescBox )
		mpDescBox->SetDrawTextBottom( false );

	/// ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	cUINodeSkin* pHighSkin = pSkin->GetNodeSkin( "Quest_FolderHigh" );
	cUINodeSkin* pHighNoSkin = pSkin->GetNodeSkin( "Quest_FolderHighNoCheck" );
	if( pHighSkin && pHighNoSkin )
	{
		mpHighImage = new cUIImage( pHighSkin->mpTexture );

		unsigned int tx = pHighSkin->mSkinInfo->mTexX;
		unsigned int ty = pHighSkin->mSkinInfo->mTexY;
		unsigned int w = pHighSkin->mSkinInfo->mWidth;
		unsigned int h = pHighSkin->mSkinInfo->mHeight;
		unsigned int x = pHighSkin->mSkinInfo->mX;
		unsigned int y = pHighSkin->mSkinInfo->mY;

		mpHighImage->SetTextureRect( tx, ty, tx + w, ty + h );
		mpHighImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );

		unsigned int tx2 = pHighNoSkin->mSkinInfo->mTexX;
		unsigned int ty2 = pHighNoSkin->mSkinInfo->mTexY;

		mpListBox->SetHighNoCheckPos( tx, ty );
		mpListBox->SetHighCheckPos( tx2, ty2 );
	}


	cUINodeSkin* pLowSkin = pSkin->GetNodeSkin( "Quest_FolderLow" );
	cUINodeSkin* pLowNoSkin = pSkin->GetNodeSkin( "Quest_FolderLowNoCheck" );
	if( pLowSkin && pLowNoSkin )
	{
		mpLowImage = new cUIImage( pLowSkin->mpTexture );

		unsigned int tx = pLowSkin->mSkinInfo->mTexX;
		unsigned int ty = pLowSkin->mSkinInfo->mTexY;
		unsigned int w = pLowSkin->mSkinInfo->mWidth;
		unsigned int h = pLowSkin->mSkinInfo->mHeight;
		unsigned int x = pLowSkin->mSkinInfo->mX;
		unsigned int y = pLowSkin->mSkinInfo->mY;
		
		mpLowImage->SetTextureRect( tx, ty, tx + w, ty + h );
		mpLowImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );

		unsigned int tx2 = pLowNoSkin->mSkinInfo->mTexX;
		unsigned int ty2 = pLowNoSkin->mSkinInfo->mTexY;

		mpListBox->SetLowCheckPos( tx, ty );
		mpListBox->SetLowNoCheckPos( tx2, ty2 );
	}
	return true;
}

void cQuestWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_QUEST_CLOSE:
		/// ݱ
		Hide();
		break;
	case eUIID_QUEST_DELETE:
		{
			/// Ʈ 	
			unsigned int row  = mpListBox->GetSelectRow();
			unsigned int column = mpListBox->GetSelectRowColumn();
			if( column > 0 )
			{
				unsigned int arrIdx = (unsigned int)mpListBox->GetExtraData( row, column );
				unsigned long questIdx = QUESTMAN->GetQuestIndex( arrIdx );
				cQuestDefine* define = QUESTMAN->GetQuestDefine( questIdx );
				if( !define )
				{
					assert(0);
					return;
				}

				cStringT str;
				str.Format( GAMERESOURCEMAN->GetGameText( 416 ), GAMERESOURCEMAN->GetQuestTitle( define->mTitleIndex ));
				UIMAN->CreateModal(	eStage_Game,
									eMBEVENT_QUEST_DELETE, 
									(LPCTSTR)str.Cstr(),
									GAMERESOURCEMAN->GetGameText( 301 ),
									eSKIN_YESNO,
									(void*)arrIdx
									);
			}
		}
		break;
	}
}

void cQuestWindow::OnListBoxChanged( cUINode* , unsigned int )
{
	if( !mpListBox ) return;
	
	/// Ʈ  Ʈ
	SetQuestReward();
	UpdateQuestInfo();
}

void cQuestWindow::OnImageClicked( cUINode* , unsigned int )
{
	if( mpListBox )
	{
		unsigned int row = mpListBox->GetClickImgRow();
		unsigned int column = mpListBox->GetClickImgRowColumn();
		unsigned int arrIdx = (unsigned int)mpListBox->GetExtraData( row, column );
		unsigned long questIdx = QUESTMAN->GetQuestIndex( arrIdx );

		bool check = QUESTMAN->IsSelectQuest( questIdx );
		if( check == true )
		{
			/// üũ Ǯ
			mpListBox->SetClickLowImage( row, column, false );
			QUESTMAN->DeleteQuestSelect( questIdx );
		}
		else
		{
			/// üũ ߰
			mpListBox->SetClickLowImage( row, column, true );
			QUESTMAN->AddQuestSelect( questIdx );
		}
	}
}

void cQuestWindow::OnIconHovered( cUINode* caller, unsigned int id, const cUIPos& pos )
{
	cIcon* hoverIcon = (cIcon*)caller;

	bool defaultIcon = true;
	int index = -1;
	for( unsigned int i = 0; i < 5; ++i )
	{
		if( mDefaultIcon[i].icon == hoverIcon || mSelectIcon[i].icon == hoverIcon )
		{
			if( mSelectIcon[i].icon == hoverIcon )
				defaultIcon = false;

			index = i;
			break;
		}
	}

	if( index == -1 )
		return;

	sRewardIcon& data = ( defaultIcon == true )? mDefaultIcon[index] : mSelectIcon[index];
	if( data.icon )
	{
		int type = data.icon->GetIconType();
		if( type == eICON_ITEM )
		{
			UIMAN->ShowItemTip( eTIP_ITEM, pos, data.index, UINT_MAX, 0 );
		}
		else if( type == eICON_SKILL )
		{
			cBuffToolTipWindow* pTip = GAMEUI->GetBuffTip();
			UIMAN->ShowBuffTip( pTip, pos, (unsigned long)-1, data.index, false );
		}
	}
}
bool cQuestWindow::SetQuestReward()
{
	/// ʱȭ
	ClearIcon();

	/// õ Ʈ  
	unsigned int row  = mpListBox->GetSelectRow();
	unsigned int column = mpListBox->GetSelectRowColumn();
	unsigned int arrIdx = (unsigned int)mpListBox->GetExtraData( row, column );
	unsigned long questIdx = QUESTMAN->GetQuestIndex( arrIdx );

	cQuestDefine* define = QUESTMAN->GetQuestDefine( questIdx );
	if( !define )
	{
		assert(0);
		return false;
	}

	SetSelectCount( define->mSelectCount );

	/// ⺻  
	cQuestReward* reward = define->mDefaultReward;
	if( reward )
	{
		if( reward->mExp > 0 )
			SetExp( reward->mExp );
		else
			SetExp( 0 );

		if( reward->mSxp > 0 )
			SetSxp( reward->mSxp );
		else
			SetSxp( 0 );

		if( reward->mMoney > 0 )
			SetMoney( reward->mMoney );
		else
			SetMoney( 0 );

		if( reward->mSkillPoint > 0 )
			SetSkillPoint( reward->mSkillPoint );
		else
			SetSkillPoint( 0 );

		UpdateReward( reward, mDefaultIcon );
	}

	///   
	cQuestReward* selectReward = define->mSelectReward;
	if( selectReward )
	{
		UpdateReward( selectReward, mSelectIcon );
	}
	return true;
}

void cQuestWindow::UpdateReward( cQuestReward* reward, sRewardIcon* icon )
{
	///  
	int iconIdx = 0;
	cItemDefine* itemDefine = 0;
	for( int i = 0; i < QUEST_ITEM_MAX; ++i )
	{
		sQuestItem& item = reward->mRewardItem[i];
		itemDefine = ITEMMAN->GetItemDefine( item.itemIndex );
		if( !itemDefine )
			continue;

		cIconParam* pParam = itemDefine->GetIconParam();
		if( pParam && iconIdx < 5 )
		{
			sRewardIcon* rewardIcon = (icon + iconIdx);
			if( rewardIcon && rewardIcon->icon )
			{
				cIcon* icon = rewardIcon->icon;

				rewardIcon->index = item.itemIndex;
				icon->SetIconType( eICON_ITEM );
				icon->ChangeImage( pParam, ICON_SIZE, ICON_SIZE );
				icon->SetNumber( item.count );

				bool show = ( itemDefine->GetCapacity() > 1 ) ? true : false;
				icon->ShowNumber( show );

				iconIdx++;
			}
		}
		else
		{
			assert(0);
		}
	}

	///  
	for( int i = 0; i < QUEST_BUFF_MAX; ++i )
	{
		unsigned long buffIdx = reward->mRewardBuff[i];

		sInfluenceScript* pInfo = SKILLSCRIPT->GetInfluenceInfo( buffIdx );
		if( pInfo )
		{
			cIconParam* pParam = UIMAN->GetIconParam( pInfo->mIconIdx );
			if( pParam && iconIdx < 5 )
			{
				sRewardIcon* rewardIcon = (icon + iconIdx);
				if( rewardIcon && rewardIcon->icon )
				{
					cIcon* icon = rewardIcon->icon;

					rewardIcon->index = buffIdx;
					icon->SetIconType( eICON_SKILL );
					icon->ShowNumber( false );
					icon->ChangeImage( pParam, ICON_SIZE, ICON_SIZE );
					iconIdx++;
				}
			}
			else
			{
				assert(0);
			}
		}
	}

	/// ŸƲ  
	if( reward->mGiveTitleIndex > 0 )
	{
		cTitleDefine* define = TITLEMAN->GetTitleDefine( reward->mGiveTitleIndex );
		if( define )
		{
			sInfluenceScript* pInfo = SKILLSCRIPT->GetInfluenceInfo( define->mInfluenceIndex );
			if( pInfo )
			{
				cIconParam* pParam = UIMAN->GetIconParam( pInfo->mIconIdx );
				if( pParam && iconIdx < 5 )
				{
					sRewardIcon* rewardIcon = (icon + iconIdx);
					if( rewardIcon && rewardIcon->icon )
					{
						cIcon* icon = rewardIcon->icon;

						rewardIcon->index = define->mInfluenceIndex;
						icon->SetIconType( eICON_SKILL );
						icon->ShowNumber( false );
						icon->ChangeImage( pParam, ICON_SIZE, ICON_SIZE );
						iconIdx++;
					}
				}
				else
				{
					assert(0);
				}
			}
		}
	}
}

void cQuestWindow::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mTimeLine == -1 || mSelectQuestIndex <= 0 )
		return;

	/// ð
	long restTime = QUESTMAN->GetQuestRestTime( mSelectQuestIndex );
	int time = (int)(restTime*0.001);
	if( time >= 0 )
	{
		int h = time / 3600;
		int m = time / 60;
		int s = time % 60;

		cStringT th,tm,ts;
		if( h != 0 )
			th.Format(_T("%d"), h );
		
		if( m != 0 )
			tm.Format(_T("%d"), m );
		ts.Format(_T("%d"), s );

		th = (th+tm+ts);
		
		cStringT timeStr;
		timeStr.Format( GAMERESOURCEMAN->GetGameText( 471 ), (LPCTSTR)th.Cstr() );
		mpDescBox->UpdateRowText( mTimeLine, (LPCTSTR)timeStr.Cstr() );
	}
}


///  ƮŴ Ʈ, 迭ε 
bool cQuestWindow::AddQuest( unsigned int arrIdx, unsigned long questIdx, bool complete )
{
	cQuestDefine* define = QUESTMAN->GetQuestDefine( questIdx );
	if( !define )
	{
		assert(0);
		return false;
	}

	///
	cStringT title;
	title.Format( GAMERESOURCEMAN->GetGameText( 444 ), define->mLevel, GAMERESOURCEMAN->GetQuestTitle( define->mTitleIndex ) );
	if( complete == true )
		title.Append( GAMERESOURCEMAN->GetGameText( 445 ) );

	/// üũ  
	bool check = QUESTMAN->IsSelectQuest( questIdx );

	///  ϸ  
	if( define->mTakeMapIndex > 0 )
	{
		mpListBox->AddHighData( define->mTakeMapIndex, GAMERESOURCEMAN->GetMapName( define->mTakeMapIndex ), eCOLOR_YELLOW, mpHighImage );

		/// Ʈ  
		mpListBox->AddLowData( define->mTakeMapIndex, (LPCTSTR)title.Cstr(), mDefaultColor, (void*)arrIdx, mpLowImage, check );
	}
	else
	{
		assert(0);
	}

	///  Ʈ
	SetQuestReward();
	UpdateQuestInfo();
	return true;
}

void cQuestWindow::SetCheck( unsigned int arrIdx, unsigned long questIdx, bool check )
{
	cQuestDefine* define = QUESTMAN->GetQuestDefine( questIdx );
	if( define )
	{
		bool ret = mpListBox->UpdateLowCheck( define->mTakeMapIndex, check, (void*)arrIdx );
		if( ret == false )
		{
			assert(0);
		}
	}
}

void cQuestWindow::SetCompleteQuest( unsigned int arrIdx, unsigned long questIdx )
{
	cQuestDefine* define = QUESTMAN->GetQuestDefine( questIdx );
	if( define )
	{
		cStringT title;
		title.Format( GAMERESOURCEMAN->GetGameText( 444 ), define->mLevel, GAMERESOURCEMAN->GetQuestTitle( define->mTitleIndex ) );
		title.Append( GAMERESOURCEMAN->GetGameText( 445 ) );

		bool ret = mpListBox->UpdateLowData( define->mTakeMapIndex, (LPCTSTR)title.Cstr(), (void*)arrIdx );
		if( ret == false )
		{
			assert(0);
		}
	}
}


/// Ʈ  Ȳ 
void cQuestWindow::UpdateQuestInfo()
{
	if( !mpDescBox ) return;
	if( !mVisible ) return;

	if( mpListBox->GetRowCount() == 0 )
		return;

	/// ʱȭ 
	mpDescBox->Clear();
	mSelectQuestIndex = 0;
	mTimeLine = -1;

	/// õ Ʈ  
	unsigned int row  = mpListBox->GetSelectRow();
	unsigned int column = mpListBox->GetSelectRowColumn();
	unsigned int arrIdx = (unsigned int)mpListBox->GetExtraData( row, column );
	unsigned char status = QUESTMAN->GetQuestStatus( arrIdx );

	mSelectQuestIndex = QUESTMAN->GetQuestIndex( arrIdx );
	cQuestDefine* define = QUESTMAN->GetQuestDefine( mSelectQuestIndex );
	if( !define )
	{
		assert(0);
		return;
	}
	
	/// Ʈ
	mpDescBox->AddNewRow( GAMERESOURCEMAN->GetGameText( 443 ), eCOLOR_GREEN );
	LPCTSTR title = GAMERESOURCEMAN->GetQuestTitle( define->mTitleIndex );
	mpDescBox->AddNewRow( title, mDefaultColor );

	/// ݺ
	if( define->mRepeatType == eQUEST_REPEAT )
        mpDescBox->AddNewRow( GAMERESOURCEMAN->GetGameText( 472 ), mDefaultColor );

	mpDescBox->AddEmptyRow(1);

	/// [Ƿ] - Ƿ, Ƿڸ
	cStringT info, mapinfo;
	mpDescBox->AddNewRow( GAMERESOURCEMAN->GetGameText( 440 ), eCOLOR_GREEN );

	sNPCList* pNpc = NPCSCRIPT->GetNPCList( define->mTakeNpcIndex );
	if( pNpc )
	{
		info.Format( GAMERESOURCEMAN->GetGameText( 441 ), pNpc->mName );
		mpDescBox->AddNewRow( (LPCTSTR)info.Cstr(), mDefaultColor );
	}
	
	mapinfo.Format( GAMERESOURCEMAN->GetGameText( 442 ), GAMERESOURCEMAN->GetMapName( define->mTakeMapIndex ) );
	mpDescBox->AddNewRow( (LPCTSTR)mapinfo.Cstr(), mDefaultColor );
	mpDescBox->AddEmptyRow(1);

	/// [ ǥ ]
	mpDescBox->AddNewRow( GAMERESOURCEMAN->GetGameText( 450 ), eCOLOR_GREEN );
	if( status == eQUEST_COMPLETE )
	{
		mpDescBox->AddNewRow( GAMERESOURCEMAN->GetGameText( 449 ), mDefaultColor );
	}
	else if( status == eQUEST_PLAYING )
	{
		/// ð ڿ  ( ƮŴ  )
		cQuestLimit* limit = define->mQuestLimit;
		if( limit && limit->mTimeType != eTIME_NONE )
		{
			long restTime = QUESTMAN->GetQuestRestTime( mSelectQuestIndex );
			cStringT time;
			int h = restTime / 3600;
			int m = restTime / 60;
			int s = restTime % 60;

			cStringT th,tm,ts;
			if( h != 0 )
				th.Format(_T("%d"), h );

			if( m != 0 )
				tm.Format(_T("%d"), m );
			ts.Format(_T("%d"), s );

			th = (th+tm+ts);

			cStringT timeStr;
			timeStr.Format( GAMERESOURCEMAN->GetGameText( 471 ), (LPCTSTR)th.Cstr() );
			mTimeLine = mpDescBox->AddNewRow( (LPCTSTR)timeStr.Cstr(), mDefaultColor );
		}
		
		///    
		cQuestDuty* duty = define->mQuestDuty;
		if( duty )
		{
			cStringT str;
			__int64 check = QUESTMAN->GetProgress( arrIdx );

			__int64 end = 0xFF;
			for( unsigned int i = 0; i < MAX_DUTY; ++i )
			{
				eDutyType type = duty->mDuty[i].dutyType;
				unsigned long targetIdx = duty->mDuty[i].targetIdx;
				unsigned int count = duty->mDuty[i].count;

				if( type == eDUTY_NONE )
					break;

				///  
				switch( type )
				{
				case eDUTY_HUNT:		/// 
					{
						LPCTSTR monName = GAMERESOURCEMAN->GetMonsterName( targetIdx );
						str.Format( GAMERESOURCEMAN->GetGameText( 451 ), monName, count );

						/// Ϸ
						if( (check & end) >= (define->mComplete & end) )
							str.Append( GAMERESOURCEMAN->GetGameText( 445 ) );
						/// 
						else
						{
							__int64 cnt = check & end;
							for( unsigned int b = 0; b < i; ++b)
								cnt = cnt >> 8;

							cStringT str1;
							str1.Format( GAMERESOURCEMAN->GetGameText( 459 ), (unsigned int)cnt, count );

							str += str1;
						}

						mpDescBox->AddNewRow( (LPCTSTR)str.Cstr(), mDefaultColor );
					}
					break;
				case eDUTY_COLLECT:		/// 
					{
						LPCTSTR itemName = ITEMMAN->GetItemName( targetIdx );
						str.Format( GAMERESOURCEMAN->GetGameText( 453 ), itemName, count );

						/// Ϸ
						if( (check & end) >= (define->mComplete & end) )
							str.Append( GAMERESOURCEMAN->GetGameText( 445 ) );
						/// 
						else
						{
							__int64 cnt = check & end;
							for( unsigned int b = 0; b < i; ++b)
								cnt = cnt >> 8;

							cStringT str1;
							str1.Format( GAMERESOURCEMAN->GetGameText( 459 ), (unsigned int)cnt, count );

							str += str1;
						}

						mpDescBox->AddNewRow( (LPCTSTR)str.Cstr(), mDefaultColor );
					}
					break;
				case eDUTY_MEET:		/// npc 
					{
						LPCTSTR npcName = GAMERESOURCEMAN->GetNpcName( targetIdx );
						str.Format( GAMERESOURCEMAN->GetGameText( 455 ), npcName );

						/// Ϸ
						if( (check & end) >= (define->mComplete & end) )
							str.Append( GAMERESOURCEMAN->GetGameText( 445 ) );

						mpDescBox->AddNewRow( (LPCTSTR)str.Cstr(), mDefaultColor );
					}
					break;
				}

				/// Ϸ üũ
				end = end << 8;
			}
		}
	}

	
	///  
	mpDescBox->AddEmptyRow(1);

	/// [  ]
	mpDescBox->AddNewRow( GAMERESOURCEMAN->GetGameText( 452 ), eCOLOR_GREEN );
	mpDescBox->AddEmptyRow(1);

	cUIFuncTextParam textParam;
	textParam.mName = HERO->GetName();
	for( unsigned int i = 0; i < define->mDestLineNum; ++i )
	{
		mpDescBox->AddFucnText( QUESTMAN->GetNpcTextNode( define->mDestIndex + i), &textParam );
		mpDescBox->AddEmptyRow(1);
	}
}

void cQuestWindow::SetExp( unsigned int exp )
{
	if( mpEXP )
		mpEXP->SetValue( exp );
}

void cQuestWindow::SetSxp( unsigned int sxp )
{
	if( mpSXP )
		mpSXP->SetValue( sxp );
}

void cQuestWindow::SetMoney( unsigned long money )
{
	if( mpMoney )
		mpMoney->SetValue( money );
}

void cQuestWindow::SetSkillPoint( unsigned int sp )
{
	if( mpSkillPoint )
		mpSkillPoint->SetValue( sp );
}

void cQuestWindow::SetSelectCount( unsigned int count )
{
	if( mpCount )
	{
		cStringT str;
		str.Format( _T("%d"), count );

		///  
		mpCount->SetText( (LPCTSTR)str.Cstr() );
	}
}


void cQuestWindow::UpdateCount( unsigned int progress, unsigned int complete )
{
	if( mpProgressCount && mpCompleteCount )
	{
		cStringT str;
		str.Format( _T("%d"), progress );
		mpProgressCount->SetText( (LPCTSTR)str.Cstr() );

		str.Format( _T("%d"), complete );
		mpCompleteCount->SetText( (LPCTSTR)str.Cstr() );
	}
}

void cQuestWindow::OnNetLock( int lockTry )
{
	if( mpDelete )
		mpDelete->NetLock( lockTry );
}

void cQuestWindow::OnNetUnLock( int lockTry )
{
	if( mpDelete )
		mpDelete->NetUnLock( lockTry );
}
