/* ==========================================================================
*      : QuestWindow.h
*      : 
*    : 谡
*    : 2008-03-19
* ǻ :
*===========================================================================*/
#pragma once
#include "QuestDefine.h"
#include "UIWindow.h"
#include "Icon.h"

class cUIImage;
class cIcon;
class cLabel;
class cListFolderBox;
class cTextBox;
class cButton;

struct sRewardIcon
{
	cIcon*		  icon;
	unsigned long index;	/// ų or  ε
	bool		  select;	/// õǾ 

	sRewardIcon()
	{
		icon = 0;
		index = 0;
		select = false;
	}
};

class cQuestWindow : public cUIWindow
{
public:
	cQuestWindow();
	virtual ~cQuestWindow();

	void Clear();

	/// Ʈ ߰
    bool AddQuest( unsigned int arrIdx, unsigned long questIdx, bool complete );

	/// 
	void SetCheck( unsigned int arrIdx, unsigned long questIdx, bool check );
	void SetCompleteQuest( unsigned int arrIdx, unsigned long questIdx );
	
	/// Ʈ    Ʈ
	void UpdateQuestInfo();				

	/// , Ϸᰡ Ʈ  
	void UpdateCount( unsigned int progress, unsigned int complete );

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnCommand( cUINode* pcaller, unsigned int id );
	void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	void OnListBoxChanged( cUINode* , unsigned int );
	void OnIconHovered(cUINode* caller, unsigned int id, const cUIPos& pos );
	void OnImageClicked( cUINode* , unsigned int );
	void OnNetLock( int lockTry );
	void OnNetUnLock( int lockTry );
	void OnShow();

	bool SetQuestReward();	///  Ʈ
	void UpdateReward( cQuestReward* reward, sRewardIcon* icon );
	
	void SetExp( unsigned int exp );
	void SetSxp( unsigned int sxp );
	void SetMoney( unsigned long money );
	void SetSkillPoint( unsigned int sp );
	void SetSelectCount( unsigned int count );

	void ClearIcon();

protected:
	cListFolderBox*	mpListBox;

	/// 
	sRewardIcon mDefaultIcon[5];
	sRewardIcon mSelectIcon[5];
	
	cLabel* mpEXP;
	cLabel* mpSXP;
	cLabel* mpSkillPoint;
	cLabel* mpMoney;
	cLabel* mpCount;

	///  
	cLabel* mpCompleteCount;
	cLabel* mpProgressCount;

	/// Ʈ  ڽ
	cTextBox* mpDescBox;

	/// 
	cButton* mpDelete;

	cUIImage*	mpHighImage;
	cUIImage*	mpLowImage;

	/// ð  
	int	mTimeLine;
	unsigned long mSelectQuestIndex;
};
