/* ==========================================================================
*      : QuickManager.h
*      :  Ŵ
*    : 谡
*    : 2007-09-20
* ǻ :
*===========================================================================*/
#pragma once
#include "Icon.h"
#include "Player_Common.h"
#include "Item_Common.h"

const int QUICK_COUNT = 50;		/// Ϲ (30) + FS(20)
const int QUICK_COUNT_MON = 3;	/// (3)
const int QUICK_TOTAL = QUICK_COUNT + QUICK_COUNT_MON;

const int ICON_COUNT = 20;		///   
const int QUICKSLOT_COUNT = 10;	/// µǴ  

///  ų ̹ ε ( 3 ~ 5 )
const int MONICON_PARAMINDEX = 3; 

///  
enum eQuickSlotIndex
{
	/// Ϲ 
	QUICKSLOT_BEGIN = 0,
	QUICKSLOT_END = QUICKSLOT_BEGIN + 30 - 1,

	/// FS 
	QUICKSLOT_FS_BEGIN,				//QUICKSLOT_F
	QUICKSLOT_FS_END = QUICKSLOT_FS_BEGIN + 20 - 1,

	/// MONSTER 
	QUICKSLOT_MON_BEGIN,
	QUICKSLOT_MON_END = QUICKSLOT_MON_BEGIN + 3 - 1,
};


class cIcon;
class cQuickData
{
public:
	cQuickData();
	cQuickData( cQuickData& other );

	/// 
	void operator=( const cQuickData& other );
	void operator=( unsigned int i );

public:
	///  Ÿ ( 0 : ۷, 1 : ų )
	char mType;

	///  ε
	unsigned long mDBIndex;
	///  ε
	unsigned long mItemIndex;

	/// ų ε
	unsigned long mSkillIndex;
	unsigned char mSkillStep;
	
    ///  ÷
	NiColorA mColor;

	/// ִϸ̼
	sAniParam* mAniParam;

	///    Ÿ ( ̹ ׵θ )
	unsigned int mTipType;

	unsigned long mStartTime;
	unsigned long mElapsedTime;
	unsigned long mMaintainTime;
};

inline cQuickData::cQuickData()
: mType( eSHORTCUT_NONE )
, mDBIndex(0)
, mItemIndex(0)
, mSkillIndex(0)
, mSkillStep(0)
, mColor( NiColorA::WHITE )
, mStartTime(0)
, mElapsedTime(0)
, mMaintainTime(0)
, mAniParam(0)
, mTipType( eTOOLTIP_NONE )
{
}

inline cQuickData::cQuickData( cQuickData& other )
: mType( eSHORTCUT_NONE )
, mDBIndex(0)
, mItemIndex(0)
, mSkillIndex(0)
, mSkillStep(0)
, mColor( NiColorA::WHITE )
, mStartTime(0)
, mElapsedTime(0)
, mMaintainTime(0)
, mAniParam(0)
, mTipType( eTOOLTIP_NONE )
{
	operator=( other );
}

inline void cQuickData::operator=( const cQuickData& other )
{
	mType = other.mType;
	mDBIndex = other.mDBIndex;
	mItemIndex = other.mItemIndex;
	mSkillIndex = other.mSkillIndex;
	mSkillStep = other.mSkillStep;
	mColor = other.mColor;
	mStartTime = other.mStartTime;
	mElapsedTime = other.mElapsedTime;
	mMaintainTime = other.mMaintainTime;
	mAniParam = other.mAniParam;
	mTipType = other.mTipType;
}

inline void cQuickData::operator=( unsigned int i )
{
	if( i <= 0 )
	{
		mType = eSHORTCUT_NONE;
		mDBIndex = 0;
		mItemIndex = 0;
		mSkillIndex = 0;
		mSkillStep = 0;
		mColor = NiColorA::WHITE;
		mStartTime = 0;
		mElapsedTime = 0;
		mMaintainTime = 0;
		mAniParam = 0;
		mTipType = eTOOLTIP_NONE;
	}
	else
	{
		assert(0);
	}
}

///  
class cBindIcon
{
public:
	cBindIcon();

	/// 
	void operator=( const cBindIcon& other );
	void operator=( cIcon& other );
	
	void SetParam( cIconParam* param );
	void SetCount( unsigned int count );
	void ShowNumber( bool show );
	void SetColor( const NiColorA& color );
	void SetColor( float r, float g, float b, float a );
	void SetAniParam( sAniParam* param );
	void SetTipType( unsigned int type );
	void StopDelay();

public:
	cIcon* mRowIcon;
	cIcon* mColumnIcon;
};

inline cBindIcon::cBindIcon()
: mRowIcon(0)
, mColumnIcon(0)
{
}

inline void cBindIcon::operator=( const cBindIcon& other )
{
	cIcon* icon = other.mColumnIcon;
	operator=( *icon );
}

inline void cBindIcon::operator=( cIcon& other )
{
	SetParam( other.GetIconParam() );
	SetCount( other.GetNumber() );
	ShowNumber( other.IsShowNumber() );

	SetAniParam( other.GetAniParam() );
	SetTipType( other.GetTipType() );

	mRowIcon->ChangeGauge( other.GetGauge() );
	mColumnIcon->ChangeGauge( other.GetGauge() );
}

inline void cBindIcon::SetParam( cIconParam* param )
{
	mRowIcon->ChangeImage( param );
	mColumnIcon->ChangeImage( param );
}

inline void cBindIcon::SetCount( unsigned int count )
{
	mRowIcon->SetNumber( count );
	mColumnIcon->SetNumber( count );
}

inline void cBindIcon::SetColor( float r, float g, float b, float a )
{
	mRowIcon->SetColor( r, g, b, a );
	mColumnIcon->SetColor( r, g, b, a );
}

inline void cBindIcon::SetColor( const NiColorA& color )
{
	mRowIcon->SetColor( color );
	mColumnIcon->SetColor( color );
}

inline void cBindIcon::ShowNumber( bool show )
{
	mRowIcon->ShowNumber( show );
	mColumnIcon->ShowNumber( show );
}

inline void cBindIcon::SetAniParam( sAniParam* param )
{
	mRowIcon->SetAniParam( param );
	mColumnIcon->SetAniParam( param );
}

inline void cBindIcon::SetTipType( unsigned int type )
{
	mRowIcon->SetTipType( type );
	mColumnIcon->SetTipType( type );
}

inline void cBindIcon::StopDelay()
{
	mRowIcon->StopDelay();
	mColumnIcon->StopDelay();
}


///  Ŵ 
class cQuickManager
{
public:
	static cQuickManager* mSingleton;

public:
	cQuickManager();
	~cQuickManager();

	///
	void Open();

	///   
	void Clear();
	
	/// Ʈũ  
	void NetSetData( unsigned int dataIndex, const sShortcut& shortcut );
	void NetUpdateData();

	///   - Ű
	void OnKeyDown( eKeyCode code );
	void OnMouseDown( unsigned int iconId, bool IsFS = false );
	
	///  Ʈ
	void UpdateUI();
	void UpdateIcon( int i, int iconId, bool countCheck = true );

	/// hero   ų   ˻
	void CheckSkillIcon();
	void CheckItemIcon();

	///  ü
	void ChangeTab( unsigned int tabindex );
	void ChangeTabFS( unsigned int tabindex );

	///   ġ   
	void AddData( unsigned int iconId, cIcon* srcIcon, bool toIsFS );
	void MoveData( unsigned int iconId, cIcon* srcIcon, bool toIsFS );
	void DeleteData();
	void DeleteData( unsigned int iconId, unsigned int dataIndex );

	///  Ͱ ִ 
    bool IsUseSlot( unsigned int iconId, bool IsFS = false );
	eSHORTCUT_TYPE GetQuickType( unsigned int iconId, bool IsFS = false );
	unsigned int GetItemIndex( unsigned int iconId, bool IsFS = false );
	unsigned int GetSkillIndex( unsigned int iconId, bool IsFS = false );
	short GetMonSkillIndex( unsigned int iconId );

	void DragIcon( cIcon* icon );
	void UnDragIcon();

	/// UI ܰ ε
	void BindRowIcon( unsigned int index, cIcon* icon );
	void BindColumnIcon( unsigned int index, cIcon* icon );
	void BindFSRowIcon( unsigned int index, cIcon* icon );
	void BindFSColumnIcon( unsigned int index, cIcon* icon );

	///
	unsigned int GetTabIndex() { return mTabIndex; }
	void SetRowQuick( bool IsRow );
	bool IsRowQuick() { return mIsRowQuick; }

	void SetRowQuickFS( bool IsRow );
	bool IsRowQuickFS() { return mIsRowQuickFS; }

	void SetTotalCount( unsigned int dataIndex, unsigned int iconId, unsigned long itemIndex );

	///  ִϸ̼ 
	void SetSkillAniAura( unsigned long skillIndex, sAniParam* param );

	void SetCharge( unsigned long skillIndex, bool charge );
	void SetMonCharge( unsigned long skillIndex, bool charge );	///  ų í


	/// ӽ   Ÿ 
	void SetAllItemCool();
	void ClearCoolTime( unsigned int slottype, unsigned long index );
	void LoadCoolTime();
	void LoadCoolTimeMon();
    
	void SetItemCool( unsigned int quickIdx, unsigned long startTime, unsigned long restTime, unsigned long totalTime );
	void StartCoolTime( unsigned long itemIndex, unsigned long coolTime );
	void EndCoolTime( unsigned long itemIndex );

	/// ų Ÿ
	void SaveSkillCool( unsigned int dataIdx, unsigned int iconId );
	void InitSkillCooltime( unsigned long skillindex, unsigned long restTime, unsigned long totalTime );
	void StartSkillCoolTime( unsigned long skillIndex, unsigned long cool );

	///  ų 
	void ChangeMonster( unsigned long monIndex );

	///  ӽ  Ÿ ü 
	void SaveSkillCoolMon( unsigned int dataIdx, unsigned int iconId );
	void InitMonSkillCooltime( short skillindex, unsigned long restTime, unsigned long totalTime );
	void StartMonSkillCoolTime( short skillIdx, unsigned long cool );

protected:
	///  
	void UseQuickSlot( unsigned int iconId, bool IsFS = false );
	void UseMonsterQuickSlot( unsigned int iconId );	

	bool UsableSkillIcon( eWEAPON_STATE heroWeaponState, unsigned long skillindex, unsigned char skillstep );
	bool UsableMonSkillIcon( unsigned long skillindex );

public:
	static cQuickManager* GetSingleton();

private:
	///  
	/// Ϲ  + FS  +  
	cQuickData mQuick[QUICK_TOTAL];
	cBindIcon mBindIcon[ICON_COUNT];

	///     
	bool mIsLockByMonster;

	///   ε
	unsigned int mTabIndex;
	unsigned int mTabIndexFS;		/// FS 

	///    ( 0 : , 1 :  )
	bool mIsRowQuick;
	bool mIsRowQuickFS;				/// FS 

	/// 巡  
	cIcon* mDragIcon;
};

inline void cQuickManager::BindRowIcon( unsigned int index, cIcon* icon )
{
	assert( icon );
	mBindIcon[index].mRowIcon = icon;
}

inline void cQuickManager::BindColumnIcon( unsigned int index, cIcon* icon )
{
	assert( icon );
	mBindIcon[index].mColumnIcon = icon;	
}

inline void cQuickManager::BindFSRowIcon( unsigned int index, cIcon* icon )
{
	assert( icon );
	mBindIcon[index+QUICKSLOT_COUNT].mRowIcon = icon;
}

inline void cQuickManager::BindFSColumnIcon( unsigned int index, cIcon* icon )
{
	assert( icon );
	mBindIcon[index+QUICKSLOT_COUNT].mColumnIcon = icon;	
}

inline 
cQuickManager* cQuickManager::GetSingleton()
{
	return mSingleton;
}

#define QUICKMAN cQuickManager::GetSingleton()
