#pragma once
#include "UIWindow.h"

const int MENU_GAPX = 4;
const int MENU_GAPY = 9;

enum ePopupPos
{
	ePopupPos_Character = 0,
	ePopupPos_TargetWindow,
	ePopupPos_PartyWindow,
};

enum ePopupMenuType
{
	ePopupMenuType_Whisper = 1,	/// ӼӸ		800
	ePopupMenuType_Note,		/// 	801
	ePopupMenuType_Friend,		/// ģ	802
	ePopupMenuType_PartyIn,		/// Ƽʴ	803
	ePopupMenuType_PartyLeader,	/// Ƽ 	804
	ePopupMenuType_PartyOut,	/// Ƽ ߹	805
	ePopupMenuType_Duel,		///  û	806
	ePopupMenuType_Trade,		/// ŷ û	807
	ePopupMenuType_GuildIn,		///  ʴ	808
};

class cListBox;
class cLabel;
class cPlaneObject;

class cRButtonMenuWindow : public cUIWindow
{
public:
	cRButtonMenuWindow();
	virtual ~cRButtonMenuWindow();

	void PopUp( int posX, int posY, unsigned long playerIdx, LPCTSTR playerName, ePopupPos caller );

protected:
	bool OnCreate( cUINodeProperty* prop );
	void OnRender( cUIFontItemKeeper* fontKeeper );

	void OnMouseOtherClick( const cUIPos& pos );
	void OnListBoxChanged( cUINode* caller, unsigned int id );
	void OnHide();

	void Clear();

protected:
	enum
	{
		eBACKIMAGE_TOP = 0,
		eBACKIMAGE_CENTER,
		eBACKIMAGE_BOTTOM,
		eBACKIMAGE_LEFT,
		eBACKIMAGE_RIGHT,

		eBACKIMAGE_MAX
	};

	cListBox*	mpMenuList;
	cLabel*		mpName;

	///  ̹
	cUINodeSkin*	mpBackSkin[eBACKIMAGE_MAX];
	cPlaneObject*	mpBackImage[eBACKIMAGE_MAX];

	unsigned long mPlayerIdx;
	cStringT mPlayerName;

	unsigned int	mInitWidth;
};
