#include "StdAfx.h"
#include "RadioButton.h"
#include "UIManager.h"
#include "UISkinLexer.h"
#include "Token.h"
#include "Parser.h"

#include "UIImage.h"
#include "UIContainer.h"
#include "FontAgent.h"
#include "SoundSystem.h"

cRadioButton::cRadioButton( eUINodeType type )
: cButton( type )
, mGroupNum(0)
{
	mpPrev = NULL;
	mpNext = NULL;

	mDownSoundIdx = (unsigned long)-1;

	mProcessEnable = false;
}

cRadioButton::~cRadioButton()
{
}

void cRadioButton::Hide()
{
	cUINode::Hide();
}

bool cRadioButton::OnCreate( cUINodeProperty* pproperty )
{
	if( cUINode::OnCreate( pproperty ) == false )
		return false;

	mpParent->AddRadio( mGroupNum, this );

	return true;
}

/// ǻ : 
bool cRadioButton::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_RADIOBUTTON ) == false )
	{
		assert( 0 && "not radio button skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
	{
		return false;
	}

	cRadioButtonSkin* p = (cRadioButtonSkin*)pskin;

	if( p->mText.IsEmpty() == false )
		mText = p->mText;

    mOriginalTexWidth = mpImage->GetWidth();
	mOriginalTexHeight = mpImage->GetHeight();
	mGroupNum = p->mGroupNum;

	/// ư ̹ ȯǥ  
	mUpPos = p->mUpPos;
	mDownPos = p->mDownPos;

	/// ư  ؽƮ ÷
	mUpColor = p->mUpColor;
	mDownColor = p->mDownColor;

	/// 
	mDownSoundIdx = p->mDownSoundIdx;

	/// ؽƮ ǥ Ʈ 
	UpdateText();
	
	/// ʱ° ִٸ 
	SetPress( mPressed );
	return true;
}

/// ǻ : 
void cRadioButton::OnRender( cUIFontItemKeeper* pKeeper )
{
	/// ̹ 
	if( mpImage )
		mpImage->Draw();

	if( mPressed && mText.IsEmpty() == false )
		pKeeper->AddFontItem( cFontAgent::eFont_UI, const_cast<LPTSTR>(mText.Cstr()), mTextPosX, mTextPosY+1, mDownColor );
	else
		pKeeper->AddFontItem( cFontAgent::eFont_UI, const_cast<LPTSTR>(mText.Cstr()), mTextPosX, mTextPosY, mUpColor );
}

/// ǻ : 
void cRadioButton::OnLButtonDown( const cUIPos&, bool, bool, bool )
{
	if( !mEnabled || mPressed )
		return;

	/// θ   
	UIMAN->GotoFrontNode( this );
	SetPress( true );

	SOUNDSYS->Play2DSound( mDownSoundIdx );
}

/// ǻ : 𼱰 SetPress ̺Ʈ ,
void cRadioButton::SetPress( bool press, bool onsound, bool exceptEnable )
{
	if( !exceptEnable && !mEnabled ) 
		return;

	mPressed = press;

	///   
	AdjustPress();

	if( mPressed == false )	
		return;

	if( onsound )
		SOUNDSYS->Play2DSound( mDownSoundIdx );

	///  ׷쿡  
	UpdateGroup();

	/// ̺Ʈ ߻
	cUIEvent event;
	event.mType = eUIEVENT_RADIO_PRESSED;
	event.mpCaller = this;
	event.mID = mID;
	mpParent->HandleEvent( event );
}

///  ư  
void cRadioButton::SetPressNoEvent( bool press, bool onsound )
{
	if( mEnabled == false )
		return;

	mPressed = press;

	///   
	AdjustPress();

	if( mPressed == false )	
		return;

	if( onsound )
		SOUNDSYS->Play2DSound( mDownSoundIdx );

	///  ׷쿡  
	UpdateGroup();
}

/// ǻ : 
void cRadioButton::SetEnabled( bool enabled )
{
	cUINode::SetEnabled( enabled );
}

/// ǻ :
void cRadioButton::AdjustPress()
{
	/// ̹ 		
	if( mPressed == true )
	{
		///  ư  ̹ Ѵ
		mpImage->SetTextureRect( (unsigned short)(mDownPos.mX), (unsigned short)(mDownPos.mY), 
								 (unsigned short)(mDownPos.mX + mOriginalTexWidth), (unsigned short)(mDownPos.mY + mOriginalTexHeight) );
	}
	else if( mPressed == false )
	{
		///  ư   ̹ Ѵ 
		mpImage->SetTextureRect( (unsigned short)(mUpPos.mX), (unsigned short)(mUpPos.mY), 
								 (unsigned short)(mUpPos.mX + mOriginalTexWidth), (unsigned short)(mUpPos.mY + mOriginalTexHeight) );
	}
}

/// ǻ :
void cRadioButton::UpdateGroup()
{
	///  ׷쿡  
	cRadioButton* tempNode = this;
	bool findNode = false;

	/// prev ư ˻ 
	while( tempNode->mpPrev )
	{
		tempNode = tempNode->mpPrev;
		if( tempNode->IsPress() == true )
		{ 
			tempNode->SetPress( false );
			findNode = true;
			return;
		}
	}

	/// trueΰ ־ Ʈ Ƿ 
	/// next ˻ ʿ 
	if( findNode )
		return;

	tempNode = this;
	/// next ư ˻ 
	while( tempNode->mpNext )
	{
		tempNode = tempNode->mpNext;
		if( tempNode->IsPress() == true )
		{
			tempNode->SetPress( false );
			return;
		}
	}
}

/// ǻ : ׷쳢 ߿ḮƮ 
void cRadioButton::Link( cUINode* node )
{
	if( node == 0 )
		return;

	cRadioButton* addNode = (cRadioButton*)node;
	cRadioButton* tempNode = this;

	/// next null   ãƼ  
	while( tempNode->mpNext )
	{
		tempNode = tempNode->mpNext;
	}

	addNode->mpNext = tempNode->mpNext;
	tempNode->mpNext = addNode;
	addNode->mpPrev = tempNode;
}

/// ǻ :
void cRadioButton::UpdateText()
{
	if( mText )
	{
		/// ؽƮ ѷ ġ  
		cUIRect rc = GetAbsoluteRect();
		/// ѷ ǥ 
		mTextPosX = rc.mLeft + (int)((rc.GetWidth() - FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, mText.Cstr(), mText.GetLength()) ) * 0.5f);
		mTextPosY = rc.mTop + (int)((rc.GetHeight() - FONTAGENT->GetTextHeight(cFontAgent::eFont_UI) ) * 0.5f);
	}	
}

///
LPCTSTR cRadioButton::GetText()
{
	return ( mText.IsEmpty() ) ? 0 : (LPCTSTR)mText.Cstr();
}


//////////////////////////////////////////////////////////////////////////////
cRadioButtonSkin::cRadioButtonSkin( eUINodeType type )
: cUINodeSkin( type )
, mGroupNum(0)
, mUpPos(0, 0)
, mDownPos(0, 0)
{
	mUpColor = mDefaultColor;
	mDownColor = mDefaultColor;

	mDownSoundIdx = (unsigned long)-1;
}

cRadioButtonSkin::~cRadioButtonSkin()
{
}

/// ǻ :  ư ʿ   Ľ
bool cRadioButtonSkin::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			///  Ż ^^
			break;
		}

		switch( token.mType )
		{
		case eTOKEN_DOWNSOUND:
			{
				mDownSoundIdx = parser.ParseInt();
			}
			break;
		case eTOKEN_UPCOLOR:
			{
				///  ū "(" ̹Ƿ Ѿ 
				if( parser.ExpectTokenString( "(" ) == false )
					return false;

				unsigned char r = (unsigned char)parser.ParseInt();
				unsigned char g = (unsigned char)parser.ParseInt();
				unsigned char b = (unsigned char)parser.ParseInt();

				if( parser.ExpectTokenString( ")" ) == false )
					return false;

				/// ȯ ( R,G,B  )
				unsigned long color = (unsigned long)( (DWORD)((BYTE)r << 16) | (WORD)((BYTE)g << 8) | (BYTE)b );

				/// down ÷ ⺻ up ÷ ϰ Ѵ
				mUpColor = mDownColor = color | 0xff000000;
			}
			break;
		case eTOKEN_DOWNCOLOR:
			{
				///  ū "(" ̹Ƿ Ѿ 
				if( parser.ExpectTokenString( "(" ) == false )
					return false;

				unsigned char r = (unsigned char)parser.ParseInt();
				unsigned char g = (unsigned char)parser.ParseInt();
				unsigned char b = (unsigned char)parser.ParseInt();

				if( parser.ExpectTokenString( ")" ) == false )
					return false;

				/// ȯ ( R,G,B  )
				unsigned long color = (unsigned long)( (DWORD)((BYTE)r << 16) | (WORD)((BYTE)g << 8) | (BYTE)b );

				mDownColor = color | 0xff000000;
			}
			break;
		case eTOKEN_GROUPNUM:
			{
				mGroupNum = parser.ParseInt();
			}
			break;
		case eTOKEN_TEXT:
			{
				int i = parser.ParseInt();
				if( UIMAN->GetUIText( &mText, i ) == false )
				{
					return false;
				}
			}
			break;
		case eTOKEN_UPPOS:
			{
				mUpPos.mX = parser.ParseInt();
				mUpPos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_DOWNPOS:
			{
				mDownPos.mX = parser.ParseInt();
				mDownPos.mY = parser.ParseInt();
			}
			break;
		default:
			if( cUINodeSkin::ParseLine( parser, token ) == false )
			{
				return false;
			}
			break;
		}
	}
	return true;
}
