/* ==========================================================================
*      : RadioButton.h
*      : 
*    : 谡
*    : 2007-03-06
* ǻ :
*===========================================================================*/
#pragma once
#include "Button.h"
#include "UINodeData.h"

class cRadioButton : public cButton
{
public:
	cRadioButton( eUINodeType type = eUINODE_BUTTON );
	virtual ~cRadioButton();

	virtual void SetEnabled( bool enabled );

	///  
	virtual void SetPress( bool press, bool onsound = true, bool exceptEnable = false );

	/// ̺Ʈ   
	void SetPressNoEvent( bool press, bool onsound = true );

	///  ư ׷ 
	void Link( cUINode* node );

	/// ׷ ѹ  
	int GetGroupNum() const;

	/// ư ؽƮ  
	LPCTSTR GetText();

	cRadioButton* GetNext() { return mpNext; }

	void Hide(); 

private:
	/// ̺Ʈ ó
	virtual bool OnCreate( cUINodeProperty* pproperty );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void OnMouseMove( const cUIPos& /*pos*/ ) {}
	virtual void OnLButtonUp( const cUIPos& /*pos*/ ) {}
	virtual void OnMouseHovered( const cUIPos& /*pos*/ ) {}
	virtual void OnMouseLeft( const cUIPos& /*pos*/ ) {}

	/// ؽƮ ǥ Ʈ 
	virtual void UpdateText();

	///  ׷  
	void UpdateGroup();

	///   
	void AdjustPress();

private:
	///  ư ׷ ȣ  
	int mGroupNum;
	cRadioButton* mpPrev;
	cRadioButton* mpNext;

	unsigned long mDownSoundIdx;
};

inline int cRadioButton::GetGroupNum() const
{
	return mGroupNum;
}


////////////////////////////////////////////////////////////////////////////
///  ư Ų
class cRadioButtonSkin : public cUINodeSkin
{
public:
	cRadioButtonSkin( eUINodeType type = eUINODE_RADIOBUTTON );
	virtual ~cRadioButtonSkin();
	/// ε
	virtual bool Load( cParser& parser );

public:
	/// ؽƮ
	cStringT mText;

	/// ư ̹ ȯǥ  
	cUIPos mUpPos;
	cUIPos mDownPos;

	///  ư¿  ؽƮ ÷ 
	unsigned long mUpColor;
	unsigned long mDownColor;

	///  ư ׷ ȣ 
	int mGroupNum;

	unsigned long mDownSoundIdx;
};

